/*
Copyright (C) 2007-2010 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "menu.h"

void initTTF()
{
	TTF_Init();
}

void freeTTF()
{
	TTF_Quit();
}

// This function handles the game's main menu. From here //
// the player can select to enter the game, or quit.     //
int do_menu(SDL_Surface *screen)
{
	// Get the number of ticks since SDL was initialized. //
	g_Timer = SDL_GetTicks();
	g_Window = screen;
	char value[2];
	leave = 0;
	actual = 0;
	
	//Reset variables
	selected_track = 1;
	selected_car = 1;
	
	while(leave==0){
		// Here we compare the difference between the current time and the last time we //
		// handled a frame. If FRAME_RATE amount of time has, it's time for a new frame. //
		if ( (SDL_GetTicks() - g_Timer) >= FRAME_RATE )
		{
			HandleMenuInput();

			// Make sure nothing from the last frame is still drawn. //
			ClearScreen();

			DisplayText("SKUNKS 2.0.0", 0.35*SCREENWIDTH, 0.05*SCREENHEIGHT, 14, 255, 0, 0, 0, 0, 0); //Title
			//Track
			sprintf(value, "%i", selected_track);
			if (actual==0){
				DisplayText("Track", 0.35*SCREENWIDTH, 0.20*SCREENHEIGHT, 12, 255, 255, 0, 0, 0, 0);
				DisplayText(value, 0.60*SCREENWIDTH, 0.20*SCREENHEIGHT, 12, 255, 255, 0, 0, 0, 0);
			}
			else{
				DisplayText("Track", 0.35*SCREENWIDTH, 0.20*SCREENHEIGHT, 12, 255, 255, 255, 0, 0, 0);
				DisplayText(value, 0.60*SCREENWIDTH, 0.20*SCREENHEIGHT, 12, 255, 255, 255, 0, 0, 0);
			}
			//Car
			sprintf(value, "%i", selected_car);
			if (actual==1){
				DisplayText("Car", 0.35*SCREENWIDTH, 0.27*SCREENHEIGHT, 12, 255, 255, 0, 0, 0, 0);
				DisplayText(value, 0.60*SCREENWIDTH, 0.27*SCREENHEIGHT, 12, 255, 255, 0, 0, 0, 0);
			}
			else{
				DisplayText("Car", 0.35*SCREENWIDTH, 0.27*SCREENHEIGHT, 12, 255, 255, 255, 0, 0, 0);
				DisplayText(value, 0.60*SCREENWIDTH, 0.27*SCREENHEIGHT, 12, 255, 255, 255, 0, 0, 0);
			}
			
			//Start game!
			if (actual==2){
				DisplayText("Start Game!", 0.37*SCREENWIDTH, 0.50*SCREENHEIGHT, 12, 255, 255, 0, 0, 0, 0);
			}
			else{
				DisplayText("Start Game!", 0.37*SCREENWIDTH, 0.50*SCREENHEIGHT, 12, 255, 255, 255, 0, 0, 0);
			}
				
			// Tell SDL to display our backbuffer. The four 0's will make //
			// SDL display the whole screen. //
			SDL_Flip(g_Window);

			// We've processed a frame so we now need to record the time at which we did it. //
			// This way we can compare this time the next time our function gets called and  //
			// see if enough time has passed between iterations. //
			g_Timer = SDL_GetTicks();
		}
	}
	return leave;
}

// This function simply clears the back buffer to black. //
void ClearScreen()
{
	// This function just fills a surface with a given color. The //
	// first 0 tells SDL to fill the whole surface. The second 0  //
	// is for black. //
	SDL_FillRect(g_Window, 0, 0);
}

// This function displays text to the screen. It takes the text //
// to be displayed, the location to display it, the size of the //
// text, and the color of the text and background.              //
void DisplayText(char* text, int x, int y, int size, int fR, int fG, int fB, int bR, int bG, int bB) 
{
	// Open our font and set its size to the given parameter. //
    TTF_Font* font = TTF_OpenFont("arial.ttf", size);

	SDL_Color foreground  = { fR, fG, fB};   // Text color. //
	SDL_Color background  = { bR, bG, bB };  // Color of what's behind the text. //

	// This renders our text to a temporary surface. There //
	// are other text functions, but this one looks nice.  //
	SDL_Surface* temp = TTF_RenderText_Shaded(font, text, foreground, background);

	// A structure storing the destination of our text. //
	SDL_Rect destination = { x, y, 0, 0 };
	
	// Blit the text surface to our window surface. //
	SDL_BlitSurface(temp, NULL, g_Window, &destination);

	// Always free memory! //
	SDL_FreeSurface(temp);

	// Close the font. //
	TTF_CloseFont(font);
}

// This function receives player input and //
// handles it for the game's menu screen.  //
void HandleMenuInput() 
{
	SDL_Event g_Event;
	// Fill our event structure with event information. //
	if ( SDL_PollEvent(&g_Event) )
	{
		// Handle user manually closing game window //
		if (g_Event.type == SDL_QUIT)
		{
			leave=2; //exit game
			return;
		}

		// Handle keyboard input here //
		if (g_Event.type == SDL_KEYDOWN)
		{
			if (g_Event.key.keysym.sym == SDLK_ESCAPE)
			{
				leave=2; //exit game!
				return;
			}
			// Moving...
			if (g_Event.key.keysym.sym == SDLK_DOWN)
			{
				if (actual<2) actual++;
				return; 
			}
			if (g_Event.key.keysym.sym == SDLK_UP)
			{
				if (actual>0) actual--;
				return;
			}
			//Change value?
			if (g_Event.key.keysym.sym == SDLK_RIGHT)
			{
				if (actual==0){ if (selected_track<7) selected_track++; }
				else if (actual==1){ if (selected_car<6) selected_car++; }
				return; 
			}
			if (g_Event.key.keysym.sym == SDLK_LEFT)
			{
				if (actual==0){ if (selected_track>1) selected_track--; }
				else if (actual==1){ if (selected_car>1) selected_car--; }
				return;
			}
			//Start game?
			if (g_Event.key.keysym.sym == SDLK_RETURN)
			{
				if (actual==2) leave=1;
				return;
			}
			
		}
	}
}
