/*
Copyright (C) 2007-2010 Victor Matei Petrescu

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <SDL/SDL.h>     // Main SDL header 
#include <SDL/SDL_TTF.h> // True Type Font header

#include "config.h"

#define FRAMES_PER_SECOND 30
#define FRAME_RATE 1000/FRAMES_PER_SECOND  

void initTTF(void);
void freeTTF(void);
int do_menu(SDL_Surface *screen);

// Helper functions for the main game state functions //
void ClearScreen();
void DisplayText(char* text, int x, int y, int size, int fR, int fG, int fB, int bR, int bG, int bB);
void HandleMenuInput();

SDL_Surface *g_Window;
int g_Timer;
int leave; //exit menu?
int actual; //actual option selected

//Our options
int selected_track;
int selected_car;
