#define MR_MAX_COLORS 127

#define MR_TRADEMARK_SIZE 299
#define MR_TRADEMARK_WIDTH 22
#define MR_TRADEMARK_HEIGHT 12

#define MR_SEGA_SIZE 4311
#define MR_SEGA_WIDTH 291
#define MR_SEGA_HEIGHT 89

#define MR_USER_MAX_SIZE 8192
#define MR_USER_WIDTH 320
#define MR_USER_HEIGHT 90

typedef struct {
    char id[2];
    unsigned short size;
    char crap0[6];
    unsigned short offset;
    char crap1[2];
    unsigned short width;
    char crap2[2];
    unsigned short height;
    char crap3[6];
    unsigned short colors;
    char crap4[2];
    char palette[MR_MAX_COLORS * 4];
    char bitmap[MR_USER_MAX_SIZE - 1]; /* actual size defined in size */
    char bitmap_expanded[MR_USER_WIDTH * MR_USER_HEIGHT];
} typemr;

typedef enum {
    unscrambled,
    sh_elf,
    scrambled
} enummbf;

typedef struct {
    char hardware_id[17]; /* always "SEGA SEGAKATANA " */
    char maker_id[17]; /* always "SEGA ENTERPRISES" */
    char checksum[5];
    char disc_info[12];
    char area_symbols[4];
    char peripherals[8];
    int mouse;
    int gun;
    int keyboard;
    int expand_analog_vert;
    int expand_analog_hor;
    int analog_vert_controller;
    int analog_hor_controller;
    int analog_l_trigger;
    int analog_r_trigger;
    int expand_dir_buttons;
    int z_button;
    int y_button;
    int x_button;
    int d_button;
    int c_button;
    int start_abdir_buttons;
    int memory_card;
    int microphone_card;
    int purupuru_card;
    int other;
    int vga_box;
    int windowsce;
    char product_id[11];
    char product_version[6];
    char release_date[9];
    char boot_filname[17];
    char company_name[17];
    char software_name[129];
    char mr_trademark[MR_TRADEMARK_SIZE];
    char mr_sega[MR_SEGA_SIZE];
    char mr_user[MR_USER_MAX_SIZE];
} typebsf;
