#include <stdio.h>

#include "main.h"

typebsf bs;

int read_bsf(char *bsf); /* prototype */

/*
void set(int *arg, int FLAG)	{
    *arg |= FLAG;
}

void clear(int *arg, int FLAG)	{
    *arg &= ~FLAG;
}

int check(int *arg, int FLAG)	{
    return(*arg & FLAG) != 0;
}

void toggle(int *arg, int FLAG)	{
    *arg ^= FLAG;
} */

int main(int argc, char *argv[])	{
    int rets;

    if(argc != 2)	{
        printf("Usage: %s IP.BIN\n", argv[0]);
        return -1;
    }

    rets = read_bsf(argv[1]);
    if(rets)	{
        printf("Error in read_bsf()\n");
        return -1;
    }

    printf("bs.hardware_id: %s\n", bs.hardware_id);
    printf("bs.maker_id: %s\n", bs.maker_id);
    printf("bs.checksum: %s\n", bs.checksum);
    printf("bs.disc_info: %s\n", bs.disc_info);
    printf("bs.area_symbols: %s\n", bs.area_symbols);
    printf("bs.peripherals: %s\n", bs.peripherals);
    printf("bs.expand_analog_vert: %i\n", bs.expand_analog_vert);
    printf("bs.keyboard: %i\n", bs.keyboard);
    printf("bs.gun: %i\n", bs.gun);
    printf("bs.mouse: %i\n", bs.mouse);
    printf("bs.analog_l_trigger: %i\n", bs.analog_l_trigger);
    printf("bs.analog_vert_controller: %i\n", bs.analog_vert_controller);
    printf("bs.analog_hor_controller: %i\n", bs.analog_hor_controller);
    printf("bs.expand_analog_hor: %i\n", bs.expand_analog_hor);
    printf("bs.y_button: %i\n", bs.y_button);
    printf("bs.expand_dir_buttons: %i\n", bs.expand_dir_buttons);
    printf("bs.z_button: %i\n", bs.z_button);
    printf("bs.analog_r_trigger: %i\n", bs.analog_r_trigger);
    printf("bs.start_abdir_buttons: %i\n", bs.start_abdir_buttons);
    printf("bs.d_button: %i\n", bs.d_button);
    printf("bs.c_button: %i\n", bs.c_button);
    printf("bs.x_button: %i\n", bs.x_button);
    printf("bs.other: %i\n", bs.other);
    printf("bs.microphone_card: %i\n", bs.microphone_card);
    printf("bs.purupuru_card: %i\n", bs.purupuru_card);
    printf("bs.memory_card: %i\n", bs.memory_card);
    printf("bs.vga_box: %i\n", bs.vga_box);
    printf("bs.windowsce: %i\n", bs.windowsce);
    printf("bs.product_id: %s\n", bs.product_id);
    printf("bs.product_version: %s\n", bs.product_version);
    printf("bs.release_date: %s\n", bs.release_date);
    printf("bs.boot_filname: %s\n", bs.boot_filname);
    printf("bs.company_name: %s\n", bs.company_name);
    printf("bs.software_name: %s\n", bs.software_name);

/*  if(bs.mr_trademark[0] == 'M' && bs.mr_trademark[1] == 'R')	{
        fp = fopen("trademark.mr", "wb");
        if(!fp)
            return -1;

        fwrite(bs.mr_trademark, 1, sizeof(bs.mr_trademark), fp);

        fclose(fp);
    }

    if(bs.mr_sega[0] == 'M' && bs.mr_sega[1] == 'R')	{
        fp = fopen("sega.mr", "wb");
        if(!fp)
            return -1;

        fwrite(bs.mr_sega, 1, sizeof(bs.mr_sega), fp);

        fclose(fp);
    }

    if(bs.mr_user[0] == 'M' && bs.mr_user[1] == 'R')	{
        fp = fopen("user.mr", "wb");
        if(!fp)
            return -1;

        fwrite(bs.mr_user, 1, sizeof(bs.mr_user), fp);

        fclose(fp);
    } */

    return 0;
}

int read_peripheral(int ascii, int *FLAG1, int *FLAG2, int *FLAG3,
      int *FLAG4)	{
    switch(ascii)	{
        case '1': /* 10001100 */
            *FLAG1 = 1;
            if(FLAG2 != NULL)
                *FLAG2 = 0;
            if(FLAG3 != NULL)
                *FLAG3 = 0;
            if(FLAG4 != NULL)
                *FLAG4 = 0;
            break;
        case '2': /* 01001100 */
            *FLAG1 = 0;
            *FLAG2 = 1;
            *FLAG3 = 0;
            *FLAG4 = 0;
            break;
        case '3': /* 11001100 */
            *FLAG1 = 1;
            *FLAG2 = 1;
            *FLAG3 = 0;
            *FLAG4 = 0;
            break;
        case '4': /* 00101100 */
            *FLAG1 = 0;
            *FLAG2 = 0;
            *FLAG3 = 1;
            *FLAG4 = 0;
            break;
        case '5': /* 10101100 */
            *FLAG1 = 1;
            *FLAG2 = 0;
            *FLAG3 = 1;
            *FLAG4 = 0;
            break;
        case '6': /* 01101100 */
            *FLAG1 = 0;
            *FLAG2 = 1;
            *FLAG3 = 1;
            *FLAG4 = 0;
            break;
        case '7': /* 11101100 */
            *FLAG1 = 1;
            *FLAG2 = 1;
            *FLAG3 = 1;
            *FLAG4 = 0;
            break;
        case '8': /* 00011100 */
            *FLAG1 = 0;
            *FLAG2 = 0;
            *FLAG3 = 0;
            *FLAG4 = 1;
            break;
        case '9': /* 10011100 */
            *FLAG1 = 1;
            *FLAG2 = 0;
            *FLAG3 = 0;
            *FLAG4 = 1;
            break;
        case 'A': /* 10000010 */
            *FLAG1 = 0;
            *FLAG2 = 1;
            *FLAG3 = 0;
            *FLAG4 = 1;
            break;
        case 'B': /* 01000010 */
            *FLAG1 = 1;
            *FLAG2 = 1;
            *FLAG3 = 0;
            *FLAG4 = 1;
            break;
        case 'C': /* 11000010 */
            *FLAG1 = 0;
            *FLAG2 = 0;
            *FLAG3 = 1;
            *FLAG4 = 1;
            break;
        case 'D': /* 00100010 */
            *FLAG1 = 1;
            *FLAG2 = 0;
            *FLAG3 = 1;
            *FLAG4 = 1;
            break;
        case 'E': /* 10100010 */
            *FLAG1 = 0;
            *FLAG2 = 1;
            *FLAG3 = 1;
            *FLAG4 = 1;
            break;
        case 'F': /* 01100010 */
            *FLAG1 = 1;
            *FLAG2 = 1;
            *FLAG3 = 1;
            *FLAG4 = 1;
            break;
        default: /* 0000110 or other */
            *FLAG1 = 0;
            if(FLAG2 != NULL)
                *FLAG2 = 0;
            if(FLAG3 != NULL)
                *FLAG3 = 0;
            if(FLAG4 != NULL)
                *FLAG4 = 0;
            break;
    }

    return 0;
}

int read_bsf(char *bsf)	{
    FILE *fp;

    fp = fopen(bsf, "r");
    if(!fp)
        return -1;

    fread(bs.hardware_id, sizeof(bs.hardware_id) - 1, 1, fp);
    fread(bs.maker_id, sizeof(bs.maker_id) - 1, 1, fp);
    fread(bs.checksum, sizeof(bs.checksum) - 1, 1, fp);
    fseek(fp, 1, SEEK_CUR);
    fread(bs.disc_info, sizeof(bs.disc_info) - 1, 1, fp);
    fread(bs.area_symbols, sizeof(bs.area_symbols) - 1, 1, fp);
    fseek(fp, 5, SEEK_CUR);
    fread(bs.peripherals, sizeof(bs.peripherals) - 1, 1, fp);
    read_peripheral(bs.peripherals[0], &bs.expand_analog_vert, &bs.keyboard,
          &bs.gun, &bs.mouse);
    read_peripheral(bs.peripherals[1], &bs.analog_l_trigger,
          &bs.analog_vert_controller, &bs.analog_hor_controller,
          &bs.expand_analog_hor);
    read_peripheral(bs.peripherals[2], &bs.y_button, &bs.expand_dir_buttons,
          &bs.z_button, &bs.analog_r_trigger);
    read_peripheral(bs.peripherals[3], &bs.start_abdir_buttons, &bs.d_button,
          &bs.c_button, &bs.x_button);
    read_peripheral(bs.peripherals[4], &bs.other, &bs.microphone_card,
          &bs.purupuru_card, &bs.memory_card);
    read_peripheral(bs.peripherals[5], &bs.vga_box, NULL, NULL, NULL);
    read_peripheral(bs.peripherals[6], &bs.windowsce, NULL, NULL, NULL);
    fseek(fp, 1, SEEK_CUR);
    fread(bs.product_id, sizeof(bs.product_id) - 1, 1, fp);
    fseek(fp, 1, SEEK_CUR);
    fread(bs.product_version, sizeof(bs.product_version) - 1, 1, fp);
    fread(bs.release_date, sizeof(bs.release_date) - 1, 1, fp);
    fseek(fp, 8, SEEK_CUR);
    fread(bs.boot_filname, sizeof(bs.boot_filname) - 1, 1, fp);
    fread(bs.company_name, sizeof(bs.company_name) - 1, 1, fp);
    fread(bs.software_name, sizeof(bs.software_name) - 1, 1, fp);
    fseek(fp, 8556, SEEK_CUR);
    fread(bs.mr_trademark, sizeof(bs.mr_trademark), 1, fp);
    fread(bs.mr_sega, sizeof(bs.mr_sega), 1, fp);
    fseek(fp, 946, SEEK_CUR);
    fread(bs.mr_user, sizeof(bs.mr_user), 1, fp);

    fclose(fp);

    return 0;
}
