/* Dream Break v0.2 - KOS 2010
   by David Persik */

//#include <stdlib.h>
//#include <time.h>
//#include <stdio.h>

#include "colors.h"
#include "config.h"
#include "draw.h"

#include <kos.h>
KOS_INIT_FLAGS(INIT_DEFAULT); 

int block_count;
int paddlex;
int paddley;

int paddlex_old;
int paddley_old;

int ballx;
int bally;
int ballxs;
int ballys;

int ballx_old;
int bally_old;

int no_balls;
int speed = SPEED;
int score;
char score_str[20];
char no_balls_str[3];

int game;

int block[72];
int color[9];

//KOS Updated code to get controller and mouse
maple_device_t *mcont,*mmouse;
cont_state_t *cond;
mouse_state_t *mcond;


unsigned long seed=123;
#define RNDC 1013904223
#define RNDM 1164525

int my_rand() {
        seed = seed * RNDM + RNDC;
        return seed;
}

int randnum(int limit) { return (my_rand() & 0x7fffffff) % limit; }


void load()
{
	no_balls = START_BALLS;
	score = 0;
	block_count = 0;
}

void between()
{
	int x,y,c;
	unsigned int count = 0;
	int color[MAX_COLORS];

	color[0] = BLACK;
	color[1] = WHITE;
	color[2] = RED;
	color[3] = ORANGE;
	color[4] = YELLOW;
	color[5] = GREEN;
	color[6] = BLUE;
	color[7] = INDIGO;
	color[8] = VIOLET;

	while (count < 1000000) {
		//srand(time(NULL));
		x = randnum(SCREEN_W);
		y = randnum(SCREEN_H);
		c = randnum(7) + 1;
		put_pixel(x,y,color[c]);
		count++;
	}
	while (count > 0) {
		x = randnum(SCREEN_W);
		y = randnum(SCREEN_H);
		//c = random() & 7;
		put_pixel(x,y,BLACK);
		count--;
	}
}

void draw_screen()
{
	int i,j;
	int c = 2;
	int block_color;
	int color[MAX_COLORS];

	color[0] = BLACK;
	color[1] = WHITE;
	color[2] = RED;
	color[3] = ORANGE;
	color[4] = YELLOW;
	color[5] = GREEN;
	color[6] = BLUE;
	color[7] = INDIGO;
	color[8] = VIOLET;

	speed = SPEED;

	paddlex = PADDLE_X;
	paddley = PADDLE_Y;
	paddlex_old = PADDLE_X;
	paddley_old = PADDLE_Y;

	//ballx = BORDER_W + randnum(SCREEN_W - 2*BORDER_W - 2*BALL_W) + BALL_W;
	ballx = BALL_X;
	bally =  BALL_Y;
	ballx_old = BALL_X;
	bally_old = BALL_Y;
	ballxs = BALL_XS;
	ballys = BALL_YS;

	clear_screen(SCREEN_COLOR);

	sprintf (score_str,"%d",score);
	//KOS - 4 args:
	//uint16 *buffer, int width, int opaque, char *str
	bfont_draw_str(vram_s + ( 20*SCREEN_W + 100), SCREEN_W, 0, score_str);
	sprintf (no_balls_str,"%d",no_balls);
	bfont_draw_str(vram_s + ( 20*SCREEN_W + 500), SCREEN_W, 0, no_balls_str);

	/* Draw initial paddle */
	rect_fill(paddlex, paddley, paddlex + PADDLE_W, paddley + PADDLE_H, PADDLE_COLOR );

	/* Draw border */
	rect_fill (0, TOP, SCREEN_W, TOP + BORDER_W, BORDER_COLOR);
	rect_fill (0, TOP, BORDER_W, SCREEN_H, BORDER_COLOR);
	rect_fill (SCREEN_W - BORDER_W, TOP, SCREEN_W, SCREEN_H, BORDER_COLOR);

	/* Draw blocks */
	for (j = BLOCK_START ; j < BLOCK_START + BLOCK_H * NO_ROWS; j += BLOCK_H)
	{
		block_color = color[c];
		for (i = BORDER_W + 1; i < SCREEN_W - BLOCK_W; i += BLOCK_W)
		{
			block[block_count] = 1;
			rect_fill(i, j, i + BLOCK_W, j + BLOCK_H, block_color);
			block_count++;
			vid_waitvbl();
		}
		c++;
	}
}



void detect_collision()
{
		int i,j;
		int c = 0;
		int block_row = 6;
		int checkx = ballx;
		int checky = bally;

		if (ballys > 0)
			checky += BALL_W;
		if (ballxs > 0)
			checkx += BALL_W;

		/* missed ball */
		if (paddley - bally <= BALL_W - 1)
		{
			/* erase ball */
			rect_fill(ballx_old, bally_old, ballx_old + BALL_W, bally_old + BALL_W, SCREEN_COLOR);

			--no_balls;
			ballx = BORDER_W + randnum(SCREEN_W - 2*BORDER_W - 2*BALL_W) + BALL_W;
			//ballx = ballx < BORDER_W + BALL_W ? BORDER_W + BALL_W : ballx;
			//ballx = ballx > SCREEN_W - BALL_W - BORDER_W ? SCREEN_W - BALL_W - BORDER_W : ballx;
			bally = BALL_Y;
			ballxs = randnum(4) < 2 ? 1 : -1;
			ballys = BALL_YS;
			speed = SPEED;

			sprintf (no_balls_str,"%d",no_balls);
			rect_fill(320, 0, 640, 40, SCREEN_COLOR);
			bfont_draw_str(vram_s + ( 20*SCREEN_W + 500), SCREEN_W, 0, no_balls_str);

			thd_sleep(1000);
			return;
		}

		/* ball hit side of screen */
		else if ( (ballx >= SCREEN_W - BALL_W - BORDER_W - 1) || (ballx <= BORDER_W + 1) )
		{
			if (bally <= TOP + BORDER_W + 1)
				ballys = -ballys;

			ballxs = -ballxs;
			ballx = ballx_old;
			bally = bally_old;
			return;
		}

		/* ball hit paddle */
		else if ( ( paddley - checky <= 1) && (checkx >= paddlex) && (checkx <= paddlex + PADDLE_W) )
		{
			if ( (ballxs < 0) && (checkx > paddlex + PADDLE_W/2) )
				ballxs = -ballxs;
			if ( (ballxs > 0) && (checkx < paddlex + PADDLE_W/2) )
				ballxs = -ballxs;

			if (mcond->dx > 1)
				ballxs += 1;

			if (mcond->dx < -1)
				ballxs -= 1;

			if (ballxs == 0)
				ballxs = 1;

			ballys = - ballys;
			return;
		}

		/* ball hit top */
		else if (bally <= TOP + BORDER_W + 1)
		{
			ballys = -ballys;
			speed -= 2;
			//speed can't be negative!
			if (speed < 0) speed = 0;
			return;
		}

		/* ball hit block? */
		else
		{
			for (j = BLOCK_START ; j < BLOCK_START + BLOCK_H * NO_ROWS; j += BLOCK_H)
			{
				for (i = BORDER_W + 1; i < SCREEN_W - BLOCK_W; i += BLOCK_W)
				{
					if ( (checkx >= i) && (checkx <= i + BLOCK_W) && (checky >= j) && (checky <= j + BLOCK_H) && block[c] )
					{
						/* hit block */

						/* reverse ball direction*/
						if (game == 1 || game == 2)
						{
							if ((checky == j) || (checky == j + BLOCK_H))
							{
								ballys = -ballys;
								bally += 2 * ballys;
							}
							if ((checkx == i) || (checkx == i + BLOCK_W))
							{
								ballxs = -ballxs;
								ballx += 2 * ballxs;
							}
						}

						/* erase block */
						block[c] = 0;
						rect_fill(i, j, i + BLOCK_W, j + BLOCK_H, SCREEN_COLOR);
						block_count--;

						/* increment score */
						score += (10 * block_row);
						sprintf (score_str,"%d",score);
						rect_fill(0, 0, 320, 40, SCREEN_COLOR);
						bfont_draw_str(vram_s + ( 20*SCREEN_W + 100), SCREEN_W, 0, score_str);

						/* any blocks left? */
						if (block_count == 0)
						{
							thd_sleep(1000);
							between();
							draw_screen();
						}
						return; /* only hit one block */
					}
					c++; /* increase block count */
				}
				block_row--;
			}
		}
}

int main_menu()
{
	int i,j;
	int x = 320;
	int y = 240;
	int old_x = x;
	int old_y = y;
	int c;
	int old_color[(BALL_W+1) * (BALL_W+1)];

	for (c = 0; c < (BALL_W+1) * (BALL_W+1); c++)
		old_color[c] = SCREEN_COLOR;

	clear_screen(SCREEN_COLOR);

	bfont_draw_str(vram_s + ( 40*640+240), 640, 0, "Dream Break");
	bfont_draw_str(vram_s + (130*640+230), 640, 0, "Select a Game");
	//bfont_draw_str(vram_s + (160*640+10), 640, 0, "Press right mouse button for Game 2");

	rect_fill(0,  280,320,380,RED);
	rect_fill(0,  380,320,480,BLUE);
	rect_fill(320,280,639,380,ORANGE);
	rect_fill(320,380,639,480,VIOLET);

	bfont_draw_str(vram_s + (320*640+100), 640, 0, "Game 1");
	bfont_draw_str(vram_s + (420*640+100), 640, 0, "Game 3");
	bfont_draw_str(vram_s + (320*640+420), 640, 0, "Game 2");
	bfont_draw_str(vram_s + (420*640+420), 640, 0, "Game 4");

	/* draw cursor */
	rect_fill(x, y, x + BALL_W, y + BALL_W, BALL_COLOR);

    mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
	
	if (!mcont) {
		printf("No controllers attached!\r\n");
		return -1;
	}

	mmouse = maple_enum_type(0, MAPLE_FUNC_MOUSE);

	if (!mmouse) {
		printf("No mice attached!\r\n");
		return -1;
	}

	while (1)
	{
		cond = (cont_state_t *)maple_dev_status(mcont);
		if (!cond){
			printf("Error getting controller status\r\n");
			return -1;
		}
		
		/* Check for start on the controller */
		if (cond->buttons & CONT_START) {
			printf("Pressed start\r\n");
			return -1;
		}
		
		/* Check for mouse input */
		mcond = (mouse_state_t *)maple_dev_status(mmouse);
		if (!mcond){
			printf("Error checking mouse status\r\n");
			return -1;
		}

		/* Mouse has moved */
		if (mcond->dx || mcond->dy)
		{
			/* move cursor */
			x += mcond->dx;
			y += mcond->dy;

			/* check borders */
			x = x < 0   ? 0   : x;
			x = x > SCREEN_W - BALL_W - 1 ? SCREEN_W - BALL_W - 1: x;
			y = y < 0   ? 0   : y;
			y = y > SCREEN_H - BALL_W ? SCREEN_H - BALL_W : y;

			/* erase cursor */
			for (j=0; j <= BALL_W; j++)
			{
				for (i=0;i<=BALL_W; i++)
				{
					put_pixel(old_x+i,old_y+j,old_color[i+j*(BALL_W + 1)]);
				}
			}

			/* record the pixels under where the cursor will be */
			for (j=0; j <= BALL_W; j++)
			{
				for (i=0;i<=BALL_W; i++)
				{
					old_color[i+j*(BALL_W+1)] = get_pixel(x+i,y+j);
				}
			}

			/* draw cursor */
			rect_fill(x, y, x + BALL_W, y + BALL_W, BALL_COLOR);

			old_x = x;
			old_y = y;
			
			/* WAIT for video!!! */
			vid_waitvbl();
		}

		/* Check left mouse button */
		if (mcond->buttons & MOUSE_LEFTBUTTON)
		{
			if (x > 0   && x < 320 && y > 280 && y < 380)
				return 1;
			if (x > 0   && x < 320 && y > 380 && y < 480)
				return 3;
			if (x > 320 && x < 640 && y > 280 && y < 380)
				return 2;
			if (x > 320 && x < 640 && y > 380 && y < 480)
				return 4;
		}
	}
}

void game_over()
{
	bfont_draw_str(vram_s + (300*640+250), 640, 0, " GAME OVER ");
	thd_sleep(3*1000);
}

void game_loop()
{
	
    mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);

	if (!mcont) {
		printf("No controllers attached!\r\n");
		return;
	}
	
	mmouse = maple_enum_type(0, MAPLE_FUNC_MOUSE);

	if (!mmouse) {
		printf("No mice attached!\r\n");
		return;
	}

	printf("Starting Main Loop\r\n");
	while (1)
	{
		/* Check for start on the controller */
		cond = (cont_state_t *)maple_dev_status(mcont);
		if (!cond) {
			printf("Error getting controller status\r\n");
			return;
		}

		if (cond->buttons & CONT_START) {
			printf("Pressed start\r\n");
			return;
		}

		/* Check for mouse input */
		mcond = (mouse_state_t *)maple_dev_status(mmouse);
		if (!mcond) {
			printf("Error checking mouse status\r\n");
			return;
		}
		/* Mouse has moved */
		if (mcond->dx)
		{
			/* move paddle */
			paddlex += mcond->dx;

			/* check borders */
			paddlex = paddlex <= BORDER_W + 1  ? BORDER_W + 1  : paddlex;
			paddlex = paddlex >= SCREEN_W - BORDER_W - PADDLE_W - 1 ? SCREEN_W - BORDER_W - PADDLE_W - 1 : paddlex;

			/* erase the paddle */
			rect_fill(paddlex_old, paddley_old, paddlex_old + PADDLE_W, paddley + PADDLE_H, SCREEN_COLOR);

			/* draw the paddle */
			rect_fill(paddlex, paddley, paddlex + PADDLE_W, paddley + PADDLE_H, PADDLE_COLOR );

			/* save old position for next erase */
			paddlex_old = paddlex;
			paddley_old = paddley;
			
		}

		/* move ball */
		ballx += ballxs;
		bally += ballys;

		if ((game == 2 || game == 4) && (ballys < 0))
			ballx += mcond->dx;

		detect_collision();

		if (no_balls < 1)
			return;

		vid_waitvbl();
		thd_sleep(speed);

		/* erase ball */
		rect_fill(ballx_old, bally_old, ballx_old + BALL_W, bally_old + BALL_W, SCREEN_COLOR);

		/* draw ball */
		rect_fill(ballx, bally, ballx + BALL_W, bally + BALL_W, BALL_COLOR);

		ballx_old = ballx;
		bally_old = bally;

	}
}

void dream_break() {
	load(); //init() is a reserved function
	draw_screen();
	game_loop();
	game_over();
}

int main() {

	/* Do initial setup */
	vid_set_mode(DM_640x480_PAL_IL,PM_RGB565);

	/* Do the main menu */
	while (1) {
		printf("Running menu\r\n");
		game = main_menu();
		printf("Back from menu\r\n");
		switch(game) {
			case 0:
				return 0;
			case 1:
				dream_break();
				break;
			case 2:
				dream_break();
				break;
			case 3:
				dream_break();
				break;
			case 4:
				dream_break();
				break;
			case -1:
				return -1;
		}
		printf("Out of switch\r\n");
	}

	return 0;
}
