//#include "dream.h"
#include <kos.h>
#include <stdlib.h> //abs

#define PI 3.14159265358979;

void clear_screen(int rgb)
{
	int i;
	//KOS: location = x_coordinate + (y_coordinate * width)
	//For 640x480, last location is: 640 + (480 * 640) = 307840
	for (i=0; i< 307840; i++)
		vram_s[i] = rgb;
}

void put_pixel(int x, int y, int rgb)
{
	vram_s[y*640+x] = rgb;
}

int get_pixel(int x, int y)
{
	return vram_s[y*640+x];
}

int sign(int value)
{
	return value < 0 ? -1 : 1;
}

void line(int x1, int y1, int x2, int y2, int rgb)
{
   int d, x, y, ax, ay, sx, sy, dx, dy;

   dx = x2-x1;
   ax = abs(dx) << 1;
   sx = sign(dx);
   dy = y2-y1;
   ay = abs(dy) << 1;
   sy = sign(dy);

   x = x1;
   y = y1;
   if( ax > ay )
   {
      d = ay - (ax >> 1);
      while( x != x2 )
      {
         put_pixel(x, y, rgb);
         if( d >= 0 )
         {
            y += sy;
            d -= ax;
         }
         x += sx;
         d += ay;
      }
   }
   else
   {
      d = ax - (ay >> 1);
      while( y != y2 )
      {
         put_pixel(x, y, rgb);
         if( d >= 0 )
         {
            x += sx;
            d -= ay;
         }
         y += sy;
         d += ax;
      }
   }
}


void filled_square(int x, int y, int width, int color)
{
	int i,j;
	for (i = y - width; i < y + width; i++) {
		for (j = x - width; j < x + width; j++) {
			vram_s[i*640+j] = color;
		}
	}
}

void square(int x, int y, int width, int color)
{
	line (x - width/2 ,y - width/2, x + width/2, y - width/2,color);
	line (x - width/2, y + width/2, x + width/2, y + width/2,color);
	line (x - width/2, y - width/2, x - width/2, y + width/2,color);
	line (x + width/2, y - width/2, x + width/2, y + width/2,color);
}

void circle(int x, int y, int radius, int d)
{
   int cx = 0;
   int cy = radius;
   int df = 1 - radius;
   int d_e = 3;
   int d_se = -2 * radius + 5;

   do {
      put_pixel(x+cx, y+cy, d);

      if (cx)
	 put_pixel(x-cx, y+cy, d);

      if (cy)
	 put_pixel(x+cx, y-cy, d);

      if ((cx) && (cy))
	 put_pixel(x-cx, y-cy, d);

      if (cx != cy) {
	 put_pixel(x+cy, y+cx, d);

	 if (cx)
	    put_pixel(x+cy, y-cx, d);

	 if (cy)
	    put_pixel(x-cy, y+cx, d);

	 if (cx && cy)
	    put_pixel(x-cy, y-cx, d);
      }

      if (df < 0)  {
	 df += d_e;
	 d_e += 2;
	 d_se += 2;
      }
      else {
	 df += d_se;
	 d_e += 2;
	 d_se += 4;
	 cy--;
      }

      cx++;

   } while (cx <= cy);
}

void circle_fill(int x, int y, int radius, int color)
{
   int cx = 0;
   int cy = radius;
   int df = 1 - radius;
   int d_e = 3;
   int d_se = -2 * radius + 5;

   do {
      line(x-cy, y-cx, x+cy, y-cx, color);

      if (cx)
	 line(x-cy, y+cx, x+cy, y+cx, color);

      if (df < 0)  {
	 df += d_e;
	 d_e += 2;
	 d_se += 2;
      }
      else {
	 if (cx != cy) {
	    line(x-cx, y-cy, x+cx, y-cy, color);

	    if (cy)
	       line(x-cx, y+cy, x+cx, y+cy, color);
	 }

	 df += d_se;
	 d_e += 2;
	 d_se += 4;
	 cy--;
      }

      cx++;

   } while (cx <= cy);

}

void rect (int x1, int y1, int x2, int y2, int rgb)
{
	line(x1,y1,x1,y2,rgb);
	line(x1,y2,x2,y2,rgb);
	line(x2,y2,x2,y1,rgb);
	line(x2,y1,x1,y1,rgb);
}

void rect_fill (int x1, int y1, int x2, int y2, int rgb)
{
	int i,j;
	for (i = y1; i <= y2; i++)
	{
		for (j = x1; j <= x2; j++)
		{
			vram_s[i*640+j] = rgb;
		}
	}
}
