#include <kos.h>
#include <stdlib.h> //abs
#define PI 3.14159265358979;

void screen_color(int rgb)
{
	int i;
	//KOS: location = x_coordinate + (y_coordinate * width)
	//For 640x480, last location is: 640 + (480 * 640) = 307840
	for (i=0; i< 307840; i++)
		vram_s[i] = rgb;
}

void put_pixel(int x, int y, int rgb)
{
	//Check X border...
	if (x>638) x=638;
	vram_s[y*640+x] = rgb;
}

int get_pixel(int x, int y)
{
	//Check X border...
	if (x>638) x=638;
	return vram_s[y*640+x];
}

void line(int x1, int y1, int x2, int y2, int width, int color)
{
	int a,xi,yi,length;
	float x, y, xinc, yinc;

	length = abs(x2-x1);
	if (abs(y2-y1)>length) {
		length = abs(y2-y1);
	}
	//Check division by 0!
	if (length==0) length=1;
	xinc = (x2-x1)/length;
	yinc = (y2-y1)/length;
	x=x1+0.5;
	y=y1+0.5;
	for (a=1;a<=length;a++) {
		xi = x;
		yi = y;
		vram_s[yi*640+xi] = color;
		x += xinc;
		y += yinc;
	}
}

void filled_square(int x, int y, int width, int color)
{
	int i,j;
	for (i = y - width; i < y + width; i++) {
		for (j = x - width; j < x + width; j++) {
			vram_s[i*640+j] = color;
		}
	}
}

void square(int x, int y, int width, int color)
{
	line (x - width/2 ,y - width/2, x + width/2, y - width/2,1,color);
	line (x - width/2, y + width/2, x + width/2, y + width/2,1,color);
	line (x - width/2, y - width/2, x - width/2, y + width/2,1,color);
	line (x + width/2, y - width/2, x + width/2, y + width/2,1,color);
}

void circle (int x, int y, int r, int rgb)
{
	int xplot = x + r;
	int yplot = y;
	int xplot_old = xplot;
	int yplot_old = yplot;
	int deg;
	//float theta;

	for (deg = 0; deg < 360; deg++)
	{
		//theta = deg / 180 * PI;
		//xplot = xplot_old * cos(deg) + yplot_old * sin(deg);
		//yplot = yplot_old * cos(deg) - xplot_old * sin(deg);

		vram_s[yplot*640+xplot] = rgb;

		xplot_old = xplot;
		yplot_old = yplot;
	}
}
