/* Dream Paint v0.02 */
#include "draw.h"

#include <kos.h>
KOS_INIT_FLAGS(INIT_DEFAULT); 

const int MAX_COLORS= 9;

const int black 	= 0;
const int white 	= 65535;
const int red 		= 64000;
const int orange	= 58887;
const int yellow 	= 57255;
const int green 	= 10000;
const int blue 		= 255;
const int indigo 	= 33333;
const int violet 	= 49500;

int canvas_color = 1;
int gui = 1;

//KOS Updated code to get controller and mouse
maple_device_t *mcont,*mmouse;
cont_state_t *cond;
mouse_state_t *mcond;

/* Setup the screen - draw the tool bar etc */
void draw_gui()
{
	int x, y;
	int gui_color;

	gui_color = canvas_color == black ? white : black;

	/* Quit */
	bfont_draw_str(vram_s + ( 10*640+0), 640, 0, "Quit");
	line(2, 35, 70, 35,  1,gui_color);
	line(70, 0, 70, 479, 1,gui_color);

	/* Clear */
	bfont_draw_str(vram_s + ( 40*640+0), 640, 0, "Clear");
	line(0, 70, 70, 70, 1,gui_color);

	/* Thin Line */
	line(20, 95, 50, 95, 1,gui_color);

	/* Thick Line */
	line(20, 119, 50, 119, 1,gui_color);
	line(20, 120, 50, 120, 1,gui_color);
	line(20, 121, 50, 121, 1,gui_color);

	/* Thicker Line */
	line(20, 143, 50, 143, 1,gui_color);
	line(20, 144, 50, 144, 1,gui_color);
	line(20, 145, 50, 145, 1,gui_color);
	line(20, 146, 50, 146, 1,gui_color);
	line(20, 147, 50, 147, 1,gui_color);

	/* Thickest Line */
	line(20, 162, 50, 162, 1,gui_color);
	line(20, 163, 50, 163, 1,gui_color);
	line(20, 164, 50, 164, 1,gui_color);
	line(20, 165, 50, 165, 1,gui_color);
	line(20, 166, 50, 166, 1,gui_color);
	line(20, 167, 50, 167, 1,gui_color);
	line(20, 168, 50, 168, 1,gui_color);

	/* Super Thick Line */
	line(20, 181, 50, 181, 1,gui_color);
	line(20, 182, 50, 182, 1,gui_color);
	line(20, 183, 50, 183, 1,gui_color);
	line(20, 184, 50, 184, 1,gui_color);
	line(20, 185, 50, 185, 1,gui_color);
	line(20, 186, 50, 186, 1,gui_color);
	line(20, 187, 50, 187, 1,gui_color);
	line(20, 188, 50, 188, 1,gui_color);
	line(20, 189, 50, 189, 1,gui_color);

	/* color pallete */
	line(0, 199, 70, 199, 1,gui_color);
	line(0, 305, 70, 305, 1,gui_color);

	/* selected color box */
	square(35, 385, 52, gui_color);
	//line(9, 359, 61, 359, 1,gui_color);
	//line(9, 411, 61, 411, 1,gui_color);
	//line(9, 359,  9, 411, 1,gui_color);
	//line(61,359, 61, 411, 1,gui_color);

	for(x=0; x<35; x++) {
		for(y=200; y<235; y++)
			put_pixel(x, y, black);
		for(y=235; y<270; y++)
			put_pixel(x, y, red);
		for(y=270; y<305; y++)
			put_pixel(x, y, yellow);
		for(y=305; y<340; y++)
			put_pixel(x, y, blue);
	}
	for(x=35; x<70; x++) {
		for(y=200; y<235; y++)
			put_pixel(x, y, white);
		for(y=235; y<270; y++)
			put_pixel(x, y, orange);
		for(y=270; y<305; y++)
			put_pixel(x, y, green);
		for(y=305; y<340; y++)
			put_pixel(x, y, violet);
	}
}

void select_canvas(int *colors_ptr) {

	int c = 1;

	screen_color(blue);

	bfont_draw_str(vram_s + ( 40*640+10), 640, 0, "Dream Paint (KOS 2.X - 2013) ");
	bfont_draw_str(vram_s + (100*640+10), 640, 0, "Use the mouse wheel to select a canvas color ");
	bfont_draw_str(vram_s + (130*640+10), 640, 0, "Press left mouse button to start");
	//bfont_draw_str(vram_s + (160*640+10), 640, 0, "Press right mouse button for full screen drawing (no GUI)");

	//square(320,240,44,black);

	while (1) {
	
		thd_sleep(20); //Wait before reading...
		
		/* Check for start on the controller */
		cond = (cont_state_t *)maple_dev_status(mcont);
		if (!cond){
			printf("Error getting controller status\r\n");
			return;
		}

		if (cond->buttons & CONT_START) {
			printf("Pressed start\r\n");
			return;
		}

		/* Check for mouse input */
		mcond = (mouse_state_t *)maple_dev_status(mmouse);
		if (!mcond){
			printf("Error checking mouse status\r\n");
			return;
		}

		/* Select canvas */
		c += mcond->dz;
		c = c < 0 ? 0 : c;
		c = c > MAX_COLORS - 1 ? MAX_COLORS - 1 : c;
		canvas_color = *(colors_ptr + c);

		filled_square (320,240,20,canvas_color);

		if (mcond->buttons & MOUSE_LEFTBUTTON){
			printf("buttons = %d\n", mcond->buttons);
			screen_color(canvas_color);
			gui = 1;
			draw_gui();
			return;
		}

		if (mcond->buttons & MOUSE_RIGHTBUTTON){
			gui = 0;
			screen_color(canvas_color);
			return;
		}
	}
}


void dc_paint() {

	int draw_color;
	int x = 160, y = 120;
	int color[MAX_COLORS];
	int *colors_ptr = color;
	int old_color[9];
	int cursor_color;
	int right_button = 0;
	int left_button = 0;
	int r = 0;
	int squarex = 0, squarey = 0;
	int thick_line = 0;
	int t=0,u=0;
	int old_x = 0,old_y = 0;

	mcont = maple_enum_type(0, MAPLE_FUNC_CONTROLLER);
  
	if (!mcont) {
		printf("No controllers attached!\r\n");
		return;
	}
	
	mmouse = maple_enum_type(0, MAPLE_FUNC_MOUSE);
	
	if (!mmouse) {
		printf("No mice attached!\r\n");
		return;
	}

	color[0] = black;
	color[1] = white;
	color[2] = red;
	color[3] = orange;
	color[4] = yellow;
	color[5] = green;
	color[6] = blue;
	color[7] = indigo;
	color[8] = violet;

	select_canvas(colors_ptr);

	draw_color = canvas_color == black ? white : black;
	cursor_color = draw_color;

	filled_square(35, 385, 25, draw_color);

	printf("Starting Main Loop\r\n");
	while (1) {
		
		/* WAIT for video!!! */
		vid_waitvbl();
			
		/* Check for start on the controller */
		cond = (cont_state_t *)maple_dev_status(mcont);
		if (!cond){
			printf("Error getting controller status\r\n");
			return;
		}

		if (cond->buttons & CONT_START) {
			printf("Pressed start\r\n");
			return;
		}

		/* Check for mouse input */
		mcond = (mouse_state_t *)maple_dev_status(mmouse);
		if (!mcond){
			printf("Error checking mouse status\r\n");
			return;
		}

		/* Return to Menu */
		if (mcond->buttons & MOUSE_SIDEBUTTON)
		{
			//screen_color(black);
			dc_paint();
		}

		if (!(mcond->buttons & MOUSE_LEFTBUTTON))
		{
			left_button = 0;
		}

		/* Clear screen if both buttons pressed */
		//if (mcond.buttons==249)&&(!pressed_buttons)
		//{
		//	pressed_buttons=1;
		//	screen_color(canvas_color);
		//	draw_gui();
		//}

		/* Change color */
		//i += mcond.dz;
		//i = i < 0 ? 0 : i;
		//i = i > MAX_COLORS - 1 ? MAX_COLORS - 1 : i;
		//draw_color = color[i];

			/* Check left button */
			if ((mcond->buttons & MOUSE_LEFTBUTTON)&& !left_button)
			{

				if (( x < 70 ) && gui)
				{
					/* Return to Menu */
					if ( y < 35)
					{
						thd_sleep(250);
						dc_paint();
					}

					/* Clear The Drawing Area */
					if( y > 35 && y < 70 )
					{
						screen_color(canvas_color);
						draw_gui();
					}

					/* Thin Line */
					if( y > 90 && y < 110 )
					{
						thick_line=0;
					}

					/* Thick Line */
					if( y > 110 && y < 130 )
					{
						thick_line=1;
					}

					/* Thicker Line */
					if( y > 130 && y < 150 )
					{
						thick_line=2;
					}

					/* Thickest Line (so far) */
					if( y > 150 && y < 170 )
					{
						thick_line=3;
					}

					/* Super Thick Line */
					if( y > 170 && y < 190 )
					{
						thick_line=4;
					}

					/* Select a new Colour */
					else if( x < 35 )
					{
						if( y > 199 && y < 235 )
							draw_color = black;
						if( y > 234 && y < 270 )
							draw_color = red;
						if( y > 269 && y < 305 )
							draw_color = yellow;
						if( y > 304 && y < 340 )
							draw_color = blue;
					}
					else
					{
						if( y > 199 && y < 235 )
							draw_color = white;
						if( y > 234 && y < 270 )
							draw_color = orange;
						if( y > 269 && y < 305 )
							draw_color = green;
						if( y > 304 && y < 340 )
							draw_color = violet;
					}
					filled_square(35, 385, 25, draw_color);
				}
				left_button=1;
			}

		/* Mouse has moved */
		if (mcond->dx || mcond->dy)
		{
			/* move cursor */
			x += mcond->dx;
			y += mcond->dy;

			/* check borders */
			x = x < 0   ? 0   : x;
			x = x > 640 ? 640 : x;
			y = y < 0   ? 0   : y;
			y = y > 480 ? 480 : y;

			/* undraw the previous cursor */
			
			put_pixel( old_x,   old_y, old_color[0] );
			put_pixel( old_x-2, old_y, old_color[1] );
			put_pixel( old_x-1, old_y, old_color[2] );
			put_pixel( old_x+1, old_y, old_color[3] );
			put_pixel( old_x+2, old_y, old_color[4] );
			put_pixel( old_x, old_y-2, old_color[5] );
			put_pixel( old_x, old_y-1, old_color[6] );
			put_pixel( old_x, old_y+1, old_color[7] );
			put_pixel( old_x, old_y+2, old_color[8] );

			/* Stop drawing square when button is released(should this go above?) */
			if (!(mcond->buttons & MOUSE_RIGHTBUTTON) && (right_button))
			{
				right_button = 0;
				r = 0;
			}

			/* Draw square if right button pressed */
			if (mcond->buttons & MOUSE_RIGHTBUTTON)
			{
				if (!right_button)
				{
					right_button = 1;
					squarex = x;
					squarey = y;
				}
				square (squarex,squarey,r,canvas_color);
				r++;
				square (squarex,squarey,r,draw_color);
			}

			if (mcond->buttons & MOUSE_LEFTBUTTON)
			{

				/* if we are in the drawing area, draw */
				if (( x > 75 ) || ! gui)
				{
					for (t=-thick_line;t<=thick_line;t++)
					{
						for (u=-thick_line;u<=thick_line;u++)
						{
							put_pixel(x+u,y+t,draw_color);
						}
					}
				}

				left_button=1;
			}

			/* record the pixels under where the cursor will be */
			old_x = x;
			old_y = y;
			old_color[0] = get_pixel(x,y);
			old_color[1] = get_pixel(x-2, y);
			old_color[2] = get_pixel(x-1, y);
			old_color[3] = get_pixel(x+1, y);
			old_color[4] = get_pixel(x+2, y);
			old_color[5] = get_pixel(x, y-2);
			old_color[6] = get_pixel(x, y-1);
			old_color[7] = get_pixel(x, y+1);
			old_color[8] = get_pixel(x, y+2);

			vid_waitvbl();

			/* draw the cursor */
			put_pixel( x,   y, cursor_color );
			put_pixel( x-2, y, cursor_color );
			put_pixel( x-1, y, cursor_color );
			put_pixel( x+1, y, cursor_color );
			put_pixel( x+2, y, cursor_color );
			put_pixel( x, y-2, cursor_color );
			put_pixel( x, y-1, cursor_color );
			put_pixel( x, y+1, cursor_color );
			put_pixel( x, y+2, cursor_color );
		}
	}
}

int main() {

	/* Do initial setup */
	vid_set_mode(DM_640x480_PAL_IL,PM_RGB565);

	dc_paint();

	return 0;
}
