/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Wed Aug 15 2001
    copyright            : (C) 2001 by Giuseppe "Quobod" D'Aqu�
    email                : kumber@tiscalinet.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License, Version 2,      *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "dephine.h"
#include <SDL/SDL.h>
#include "surface_manager.h"
#include "resource_factory.h"
#include "music_manager.h"
#include "sfx.h"
#include "input.h"
#include "fonts/font_manager.h"
#include "game.h"
#include "screen.h"

#ifdef DREAMCAST
#include <kos.h>
#include <SDL/SDL_dreamcast.h>
#endif

#define PACKAGE "EPIPHANY 0.7"


#include "commandline_configuration.h"



	const char* get_title()
	{
		
		return PACKAGE;
	
	}

	void init_modules()
	{
	
		SDL_Init ( SDL_INIT_VIDEO | SDL_INIT_JOYSTICK | SDL_INIT_AUDIO | SDL_INIT_TIMER );
		
		#ifndef DREAMCAST
		SDL_Delay(1000);
		#endif
		
		Screen::instance();

		Input::instance()->init();
		
		#ifdef DREAMCAST
		// Set up the joystick
		SDL_DC_MapKey(0,SDL_DC_UP,SDLK_UP);
		SDL_DC_MapKey(0,SDL_DC_DOWN,SDLK_DOWN);
		SDL_DC_MapKey(0,SDL_DC_LEFT,SDLK_LEFT); 
		SDL_DC_MapKey(0,SDL_DC_RIGHT,SDLK_RIGHT);
		SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //L button, exits
		SDL_DC_MapKey(0,SDL_DC_L,SDLK_p); //R button, pause
		SDL_DC_MapKey(0,SDL_DC_A,SDLK_SPACE); //Space = Fire
		SDL_DC_MapKey(0,SDL_DC_B,SDLK_LALT); //Second button
		SDL_DC_MapKey(0,SDL_DC_START,SDLK_RETURN);
		
		SDL_JoystickEventState(SDL_ENABLE);
		SDL_JoystickOpen(0);
		SDL_DC_EmulateMouse(SDL_FALSE);
		// Dreamcast delay...
		SDL_Delay(20);
		SDL_Event ev;
		while(SDL_PollEvent(&ev))
			SDL_Delay(20);
		#endif
		
		Resource_Factory::instance();
			
		Sample_Manager::instance();
		
		Music_Manager::instance();

		#ifndef DREAMCAST
		SDL_WM_SetCaption(get_title(), NULL);
		#endif
	
	}
	
	void deinit_modules()
	{
		
		Surface_Manager::instance()->deinit();
		
		Music_Manager::instance()->deinit();
		
		Sample_Manager::instance()->deinit();
		
		Font_Manager::instance()->deinit();
		
		Resource_Factory::instance()->deinit();
	
	}	
		

	int main(int argc, char* argv[])
	{
		
		#ifdef DREAMCAST
		printf("Starting...\n");
		fs_chdir("/cd");
		bool disable_frame_limiter = true;
		#else
		bool disable_frame_limiter = false;
		bool disable_music = false;
		bool print_help = false;
		#endif
		
		bool using_another_map = false;
		
		std::string map_name; 
		
		#ifdef DREAMCAST
			Uint32 frame_skip = 1; //very useful!
		#else
			Uint32 frame_skip = 0;
		#endif
		
		//Next code won't execute in Dreamcast (not using arguments)
		#ifndef DREAMCAST
		CommandlineConfiguration* cmdconf = new CommandlineConfiguration(argc, argv);
		
		if(cmdconf->get_bool(std::string("cmd"), std::string("help"), print_help))
		{
			printf("Epiphany 0.7.0\n");
			printf("Options:\n");
			printf("\t--help\t\t\t\tprint this help\n");
			printf("\t--frame-skip <n>\t\tskip <n> frames\n");
			printf("\t--disable-frame-limiter\t\tdisable frame limiter\n");
			printf("\t--map <map_path>\t\tplay <map_path> as level\n");
			printf("\t--disable-music\t\tDon't play music\n");
			return 0;
			
		}
		
		using_another_map = cmdconf->get_string(std::string("cmd"), std::string("map"), map_name);
		
		cmdconf->get_bool(std::string("cmd"), std::string("disable-frame-limiter"), disable_frame_limiter);
			
		if(cmdconf->get_int(std::string("cmd"), std::string("frame-skip"), frame_skip) == false)
		{
			frame_skip = 1;
		}
		
		cmdconf->get_bool(std::string("cmd"), std::string("disable-music"), disable_music);
		
		if(disable_music == true)
		{
			Music_Manager::instance()->disable_music();
		}
		
		#endif
		
		init_modules();	

		Game* game = Game::instance();
		
		game->set_frame_skip(frame_skip);
		
		if(disable_frame_limiter == true)
		{
			game->set_frame_limiter_enabled(false);
		}
		
		if(using_another_map == true)
		{
			printf("Map name: %s\n", map_name.c_str());
			
			game->play_level(map_name.c_str());
		}
		else
		{
			game->go();
		}
		
		DEBOUT("Exiting game::go().\n");
		
		deinit_modules();
		
		game->save_config(); //PC: Saves INI. Dreamcast: Saves to VMU

		delete game;
		
		atexit(SDL_Quit);
		return (0);
	
	}
	
	

