
#ifndef DREAMCAST
	#include <conio.h>
	#include <libamp.h>
#else //KOS
	#include <kos.h>
	KOS_INIT_FLAGS(INIT_DEFAULT);
#endif

#include "common.h"


// -- global variables -------------------------------------------------------
volatile TIMER timer[max_player];
JGMOD *curr_mod;
BITMAP *curr_background = NULL;
BITMAP *temp_buffer = NULL;
DATAFILE *datafile;
BLOCK block[max_block];
PLAYER player[max_player];
PLAYER_KEYS player_keys[max_player];
int curr_song_type = song_type_none;
int change_background = TRUE;
int curr_background_no = -1;
int music_sequential = TRUE;
int alpha_level = 119;
int selected_color_depth = 16;
int no_music = 0;
int curr_music = 0;
int music_volume = 255;
int sfx_volume = 119;
int no_channels = 64;
int resume_game = FALSE;
int resume_no_player = 0;
int resume_curr_background = -1;
int level_speed[15];



FAME_INFO fame_info[10] = {
    { "Hvbo!Gpp!Xbi",       104, 1400},
    { "PcjHvbo!Lfopcj",     95, 1300},
    { "Ebub",               90, 1200},
    { "Cpsh!Rvffo",         83, 1000},
    { "Tfwfo!pg!Ojof",      79, 900},
    { "Uvwpl",              74, 800},
    { "Tqpdl",              67, 700},
    { "Kfbo!Mvd!Qjdbse",    55, 600},
    { "Cfokbnjo!Tjtlp",     48, 500},
    { "Uif!Epdups",         39, 400}
};



// the menu for game over scores
char *game_over_menu[] = {
"Players Score",
"",
"",
"\000"
};


#ifndef DREAMCAST
char *select_color_depth[] = {
"1. 15 bits (32768 colors)",
"2. 16 bits (65536 colors)",
"3. 24 bits (16.7 million colors)",
"4. 32 bits (16.7 million colors)",
"5. Exit",
""
};
#endif


int main (void)
{
	#ifdef DREAMCAST
	printf("Starting...\n");
	chdir("/cd/data_files");
	#endif
    user_select_depth();
    init_tetris();
    init_var();
    //intro();
    do_main_tetris_menu();
    exiting_message();
    return 0;    
}


// a short short time ago intro screen....
void intro (void)
{
    font = (FONT *)datafile[PLAYER_FONT].dat;

    clear (screen);
    textout_centre(screen, font, "A short short time ago", 320, 200, makecol (0, 0, 255));
    textout_centre(screen, font, "in a planet near near away . . .", 320, 240, makecol (0, 0, 255));

    timer[0].left = 0;

    // wait until player pressed a key or 4 seconds is up
    while (!keypressed() && timer[0].left < 240);

    if (keypressed())
        readkey();
}


// the main loop when playing tetris. players score, block positions, etc
// are updated here
void play_tetris (int no_player, int level, int height)
{
    int player_no;
    int results;
    int curr_level;
    int index;

    enable_lasttrk_loop = FALSE;

    if (resume_game == FALSE)
        resume_no_player = no_player;
    else
        no_player = resume_no_player;

    init_player (no_player, level, height);

    if (resume_game == FALSE)
        ready_game_background (no_player, FALSE, FALSE);
    else
        ready_game_background (no_player, FALSE, TRUE);

	#ifdef DREAMCAST
	acquire_screen();
	#endif
    blit (curr_background, screen, 0,0,0,0, SCREEN_W, SCREEN_H);
	#ifdef DREAMCAST
	release_screen();
	#endif
    play_next_music();

    init_player_timer ();

    
    while ((player[0].status == active) || (player[1].status == active))
        {
        // is escape key pressed ?
        if (key[KEY_ESC] || key[KEY_SPACE])
            {
            save_config_cfg();
            resume_curr_background = curr_background_no;
            resume_game = TRUE;
            enable_lasttrk_loop = TRUE;
            return;
            }

            /*
            if (do_exit_game_menu(no_player) == 1)
                {
                save_config_cfg();
                resume_game = TRUE;
                return;
                }*/

        if (is_music_playing() == FALSE)
            {
            volatile TIMER timer_temp[max_player];

            copy_timer (timer_temp[0], timer[0]); // backup timer
            copy_timer (timer_temp[1], timer[1]); 
            play_random_music();
            copy_timer (timer[0], timer_temp[0]); // restore timer
            copy_timer (timer[1], timer_temp[1]); 
            }

        // update the players positions first
        for (player_no=0; player_no<no_player; player_no++)
            {
            if (player[player_no].status == inactive)
                continue;

            erase_block (player_no, player[player_no].block_x, player[player_no].block_y, player[player_no].curr_block, player[player_no].rotation);

            // left key is pressed
            if (key[ player[player_no].key_left] && (timer[player_no].left >= player[player_no].x_movement_speed) )       
                {
                results = detect_block (player_no, player[player_no].block_x-1, player[player_no].block_y, player[player_no].curr_block, player[player_no].rotation);
                if (results == FALSE)
                    {
                    player[player_no].block_x--;
                    timer[player_no].left = 0;
                    }
                }

            // right key is pressed
            if (key[ player[player_no].key_right] && (timer[player_no].right >= player[player_no].x_movement_speed) )
                {
                results = detect_block (player_no, player[player_no].block_x+1, player[player_no].block_y, player[player_no].curr_block, player[player_no].rotation);
                if (results == FALSE)
                    {
                    player[player_no].block_x++;
                    timer[player_no].right = 0;
                    }
                }

            // rotate clockwise is pressed        
            if (key[ player[player_no].key_rotate_cw] && (timer[player_no].cw >= player[player_no].rotate_movement_speed))   
                {
                int temp = player[player_no].rotation;
                temp++;
                if (temp >= 4)
                    temp = 0;

                results = detect_block (player_no, player[player_no].block_x, player[player_no].block_y, player[player_no].curr_block, temp);
                if (results == FALSE)
                    {
                    player[player_no].rotation = temp;
                    timer[player_no].cw = 0;
                    play_sample ((SAMPLE *)datafile[ROTATE].dat, sfx_volume, 128, 1000, FALSE);
                    }
                }

            // rotate counter clockwise is pressed        
            if (key[ player[player_no].key_rotate_ccw] && (timer[player_no].ccw >= player[player_no].rotate_movement_speed) )
                {
                int temp = player[player_no].rotation;
                temp--;
                if (temp < 0)
                    temp = 3;

                results = detect_block (player_no, player[player_no].block_x, player[player_no].block_y, player[player_no].curr_block, temp);
                if (results == FALSE)
                    {
                    player[player_no].rotation = temp;
                    timer[player_no].ccw = 0;
                    play_sample ((SAMPLE *)datafile[ROTATE].dat, sfx_volume, 128, 1000, FALSE);
                    }
                }

            curr_level = player[player_no].level;
            if (curr_level > 14)
                curr_level = 14;

            // move the block down
            if ( (key[ player[player_no].key_down] && (timer[player_no].down >= player[player_no].y_movement_speed))
                || timer[player_no].move_down >= (60 - level_speed[curr_level] ) )
                {
                timer[player_no].move_down = 0;
                results = detect_block (player_no, player[player_no].block_x, player[player_no].block_y+1, player[player_no].curr_block, player[player_no].rotation);
                if (results == FALSE)   //nothing below. Ok to move down
                    {
                    player[player_no].block_y++;
                    timer[player_no].down = 0;
                    }
                else    // hit something below. Start a new block
                    {
                    int no_lines_completed;

                    draw_block (player_no, player[player_no].block_x, player[player_no].block_y, player[player_no].curr_block, player[player_no].rotation);
                    no_lines_completed = detect_line (player_no);
                    player[player_no].lines_done += no_lines_completed;
                    player[player_no].lines_left -= no_lines_completed;

                    // now play sound effects
                    if (no_lines_completed)
                        play_sample ((SAMPLE *)datafile[TET].dat, sfx_volume, 128, 1000, FALSE);
                    else
                        play_sample ((SAMPLE *)datafile[HIT_FLOR].dat, sfx_volume, 128, 1000, FALSE);

                    // add to the score
                    if (no_lines_completed == 1)
                        player[player_no].score += 10;
                    else if (no_lines_completed == 2)
                        player[player_no].score += 30;
                    else if (no_lines_completed == 3)
                        player[player_no].score += 60;
                    else if (no_lines_completed == 4)
                        player[player_no].score += 200;


                    timer[player_no].down = -30;
                    player[player_no].block_y = -2;
                    player[player_no].block_x = 3;
                    player[player_no].rotation = 0;
                    player[player_no].curr_block = player[player_no].next_block;
					
					#ifdef DREAMCAST
					player[player_no].next_block = rand() % max_block;
					#else
					player[player_no].next_block = random() % max_block;
					#endif
                    
                    if (player[player_no].lines_left <= 0)
                        {
                        player[player_no].lines_left += 10;
                        player[player_no].level++;
                        if (change_background == TRUE)      // change the background
                            {
                            volatile TIMER timer_temp[max_player];

                            copy_timer (timer_temp[0], timer[0]); // backup timer
                            copy_timer (timer_temp[1], timer[1]); 

                            clear_old_game_space (0, -2);
                            clear_old_game_space (1, -2);
                            ready_game_background (no_player);
							#ifdef DREAMCAST
							acquire_screen();
							#endif
							blit (curr_background, screen, 0,0,0,0, SCREEN_W, SCREEN_H);
							#ifdef DREAMCAST
							release_screen();
							#endif
                            erase_block (player_no, player[player_no].block_x, player[player_no].block_y, player[player_no].curr_block, player[player_no].rotation);

                            copy_timer (timer[0], timer_temp[0]); // restore timer
                            copy_timer (timer[1], timer_temp[1]); 
                            }
                        }

                    draw_info_window (screen, player_no);

                    //now test if game over
                    results = detect_block (player_no, player[player_no].block_x, player[player_no].block_y, player[player_no].curr_block, player[player_no].rotation);
                    if (results == TRUE)    // Ok. Game over
                        {
                        player[player_no].status = inactive;
                        draw_block (player_no, player[player_no].block_x, player[player_no].block_y, player[player_no].curr_block, player[player_no].rotation);
                        display_game_block(screen, player_no);
                        play_sample ((SAMPLE *)datafile[UGH].dat, sfx_volume, 128, 1000, FALSE);
                        }
                    }
                }
            }

        // now update the screen
        for (player_no=0; player_no<no_player; player_no++)
            {
            if (player[player_no].status == inactive)
                continue;

            draw_block (player_no, player[player_no].block_x, player[player_no].block_y, player[player_no].curr_block, player[player_no].rotation);
            display_game_block(screen, player_no);
            backup_game_space (player_no);
            erase_block (player_no, player[player_no].block_x, player[player_no].block_y, player[player_no].curr_block, player[player_no].rotation);
            }

        detect_F_keys (no_player);
        }

       
    {
    MENU_DIM game_over_menu_dim;
    if (no_player == 1)
        {
        sprintf (game_over_menu[1], "Player 1 : %d", player[0].score);
		game_over_menu[2] = ".";
        }
    else
        {
        sprintf (game_over_menu[1], "Player 1 : %d", player[0].score);
        sprintf (game_over_menu[2], "Player 2 : %d", player[1].score);
        }

    font = (FONT *)datafile[PLAYER_FONT].dat;
	#ifdef DREAMCAST
	acquire_screen();
	#endif
    blit (curr_background, screen, 0,0,0,0, SCREEN_W, SCREEN_H);
	#ifdef DREAMCAST
	release_screen();
	#endif
    draw_menu (curr_background, screen, &game_over_menu_dim, game_over_menu, 1, font, font, FALSE, draw_game_over_menu);
    }


    save_config_cfg();
    resume_game = FALSE;


    is_music_playing();
    rest (200);
    is_music_playing();
    rest (200);
    is_music_playing();
    rest (200);
    is_music_playing();
    rest (200);
    is_music_playing();
    rest (200);
    is_music_playing();
    rest (200);
    is_music_playing();
    rest (200);
    is_music_playing();
    rest (200);
    is_music_playing();
    rest (200);
    is_music_playing();
    rest (200);


    clear_keybuf();
    while (!keypressed())
        is_music_playing();

    clear_keybuf();    

    {
    MENU_DIM fame_menu_dim;
    int fame_no[max_player] = {-1, -1};
     

    for (player_no=no_player-1; player_no>=0 ;player_no--) 
        {
        fame_no[player_no] = get_player_fame (player[player_no].score);

        if (fame_no[player_no] > 0)
            {
            move_fame_down (fame_no[player_no]);
            sprintf (fame_info[fame_no[player_no]-1].name, "Player %d", player_no + 1);
            fame_info[fame_no[player_no]-1].lines = player[player_no].lines_done;
            fame_info[fame_no[player_no]-1].score = player[player_no].score;
            }
        }

    if (no_player == 2)
        if (fame_no[0] != -1)
            if ( fame_no[0] <= fame_no[1] )
                {
                fame_no[1]++;

                if (fame_no[1] > 10)
                    fame_no[1] = -1;
                }


    if ( (fame_no[0] > 0) || (fame_no[1] > 0) )
        load_same_background();

    // now querry player for name.
    for (player_no=0; player_no<no_player; player_no++)
        {
        if (fame_no[player_no] > 0)
            {
            sprintf (fame_menu[0], "Enter your name, Player %d", player_no+1);
            for (index=1; index <= 10; index++)
                write_fame (index, fame_info[index-1].name, fame_info[index-1].lines, fame_info[index-1].score);

            font = (FONT *) datafile[FIXED_WIDTH].dat;
            draw_menu (curr_background, screen, &fame_menu_dim, fame_menu, 1,
                (FONT *)datafile[PLAYER_FONT].dat, font, FALSE, NULL, makecol (255,255,255));

            clear_keybuf();
            manage_name_input (screen, fame_no[player_no], &fame_menu_dim);
			#ifndef DRREAMCAST
            if (save_chart_cfg() == 1)
                exiting_error ("Error : Unable to open chart.cfg");
            }
			#endif
        }

    }

    enable_lasttrk_loop = TRUE;
}


/*In Dreamcast version we don't have to select any of this options!*/
void user_select_depth(void)
{
	#ifdef DREAMCAST
	selected_color_depth = 16; //lower MEM requirements :)
	#else
    int input;

    _setcursortype (_NOCURSOR);
    setvbuf(stdout, NULL, _IONBF, 0);   // always flush buffer to screen instantly
    color (7, 0);
    clrscr();
    show_blue_bar();
    color (7, 0);

    gotoxy (1, 4);
    printf ("Please select your desired color depth\n");
    printf ("\n");

    input = manage_text_menu(select_color_depth, 1, 6);
    _setcursortype (_NORMALCURSOR);
    color (7, 0);

    if (input == 1)
        selected_color_depth = 15;
    else if (input == 2)
        selected_color_depth = 16;
    else if (input == 3)
        selected_color_depth = 24;
    else if (input == 4)
        selected_color_depth = 32;
    else
        {
        gotoxy (1,11);
        cprintf ("\n");
        exit(0);
        }
	#endif
}

#ifndef DREAMCAST
int manage_text_menu(char **text_menu, int x, int y)
{
    int temp;
    int no_strings;
    int opt_no=0;
    int old_opt=0;
    int input=0;

    no_strings = count_no_strings (text_menu);
    for (temp=0; temp<no_strings; temp++)
        {
        gotoxy (x, y+temp);
        printf ("%s", text_menu[temp]);
        }

    color (15,1);
    gotoxy (x, y + opt_no);
    cprintf ("%s", text_menu[opt_no]);

    while (1)
        {
        input = getch();

        if (input  == 13)       // pressed enter
            return (opt_no+1);
        else if (input == 27)   // pressed escape
            return -1;
        else if (input == 0)
            {
            input = getch();

            old_opt = opt_no;
            if (input == 72)        // presed up
                {
                opt_no--;
                if (opt_no < 0)
                    opt_no = no_strings -1;
                }
            else if (input == 80)   // pressed down
                {
                opt_no++;
                if (opt_no >= no_strings)
                    opt_no = 0;
                }

            if (old_opt != opt_no)  // highlight another option ?
                {
                color (15,1);
                gotoxy (x, y + opt_no);
                cprintf ("%s", text_menu[opt_no]);

                color (7,0);
                gotoxy (x, y + old_opt);
                cprintf ("%s", text_menu[old_opt]);
                }
            }
        }
}
#endif
