#include <stdio.h>

#ifdef DREAMCAST
#include <kos.h>
#include <dcalleg.h>
#endif

#include <allegro.h>
#include <jgmod.h>
#include "tetris.h"

#define tetris_version      "1.01"


#define max_player          2
#define no_background       7
#define max_block           7

#define screen_width        640
#define screen_height       480

#define block_width         19
#define block_height        19

#define game_window_width   10
#define game_window_height  22
#define game_info_width     6
#define game_info_height    10

#define inactive            0
#define active              1

#define x_speed             7       // speed for moving block in x coord
#define y_speed             2       // speed for moving block in y coord
#define rotate_speed        13       // speed for rotating block

#define menu_bar_color      makecol (0, 0, 170)
#define menu_fade_color     makecol (160, 160, 160)
#define menu_for_color      makecol (255, 255, 255)

#define no_sfx_channel      4

#define song_type_none      0
#define song_type_mod       1
#define song_type_mp3       2

#define kleft               0
#define kright              1
#define kdown               2
#define kccw                3 //rotate counter clockwise
#define kcw                 4 //rotate clockwise


typedef struct PLAYER_KEYS
{
    int p[10];
}PLAYER_KEYS;

typedef struct TIMER
{
    int left;
    int right;
    int down;
    int cw;
    int ccw;
    int move_down;

}TIMER;


typedef struct PLAYER
{
    int game_window_xpos;
    int game_window_ypos;

    int game_info_xpos;
    int game_info_ypos;

    BITMAP *game_window_buffer;
    BITMAP *game_info_buffer;

    int status;         // to know dead or alive
    int score;
    int level;
    int lines_done;
    int lines_left;
    int block_x;
    int block_y;
    int curr_block;
    int next_block;
    int rotation;

    int game_space [game_window_width][game_window_height];
    int old_game_space [game_window_width][game_window_height];

    int key_down;
    int key_left;
    int key_right;
    int key_rotate_cw;  // clock wise
    int key_rotate_ccw; // counter clock wise

    int x_movement_speed;
    int y_movement_speed;
    int rotate_movement_speed;

}PLAYER;

typedef struct BLOCK
{
    int pos[4];
    int bitmap;
}BLOCK;

typedef struct MENU_DIM{

    int x1;
    int y1;
    int width;
    int height;
    int bar_thickness;
    int opt_y1;
    int no_strings;

    FONT *normal_font;
    FONT *title_font;
    char **the_menu;

}MENU_DIM;

typedef struct fame_info
{
    char name[22];
    int lines;
    int score;
}FAME_INFO;


extern int alpha_level;
extern volatile TIMER timer[max_player];
extern DATAFILE *datafile;
extern BLOCK block[max_block];
extern PLAYER player[max_player];
extern PLAYER_KEYS player_keys[max_player];
extern BITMAP *temp_buffer;
extern volatile TIMER timer[max_player];
extern BITMAP *curr_background;
extern JGMOD *curr_mod;
extern int curr_song_type;
extern int curr_background_no;
extern int change_background;
extern int selected_color_depth;
extern int level_speed[15];
extern int music_sequential;
extern int no_music;
extern int curr_music;
extern int music_volume;
extern int sfx_volume;
extern int resume_game;
extern int resume_no_player;
extern int resume_curr_background;
extern int no_channels;
extern char *pause_menu[];
extern FAME_INFO fame_info[10];
extern char *fame_menu[];

//-- located in init.cpp -----------------------------------------------------
void init_tetris (void);
void show_blue_bar (void);
void color (int forground, int background);
void print_center (int row, char *strng);
void init_soundcard (void);
void init_libamp (void);
void init_jgmod(void);
void set_graphics_mode (void);
void load_tetris_datafile (void);
void init_var (void);
void timer_interrupt ();
void libamp_interrupt ();
void init_player_timer (void);
void lock_stuff(void);
void create_buffer(void);
void init_player (int no_player, int level, int height);
void check_music_lst(void);
void load_config_cfg (void);
void switch_numlock_off (void);
void detect_necessary_files(void);
void load_chart_cfg (void);
void reduce_str (void);
int  load_chart(void);

//-- located in block.cpp ----------------------------------------------------
int detect_line (int player_no);
void move_line (int player_no, int line_no);
void detect_F_keys (int no_player);
void clear_old_game_space (int player_no, int clear= -1);
void draw_info_window (BITMAP *bitmap, int player_no);
void draw_info_block (BITMAP *bitmap, int block_type, int x, int y);
void draw_block (int player_no, int x, int y, int block_no, int rotation);
void display_game_block (BITMAP *dest, int player_no);
void clear_game_space (int player_no);
void backup_game_space (int player_no);
void erase_block (int player_no, int x, int y, int block_no, int rotation);
int detect_block (int player_no, int x, int y, int block_no, int rotation);

//-- located in misc.cpp -----------------------------------------------------
void exiting_message (void);
void load_sequential_background(void);
void load_same_background(void);
void draw_box (BITMAP *bitmap, int x1, int y1, int x2, int y2, int color);
void ready_game_background (int no_player, int pause=FALSE, int same=FALSE);
void pause_game (int no_player);
void copy_timer (volatile TIMER &a, volatile TIMER &b);
void exiting_error (char *message);
void detect_some_F_keys (int no_player, int ch, int pause);
void save_config_cfg (void);
int save_chart_cfg (void);
int jg_readkey(void);

//-- located in vstrfld.cpp --------------------------------------------------
void vstrfld(void);
void accelerate_stars (void);
void draw_fading_line (BITMAP *dest, int x1, int y1, int x2, int y2, int color);
int font_fading(BITMAP *dest, int ypos);

//-- located in music.cpp ----------------------------------------------------
int find_no_of_music (char *filename);
int get_music_no (char *filename, char *dest, int string_no);
void play_music_no (int music_no);
void play_prev_music(void);
void play_next_music(void);
void play_random_music (void);
void play_music_name (char *name, int loop=FALSE);
int is_music_playing(void);
void fr_music(void);
void ff_music(void);

//-- located in menu.cpp -----------------------------------------------------
int count_no_strings (char **the_string);
void draw_menu (BITMAP *source, BITMAP *dest, MENU_DIM *mn, char **the_menu, int bar_thickness, FONT *title, FONT *normal_font, int highlight=TRUE, void (*callfunc)(BITMAP *source, char **the_menu, MENU_DIM *mn) = NULL, int fade_color=menu_fade_color );
int manage_menu (BITMAP *dest, MENU_DIM *mn, void (*callfunc)(int* curr_opt, int old_opt) = NULL);
void draw_game_over_menu (BITMAP *source, char **the_menu, MENU_DIM *mn);
void draw_2p_menu (BITMAP *source, char **the_menu, MENU_DIM *mn);
void draw_1p_menu (BITMAP *source, char **the_menu, MENU_DIM *mn);
void manage_2p_menu (int *curr_opt, int old_opt);
void manage_1p_menu (int *curr_opt, int old_opt);
int check_any_undefined_keys (PLAYER_KEYS *pkeys, int max);
void test_conflict_keys (PLAYER_KEYS *pkeys, int element, int max);
int get_defined_key(void);
void do_define_1p_menu();
void do_define_2p_menu();
void select_player (void);
void do_define_keys_menu(void);
void do_options_menu (void);
int do_exit_game_menu (int no_player);
int make_random_exit_options (void);
int do_exit_menu (void);
void do_main_tetris_menu (void);
void display_logo (BITMAP *dest);
void do_fame_menu (void);
void do_sensitivity_menu (void);
void draw_sensitivity_menu (BITMAP *source, char **the_menu, MENU_DIM *mn);
void manage_sensitivity_menu (int *curr_opt, int old_opt);
void write_fame (int fame_no, char *name, int lines, int score);
void move_fame_down (int fame_no);
void manage_name_input (BITMAP *dest, int fame_no, MENU_DIM *mn);
int get_player_fame (int score);


// -- located in tetris.cpp --------------------------------------------------
void play_tetris (int no_player, int level, int height);
void intro (void);
void user_select_depth(void);
int manage_text_menu(char **text_menu, int x, int y);


// -- located in file_io.cpp -------------------------------------------------
FILE *jfopen (char *filename, char *mode);
int jfclose (FILE *f);
int jfgetc (FILE *f);
int jfputc (int c, FILE *f);
long jiputl (long l, FILE *f);
int jiputw (int w, FILE *f);
long jigetl (FILE *f);
int jigetw (FILE *f);
int jfwrite (char *buf, FILE *f);
int jfread (char *buf, FILE *f);
void jfgets (char *dest, int max_length, FILE *file);

