#ifndef DREAMCAST
#include <libamp.h>
#endif

#include "common.h"


// find no of musics (or words) in a text file
// returns negative if fail 
int find_no_of_music (char *filename)
{
    FILE *file;
    int no_lines=0;
    char text[501];

    file = fopen ("music.lst", "r");
    if (file == NULL)
        return -1;

    while (!feof(file))
        {
        //fscanf (file, "%s", text);
        jfgets (text, 500, file); 

        if (!feof(file) && text[0] != ';')
            no_lines++;
        }

    fclose (file);
    return no_lines;
}

// returns string string_no in a text file
// returns negative if fail. Positive if successfll
int get_music_no (char *filename, char *dest, int string_no)
{
    FILE *file;
    int temp;

    file = fopen ("music.lst", "r");
    if (file == NULL)
        return -1;

    for (temp=0; temp <= string_no; temp++)
        {
        //fscanf (file, "%s", dest);
        jfgets (dest, 500, file);
        dest[strlen(dest)-1] = 0;
        if (dest[0] == ';')
            temp--;
        }

    fclose (file);
    return 1;
}

// plays next music in the music list
void play_next_music(void)
{
    curr_music++;
    if (curr_music >= no_music)
        curr_music = 0;

    play_music_no (curr_music);
}

// plays previous music in the music list
void play_prev_music(void)
{
    curr_music--;
    if (curr_music < 0)
        curr_music = no_music - 1;

    play_music_no (curr_music);
}

// plays the music no in the music.lst
void play_music_no (int music_no)
{
    char dest[501];
    //char error_message[290];

    if (get_music_no ("music.lst", dest, music_no) < 0)
        exiting_error ("Error : Unable to open music.lst\n");

    //stop_mod();
    //destroy_mod (curr_mod);


    //curr_mod = load_mod (dest);
    play_music_name (dest, FALSE);

    //if (curr_mod == NULL)
    //    {
    //    sprintf (error_message, "Error : Unable to open %s\n", dest);
    //    exiting_error (error_message);
    //    }

    //play_mod (curr_mod, FALSE);
}

// plays the next music or random music
void play_random_music (void)
{
    int temp = -1;

    if (music_sequential == FALSE)
        {
        if (no_music > 1)
            {
            do
				#ifdef DREAMCAST
				temp = rand() % no_music;
				#else
                temp = random() % no_music;
				#endif
            while  (temp == curr_music);

            curr_music = temp;
            }
        play_music_no (curr_music);
        }
    else
        play_next_music();
}

// plays a music according to its file name
void play_music_name (char *name, int loop)
{
    if (curr_song_type == song_type_mod)
        {
        stop_mod();
        destroy_mod (curr_mod);
        }
	#ifndef DREAMCAST
    else if (curr_song_type == song_type_mp3)
        unload_amp();
    #endif

    curr_song_type = song_type_none;
	
	//MP3 Junk code...
	#ifndef DREAMCAST
    if (curr_song_type == song_type_none)
        {
        char *p = get_extension (name);
        if (strcmp (p, "mp3") == 0 ||
            strcmp (p, "Mp3") == 0 ||
            strcmp (p, "mP3") == 0 ||
            strcmp (p, "MP3") == 0 )
            {
            if (load_amp (name, FALSE))
                curr_song_type = song_type_mp3;
            }
        }
	#endif
	
    if (curr_song_type == song_type_none)
        {
        curr_mod = load_mod (name);
        if (curr_mod != NULL)
            {
            curr_song_type = song_type_mod;
            play_mod (curr_mod, loop);
            }
        }

    if (curr_song_type == song_type_none)
        {
        char temp[256];
        sprintf (temp, "Error : Unable to open %s\n", name);
        exiting_error (temp);
        }
}


int is_music_playing(void)
{
    if (is_mod_playing() == TRUE)
        return TRUE;

	#ifndef DREAMCAST
    if (run_amp() != -1)
        return TRUE;
	#endif

    return FALSE;
}

void fr_music(void)
{
    if (curr_song_type == song_type_mod)
        prev_mod_track();
	#ifndef DREAMCAST
    else if (curr_song_type == song_type_mp3)
        seek_amp_rel(-10*amp_samprat/amp_pollsize); /* seek 10 seconds */
    #endif
}
      
void ff_music(void)
{
    if (curr_song_type == song_type_mod)
        next_mod_track();
	#ifndef DREAMCAST
    else if (curr_song_type == song_type_mp3)
        seek_amp_rel(10*amp_samprat/amp_pollsize); /* seek 4 seconds */
	#endif
}

