#include "common.h"


FILE *jfopen (char *filename, char *mode)
{
    return fopen (filename, mode);
}


int jfclose (FILE *f)
{
    return fclose (f);
}


int jfgetc (FILE *f)
{
    uchar temp;
    temp = fgetc(f);
    return  (uchar)(((uchar)fgetc(f) - temp));
}


int jfputc (int c, FILE *f)
{
    uchar temp;

	#ifdef DREAMCAST
	temp = rand() & 0xFF;
	#else
    temp = random() & 0xFF;
	#endif
    fputc (temp, f);
    return fputc ( (uchar)c + temp, f);
}


int jiputw (int w, FILE *f)
{
    int b1, b2;

    b1 = (w & 0xFF00) >> 8;
    b2 = (w & 0xFF);

   jfputc(b2,f);
   jfputc(b1,f);
   return w;
}


long jiputl (long l, FILE *f)
{
    int b1, b2, b3, b4;

    b1 = (long)((l & 0xFF000000L) >> 24);
    b2 = (long)((l & 0x00FF0000L) >> 16);
    b3 = (long)((l & 0x0000FF00L) >> 8);
    b4 = (long)l & 0x00FF;

    jfputc(b4,f);
    jfputc(b3,f);
    jfputc(b2,f);
    jfputc(b1,f);
    return l;
}

int jigetw (FILE *f)
{
    int b1, b2;

    b1=jfgetc(f);
    b2=jfgetc(f);
    return ( (b2 << 8) + b1 );

}


long jigetl (FILE *f)
{
    long b1, b2, b3, b4;

    b1=jfgetc(f);
    b2=jfgetc(f);
    b3=jfgetc(f);
    b4=jfgetc(f);
    return ( (b4 << 24) + (b3 << 16) + (b2 << 8) + b1 );

    return EOF;
}


int jfwrite (char *buf, FILE *f)
{
    int len;
    int index;

    len = strlen (buf);
    jiputl (len, f);

    for (index=0; index<len; index++)
        jfputc (buf[index], f);

    return len;
}


int jfread (char *buf, FILE *f)
{
    int len;
    int index;

    len = jigetl (f);

    for (index=0; index<len; index++)
        buf[index] = jfgetc (f);

    buf[len] = 0;
    return len;
}

void jfgets (char *dest, int max_length, FILE *file)
{
    char char_temp[max_length+1];
    char *beginning;


    fgets (char_temp, max_length, file);
    beginning = char_temp;

    while (*beginning == ' ')
        beginning++;


    strcpy (dest, beginning);

}
