/*
H - Jeu ludique
Copyright (C) 2007  Yoann CALAMAI

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include "../Motor/Motor.h"
#include "../Character/Character.h"
#include "../SDLfont/SDLfont.h"

#ifdef DREAMCAST
#include <kos.h>
extern uint8 romdisk[];
KOS_INIT_ROMDISK(romdisk);
#include <SDL/SDL_dreamcast.h>
#endif

int main(int argc, char **argv)
{

	#ifdef DREAMCAST
	printf("Starting...\n");
	fs_chdir("/rd");
	#endif

////////////////////////////////////////////////////////////
//Definition et initialisation des variables et des objets//
////////////////////////////////////////////////////////////
	const char	*LevelPath;
	Motor		Game;
	string 		Level;
	SDL_Event	event;

	//Initialisation du moteur de jeu
	Game.Init();
	//Initialisation du texte
	SDLFont	fonte("Police/police.ttf",48);
	
	#ifdef DREAMCAST
	SDL_DC_MapKey(0,SDL_DC_START,SDLK_r); //reset
	SDL_DC_MapKey(0,SDL_DC_UP,SDLK_UP);
	SDL_DC_MapKey(0,SDL_DC_DOWN,SDLK_DOWN);
	SDL_DC_MapKey(0,SDL_DC_LEFT,SDLK_LEFT); 
	SDL_DC_MapKey(0,SDL_DC_RIGHT,SDLK_RIGHT);
	SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //L button
	
	SDL_JoystickEventState(SDL_ENABLE);
	SDL_JoystickOpen(0); 
	SDL_ShowCursor(0);
	
	//Dreamcast delay...
	SDL_Event evento;
	while(SDL_PollEvent(&evento))
		SDL_Delay(20);
	#endif

////////////////////////////
//Chargement du 1er niveau//
////////////////////////////
	LevelPath = "1";
	if ((Game.CheckFile(LevelPath)) == false)
	{ 
		cout << " Le fichier 1.txt correspondant au premier niveau est incorrect!! " <<endl;
		Game.Exit = true;
	}
	//cout << Game.GetLevel()<< endl;
	//cout << LevelPath <<endl;
	Game.ReadTable(LevelPath);
	fonte.Text(50,200,255,255,255,Game.GetScreen(),"LEVEL 1");
	SDL_Flip(Game.GetScreen());
	SDL_Delay(2000);
	Game.Display();
////////////////////////////////////////////////////////////////////
///////////////////BOUCLE PRINCIPALE DU PROGRAMME///////////////////
////////////////////////////////////////////////////////////////////
	while (!Game.Exit)
	{
//////////////////////////
//Gestion des evenements//
//////////////////////////
		if(SDL_PollEvent(&event))
		{
			switch(event.type)
			{
				case SDL_QUIT:
					Game.Exit=true;
					exit(0);
					break;
				default:
					break;
			}
		}

////////////////////////
//Changement de niveau//
////////////////////////
		if (Game.NextLevel() == true)
		{
			//Suppression des objets principaux
			Game.Delete();
			//Affichage plateau vide
			Game.Display();
			fonte.Text(50,200,255,255,255,Game.GetScreen(),"LEVEL %i", Game.GetLevel());
			SDL_Flip(Game.GetScreen());
			//Passage au niveau suprieur
			ostringstream oss;
			oss << Game.GetLevel();
			Level = oss.str();
			LevelPath = Level.c_str();
			//cout << Game.GetLevel() << endl;
			//cout << LevelPath << endl;
			if (Game.CheckFile(LevelPath) == true)
			{
				if (Game.ReadTable(LevelPath)==1)
				{	
					fonte.Text(200,250,255,255,255,Game.GetScreen(),"");
					SDL_Flip(Game.GetScreen());
					cout << "Pas de niveau suivant  charger : fin du jeu" << endl;
					fonte.Text(100,250,255,255,255,Game.GetScreen(),"GAME'S END");
					SDL_Flip(Game.GetScreen());
					SDL_Delay(100);
				}
				else
				{
					cout << "Affichage Niveau superieur" << endl;
					SDL_Delay(1000);
					Game.New();
				}
			}
			else
			{
				SDL_Quit();
			}

		}
		Game.Cycle();
		Game.Display();
		//Game.Menu();
	}
	SDL_Quit();
	return 0;
}

