/*
    dc_vmu.c
    This file is from the Wolf4SDL\DC project, with
    minor changes by Chilly Willy.

    It has the LCD drawing and VMU save\load functions.

    It counts on the CWD being "/ram".

    LCD drawing code found in Sam Steele's DreamZZT.
    Saving code found in OneThirty8's sdlWolf port.

    Cyle Terry <cyle.terry@gmail.com>
*/

#include <kos.h>
#include <zlib/zlib.h>
#include "dc_vmu.h"

// 32x32 16 color, preceded by the palette
unsigned char cacodemon_icon[544] = {
	0x17, 0xf1,
	0x10, 0xf7,
	0x00, 0xfb,
	0x22, 0xf5,
	0x00, 0xfd,
	0x33, 0xf3,
	0x20, 0xf9,
	0x43, 0xf6,
	0x32, 0xf9,
	0x51, 0xf3,
	0x55, 0xf9,
	0x66, 0xf6,
	0x55, 0xff,
	0x99, 0xf9,
	0xcc, 0xfd,
	0xff, 0xff,
	0xff, 0xfe, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xed, 0xff, 0xff, 0xed, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0xff, 0xfe, 0xde, 0xff,
	0xff, 0xfd, 0xef, 0xff, 0xdd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xff, 0xfe, 0xdf, 0xff,
	0xff, 0xfe, 0xbe, 0xff, 0xdd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xff, 0xed, 0xdf, 0xff,
	0xff, 0xff, 0xbd, 0xef, 0xdb, 0xde, 0xee, 0x24, 0x48, 0xee, 0xed, 0xdd, 0xfe, 0xbb, 0xff, 0xff,
	0xff, 0xff, 0xeb, 0xbe, 0xb1, 0x22, 0x84, 0x44, 0x44, 0x48, 0x22, 0x1b, 0xdd, 0xbe, 0xff, 0xff,
	0xfe, 0xff, 0xfb, 0xbd, 0xed, 0x24, 0x24, 0x44, 0x44, 0x44, 0x26, 0xed, 0xdb, 0xbf, 0xff, 0xef,
	0xfd, 0xdf, 0xe8, 0x5b, 0xbe, 0xa4, 0x26, 0x42, 0x42, 0x62, 0x4a, 0xeb, 0xb5, 0x8e, 0xfd, 0xdf,
	0xff, 0xdd, 0xd8, 0x23, 0xbb, 0xa4, 0x22, 0x24, 0x22, 0x42, 0x4a, 0xbb, 0xa2, 0x8d, 0xdd, 0xff,
	0xff, 0xeb, 0xbb, 0x22, 0x66, 0x22, 0x42, 0x21, 0x66, 0x24, 0x22, 0x16, 0x22, 0x7b, 0xbe, 0xff,
	0xff, 0xa4, 0x22, 0x26, 0x66, 0x22, 0x44, 0x21, 0x12, 0x44, 0x22, 0x21, 0x22, 0x22, 0x4a, 0xff,
	0xfd, 0x22, 0x22, 0x22, 0x11, 0x66, 0x24, 0x42, 0x24, 0x42, 0x21, 0x61, 0x62, 0x22, 0x22, 0xdf,
	0xfa, 0x62, 0x24, 0x26, 0x66, 0x66, 0x11, 0x26, 0x26, 0x11, 0x66, 0x66, 0x64, 0x22, 0x26, 0xaf,
	0xfa, 0x16, 0x66, 0x62, 0x26, 0x66, 0x63, 0x99, 0x99, 0x36, 0x66, 0x62, 0x26, 0x62, 0x11, 0xaf,
	0xe4, 0x21, 0x16, 0x6c, 0xc6, 0x66, 0x66, 0x99, 0x99, 0x66, 0x66, 0x6c, 0xc8, 0x61, 0x16, 0x4e,
	0x22, 0x11, 0x11, 0xc8, 0xcc, 0xc6, 0x66, 0x11, 0x76, 0x66, 0x6c, 0xcc, 0x86, 0x13, 0x16, 0x22,
	0x26, 0x66, 0x77, 0x66, 0xcc, 0xcc, 0x2c, 0x26, 0x66, 0xc4, 0xcc, 0xcc, 0x66, 0x77, 0x16, 0x62,
	0x16, 0x63, 0x5b, 0x76, 0x6c, 0xcc, 0x8a, 0xec, 0xcc, 0xda, 0xcc, 0xc6, 0x17, 0xb3, 0x11, 0x11,
	0x16, 0x63, 0x55, 0xb7, 0x16, 0x6c, 0xcc, 0xcc, 0xce, 0xcc, 0xc6, 0x61, 0x7b, 0x51, 0x11, 0x11,
	0x14, 0x6b, 0x95, 0xb7, 0xb8, 0x76, 0xcc, 0xcc, 0xcc, 0xcc, 0x61, 0x7b, 0x75, 0x13, 0xb6, 0x26,
	0xe2, 0x46, 0x13, 0x55, 0x5b, 0xb1, 0x36, 0x66, 0x62, 0x61, 0x7b, 0x75, 0x05, 0x16, 0x14, 0x2e,
	0xe1, 0x44, 0x1b, 0xb5, 0x05, 0xbb, 0xb7, 0x37, 0x73, 0x77, 0xb7, 0x55, 0x1b, 0xb8, 0x44, 0x8e,
	0xfa, 0x66, 0x28, 0x56, 0x10, 0x5d, 0xb0, 0x0b, 0xd0, 0x0b, 0xd5, 0x11, 0x67, 0x12, 0x62, 0xaf,
	0xfd, 0x66, 0x22, 0x22, 0x11, 0x5d, 0xb0, 0x05, 0xb0, 0x0b, 0xd3, 0x61, 0x62, 0x22, 0x26, 0xdf,
	0xfb, 0x16, 0xc6, 0x24, 0x2a, 0x3b, 0xb8, 0xd8, 0x1d, 0x1b, 0xb7, 0x34, 0x44, 0x62, 0x21, 0xbf,
	0xfa, 0xbb, 0x66, 0x62, 0x44, 0x21, 0x12, 0x84, 0x48, 0x26, 0x34, 0x44, 0x26, 0x66, 0x7b, 0xaf,
	0xfe, 0x83, 0x62, 0x26, 0x22, 0x42, 0x42, 0x44, 0x44, 0x24, 0x24, 0x26, 0x62, 0x26, 0x38, 0xef,
	0xff, 0xee, 0xdb, 0x22, 0x22, 0x62, 0x26, 0x22, 0x22, 0x62, 0x46, 0x64, 0x22, 0xbd, 0xee, 0xff,
	0xff, 0xff, 0xbb, 0x82, 0x23, 0x22, 0x22, 0x12, 0x21, 0x22, 0x26, 0x32, 0x28, 0xbb, 0xff, 0xff,
	0xff, 0xff, 0xbf, 0xee, 0x83, 0xb3, 0xbb, 0x12, 0x61, 0x7b, 0x3b, 0x3c, 0xee, 0xed, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xfb, 0xbb, 0x17, 0x5a, 0x8b, 0x51, 0xbb, 0xbe, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xed, 0xe3, 0xaf, 0xfa, 0x1d, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff,
};

unsigned char marine_icon[544] = {
	0x00, 0xf0,
	0x20, 0xf2,
	0x31, 0xf4,
	0x31, 0xf5,
	0x42, 0xf6,
	0x52, 0xf8,
	0x50, 0xf9,
	0x63, 0xf9,
	0x64, 0xfa,
	0x86, 0xf9,
	0x74, 0xfc,
	0x85, 0xfd,
	0x99, 0xf9,
	0x96, 0xfe,
	0xb8, 0xff,
	0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xf2, 0x33, 0x34, 0x44, 0x44, 0x44, 0x33, 0x2f, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xf1, 0x33, 0x55, 0x8a, 0xab, 0xaa, 0x87, 0x43, 0x33, 0x1f, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x13, 0x45, 0x8a, 0xaa, 0xa8, 0x77, 0x75, 0x74, 0x43, 0x21, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x14, 0x54, 0x57, 0x85, 0x85, 0x74, 0x44, 0x43, 0x31, 0x11, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xf1, 0x23, 0x43, 0x57, 0x55, 0x55, 0x27, 0x32, 0x32, 0x11, 0x11, 0x1f, 0xff, 0xff,
	0xff, 0xff, 0xf1, 0x12, 0x33, 0x53, 0x74, 0x45, 0x42, 0x42, 0x23, 0x11, 0x11, 0x1f, 0xff, 0xff,
	0xff, 0xff, 0xf1, 0x22, 0x44, 0x35, 0x34, 0x44, 0x45, 0x55, 0x54, 0x42, 0x12, 0x1f, 0xff, 0xff,
	0xff, 0xff, 0xf1, 0x23, 0x45, 0x43, 0x73, 0x45, 0x88, 0x78, 0x55, 0x54, 0x22, 0x1f, 0xff, 0xff,
	0xff, 0xff, 0xf1, 0x23, 0x78, 0x88, 0x88, 0xa8, 0x8a, 0x87, 0x88, 0x85, 0x22, 0x1f, 0xff, 0xff,
	0xff, 0xff, 0xf1, 0x24, 0x7b, 0xaa, 0x87, 0x88, 0x88, 0x88, 0xaa, 0xb7, 0x32, 0x1f, 0xff, 0xff,
	0xff, 0xff, 0xf1, 0x24, 0x7a, 0xdd, 0xba, 0x85, 0x58, 0xab, 0xde, 0xa7, 0x42, 0x1f, 0xff, 0xff,
	0xff, 0xff, 0xf1, 0x24, 0x10, 0x37, 0xbd, 0xbb, 0xba, 0xdd, 0xee, 0xd8, 0x42, 0x1f, 0xff, 0xff,
	0xff, 0xff, 0x84, 0x24, 0x54, 0x10, 0x7e, 0x8d, 0xe8, 0xeb, 0x72, 0x12, 0x42, 0x48, 0xff, 0xff,
	0xff, 0xff, 0x84, 0x25, 0x84, 0x10, 0x00, 0x38, 0x83, 0x02, 0x12, 0x35, 0x82, 0x48, 0xff, 0xff,
	0xff, 0xff, 0x54, 0x3a, 0x40, 0x0c, 0x90, 0x23, 0x32, 0x00, 0x0c, 0xc4, 0x83, 0x45, 0xff, 0xff,
	0xff, 0xff, 0x43, 0x58, 0x58, 0xd7, 0x23, 0x5b, 0xa5, 0x34, 0x8d, 0x75, 0x85, 0x34, 0xff, 0xff,
	0xff, 0xff, 0x53, 0x5b, 0xb8, 0x87, 0x8a, 0x7e, 0xe8, 0xa8, 0x58, 0x8b, 0xb5, 0x35, 0xff, 0xff,
	0xff, 0xff, 0x53, 0x5b, 0xde, 0xba, 0xde, 0xde, 0xed, 0xed, 0xad, 0xdd, 0xa5, 0x35, 0xff, 0xff,
	0xff, 0xff, 0xf3, 0x57, 0x88, 0xbd, 0xed, 0xbd, 0xfb, 0xde, 0xdb, 0x88, 0x75, 0x3f, 0xff, 0xff,
	0xff, 0xff, 0xf3, 0x47, 0x8a, 0xee, 0xa8, 0x79, 0x75, 0x8b, 0xee, 0xa7, 0x74, 0x3f, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x48, 0x5b, 0xed, 0x83, 0x45, 0x54, 0x27, 0xde, 0xb7, 0xa4, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x3a, 0x7d, 0xe8, 0xad, 0xa7, 0x8a, 0xda, 0x8e, 0xd5, 0xa3, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x38, 0x7a, 0xdb, 0xbe, 0xeb, 0xbe, 0xeb, 0xbd, 0xb8, 0x83, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xf5, 0x8a, 0xb5, 0x46, 0x67, 0x66, 0x64, 0x5b, 0xa8, 0x4f, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xf3, 0x58, 0xaa, 0xab, 0xdd, 0xdd, 0xba, 0xaa, 0x85, 0x3f, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x47, 0xab, 0xa8, 0x55, 0x55, 0x8a, 0xba, 0x74, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xf4, 0x8a, 0xba, 0xab, 0xda, 0xab, 0xb8, 0x4f, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0x35, 0x8b, 0xde, 0xed, 0xb8, 0x52, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x45, 0x77, 0x77, 0x54, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

unsigned char pentagram_icon[544] = {
	0x00, 0xf0,
	0x10, 0xf2,
	0x10, 0xf4,
	0x10, 0xf7,
	0x41, 0xf7,
	0x31, 0xfb,
	0x31, 0xfa,
	0x54, 0xf7,
	0x63, 0xfd,
	0x76, 0xfb,
	0x99, 0xf9,
	0x84, 0xfe,
	0xb7, 0xff,
	0xcc, 0xfc,
	0xdd, 0xfd,
	0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xfe, 0xa7, 0x43, 0x65, 0x63, 0x9a, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xfd, 0xa3, 0x66, 0x88, 0x8b, 0x88, 0x85, 0x59, 0xdf, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x98, 0x88, 0x83, 0x10, 0x00, 0x02, 0x38, 0x88, 0x89, 0xef, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xeb, 0x8b, 0x61, 0x03, 0x60, 0x10, 0x01, 0x20, 0x38, 0xbb, 0x9d, 0xff, 0xff, 0xff,
	0xff, 0xfe, 0x9b, 0xcb, 0x20, 0x13, 0x33, 0x00, 0x00, 0x13, 0x4b, 0xcc, 0x86, 0xdf, 0xff, 0xff,
	0xff, 0xf9, 0x8b, 0xcc, 0xb6, 0x33, 0x26, 0x10, 0x21, 0x11, 0xbc, 0xb7, 0xb8, 0x4d, 0xff, 0xff,
	0xff, 0xa8, 0xb4, 0xbb, 0xcb, 0xb5, 0x33, 0x30, 0x60, 0x4c, 0x8c, 0x83, 0x3b, 0x89, 0xef, 0xff,
	0xfd, 0x6b, 0x40, 0x6c, 0x68, 0xb6, 0x33, 0x52, 0x05, 0xb6, 0x8b, 0x65, 0x52, 0xb6, 0xae, 0xff,
	0xf9, 0x86, 0x02, 0x4b, 0x63, 0x38, 0x83, 0x32, 0x58, 0x33, 0xbb, 0x41, 0x35, 0x68, 0x7d, 0xff,
	0xe4, 0x83, 0x60, 0x04, 0x81, 0x13, 0x58, 0x56, 0x63, 0x22, 0xb8, 0x01, 0x03, 0x36, 0x5a, 0xef,
	0xa6, 0x63, 0x10, 0x00, 0x85, 0x36, 0x25, 0x85, 0x52, 0x53, 0x84, 0x03, 0x01, 0x36, 0x67, 0xdf,
	0x96, 0x33, 0x00, 0x23, 0x35, 0x23, 0x28, 0x85, 0x85, 0x53, 0x60, 0x32, 0x03, 0x33, 0x82, 0xdf,
	0x78, 0x23, 0x33, 0x02, 0x36, 0x35, 0x85, 0x12, 0x66, 0x85, 0x52, 0x20, 0x30, 0x33, 0x83, 0xae,
	0x28, 0x02, 0x26, 0x20, 0x38, 0x58, 0x55, 0x12, 0x31, 0x58, 0x80, 0x32, 0x10, 0x61, 0x86, 0xae,
	0x58, 0x13, 0x01, 0x35, 0xb5, 0x83, 0x15, 0x22, 0x51, 0x25, 0x88, 0x22, 0x23, 0x51, 0x88, 0xad,
	0x88, 0x02, 0x10, 0x68, 0x23, 0x52, 0x32, 0x32, 0x16, 0x06, 0x83, 0xb8, 0x53, 0x22, 0x85, 0xae,
	0x38, 0x02, 0x26, 0x82, 0x35, 0x85, 0x32, 0x66, 0x26, 0x38, 0x56, 0x3b, 0xb4, 0x33, 0x83, 0x7d,
	0x98, 0x26, 0x86, 0x25, 0x10, 0x58, 0x35, 0x65, 0x53, 0x65, 0x13, 0x54, 0x4b, 0xc6, 0x83, 0xae,
	0x9b, 0xbc, 0x55, 0x65, 0x56, 0x36, 0x55, 0x63, 0x35, 0x85, 0x58, 0x88, 0x8b, 0xbc, 0xb2, 0xae,
	0x9b, 0xc8, 0x88, 0x68, 0x66, 0x58, 0x85, 0x36, 0x58, 0x85, 0x8b, 0xbb, 0xbb, 0xbc, 0xb7, 0xae,
	0xe8, 0xb4, 0x52, 0x00, 0x10, 0x35, 0x88, 0x8b, 0x88, 0x30, 0x25, 0x12, 0x01, 0x48, 0x67, 0xde,
	0xf9, 0x86, 0x26, 0x53, 0x12, 0x03, 0xb8, 0x23, 0x5c, 0x50, 0x00, 0x02, 0x11, 0x38, 0x2a, 0xdf,
	0xfd, 0x66, 0x35, 0x32, 0x53, 0x13, 0x88, 0x21, 0x88, 0x23, 0x00, 0x00, 0x02, 0x84, 0x7a, 0xef,
	0xff, 0x98, 0x82, 0x05, 0xb6, 0x36, 0x4b, 0x68, 0xc1, 0x35, 0x10, 0x12, 0x13, 0x61, 0xad, 0xff,
	0xff, 0xe9, 0x56, 0x33, 0x82, 0x12, 0x2b, 0x88, 0xb6, 0x00, 0x22, 0x61, 0x38, 0x77, 0xde, 0xff,
	0xff, 0xfd, 0x76, 0x63, 0x53, 0x33, 0x0b, 0xbb, 0x42, 0x32, 0x30, 0x28, 0x62, 0x7a, 0xef, 0xff,
	0xff, 0xff, 0xd7, 0x66, 0x81, 0x05, 0x24, 0xcb, 0x30, 0x05, 0x23, 0x83, 0x77, 0xad, 0xff, 0xff,
	0xff, 0xff, 0xfd, 0x73, 0x88, 0x66, 0x64, 0xcb, 0x43, 0x66, 0x88, 0x30, 0x7a, 0xdf, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xea, 0x72, 0x66, 0x8b, 0xcc, 0xb8, 0x86, 0x37, 0x7a, 0xde, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xfe, 0xda, 0x77, 0x26, 0x88, 0x53, 0x71, 0x7a, 0xad, 0xef, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xfe, 0xda, 0xaa, 0xaa, 0xaa, 0xaa, 0xdd, 0xef, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xed, 0xdd, 0xdd, 0xee, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
};

static uint8 bitmap[48*32/8];

void StatusDrawLCD(uint8 *source) {
    int i;
    maple_device_t *dev;

    memset(bitmap, 0, 48*32/8);
    // LCD is upside down!
    for (i=0; i<1536; i++)
	if (source[i>>3] & (0x80 >> (i&7)))
	    bitmap[(1535-i)>>3] |= (1 << (i&7));

    dev = maple_enum_type(0, MAPLE_FUNC_LCD);
    if (dev)
        vmu_draw_lcd(dev, bitmap);

    //vmu_shutdown();
}

int DC_SaveToVMU(char *src, int tp) {
    char dst[32];
    file_t file;
    int filesize = 0;
    unsigned long zipsize = 0;
    uint8 *data;
    uint8 *zipdata;
    vmu_pkg_t pkg;
    uint8 *pkg_out;
    int pkg_size;
    unsigned char *icon_data;

    strcpy(dst, "/vmu/a1/");
    strcat(dst, src);

    file = fs_open(src, O_RDONLY);
    filesize = fs_total(file);
    data = (uint8*)malloc(filesize);
    fs_read(file, data, filesize);
    fs_close(file);

    zipsize = filesize * 2;
    zipdata = (uint8*)malloc(zipsize);
    compress(zipdata, &zipsize, data, filesize);

    // Required VMU header
    strcpy(pkg.desc_short, "DOOM for DC");
    switch(tp)
    {
	case 0:
        strcpy(pkg.desc_long, "Game Save");
	icon_data = cacodemon_icon;
	break;
	case 1:
        strcpy(pkg.desc_long, "In-Game Settings");
	icon_data = pentagram_icon;
	break;
	case 2:
        strcpy(pkg.desc_long, "User Settings");
	icon_data = marine_icon;
	break;
	case 3:
        strcpy(pkg.desc_long, "Demo Game");
	icon_data = cacodemon_icon;
	break;
	case 4:
        strcpy(pkg.desc_long, "Screen Shot");
	icon_data = marine_icon;
	break;
	default:
        strcpy(pkg.desc_long, "Doom File");
	icon_data = pentagram_icon;
	break;
    }

    strcpy(pkg.app_id, "DOOM for DC");
    pkg.icon_cnt = 1;
    pkg.icon_anim_speed = 0;
    memcpy(&pkg.icon_pal[0], icon_data, 32);
    pkg.icon_data = icon_data + 32;
    pkg.eyecatch_type = VMUPKG_EC_NONE;
    pkg.data_len = zipsize;
    pkg.data = zipdata;
    vmu_pkg_build(&pkg, &pkg_out, &pkg_size);

    fs_unlink(dst);
    file = fs_open(dst, O_WRONLY);
    fs_write(file, pkg_out, pkg_size);
    fs_close(file);

    free(pkg_out);
    free(data);
    free(zipdata);

    return 0;
}

int DC_LoadFromVMU(char *dst) {
    char src[32];
    int file;
    int filesize;
    unsigned long unzipsize;
    uint8* data;
    uint8* unzipdata;
    vmu_pkg_t pkg;

    strcpy(src, "/vmu/a1/");
    strcat(src, dst);

    // Remove VMU header
    file = fs_open(src, O_RDONLY);
    if(file == 0) return -1;
    filesize = fs_total(file);
    if(filesize <= 0) return -1;
    data = (uint8*)malloc(filesize);
    fs_read(file, data, filesize);
    vmu_pkg_parse(data, &pkg);
    fs_close(file);

    unzipdata = (uint8 *)malloc(65536);
    unzipsize = 65536;

    uncompress(unzipdata, &unzipsize, (uint8 *)pkg.data, pkg.data_len);
    fs_unlink(dst);
    file = fs_open(dst, O_WRONLY);
    fs_write(file, unzipdata, unzipsize);
    fs_close(file);

    free(data);
    free(unzipdata);

    return 0;
}
