#ifdef WIN32
#pragma comment(lib, "SDL.lib")
#pragma comment(lib, "SDLmain.lib")
#pragma comment(lib, "SDL_mixer.lib")
#endif

#ifdef DREAMCAST
#include <kos.h>
extern uint8 romdisk[];
KOS_INIT_ROMDISK(romdisk);
#endif

#include "camp.h"
#include <math.h>
#include "constants.h"

int distancia(int x1, int y1, int x2, int y2)
{
	return sqrt((float)(x1-x2)*(x1-x2) + (y1-y2)*(y1-y2));
}

bool IntersectRect(SDL_Rect *dest,const SDL_Rect *src1,const SDL_Rect *src2)
{
  int px0,py0,px1,py1;
  int cx0,cy0,cx1,cy1;
  int rx0,ry0,rx1,ry1;
  
  // fill in default (NULL) result rectangle

  dest->x = 0;
  dest->y = 0;
  dest->w = 0;
  dest->h = 0;
  
  // get coordinates of the rectangles

  px0 = src1->x;
  py0 = src1->y;
  px1 = src1->x + src1->w - 1;
  py1 = src1->y + src1->h - 1;
  
  cx0 = src2->x;
  cy0 = src2->y;
  cx1 = src2->x + src2->w - 1;
  cy1 = src2->y + src2->h - 1;
  
  // check if the rectangles intersect

  if(/*(cx0 < px0) && */(cx1 < px0))
    return false;
  
  if((cx0 > px1) /*&& (cx1 > px1)*/)
    return false;
  
  if(/*(cy0 < py0) && */(cy1 < py0))
		return false;
  
  if((cy0 > py1) /*&& (cy1 > py1)*/)
    return false;
  
  // intersect x

  if(cx0 <= px0) rx0 = px0;
  else rx0 = cx0;
  
  if(cx1 >= px1) rx1 = px1;
  else rx1 = cx1;
  
  // intersect y

  if(cy0 <= py0) ry0 = py0;
  else ry0 = cy0;
  
  if(cy1 >= py1) ry1 = py1;
  else ry1 = cy1;
  
  // fill in result rect

  dest->x = rx0;
  dest->y = ry0;
  dest->w = (rx1-rx0)+1;
  dest->h = (ry1-ry0)+1;

return true;
};

int main(int argc, char **argv)
{
	#ifdef DREAMCAST
	printf("Starting...\n");
	fs_chdir("/rd");
	#endif
	
	Camp terreny;
	
	terreny.EntrenElsJugadors(NUMERO_JUGADORS);
	terreny.Partit();

	return 0;
}
