#pragma once

#define SONS 4

#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>

#include "Pilota.h"
#include "Futbolista.h"
#include "Marcador.h"

class Camp
{
private:
	void ColocaJugadors(void);
public:
	Camp(void);
	~Camp(void);	
	
	SDL_Surface *pantalla;
	SDL_Surface *imatge;
	// Coordenades del terreny de joc 31 < x < 770 i 54 < y < 546
	SDL_Rect Terreny;
	// Coordenades de les porteries 1: 225 < y < 375 i  2 < x < 31
	// Coordenades de la porteries 2: 225 < y < 375 i  770 > x > 797
	SDL_Rect Porteria[2];
	SDL_Rect Postes[4];

	Pilota pilota; 
	Futbolista *jugador;
	Marcador marcador;
    // Variable per controlar la velocitat del joc
	Uint32 timeAnterior;


	Mix_Chunk *Fressa[SONS];

	int jugadorsPerEquip;
	int equip[2];
	bool Igual(SDL_Rect a, SDL_Rect b);
	SDL_Surface* GetPantalla(void);
	SDL_Rect GetTerreny(void);

	SDL_Rect pilabans;
	int contabloqueig;

	// Sistema de so...
	void PlaySound(int canal, int num, int repeticions);
	void PlaySoundRepetit(int num);
	bool SoundLoad(char* Nom,int i);
	void SoundDelete();

	SDL_Rect GetPorteria(int numero);
	SDL_Rect GetPorteriaMig(int numero);
    void ActivaSeguentFutbolista();
	// Funci que serveix per quan es bloqueja la pilota en un punt.
	void ComprovaFalta(bool rebota);

	void EntrenElsJugadors(int numJugadors);
	bool Partit(void);	
	
	// Pantalla amb la pilota dins de la porteria
	int Gol(void);
	bool IsGol(int p);	// Diu si s gol o no

	
	friend bool IntersectRect(SDL_Rect *dest,const SDL_Rect *src1,const SDL_Rect *src2);

};
