#include "Sprite.h"
#include "camp.h"

Sprite::Sprite(void)
: x(0)
, y(0)
{
	ImatgeEquip=0;
	camp=NULL;
}

Sprite::~Sprite(void)
{
}

// funci per posicionar per pantalla els diferents elements
void Sprite::Posiciona(int x1, int y1)
{
	x = (float) x1;
	y = (float) y1;
	xMig = x + w/2;
	yMig = y + h/2;
	PuntZonaY=y1;
	PuntZonaX=x1;
}

void Sprite::Pinta(void)
{
  Camp *p = (Camp *)camp;
  SDL_Rect dest = GetPosicio();
  SDL_Rect ori = GetPosicioImatge();
  SDL_BlitSurface(imatge, &ori, p->GetPantalla(), &dest);
}

bool Sprite::PintaReverse(SDL_Rect Origen, SDL_Rect Desti)
{
	Camp *p = (Camp *)camp;
	// Primer em faig una superficie que contindr noms la imatge a mostrar...
	SDL_Surface *Temp = SDL_CreateRGBSurface(SDL_HWSURFACE, Origen.w, Origen.h, 
		                                     imatge->format->BitsPerPixel, imatge->format->Rmask,
											 imatge->format->Gmask, imatge->format->Bmask,
											 imatge->format->Amask);
	// Copio la imatge a la nova superficie
	if(!Temp)return NULL;

	SDL_Rect dest;
	dest.x = 0;
	dest.y = 0;
	SDL_BlitSurface(imatge, &Origen, Temp, &dest);
	// Ara la giro i la creo a Girada
	SDL_Surface *Girada = FlipSurfaceH(Temp);
	// Assignar el color transparent
	SDL_SetColorKey(Girada, SDL_SRCCOLORKEY , SDL_MapRGB(Girada->format, 0, 0, 0));
	// Pintar la imatge definitivament a la 'pantalla'
	SDL_BlitSurface(Girada, &dest, p->GetPantalla(), &Desti);
	// Allibero memria
	SDL_FreeSurface(Girada);
	SDL_FreeSurface(Temp);
	return false;
}

SDL_Rect Sprite::GetPosicio(void)
{
	SDL_Rect temp;
	temp.x = x;
	temp.y = y;
	temp.h = h;
	temp.w = w;
	return temp;
}

/* 
bool Sprite::IntersectRect(SDL_Rect *dest,const SDL_Rect *src1,const SDL_Rect *src2)
{
  int px0,py0,px1,py1;
  int cx0,cy0,cx1,cy1;
  int rx0,ry0,rx1,ry1;
  
  // fill in default (NULL) result rectangle

  dest->x = 0;
  dest->y = 0;
  dest->w = 0;
  dest->h = 0;
  
  // get coordinates of the rectangles

  px0 = src1->x;
  py0 = src1->y;
  px1 = src1->x + src1->w - 1;
  py1 = src1->y + src1->h - 1;
  
  cx0 = src2->x;
  cy0 = src2->y;
  cx1 = src2->x + src2->w - 1;
  cy1 = src2->y + src2->h - 1;
  
  // check if the rectangles intersect

  if((cx1 < px0))
    return false;
  
  if((cx0 > px1))
    return false;
  
  if((cy1 < py0))
		return false;
  
  if((cy0 > py1))
    return false;
  
  // intersect x

  if(cx0 <= px0) rx0 = px0;
  else rx0 = cx0;
  
  if(cx1 >= px1) rx1 = px1;
  else rx1 = cx1;
  
  // intersect y

  if(cy0 <= py0) ry0 = py0;
  else ry0 = cy0;
  
  if(cy1 >= py1) ry1 = py1;
  else ry1 = cy1;
  
  // fill in result rect

  dest->x = rx0;
  dest->y = ry0;
  dest->w = (rx1-rx0)+1;
  dest->h = (ry1-ry0)+1;

return true;
};
*/

SDL_Surface* Sprite::FlipSurfaceH(SDL_Surface *bitmap){
	if(!bitmap)return NULL;
	SDL_Surface *temp=SDL_CreateRGBSurface(0,bitmap->w,bitmap->h,
		bitmap->format->BitsPerPixel,bitmap->format->Rmask,bitmap->format->Gmask,
		bitmap->format->Bmask,bitmap->format->Amask);
	if(!temp)return NULL;
	SDL_Rect src,dest;
	src.w=1;
	src.h=bitmap->h;
	src.y=0;
	dest.y=0;
	int origw=bitmap->w;
	for(int i=0;i<origw;i++){
		src.x=i;
		dest.x=(origw-1)-i;
		SDL_BlitSurface(bitmap,&src,temp,&dest);
	}
	return temp;
}

   
SDL_Surface* Sprite::FlipSurfaceV(SDL_Surface *bitmap){
	if(!bitmap)return NULL;
	SDL_Surface *temp=SDL_CreateRGBSurface(0,bitmap->w,bitmap->h,
		bitmap->format->BitsPerPixel,bitmap->format->Rmask,bitmap->format->Gmask,
		bitmap->format->Bmask,bitmap->format->Amask);
	if(!temp)return NULL;
	SDL_Rect src,dest;
	src.w=bitmap->w;
	src.h=1;
	src.x=0;
	dest.x=0;
	int origh=bitmap->h;
	for(int i=0;i<origh;i++){
		src.y=i;
		dest.y=(origh-1)-i;
		SDL_BlitSurface(bitmap,&src,temp,&dest);
	}
	return temp;
}


SDL_Rect Sprite::GetPosicioImatge(void)
{
	SDL_Rect temp;
	temp.x = ImatgeEquip*24; //640x480
	temp.y = 0;
	temp.w = w;
	temp.h = h;
	return temp;
}

SDL_Rect Sprite::GetPuntMig(void)
{
	SDL_Rect temp;
	temp.x = x+(w/2);
	temp.y = y+(h/2);
	temp.w = 0;
	temp.h = 0;
	return temp;
}
