#include "Futbolista.h"
#include "camp.h"
#include "math.h"
#include <stdlib.h>

Futbolista::Futbolista(void)
: socActiu(false)
{
	//640x480
	imatge = SDL_LoadBMP("jugadors.bmp"); 
	SDL_SetColorKey(imatge, SDL_SRCCOLORKEY , SDL_MapRGB(imatge->format, 51, 153, 0));
	ObjectiuFixat=false;
	w=24;
	h=24;
	velocitatX = 2;
	velocitatY = 2;
}

Futbolista::~Futbolista(void)
{
	SDL_FreeSurface(imatge);
}

int Futbolista::Mou(Uint8 *keys)
{
	int novaX=0, novaY=0, b0, opcio=0;
	SDL_Rect jo, desti, gespa;


	Camp *p = (Camp *)camp;

	if (socActiu)
	{
		// Moure en la direcci de la tecla
		novaY=y;
		novaX=x;
		
		if(keys[SDLK_UP]) 	novaY = y - velocitatY;
		if(keys[SDLK_DOWN]) novaY = y + velocitatY;
		if(keys[SDLK_LEFT]) novaX = x - velocitatX; 
		if(keys[SDLK_RIGHT]) novaX = x + velocitatX;
		
		jo=GetPosicio();
		jo.x=novaX;
		jo.y=novaY;
		b0=1;
	}
	else
	{
		// Qu fan els altres ... 
		if (Numero==0)
		{
			    jo=Estrategia_Porter();
		}
		else
		{
				opcio = rand()%2;	
				int m = Quesoc();				
				switch(m)
				{
					case 1: // jo=Estrategia_Cacera();
							if (opcio==0) jo=Estrategia_Atac();
									else  jo=Estrategia_Cacera();
					        break;
					case 2: if (opcio==0) jo=Estrategia_Zona_Defensiva();
									else  jo=Estrategia_Defensa();							
					        break;
					default:
							jo=Estrategia_Zona();
							break;
				}
		}
		b0=0;
	}

	// Comprovar que no sortim dels marges
	gespa=p->GetTerreny();
	// faig el requadre ms petit per l'amplada del jugador
	gespa.x+=w;
	gespa.w-=2.5*w;
	gespa.y+=h;
	gespa.h-=2*h;
	
	if (IntersectRect(&desti,&jo,&gespa))
	{

		if (!Xoco(GetDNI(), jo))
		{
			x=jo.x;
			xMig = jo.x + w/2;
			y=jo.y;
			yMig = jo.y + w/2;
		}
	}
	return b0;
}

void Futbolista::Inicia(int numSamarreta, bool Actiu, int Equip, int direccio, void *cp)
{
	SDL_Surface *dorsals;
	Numero=numSamarreta;

    dorsals = SDL_LoadBMP("dorsals.bmp"); 
	SDL_SetColorKey(dorsals, SDL_SRCCOLORKEY , SDL_MapRGB(dorsals->format, 255, 255, 255));

	SDL_Rect Numeracio, Desti;
	//640x480
	// Quin nmero hem de posar?
	Numeracio.x=Numero*24;
	Numeracio.y=0;
	Numeracio.w=24;
	Numeracio.h=24;
	Desti.y=0;
	Desti.w=24;
	Desti.h=24;
	for (int i=0; i<12; i++)
	{
		// Pinto el dorsal a la imatge (640x480)
		Desti.x = i*24;
		SDL_BlitSurface(dorsals, &Numeracio , imatge, &Desti);	
	}
	SDL_FreeSurface(dorsals);
	
	socActiu=Actiu;
	// El primer de cada equip s el porter
	if (numSamarreta==0) 
	{
		socActiu=false;
		velocitatX=0;
	}
	// Quina s la imatge a mostrar? Equip
	ImatgeEquip=Equip;
	Direccio=direccio;
	// Li passem el camp perqu spiga on s tot ...  pugui fer una estratgia
	camp = cp; 	
}

// Identificador nic del jugador
int Futbolista::GetDNI(void)
{
	return (Numero+1)*Direccio;
}

bool Futbolista::Activa(bool sino)
{
	bool anterior;
	ObjectiuFixat=false;
	anterior=socActiu;
	socActiu=sino;
	return anterior;
}

SDL_Rect Futbolista::AnarA(int x1, int y1)
{
	SDL_Rect Resultat;
	
	 if (Numero!=0)
	 {
		x1=x1-w/2;
		y1=y1-h/2;
	 }
	// 4. posicionar
	Resultat.x = x1 - x ;
	Resultat.y = y1 - y;
	// 5. Passet a passet...
	int t = normalitza(Resultat.x,Resultat.y);
	Resultat.x = x + (Resultat.x/t)*velocitatX;
	Resultat.y = y + (Resultat.y/t)*velocitatY;
	Resultat.h = h;
	Resultat.w = w;

	return Resultat;
}


bool Futbolista::Xoco(int ID, SDL_Rect jo)
{
	 bool retorn; 
	int numjugadors, contador, dni2;	
	SDL_Rect ell, res;
	
	Camp *p = (Camp *)camp;
	retorn=false;
	contador=0;
	while (contador < p->jugadorsPerEquip*2 && retorn==false)
	{        
		dni2 = p->jugador[contador].GetDNI();
		// si no sc jo
		if (ID!=dni2)
		{			
			ell = p->jugador[contador].GetPosicio();
			retorn=IntersectRect(&res,&jo,&ell);
		}
		contador++;
	}
	return retorn;
}

int Futbolista::normalitza(int xx, int yy)
{
	int tempx, tempy, retorn;

	if (xx<0) tempx = xx*-1;
	     else tempx = xx;
	// -- necessito els valors absoluts
	if (yy<0) tempy = yy*-1;
	     else tempy = yy;
	if (tempx>tempy)retorn = tempx;
		       else retorn = tempy;	
    if (retorn==0) retorn = 1; 
	return retorn;
}

SDL_Rect Futbolista::VectorUnitari(int xx, int yy)
{
	SDL_Rect Resultat;
	int dist = distancia(x,y,xx,yy);
	Resultat.x = (x - xx) / dist;
	Resultat.y = (y - yy) / dist;
	Resultat.w = 0;
	Resultat.h = 0;
	return Resultat;
}

// Funci que determina si sc el ms proper, el ms lluny o cap de les dues
int Futbolista::Quesoc(void)
{	
	bool proper=true, llunya=true;
	int min=0, max=0, tmp=0;
	int inici=1, fi=0, compensa=0;

	Camp *p = (Camp *)camp;
	fi=p->jugadorsPerEquip;
	// 1.Localitzar la pilota.
	SDL_Rect pilotamig = p->pilota.GetPuntMig();	
	
	max = distancia(xMig,yMig,pilotamig.x,pilotamig.y);
	min = max;
	// si sn els de la dreta, canviar
	if (Direccio==-1)
	{
		compensa=fi;
		inici=fi+1;
		fi=fi*2;		 		
	}
	for (int k=inici; k<fi; k++)
	{
		if (k!=Numero+compensa && p->jugador[k].socActiu==false)
		{
			tmp = distancia(p->jugador[k].xMig,p->jugador[k].yMig,pilotamig.x,pilotamig.y);			
			if (tmp<min)
			{
				proper=false;
				min = tmp;
			}
			if (tmp>max)
			{
				llunya=false;
				max = tmp;
			}
		}
	}
	if (proper==true) return 1;
	if (llunya==true) return 2;	
	return 0;
}


void Futbolista::Pinta(void)
{
  SDL_Rect lloc;
  Camp *p = (Camp *)camp;
  SDL_Rect dest = GetPosicio();
  SDL_Rect ori = GetPosicioImatge();
  SDL_BlitSurface(imatge, &ori, p->GetPantalla(), &dest);
  if (socActiu==true)
  {	  
	  lloc.w = w/4;
	  lloc.h = h/4;
	  lloc.x = x+3*w/8;
	  lloc.y = y+3*h/8;
	  SDL_FillRect(p->GetPantalla(),&lloc,0);
	  lloc.x+=2;
	  lloc.y+=2;
	  lloc.w-=2;
	  lloc.h-=2;
	  SDL_FillRect(p->GetPantalla(),&lloc,SDL_MapRGB(p->GetPantalla()->format,255,255,64));
  }
}

// #########################################################################
// #############################  ESTRATEGIES ##############################
// #########################################################################
SDL_Rect Futbolista::Estrategia_Atac(void)
{
	SDL_Rect pilotamig, porteriamig, Moviment, Resultat;
	int porpilx=0, porpily=0, t=0;
	Camp *p = (Camp *)camp;
	// 1.Localitzar la pilota.
	pilotamig = p->pilota.GetPuntMig();
	// 2. Localitzar la porteria contraria
	if (Direccio>0) porteriamig = p->GetPorteria(1);
			   else porteriamig = p->GetPorteria(0);
	// 3. si apunto a la meva porteria, mira de girar...
	if (distancia(pilotamig.x, pilotamig.y, porteriamig.x,porteriamig.y) > distancia(xMig, yMig,porteriamig.x, porteriamig.y))
	{
		// La pilota est darrera, per tant no anar-hi directament perqu xutarem cap a 
		// la nostra porteria...	
		porpilx = pilotamig.x - porteriamig.x;
		porpily = pilotamig.y - porteriamig.y;
		t = normalitza(porpilx, porpily);		
		Resultat = AnarA(pilotamig.x + (2*w/t*porpilx)+Direccio*6, pilotamig.y + (2*h/t*porpily));
	}
	else
	{
		// Est endavant ... A per ella!
		// Mirarem d'encarar-nos cap a la porteria

		Resultat = AnarA(pilotamig.x-(pilotamig.x-porteriamig.x), pilotamig.y-(pilotamig.y-porteriamig.y));
	}		
	return Resultat;
}

// #############################  CACERA  ##############################


SDL_Rect Futbolista::Estrategia_Cacera(void)
{
	SDL_Rect Resultat, porteriamig, pilotamig, punt;	
	Camp *p = (Camp *)camp;
	int valor=0, porpilx=0, porpily=0, tempx=0, tempy=0;

	// 1.Localitzar la pilota.
	pilotamig = p->pilota.GetPuntMig();
	// 2. Localitzar la porteria contraria
	if (Direccio>0) porteriamig = p->GetPorteria(1);
			   else porteriamig = p->GetPorteria(0);
	// 3. direcci porteria --> pilota
	porpilx = pilotamig.x - porteriamig.x;
	porpily = pilotamig.y - porteriamig.y;
	// 4. Normalitzar la direcci
	int t = normalitza(porpilx,porpily);
	if (t!=0)
	{
		porpilx = porpilx/t;
		porpily = porpily/t;
	}
	else
	{
		porpilx=0;
		porpily=0;
	}

	// 5. Anar a .... (allunyo 2*w unitats i 2*h unitats)
	punt.x=pilotamig.x;
	punt.y=pilotamig.y;
	// si apunto a la meva porteria, mira de girar...
	if (distancia(pilotamig.x, pilotamig.y, porteriamig.x,porteriamig.y) > distancia(xMig, yMig,porteriamig.x, porteriamig.y))
	{
		punt.x = punt.x + (2*w*porpilx);
		punt.y = punt.y + (2*h*porpily);
	}
	// 6.Ara anem-hi!! jo --> punt
	tempx = (int) punt.x-xMig;
	tempy = (int) punt.y-yMig;

	valor = normalitza(tempx,tempy);

	Resultat.x = x + (float)tempx/valor*velocitatX;
	Resultat.y = y + (float)tempy/valor*velocitatY;
	Resultat.w = w;
	Resultat.h = h;

	return Resultat;
}

// #############################  PORTER  ##############################
SDL_Rect Futbolista::Estrategia_Porter(void)
{
	SDL_Rect Resultat, porteria, jo, dest, ball;
	Camp *p = (Camp *)camp;
	// 1. Obtenir la posici de la pilota
	ball = p->pilota.GetPuntMig();
	// 2. Obtenir la porteria
	if (Direccio>0) 
	{
		porteria = p->GetPorteria(0);
		porteria.x=0;
	}
	else 
	{
		porteria = p->GetPorteria(1);
		porteria.x=porteria.x-(2*w);
	}
    // 3. Ara hem d'anar en la seva direcci per no gaire... per aix amplio una mica
	// Allargo el requadre de la porteria perqu hi entri el tio
    porteria.w=porteria.w+(2*w); 
	// 4. Vaig a la coordenada y de la pilota...
	int punty=y;
 	if (yMig>ball.y) punty -= velocitatY;
	            else punty += velocitatY;
	jo = AnarA(x,punty);	
	// 6. Noms m'he de moure dins dels marges ...
	if (IntersectRect(&dest,&jo,&porteria)) Resultat=jo;
	  	                               else Resultat=GetPosicio();	
	return Resultat;
}

// #############################  DEFENSA  ##############################

SDL_Rect Futbolista::Estrategia_Defensa(void)
{
	SDL_Rect Resultat, porteria, punt, porteriamig, pilotamig;
	Camp *p = (Camp *)camp;
	int valor=0, porpilx=0, porpily=0, tempx=0, tempy=0;
	
	// 1.Localitzar la pilota.
	pilotamig = p->pilota.GetPuntMig();

	// 3. Si est ms enll de mig camp, fem zona
	if ((pilotamig.x*Direccio) < (395*Direccio))
	{
        // 2. Localitzar la meva porteria
		if (Direccio>0) porteriamig = p->GetPorteriaMig(0);
				   else porteriamig = p->GetPorteriaMig(1);
		// si apunto a la meva porteria, mira de girar...
		int pilport = distancia(pilotamig.x, pilotamig.y, porteriamig.x,porteriamig.y);
		int joport = distancia(xMig, yMig,porteriamig.x, porteriamig.y);
		if ( pilport > joport )
		{
			// ---- Estic ms a prop de la porteria que la pilota ---- 
			// 3. La pilota est a prop o lluny?
			int piljo = distancia(x,y,pilotamig.x,pilotamig.y);
			if (piljo<2*velocitatX)
			{
				// 4. A per la pilota que est a prop!
				Resultat = AnarA(pilotamig.x, pilotamig.y);
				ObjectiuFixat=false;
			}
			else
			{						
				// 4. Moure cap on ser la pilota d'aqu 'n' passes?
				if (ObjectiuFixat==false)
				{
					int n = pilport/10;
					Objectiu.x = p->pilota.DireccioPilotaX(n);
					Objectiu.y = p->pilota.DireccioPilotaY(n);
            		ObjectiuFixat==false;
				}
				Resultat = AnarA(Objectiu.x, Objectiu.y);
			}
		}
		else
		{
			// Recula com un psicopata!
			Resultat.x = x + -1*Direccio*velocitatX;
			Resultat.y = y;
			Resultat.w = w;
			Resultat.h = h;
			ObjectiuFixat=false;
		}
	}
	else
	{
		// Torno a casa perqu no hi ha perill
		Resultat = Estrategia_Zona_Defensiva();
		ObjectiuFixat=false;
	}
	return Resultat;
}

// #############################  ATURAT  ##############################

SDL_Rect Futbolista::Estrategia_Aturat(void)
{
	SDL_Rect Resultat;
	Resultat.x = x;
	Resultat.y = y;
	Resultat.w = w;
	Resultat.h = h;
	return Resultat;	
}

// #############################  ZONA  ##############################

SDL_Rect Futbolista::Estrategia_Zona(void)
{
	SDL_Rect porteria, ball;
	int n;
	Camp *p = (Camp *)camp;
	// 1.Localitzar la pilota.
	ball = p->pilota.GetPuntMig();	
	// 2. Calcular la 'n' millor segons estiguem al camp
	if (Direccio>0) porteria = p->GetPorteriaMig(0);
			   else porteria = p->GetPorteriaMig(1);
    // 3. Distncia en linea recta a la nostra porteria
	n = distancia(ball.x, ball.y, porteria.x,porteria.y)/100;
	return AnarA(ball.x-(w*n*Direccio), PuntZonaY);
}
// ###################### ZONA DEFENSIVA #############################
SDL_Rect Futbolista::Estrategia_Zona_Defensiva(void)
{
	SDL_Rect Resultat;
	Camp *p = (Camp *)camp;
	// 1.Localitzar la pilota.
	SDL_Rect pilotamig = p->pilota.GetPuntMig();
	// 2. Si est molt a prop, a per ella
	int piljo = distancia(x,y,pilotamig.x,pilotamig.y);
	if (piljo<4*velocitatX)
	{
		// 4. A per la pilota que est a prop!
		Resultat = AnarA(pilotamig.x, pilotamig.y);
	}
	else 
	{
		// 4. Sobre la lnea imaginria, seguint la pilota...
		Resultat = AnarA(PuntZonaX, pilotamig.y);
	}
	return Resultat;
}


bool Futbolista::EsActiu(void)
{
	return socActiu;
}
