#include "Marcador.h"
#include <time.h>

Marcador::Marcador()
{
	Lloc.x = 0;
	Lloc.y = 0;
	pantalla = NULL;
	local=0;
	visitant=0;
}

void Marcador::Init(SDL_Surface *p, int e1, int un, int e2, int dos, int tempo)
{
	SDL_Rect Nom, Desti;

	equip1=e1;
	equip2=e2;
	Lloc.x=un;
	Lloc.y=dos;
	local = 0;
	pantalla = p;
	visitant = 0;
	temps=tempo;
	segons_que_falten=tempo;
	time(&segons_inici);	
	imatge = SDL_LoadBMP("marcador.bmp");
	numeros = SDL_LoadBMP("numeros.bmp");
	equips = SDL_LoadBMP("equips.bmp");

	// Primer nom ...
	Desti.x=1;
	Desti.y=4;
	Desti.w=49;
	Desti.h=32;
	// ----
	Nom.x=equip1*49;
	Nom.y=0;
	Nom.w=49;
	Nom.h=32;		
	// ----
	SDL_BlitSurface(equips, &Nom , imatge, &Desti);	

	// segon nom ...
	Desti.x=152;
	Desti.y=4;
	Desti.w=49;
	Desti.h=32;
	// ----
	Nom.x=equip2*49;
	Nom.y=0;
	Nom.w=49;
	Nom.h=32;		
	// ----
	SDL_BlitSurface(equips, &Nom , imatge, &Desti);	
	SDL_FreeSurface(equips);
}

Marcador::~Marcador(void)
{
	SDL_FreeSurface(imatge);
	SDL_FreeSurface(numeros);	
}

void Marcador::Gol(int Qui)
{
	if (Qui<0) visitant++;
	      else local++;
}

void Marcador::Pinta()
{
	// Pintar el fons del marcador
	SDL_BlitSurface(imatge, NULL, pantalla, &Lloc);
	// Pintar els nmeros
	// LOCAL
	SDL_Rect Numero, Desti;
	// PintaNumero(local);
	// PintaNumero(visitant);
	int passades = NumXifres(local);
	
	//640x480
	
	// ---- LOCAL ----
	Desti.x = Lloc.x + 51;
	Desti.y = Lloc.y + 5;
	for (int k=passades-1; k>=0; k--)
	{
        Numero.x=Xifra(k,local)*24;
		Numero.y=0;
		Numero.w=24;
		Numero.h=24;
		SDL_BlitSurface(numeros, &Numero , pantalla, &Desti);
		Desti.x=Desti.x+24;
	}
	// ---- VISITANT ----
	Desti.x = Lloc.x + 202;
	Desti.y = Lloc.y + 5;
	passades = NumXifres(visitant);
	for (int k=passades-1; k>=0; k--)
	{
        Numero.x=Xifra(k,visitant)*24;
		Numero.y=0;
		Numero.w=24;
		Numero.h=24;
		SDL_BlitSurface(numeros, &Numero , pantalla, &Desti);
		Desti.x=Desti.x+24;
	}

	// ----- Temps restant ---
	Desti.x=10;
	Desti.y=5;
	passades = NumXifres(temps);
	for (int k=passades-1; k>=0; k--)
	{
        Numero.x=Xifra(k,temps)*24;
		Numero.y=0;
		Numero.w=24;
		Numero.h=24;
		SDL_BlitSurface(numeros, &Numero , pantalla, &Desti);
		Desti.x=Desti.x+24;
	}

}

int Marcador::NumXifres( int valor)
{
	int contador=1;
	while (valor>9)
	{		
		// int nou=(valor/10)*10;
		// valor = valor - nou;
		valor = valor / 10;
		contador++;
	}
	return contador;
}


int Marcador::Xifra(int Posicio, int num)
{
	int valor = num;
	int passada=0;

	while (passada!=Posicio)
	{
		valor=valor/10;
		passada++;
	}
	return valor = valor % 10; 	
}

bool Marcador::PartitAcabat(void)
{
	bool resultat=false;
	time_t segons_ara;	

	time(&segons_ara);
	temps = temps - ( segons_ara - segons_inici );
	
	segons_inici=segons_ara;

	if (temps <= 0)
	{
		resultat=true;
		temps=0;
	}
	
	return resultat;
}
