#include "camp.h"
#include <time.h>
#include <stdlib.h>
#include "constants.h"

#ifdef DREAMCAST
#include <kos.h>
#include <SDL/SDL_dreamcast.h>
#endif

Camp::Camp(void)
{
	srand( (unsigned)time( NULL ) );
	// 1. Iniciar el SDL
	if ( SDL_Init( SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_JOYSTICK ) < 0 )
	{
		fprintf( stderr, "Video initialization failed: %s\n",
			SDL_GetError( ) );
		SDL_Quit( );
	}
	
	//SDL_WM_SetIcon(SDL_LoadBMP("futbillar.bmp"), NULL);
	//SDL_WM_SetCaption("Futbillar","futbillar.ico");
	
	atexit(SDL_Quit);

	pantalla = SDL_SetVideoMode(640, 480, 32, SDL_HWSURFACE|SDL_DOUBLEBUF);
	if ( pantalla == NULL ) 
	{ 
		printf("Unable to set 640x480 video: %s\n", SDL_GetError()); 
	} 
	else
	{
		// 1. Fa falta controlar els ticks?
		timeAnterior = SDL_GetTicks();
		// 2. Carregar la imatge
		imatge = SDL_LoadBMP("camp.bmp"); 
		// 3. Coordenades del terreny de joc 800x600: 31 < x < 770 i 54 < y < 546
		//640x480: 24 < x < 605 i 43 < y < 394
		Terreny.x=24;
		Terreny.y=43;
		Terreny.w=605;
		Terreny.h=394;
		// 4. Coordenades de les porteries 1: 225 < y < 375 i  2 < x < 31
		//640x480: 180 < y < 304 i  2 < x < 24
		// Coordenades de la porteries 2: 225 < y < 375 i  770 > x > 797
		//640x480: 180 < y < 304 i  616 > x > 797
		Porteria[0].x=2;
		Porteria[0].y=178;
		Porteria[0].w=24;
		Porteria[0].h=122;
		// Porteria dreta
		Porteria[1].x=616;
		Porteria[1].y=178;
		Porteria[1].w=24;
		Porteria[1].h=122;		
		// 5. Dir-li a la pilota a quin camp s
		pilota.Inicia(this);
		// 6. Encara no hi ha equips
		equip[0]=-1;
		equip[1]=-1;
		// 7. el so	
		Mix_OpenAudio(44100,AUDIO_S16,2,1024);

		SoundLoad("public.wav",SO_PUBLIC);
		SoundLoad("pito.wav",SO_PITO);
		SoundLoad("gol.wav",SO_GOL);
		SoundLoad("xut.wav",SO_XUT);

		//8. el pad de dreamcast
		#ifdef DREAMCAST
		SDL_DC_MapKey(0,SDL_DC_START,SDLK_RETURN);
		SDL_DC_MapKey(0,SDL_DC_UP,SDLK_UP);
		SDL_DC_MapKey(0,SDL_DC_DOWN,SDLK_DOWN);
		SDL_DC_MapKey(0,SDL_DC_LEFT,SDLK_LEFT); 
		SDL_DC_MapKey(0,SDL_DC_RIGHT,SDLK_RIGHT);
		SDL_DC_MapKey(0,SDL_DC_A,SDLK_SPACE); //Canviar jugador
		SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //L button, exits
		
		SDL_JoystickEventState(SDL_ENABLE);
		SDL_JoystickOpen(0);
		SDL_ShowCursor(1);
		#endif
	}
}

Camp::~Camp(void)
{
	delete [] jugador;
	// Eliminar la imatge
	SDL_FreeSurface(imatge);
	SoundDelete();
	Mix_CloseAudio();
}

// ---------------------------------------------------------
// --------------------------  SO --------------------------
// ---------------------------------------------------------

void Camp::PlaySoundRepetit(int num)
{
   	if(Mix_PlayChannel(0, Fressa[num], -1)==-1) {
    //error
	}
}
void Camp::PlaySound(int canal, int num, int repeticions)
{
   	if(Mix_PlayChannel(canal, Fressa[num], repeticions)==-1) {
    //error
	}
}
bool Camp::SoundLoad(char* Nom,int i)
{
	char Error[200];
	Fressa[i]=Mix_LoadWAV(Nom);
	if(!Fressa[i]) {
		sprintf(Error,"%s",Mix_GetError());
	}
	return true;

}
void Camp::SoundDelete()
{
	for (int i=0; i<SONS; i++) 
	{
		if (Fressa[i]!=NULL) Mix_FreeChunk(Fressa[i]);
		Fressa[i]=NULL;//make sure we free it
	}
}

// Canvia el futbolista controlat per l'usuari
void Camp::ActivaSeguentFutbolista(void)
{		
	int num = jugadorsPerEquip; 
	int actiu = 1; 	
	while(jugador[actiu].EsActiu()==false && actiu < num ) 
	{
		actiu++;
	}
	if (actiu < num )
	{   
 		jugador[actiu].Activa(false);
		actiu=actiu+1;
		if (actiu>=num)actiu=1;		
		jugador[actiu].Activa(true);
	}	
 }

// Entren els jugadors al camp...
void Camp::EntrenElsJugadors(int numJugadors)
{	
	SDL_Event event;
	SDL_Surface *inicial, *boles, *noms;
	SDL_Rect dest, equips[12], orig, orig2,  rata, quadre;
	bool trobat;

	inicial = SDL_LoadBMP("tria.bmp"); 
	boles = SDL_LoadBMP("jugadors.bmp");
	noms = SDL_LoadBMP("equips.bmp");

	// On posar les boles
	// A 640x480
	
	int posy=128;
	for (int i=0; i<12; i+=2)
	{
		// 1ra columna
		equips[i].y=posy;
		equips[i].x=180;
		equips[i].w=24;
		equips[i].h=24;
		// 2na columna
		equips[i+1].x=equips[i].x+280;
		equips[i+1].y=posy;
		equips[i+1].w=24;
		equips[i+1].h=24;
		posy=posy+48;			
	}				

	int done =0;	
	while (done<2)
	{
		while ( SDL_PollEvent(&event))
		{
			if (event.type == SDL_QUIT) { done =2; }
			if (event.type == SDL_MOUSEBUTTONDOWN)
			{
				// Obtenir la rata
				rata.x = event.button.x;
				rata.y = event.button.y;
				rata.w = 5;
				rata.h = 5;
				// provar si n'ha clicat algun...
				trobat=false;
				int i=0;
				while (!trobat && i<12)
				{
					trobat = IntersectRect(&dest,&rata,&equips[i]);
					i++;
				}
				if (trobat)
				{
					equip[done]=i-1;
					quadre.x=equips[i-1].x - 5;
					quadre.y=equips[i-1].y-5;
					done++;
				}
			}
		}
		
		// 1. Pintar el fons		
		dest.x=0;
		dest.y=0;
		SDL_BlitSurface(inicial, NULL, pantalla, &dest);		
		// genric per les imatges
		orig.y=0;
		orig.w=24;
		orig.h=24;
		// genric pels noms
		orig2.y = 0;	
		orig2.w = 49;
		orig2.h = 32;
		
		// El quadre groc?
		quadre.w = 95;
		quadre.h = 42;

		if (equip[0]>-1) SDL_FillRect(pantalla,&quadre,SDL_MapRGB(pantalla->format,255,255,64));

		for (int i=0; i<12; i++)
		{			
			// Les imatges			
			orig.x=i*24;
			SDL_BlitSurface(boles,&orig , pantalla, &equips[i]);
			
			// Ara els noms
			dest.x = equips[i].x + equips[i].w + 5;
			dest.y = equips[i].y-1;
			orig2.x = i*49;
			SDL_BlitSurface(noms,&orig2,pantalla,&dest);
		}
		SDL_SetCursor(NULL); //redraw cursor!
		SDL_Flip(pantalla);
	}

	jugador = new Futbolista[numJugadors*2];
	jugadorsPerEquip=numJugadors;
	if (equip[0]==-1) equip[0] = 0;
	if (equip[1]==-1) equip[1] = 1;
	for (int i=0; i<numJugadors; i++)
	{
		// Primer equip
		jugador[i].Inicia(i,false,equip[0],+1, this);
		// Segon equip
		jugador[numJugadors+i].Inicia(i, false, equip[1],-1, this);
	}

	SDL_FreeSurface(boles);
	SDL_FreeSurface(noms);
	SDL_FreeSurface(inicial);

}

// Bucle principal del partit 
bool Camp::Partit(void)
{
	SDL_Rect dest, res, jo, ball;
	SDL_Event event;
	Uint8 *keys=NULL;
	bool haRebotat;
	
	int i,j;

	dest.x = 0;
	dest.y = 0;

	marcador.Init(pantalla,equip[0], 300, equip[1], 5, TEMPS_PARTIT);

	int done=0;

	ColocaJugadors();

	// xiulet inicial
	PlaySoundRepetit(SO_PUBLIC);
	PlaySound(-1, SO_PITO, 0);

	while (marcador.PartitAcabat()==false && done==0)
	{		
		while ( SDL_PollEvent(&event))
		{
			if (event.type == SDL_QUIT) { done = 1; }
			
			keys = SDL_GetKeyState(NULL);		
			if(keys[SDLK_SPACE]){
				// Activa el segent futbolista...
				ActivaSeguentFutbolista();
			}
			else if(keys[SDLK_ESCAPE])  { done = 1; }
		}

		// Miro si toca moure o no. Aix s necessari per controlar
		// el temps
		Uint32 currTime = SDL_GetTicks();
		Uint32 delta = (currTime - timeAnterior);
		if (delta > ESPERA) 
		{
			
			timeAnterior = currTime;

			// 1. Pintar el camp		
			SDL_BlitSurface(imatge, NULL, pantalla, &dest);
			marcador.Pinta();
			// Ho necessito per comprovar si ha fet falta
			haRebotat=false;
			// SDL_FillRect(pantalla,&Porteria[1],0);
			// 2. Moure els jugadors i pintar-los
			for (i=0; i<jugadorsPerEquip*2; i++)
			{
				jugador[i].Mou(keys);
				jugador[i].Pinta();			
				// Comprovar si xoca amb la pilota...
				jo = jugador[i].GetPosicio();
				ball = pilota.GetPosicio();
				if (IntersectRect(&res,&jo,&ball))
				{
					// si s un jugador del nostre equip 
					if (i > 0 && i<jugadorsPerEquip)
					{
						for (j=1; j<jugadorsPerEquip; j++) jugador[j].Activa(false);
						jugador[i].Activa(true);
					}
					PlaySound(-1,SO_XUT, 0);
					pilota.rebota(jo.x+jo.w/2, jo.y+jo.h/2);
					haRebotat=true;
				}
				
			}
			// tecla = (SDLKey) 0;
			// 3. Moure la pilota i pintar-la
			pilota.Mou();
			pilota.Pinta();
			if (IsGol(0) || IsGol(1))
			{
				Mix_Pause(SO_PUBLIC);
				PlaySound(1, SO_GOL, 0);
				// Fer alguna cosa en el marcador.
				if (IsGol(0)) marcador.Gol(-1);
						else  marcador.Gol(+1);
				// Hi ha un gol, atura el moviment i espera una tecla!			
				if (Gol()==2) done=1;
				// Tornem-hi!
				ColocaJugadors();
				haRebotat=false;
				// continua amb els crits de la gent
				Mix_HaltChannel(1);
				Mix_Resume(SO_PUBLIC);
			}
			else
			{
				// Intentar solventar el problema del bloqueig...
				ComprovaFalta(haRebotat);
			}
		
			// 4. Canvia pantalles
			SDL_Flip(pantalla);
		}
	}
	// Espera tecla! Per ja s'ha acabat el partit!			
	PlaySound(-1, 1, 2);
	Gol();
	return false;
}

// Noms hi ha faltes si rebota, si la pilota est sola pel
// camp no s falta.
void Camp::ComprovaFalta(bool Rebot)
{
	SDL_Rect pilara, res;
	
	pilara = pilota.GetPosicio();
	if (Rebot==true)
	{	
		if (IntersectRect(&res,&pilara,&pilabans))
		{
			contabloqueig++;
			if (contabloqueig>50)
			{
				// Falta! (640x480)
				PlaySound(-1, 1, 0);
				int lloc = (rand()%352) + 53;
				pilota.Posiciona(316,lloc);	
			}
		}
		else
		{
			pilabans=pilara;
			pilabans = pilota.GetPosicio();
			pilabans.x -=pilabans.w;
			pilabans.w +=pilabans.w;
			pilabans.y -=pilabans.h;
			pilabans.h +=pilabans.h;
			contabloqueig=0;
		}
	}
	else
	{
		pilabans=pilara;
		pilabans = pilota.GetPosicio();
		pilabans.x -=pilabans.w;
		pilabans.w +=pilabans.w;
		pilabans.y -=pilabans.h;
		pilabans.h +=pilabans.h;
		contabloqueig=0;
	}
}


// Funci que posa a la gent al seu camp per poder comenar
//
void Camp::ColocaJugadors(void)
{
	int px, py, sx;
	// La pilota al mig del camp (640x480)
	pilota.Posiciona(316,236);
	pilota.SetForca(0);
	// Faig el requadre de la pilota ms gran per comprovar el problema 
	// del bloqueig
	pilabans = pilota.GetPosicio();
	pilabans.x -=pilabans.w;
	pilabans.w +=pilabans.w;
	pilabans.y -=pilabans.h;
	pilabans.h +=pilabans.h;
	contabloqueig=0;

	// Recol.locar els jugadors (640x480)
	py=228;
	px=26;
	sx=590;
	// 1. Porters
	jugador[0].Posiciona(px,py);
	jugador[jugadorsPerEquip].Posiciona(sx,py);
	// Increment ... Espai = (Terreny.y / 2)
	// En Jugadors/3 lnies + 2 (espais)...
	int Linies = (jugadorsPerEquip/3)+2;
	int Increment = ((Terreny.w/2)-px)/Linies;

	// 2. Altres
	for (int i=1; i<jugadorsPerEquip; i+=3)
	{
		px+=Increment;
		sx-=Increment;
		// Hauria de posar-los mig b.		
		jugador[i].Posiciona(px,py);
		jugador[i].Activa(false);
		// Els altres
		jugador[i+jugadorsPerEquip].Posiciona(sx,py);
		//640x480
		if (i+1<jugadorsPerEquip) 
		{
			// Els nostres
			jugador[i+1].Posiciona(px,py-96);
			jugador[i+1].Activa(false);
			// Els altres
			jugador[i+1+jugadorsPerEquip].Posiciona(sx,py-96);
		}
		if (i+2<jugadorsPerEquip) 
		{
			// Els nostres
			jugador[i+2].Posiciona(px,py+96);
			jugador[i+2].Activa(false);
			// Els altres
			jugador[i+2+jugadorsPerEquip].Posiciona(sx,py+96);
		}									
	}
	jugador[jugadorsPerEquip-1].Activa(true);



}

SDL_Surface* Camp::GetPantalla(void)
{
	return pantalla;
}

SDL_Rect Camp::GetTerreny(void)
{
	return Terreny;
}

bool Camp::IsGol(int p)
{
	SDL_Rect resultat, ball;
	ball = pilota.GetPosicio();
	if (IntersectRect(&resultat,&Porteria[p],&ball))
	{
		// Est a punt, per ha entrat tota?
		if (Igual(resultat,ball)) return true;
	}
	return false;
}

SDL_Rect Camp::GetPorteria(int numero)
{
	return Porteria[numero];
}

SDL_Rect Camp::GetPorteriaMig(int numero)
{
	SDL_Rect tmp;	
	tmp.x = Porteria[numero].x + Porteria[numero].w/2;
	tmp.y = Porteria[numero].y + Porteria[numero].h/2;	
	tmp.w = 0;
	tmp.h = 0;
	return tmp;
}

int Camp::Gol(void)
{
	SDL_Event event;
	SDL_Rect dest;
	dest.x=0;
	dest.y=0;
	int done =0;
	// pilota.Mou();
	while (done==0)
	{
		while ( SDL_PollEvent(&event))
		{
			if (event.type == SDL_QUIT) { done = 2; }

			if (event.type == SDL_KEYDOWN) 
			{
				done=1;
			}
		}
		// 1. Pintar el camp		
		SDL_BlitSurface(imatge, NULL, pantalla, &dest);
		marcador.Pinta();
		for (int i=0; i<jugadorsPerEquip*2; i++)
		{
			jugador[i].Pinta();
		}		
		pilota.Pinta();
		SDL_Flip(pantalla);
	}
	return done;
}

bool Camp::Igual(SDL_Rect a, SDL_Rect b)
{	bool retorn = false;
	if (a.w==b.w && a.h==b.h) retorn=true;
	return retorn;
}
