#include "Pilota.h"
#include "camp.h"
#include "constants.h"

Pilota::Pilota(void)
: Forca(0)
{
	//640x480
	x=316;
	y=236;	
	w=12;
	h=12;
	xMig=x+w/2;
	yMig=y+h/2;
	velocitatX = VELOCITATPILOTAX;
	velocitatY = VELOCITATPILOTAY;
	imatge = SDL_LoadBMP("ball.bmp"); 
	SDL_SetColorKey(imatge, SDL_SRCCOLORKEY , SDL_MapRGB(imatge->format, 51, 153, 0));
	direccioX=0.0;
	direccioY=0.0;

}

Pilota::~Pilota(void)
{
	SDL_FreeSurface(imatge);
}
// Mou()
// Moure la pilota si encara t fora per moure's
void Pilota::Mou()
{
	SDL_Rect desti, gespa, porteria1, porteria2;
	int xNova, yNova; 

	if (Forca > 0) 
	{
		// 1. Simula el moviment
		xNova = x + (direccioX*velocitatX);		
		yNova = y + (direccioY*velocitatY);
		
		Camp *p = (Camp *)camp;
		// 2. On som
		SDL_Rect bola=this->GetPosicio();
		bola.x = xNova;
		bola.y = yNova;
		// 3. Porteries
		porteria1 = p->GetPorteria(0);
		porteria2 = p->GetPorteria(1);
		// Ajusto les porteries perqu continui...
		// porteria1.w = porteria1.w +12;
		// porteria2.x = porteria2.x - 12;
		// porteria2.w = porteria2.w + 12;
		bool bPorteria1 = IntersectRect(&desti,&bola,&porteria1);
		bool bPorteria2 = IntersectRect(&desti,&bola,&porteria2);
		if ( bPorteria1 == true || bPorteria2 == true )
		{
			// Si va a la porteria no rebota...
			x = xNova;
			y = yNova;			
		}
		else
		{
			// 4. No s a la zona de la porteria, per tant mirem que no surti 
			// dels marges del camp.
			gespa = p->GetTerreny();
			gespa.x+=w;
			gespa.w=gespa.w-(3*w);
			gespa.y+=h;
			gespa.h=gespa.h-(2*h);
			
			if (!IntersectRect(&desti, &bola, &gespa))
			{
				if (xNova > gespa.w+gespa.x) direccioX=-1;
				if (xNova < gespa.x) direccioX=1;
				if (yNova > gespa.h+gespa.y) direccioY=-1;
				if (yNova < gespa.y) direccioY=1; 
				/*
				// Per on ha xocat? Xoc en les X!
				if (xNova > gespa.w+gespa.x || xNova < gespa.x) 
				{
					direccioX=direccioX*-1;			
				}
				// if (yNova > gespa.h+gespa.y || yNova < gespa.y) 
				else
				{
					// Xoc per les Y
					direccioY=direccioY*-1;
				}
				*/
				
				// Incremento la fora per evitar que quedi prop del rac
				x = x + (direccioX*velocitatX);
				y = y + (direccioY*velocitatY);
				Forca+=FORCACOSTATS;
			}
			else
			{
				// cas normal, noms ha d'avanar ... 
				x = xNova;
				y = yNova;
			}
		}
		xMig = xMig + (direccioX*velocitatX);
		yMig = yMig + (direccioY*velocitatY);
		Forca--;
	}			
}

// // Funci per canviar la direcci de la pilota
bool Pilota::rebota(int xr, int yr)
{
	Forca=FORCAXUT;
	float px, py;
	px = xMig-xr;
	py = yMig-yr;
	float px2 = abs(px);
	float py2 = abs(py);
	if (px2 > py2)
	{
		if (px!=0)
		{
			direccioY = py/px2;
			direccioX = px/px2;
		}
		else
		{
            direccioY=0;
            direccioX=0.5*direccioX;
		}
	}
	else
	{
		if (py!=0)
		{
			direccioX = px/py2;
			direccioY = py/py2;
		}
		else 
		{
			direccioX=0;
			direccioY=0.5*direccioY;
		}		
	}
	return true;
}



void Pilota::Inicia(void* tot)
{
	camp = tot;
}

void Pilota::SetForca(int n)
{
	Forca=n;
}

float Pilota::abs(float val)
{
	if (val<0) val*=-1;
	return val;
}
// Funcions per veure cap on va la pilota
float Pilota::DireccioPilotaX(int n)
{
	return x + n*direccioX*velocitatX;
}

float Pilota::DireccioPilotaY(int n)
{
	return y + n*direccioY*velocitatY;
}
