#include "_variables.h"

#ifdef DREAMCAST
#include <kos.h>
#include "dreamcast_icon.h"   // VMU Icon in RGB format
#endif

void saveRecords()
{
  // fprintf(stdout, "\nattempting to save records %i...\n", 0);
  FILE* recordfile;
  #ifdef DREAMCAST
    recordfile = fopen("/ram/achievements.txt",  "w");
  #else
    recordfile = fopen("base/achievements.txt",  "w");
  #endif

  if (recordfile == NULL) // file doesn't exist
  {	 
    fprintf(stderr,"recordfile NOT FOUND!!!");
  }
  else
  {
    // file exists
    // fprintf(stdout,"recordfile found...\n");
    int i;
    for(i=0; i<49; i++)
    {
      fprintf(recordfile, "%i", StageInfo[i+1].solved);
      fprintf(recordfile, ",");
      fprintf(recordfile, "%i", StageInfo[i+1].maxCoins);
      fprintf(recordfile, ",");
      fprintf(recordfile, "%i", StageInfo[i+1].totalCoins);
      fprintf(recordfile, ",\n");
    }
    fclose(recordfile);
  }

  //Dreamcast code to save file into VMU!!!
  #ifdef DREAMCAST
  vmu_pkg_t pkg;
  uint8 *pkg_out;
  int pkg_size;
  file_t ft;

  //Temporal for reading the file
  file_t file;
  int data_size;
  char *datasave;

  // Open file and copy to buffer
  file = fs_open("/ram/achievements.txt", O_RDONLY);
  data_size = fs_total(file);
  datasave = (char *)malloc(data_size+1);
  fs_read(file, datasave, data_size);
  fs_close(file);
  fs_unlink("/ram/achievements.txt");

  //Make the package to the VMU.
  strcpy(pkg.desc_short, "openggs");
  strcpy(pkg.desc_long, "OpenGGS Save File");
  strcpy(pkg.app_id, "openggs");
  pkg.icon_cnt = 1;
  memcpy((void *)&pkg.icon_pal[0],(void *)&vmu_savestate_icon_pal,32);
  pkg.icon_data = (const uint8*)&vmu_savestate_icon_data;
  pkg.icon_anim_speed = 0;
  pkg.eyecatch_type = VMUPKG_EC_NONE;
  pkg.data_len = data_size;
  pkg.data = (const uint8*)(datasave);

  vmu_pkg_build(&pkg, &pkg_out, &pkg_size);

  fs_unlink("/vmu/a1/openggs");
  ft = fs_open("/vmu/a1/openggs", O_WRONLY);
  if (!ft) {
    printf("error writing\n");
    return;
  }
  fs_write(ft, pkg_out, pkg_size);
  fs_close(ft);

  // Free unused memory
  free(pkg_out);
  free(datasave);
  #endif
  //Dreamcast code to save file into VMU!!!
}




void updateRecords()
{
  if(StageInfo[STAGE_NUMBER].maxCoins < Player.CoinsThisStage)
  {
    StageInfo[STAGE_NUMBER].maxCoins = Player.CoinsThisStage;
  }
  StageInfo[STAGE_NUMBER].solved = true;
  saveRecords();
}





void loadRecords()
{
  // fprintf(stdout, "\nattempting to load record file...\n");

  int temp[500];
  int x;
  int y;

  //First try to load the records from the vmu
  #ifdef DREAMCAST
  char data[1140]; //128 header + 512 header + 500 data

  //Name of the file to open 
  file_t fd;
  if ((fd = fs_open("/vmu/a1/openggs", O_RDONLY)) == -1)
  {
    printf("error opening VMU A1, no found openggs.\n");
    return;
  }
  
  //Go to the starting position of the data
  //Caution, vmu is composed by header (128) + 1 icon (512) + data!
  //SEEK_SET (absolute position), SEEK_CUR (relative position)
  fs_seek(fd,128+512, SEEK_SET);
  fs_read(fd, data, sizeof(data));
	
  // Save buffer into a RAM file
  if ((fd = fs_open("/ram/achievements.txt", O_WRONLY)) == -1)
  {
    printf("Can't create RAM file from VMU.\n");
    return;
  }
  fs_write(fd, data, sizeof(data));
  fs_close(fd);
  
  // Free unused memory
  free(data);
  #endif
  //First try to load the records from the vmu


  FILE* loadrecordfile;
  #ifdef DREAMCAST
    loadrecordfile = fopen("/ram/achievements.txt",  "r");
  #else
    loadrecordfile = fopen("base/achievements.txt",  "r");
  #endif


  if (loadrecordfile == NULL)
  { // file doesn't exist
    fprintf(stderr,"record file NOT FOUND!!!");
  }
  else
  { // file exists
    // fprintf(stdout,"record file found...\n");
    // write stage information into an array 
    for (x = 0; x < 150; x++)
    {
      fscanf(loadrecordfile, "%i,", &temp[x]);
    }

    /*
    FILE* loadrecordfile2;
    loadrecordfile2 = fopen("records1XXX.txt",  "w");
    for(y = 0; y < 20; y++)
    {
      for (x = 0; x < 3; x++) 
      {
        fprintf(loadrecordfile2, "%i", temp[y*3+x]);
        fprintf(loadrecordfile2, ",");
      }
      fprintf(loadrecordfile2,"\n");
    }
    fclose(loadrecordfile2);
    */


    // write the temporary array into the variables
    for(y = 0; y < 32; y++)
    {
      for (x = 0; x < 3; x++)
      {
        if(x==0)
        {
          if(temp[y*3+x]==0){StageInfo[y+1].solved = false;}
          if(temp[y*3+x]==1){StageInfo[y+1].solved = true;}
        }
        if(x==1){StageInfo[y+1].maxCoins = temp[y*3+x];}
        if(x==2){StageInfo[y+1].totalCoins = temp[y*3+x];}
      }
	}

    // fprintf(stdout,"record file loaded correctly...\n");
    fclose(loadrecordfile);
  }
}
