#include "_variables.h"

void draw_system_default(int xpos, int ypos);
void draw_system_amiga(int xpos, int ypos);
void draw_system_C64(int xpos, int ypos);
void draw_system_atari(int xpos, int ypos);
void draw_system_amstrad(int xpos, int ypos);


Mix_Music* BackgroundMusic;

int SystemNumber;
int ScrollCounter;
int ScrollCounterGoal;
Uint32 ScrollTimer;


void pick_system()
{
  SDL_Surface* TempSurface;
  SystemNumber = 0;
  ScrollCounter = 0;
  ScrollCounterGoal = 0;
  ScrollTimer = 0;
  OverlayTimer = SDL_GetTicks();
  RandomizeSnow = false;

  #ifdef DREAMCAST
    BackgroundMusic=Mix_LoadMUS("base/default/intro.mod"); //load in the music
  #else
    iniValue = readFromINI("base/default/audio.ini", "Music", "Intro");
    BackgroundMusic=Mix_LoadMUS(iniValue); //load in the music
    free(iniValue);
  #endif

  if(PlayMusic){Mix_PlayMusic(BackgroundMusic,-1);} //play the music
  while(!Key_ESCAPE_pressed && !Key_ENTER_pressed && DifferentSystems)
  {
    getInput();
    drawBackground(1, 0, 0);
    if(SDL_GetTicks() - ScrollTimer > 10)
    {
      ScrollTimer = SDL_GetTicks(); // reset counter
    if(ScrollCounter<ScrollCounterGoal){ScrollCounter +=10;}
    if(ScrollCounter>ScrollCounterGoal){ScrollCounter -=10;}
    }

  //    if(Key_RIGHT_pressed && ScrollCounterGoal<1280){ScrollCounterGoal +=320;}
    if(Key_RIGHT_pressed && ScrollCounterGoal<320){ScrollCounterGoal +=320;}
    if(Key_LEFT_pressed && ScrollCounterGoal>0){ScrollCounterGoal -=320;}
    if(Key_F12_pressed)  {ToggleFullscreen();}
    Print(16,8,0,"pick your system (left and right)");

    if(ScrollCounter==0){SystemNumber=0;draw_system_default(0,0);}
    if(ScrollCounter > 0 && ScrollCounter < 320){draw_system_default((0-ScrollCounter),0);draw_system_C64((320-ScrollCounter),0);}
    if(ScrollCounter==320){SystemNumber=2;draw_system_C64(0,0);}
/*
    if(ScrollCounter > 320 && ScrollCounter < 640){draw_system_amiga((320-ScrollCounter),0);draw_system_C64((640-ScrollCounter),0);}
    if(ScrollCounter==640){SystemNumber=2;draw_system_C64(0,0);}
    if(ScrollCounter > 640 && ScrollCounter < 960){draw_system_C64((640-ScrollCounter),0);draw_system_atari((960-ScrollCounter),0);}
    if(ScrollCounter==960){SystemNumber=3;draw_system_atari(0,0);}
    if(ScrollCounter > 960 && ScrollCounter < 1280){draw_system_atari((960-ScrollCounter),0);draw_system_amstrad((1280-ScrollCounter),0);}
    if(ScrollCounter==1280){SystemNumber=4;draw_system_amstrad(0,0);}
*/
// PrintWave(0,0, 0, "123456789012345678901234567890");
    SDL_UpdateRect(DisplaySurface,0,0,0,0);
  }

// ATTENTION!
// CHANGED ALL
// ScaleValue = atoi(iniValue);
// TO
// ScaleValue = atoi(const_cast<char*>(iniValue));

  if(SystemNumber == 1)
  {
    iniValue = readFromINI(Path_to_ini, "Systems", "Amiga_enabled");
    if(1 != atoi(const_cast<char*>(iniValue))){SystemNumber=0;}
    free(iniValue);
  }
  if(SystemNumber == 2)
  {
    iniValue = readFromINI(Path_to_ini, "Systems", "C64_enabled");
    if(1 != atoi(const_cast<char*>(iniValue))){SystemNumber=0;}
    free(iniValue);
  }

  if(SystemNumber == 3)
  {
    iniValue = readFromINI(Path_to_ini, "Systems", "Atari_enabled");
    if(1 != atoi(const_cast<char*>(iniValue))){SystemNumber=0;}
    free(iniValue);
  }

  if(SystemNumber == 4)
  {
    iniValue = readFromINI(Path_to_ini, "Systems", "AmstradCPC_enabled");
    if(1 != atoi(const_cast<char*>(iniValue))){SystemNumber=0;}
    free(iniValue);
  }

  getInput();

  SDL_Rect TempRect;
  TempRect.x=0;
  TempRect.y=0;

  Uint32 CKColor = SDL_MapRGB(DisplaySurface->format,255,0,255);

  if(SystemNumber==0)
  {
    LevelSet=1;
	//*********************************
	// generate tiles surfaces
	if(ScaleValue!=2)
    {
      TempSurface = IMG_Load("base/default/tiles.png");
      TilesSurface = SDL_DisplayFormat(TempSurface);
      SDL_FreeSurface(TempSurface);
      TempRect.h=TilesSurface->h*ScaleValue;
      TempRect.w=TilesSurface->w*ScaleValue;
      TilesSurface = ScaleSurface(TilesSurface, TilesSurface->w*ScaleValue, TilesSurface->h*ScaleValue);
      SDL_SetColorKey(TilesSurface, SDL_SRCCOLORKEY, CKColor);
    }
    if(ScaleValue==2)
    {
      TempSurface = IMG_Load("base/default/tiles_hr.png");
      TilesSurface = SDL_DisplayFormat(TempSurface);
      SDL_FreeSurface(TempSurface);
      SDL_SetColorKey(TilesSurface, SDL_SRCCOLORKEY, CKColor);
    }
	//*********************************

	//*********************************
	// generate Player sprites surfaces
	if(ScaleValue!=2)
    {
    TempSurface = IMG_Load("base/default/player.png");
    PlayerSpritesSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=PlayerSpritesSurface->h*ScaleValue;
    TempRect.w=PlayerSpritesSurface->w*ScaleValue;
    PlayerSpritesSurface = ScaleSurface(PlayerSpritesSurface, PlayerSpritesSurface->w*ScaleValue, PlayerSpritesSurface->h*ScaleValue);
    SDL_SetColorKey(PlayerSpritesSurface, SDL_SRCCOLORKEY, CKColor);
    }
	if(ScaleValue==2)
    {
    TempSurface = IMG_Load("base/default/player_hr.png");
    PlayerSpritesSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    SDL_SetColorKey(PlayerSpritesSurface, SDL_SRCCOLORKEY, CKColor);
    }
	//*********************************

	//*********************************
	// generate enemy sprites surfaces
    if(ScaleValue!=2)
    {
    TempSurface = IMG_Load("base/default/enemies.png");
    EnemySpritesSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=EnemySpritesSurface->h*ScaleValue;
    TempRect.w=EnemySpritesSurface->w*ScaleValue;
    EnemySpritesSurface = ScaleSurface(EnemySpritesSurface, EnemySpritesSurface->w*ScaleValue, EnemySpritesSurface->h*ScaleValue);
    SDL_SetColorKey(EnemySpritesSurface, SDL_SRCCOLORKEY, CKColor);
    }
    if(ScaleValue==2)
    {
    TempSurface = IMG_Load("base/default/enemies_hr.png");
    EnemySpritesSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    SDL_SetColorKey(EnemySpritesSurface, SDL_SRCCOLORKEY, CKColor);
    }

	//*********************************

    //*********************************
	// generate bonus sprites surfaces
	if(ScaleValue!=2)
    {
    TempSurface = IMG_Load("base/default/bonus.png");
    BonusSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=BonusSurface->h*ScaleValue;
    TempRect.w=BonusSurface->w*ScaleValue;
    BonusSurface = ScaleSurface(BonusSurface, BonusSurface->w*ScaleValue, BonusSurface->h*ScaleValue);
    SDL_SetColorKey(BonusSurface, SDL_SRCCOLORKEY, CKColor);
    }
	if(ScaleValue==2)
    {
    TempSurface = IMG_Load("base/default/bonus_hr.png");
    BonusSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    SDL_SetColorKey(BonusSurface, SDL_SRCCOLORKEY, CKColor);
    }
	//*********************************
  }

  if(SystemNumber==1)
  {
	//*********************************
	// generate tiles surfaces
    TempSurface = IMG_Load("base/amiga/tiles.png");
    TilesSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=TilesSurface->h*ScaleValue;
    TempRect.w=TilesSurface->w*ScaleValue;
    TilesSurface = ScaleSurface(TilesSurface, TilesSurface->w*ScaleValue, TilesSurface->h*ScaleValue);
    SDL_SetColorKey(TilesSurface, SDL_SRCCOLORKEY, CKColor);
	//*********************************

	//*********************************
	// generate Player sprites surfaces
    TempSurface = IMG_Load("base/amiga/player.png");
    PlayerSpritesSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=PlayerSpritesSurface->h*ScaleValue;
    TempRect.w=PlayerSpritesSurface->w*ScaleValue;
    PlayerSpritesSurface = ScaleSurface(PlayerSpritesSurface, PlayerSpritesSurface->w*ScaleValue, PlayerSpritesSurface->h*ScaleValue);
    SDL_SetColorKey(PlayerSpritesSurface, SDL_SRCCOLORKEY, CKColor);
	//*********************************

	//*********************************
	// generate enemy sprites surfaces
    TempSurface = IMG_Load("base/amiga/enemies.png");
    EnemySpritesSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=EnemySpritesSurface->h*ScaleValue;
    TempRect.w=EnemySpritesSurface->w*ScaleValue;
    EnemySpritesSurface = ScaleSurface(EnemySpritesSurface, EnemySpritesSurface->w*ScaleValue, EnemySpritesSurface->h*ScaleValue);
    SDL_SetColorKey(EnemySpritesSurface, SDL_SRCCOLORKEY, CKColor);
	//*********************************

    //*********************************
	// generate bonus sprites surfaces
    TempSurface = IMG_Load("base/amiga/bonus.png");
    BonusSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=BonusSurface->h*ScaleValue;
    TempRect.w=BonusSurface->w*ScaleValue;
    BonusSurface = ScaleSurface(BonusSurface, BonusSurface->w*ScaleValue, BonusSurface->h*ScaleValue);
    SDL_SetColorKey(BonusSurface, SDL_SRCCOLORKEY, CKColor);
	//*********************************
  }

  if(SystemNumber==2)
  {
    LevelSet=0;
	//*********************************
	// generate tiles surfaces
    TempSurface = IMG_Load("base/c64/tiles.png");
    TilesSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=TilesSurface->h*ScaleValue;
    TempRect.w=TilesSurface->w*ScaleValue;
    TilesSurface = ScaleSurface(TilesSurface, TilesSurface->w*ScaleValue, TilesSurface->h*ScaleValue);
    SDL_SetColorKey(TilesSurface, SDL_SRCCOLORKEY, CKColor);
	//*********************************

	//*********************************
	// generate Player sprites surfaces
    TempSurface = IMG_Load("base/c64/player.png");
    PlayerSpritesSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=PlayerSpritesSurface->h*ScaleValue;
    TempRect.w=PlayerSpritesSurface->w*ScaleValue;
    PlayerSpritesSurface = ScaleSurface(PlayerSpritesSurface, PlayerSpritesSurface->w*ScaleValue, PlayerSpritesSurface->h*ScaleValue);
    SDL_SetColorKey(PlayerSpritesSurface, SDL_SRCCOLORKEY, CKColor);
	//*********************************

	//*********************************
	// generate enemy sprites surfaces
    TempSurface = IMG_Load("base/c64/enemies.png");
    EnemySpritesSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=EnemySpritesSurface->h*ScaleValue;
    TempRect.w=EnemySpritesSurface->w*ScaleValue;
    EnemySpritesSurface = ScaleSurface(EnemySpritesSurface, EnemySpritesSurface->w*ScaleValue, EnemySpritesSurface->h*ScaleValue);
    SDL_SetColorKey(EnemySpritesSurface, SDL_SRCCOLORKEY, CKColor);
	//*********************************

    //*********************************
	// generate bonus sprites surfaces
    TempSurface = IMG_Load("base/c64/bonus.png");
    BonusSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=BonusSurface->h*ScaleValue;
    TempRect.w=BonusSurface->w*ScaleValue;
    BonusSurface = ScaleSurface(BonusSurface, BonusSurface->w*ScaleValue, BonusSurface->h*ScaleValue);
    SDL_SetColorKey(BonusSurface, SDL_SRCCOLORKEY, CKColor);
	//*********************************

    if(!ExtensionsInClassicMode_enabled)
    {
      Snow_enabled = false;
      Walljumps_enabled = false;
      Stompattack_enabled = false;
      Running_enabled = false;
    }
  }


  // add overlay!
  if(Snow_enabled){addOverlay(1);}
  // add overlay!


  defineEnemies();
  defineBonus();
  definePlayer();
  ScrollCounter = 0;

  while(!Key_ESCAPE_pressed && !Key_ENTER_pressed && ScrollCounter < 330)
  {
    getInput();

    drawBackground(1, 0, 0);
    if(SDL_GetTicks() - ScrollTimer > 15)
    {
      ScrollTimer = SDL_GetTicks(); // reset counter
      ScrollCounter +=10;
    }

    if(SystemNumber==0){draw_system_default(0,ScrollCounter);}
    if(SystemNumber==1){draw_system_amiga(0,ScrollCounter);}
    if(SystemNumber==2){draw_system_C64(0,ScrollCounter);}
    if(SystemNumber==3){draw_system_atari(0,ScrollCounter);}
    if(SystemNumber==4){draw_system_amstrad(0,ScrollCounter);}

    SDL_UpdateRect(DisplaySurface,0,0,0,0);
  }

  if(!ShowIntro){Titlescreen();}
  if(ShowIntro)
  {
    if(SystemNumber==0){TempSurface = IMG_Load("base/default/title.png");}
    if(SystemNumber==1){TempSurface = IMG_Load("base/amiga/title.png");}
    if(SystemNumber==2){TempSurface = IMG_Load("base/c64/title.png");}
    if(SystemNumber==3){TempSurface = IMG_Load("base/atari/title.png");}
    if(SystemNumber==4){TempSurface = IMG_Load("base/amstradcpc/title.png");}
    IntroSurface = SDL_DisplayFormat(TempSurface);
    SDL_FreeSurface(TempSurface);
    TempRect.h=IntroSurface->h*ScaleValue;
    TempRect.w=IntroSurface->w*ScaleValue;
    IntroSurface = ScaleSurface(IntroSurface, IntroSurface->w*ScaleValue, IntroSurface->h*ScaleValue);
    Mix_FreeMusic(BackgroundMusic); //free the music
    Intro();
  }
}

// ###########################
// ###########################
// ###########################

void draw_system_default(int xpos, int ypos)
{
  SDL_Rect SrcRect;
  SDL_Rect DstRect;

  SrcRect.w = 272*ScaleValue;
  SrcRect.h = 88*ScaleValue;
  DstRect.x = 24*ScaleValue+xpos*ScaleValue;
  DstRect.y = 32*ScaleValue+ypos*ScaleValue;
  DstRect.w = 272*ScaleValue;
  DstRect.h = 88*ScaleValue;
  SrcRect.x = 0*ScaleValue;
  SrcRect.y = (104*ScaleValue)+0*88*ScaleValue;
  SDL_BlitSurface(IntroSurface,&SrcRect,DisplaySurface,&DstRect);

  SrcRect.x = 0*ScaleValue;
  SrcRect.y = 0*ScaleValue;
  SrcRect.w = 288*ScaleValue;
  SrcRect.h = 104*ScaleValue;
  DstRect.x = 16*ScaleValue;//+xpos*ScaleValue;
  DstRect.y = 24*ScaleValue+ypos*ScaleValue;
  DstRect.w = 288*ScaleValue;
  DstRect.h = 104*ScaleValue;
  SDL_BlitSurface(IntroSurface,&SrcRect,DisplaySurface,&DstRect);

  Print(280+xpos,144+ypos,0,">>>");
  Print(24+xpos,160+ypos,2,"Play OpenGGS with default graphics");
  Print(24+xpos,178+ypos,0,"Special (optional) Features");
  Print(24+xpos,187+ypos,0,"stomp attack, flying levels, snow,");
  Print(24+xpos,196+ypos,0,"rain, wall jumps and much more...");
}

// ###########################
// ###########################
// ###########################

void draw_system_amiga(int xpos, int ypos)
{
  SDL_Rect SrcRect;
  SDL_Rect DstRect;

  SrcRect.w = 272*ScaleValue;
  SrcRect.h = 88*ScaleValue;
  DstRect.x = 24*ScaleValue+xpos*ScaleValue;
  DstRect.y = 32*ScaleValue+ypos*ScaleValue;
  DstRect.w = 272*ScaleValue;
  DstRect.h = 88*ScaleValue;
  SrcRect.x = 0*ScaleValue;
  SrcRect.y = (104*ScaleValue)+1*88*ScaleValue;
  SDL_BlitSurface(IntroSurface,&SrcRect,DisplaySurface,&DstRect);

  SrcRect.x = 0*ScaleValue;
  SrcRect.y = 0*ScaleValue;
  SrcRect.w = 288*ScaleValue;
  SrcRect.h = 104*ScaleValue;
  DstRect.x = 16*ScaleValue;//+xpos*ScaleValue;
  DstRect.y = 24*ScaleValue+ypos*ScaleValue;
  DstRect.w = 288*ScaleValue;
  DstRect.h = 104*ScaleValue;
  SDL_BlitSurface(IntroSurface,&SrcRect,DisplaySurface,&DstRect);

  Print(16+xpos,144+ypos,0,"<<<");
  Print(280+xpos,144+ypos,0,">>>");
  Print(16+xpos,160+ypos,2,"Amiga Version");
  Print(16+xpos,178+ypos,0,"Special Features");
  Print(16+xpos,187+ypos,0,"- arguably the best version");
  Print(16+xpos,196+ypos,0,"");
  Print(88+xpos,224+ypos,1,"not yet implemented (sorry)");
}

// ###########################
// ###########################
// ###########################

void draw_system_C64(int xpos, int ypos)
{
  SDL_Rect SrcRect;
  SDL_Rect DstRect;

  SrcRect.w = 272*ScaleValue;
  SrcRect.h = 88*ScaleValue;
  DstRect.x = 24*ScaleValue+xpos*ScaleValue;
  DstRect.y = 32*ScaleValue+ypos*ScaleValue;
  DstRect.w = 272*ScaleValue;
  DstRect.h = 88*ScaleValue;
  SrcRect.x = 0*ScaleValue;
  SrcRect.y = (104*ScaleValue)+1*88*ScaleValue;
  SDL_BlitSurface(IntroSurface,&SrcRect,DisplaySurface,&DstRect);

  SrcRect.x = 0*ScaleValue;
  SrcRect.y = 0*ScaleValue;
  SrcRect.w = 288*ScaleValue;
  SrcRect.h = 104*ScaleValue;
  DstRect.x = 16*ScaleValue;//+xpos*ScaleValue;
  DstRect.y = 24*ScaleValue+ypos*ScaleValue;
  DstRect.w = 288*ScaleValue;
  DstRect.h = 104*ScaleValue;
  SDL_BlitSurface(IntroSurface,&SrcRect,DisplaySurface,&DstRect);

  Print(16+xpos,144+ypos,0,"<<<");
//  Print(280+xpos,144+ypos,0,">>>");
  Print(24+xpos,160+ypos,2,"Play OpenGGS with C64 graphics");
  Print(24+xpos,178+ypos,1,"CREDITS (ORIGINAL C64 VERSION of");
  Print(24+xpos,187+ypos,1,"         The Great Giana Sisters)");
  Print(24+xpos,196+ypos,0,"Written by: Armin Gessert");
  Print(24+xpos,205+ypos,0,"Artwork by: Manfred Trenz");
  Print(24+xpos,214+ypos,0,"Music by:   Chris Huelsbeck");
  Print(24+xpos,223+ypos,0,"1987 Softgold/Rainbow Arts");
}

// ###########################
// ###########################
// ###########################

void draw_system_atari(int xpos, int ypos)
{
  SDL_Rect SrcRect;
  SDL_Rect DstRect;

  SrcRect.w = 272*ScaleValue;
  SrcRect.h = 88*ScaleValue;
  DstRect.x = 24*ScaleValue+xpos*ScaleValue;
  DstRect.y = 32*ScaleValue+ypos*ScaleValue;
  DstRect.w = 272*ScaleValue;
  DstRect.h = 88*ScaleValue;
  SrcRect.x = 0*ScaleValue;
  SrcRect.y = (104*ScaleValue)+3*88*ScaleValue;
  SDL_BlitSurface(IntroSurface,&SrcRect,DisplaySurface,&DstRect);

  SrcRect.x = 0*ScaleValue;
  SrcRect.y = 0*ScaleValue;
  SrcRect.w = 288*ScaleValue;
  SrcRect.h = 104*ScaleValue;
  DstRect.x = 16*ScaleValue;//+xpos*ScaleValue;
  DstRect.y = 24*ScaleValue+ypos*ScaleValue;
  DstRect.w = 288*ScaleValue;
  DstRect.h = 104*ScaleValue;
  SDL_BlitSurface(IntroSurface,&SrcRect,DisplaySurface,&DstRect);

  Print(16+xpos,144+ypos,0,"<<<");
  Print(280+xpos,144+ypos,0,">>>");
  Print(16+xpos,160+ypos,2,"Atari ST Version");
  Print(16+xpos,178+ypos,0,"Special Features");
  Print(16+xpos,187+ypos,0,"- no scrolling... LOL");
  Print(88+xpos,224+ypos,1,"not yet implemented (sorry)");
}

// ###########################
// ###########################
// ###########################

void draw_system_amstrad(int xpos, int ypos)
{
  SDL_Rect SrcRect;
  SDL_Rect DstRect;

  SrcRect.w = 272*ScaleValue;
  SrcRect.h = 88*ScaleValue;
  DstRect.x = 24*ScaleValue+xpos*ScaleValue;
  DstRect.y = 32*ScaleValue+ypos*ScaleValue;
  DstRect.w = 272*ScaleValue;
  DstRect.h = 88*ScaleValue;
  SrcRect.x = 0*ScaleValue;
  SrcRect.y = (104*ScaleValue)+4*88*ScaleValue;
  SDL_BlitSurface(IntroSurface,&SrcRect,DisplaySurface,&DstRect);

  SrcRect.x = 0*ScaleValue;
  SrcRect.y = 0*ScaleValue;
  SrcRect.w = 288*ScaleValue;
  SrcRect.h = 104*ScaleValue;
  DstRect.x = 16*ScaleValue;//+xpos*ScaleValue;
  DstRect.y = 24*ScaleValue+ypos*ScaleValue;
  DstRect.w = 288*ScaleValue;
  DstRect.h = 104*ScaleValue;
  SDL_BlitSurface(IntroSurface,&SrcRect,DisplaySurface,&DstRect);

  Print(16+xpos,144+ypos,0,"<<<");
  Print(16+xpos,160+ypos,2,"Amstrad CPC Version");
  Print(16+xpos,178+ypos,0,"Special Features");
  Print(16+xpos,187+ypos,0,"- was never released");
  Print(88+xpos,224+ypos,1,"not yet implemented (sorry)");
}


// ###########################
// ###########################
// ###########################




