/* 
GameBase	->	
Code		->	Roman Hoegg, 2004
License		->	BSD License
*/

#include "_variables.h"			// include shared variables, definitions, etc.

#ifdef DREAMCAST
#include <kos.h>
KOS_INIT_FLAGS(INIT_DEFAULT);
#endif

#ifdef LINUX
#include <fcntl.h>
#include <sys/stat.h>
#endif

int intLives;
int intStartLives;
int LevelSet;
int intPoints;
int intCoins;
int intTime;
int ScaleValue;
bool DifferentSystems;
bool ShowIntro;
bool PlayMusic;
bool ExtensionsInClassicMode_enabled;
bool Walljumps_enabled;
bool Snow_enabled;
int Rain_PositionCounter;
bool Rain_enabled;
bool Stompattack_enabled;
bool Running_enabled;
char Path_to_ini[300];
char Path_to_home[100];


int Joy_Number;
bool Use_Up_For_Jump;
bool FullscreenMode;
int Joy_Left;
int Joy_Right;
int Joy_Up;
int Joy_Down;
int Joy_Jump;
int Joy_Shoot;
int Joy_Run;
int Joy_Enter;
int Joy_Escape;
int Joy_Tab;
#if defined WIZ || defined LINUX
  int Joy_VolumeUp;
  int Joy_VolumeDown;
#endif

int main(int argc, char* argv[])
{
  #ifdef DREAMCAST
    printf("Starting...\n");
    fs_chdir("/cd");
  #endif
  srand ( time(NULL) );
  loadGameConfiguration();
  initSDL();  
  defineTiles(0);
  defineStages();
  definePlatforms();
  defineSounds();
  setSurfaces();
  SDL_ShowCursor (SDL_DISABLE);
  pick_system();

  //*********************************
  // terminate program
  //SDL_JoystickClose(pStick);
  Mix_AllocateChannels(0);    //deallocate channels
  Mix_FreeChunk(WavChunk[0]); //free the chunks
  Mix_FreeChunk(WavChunk[1]); //free the chunks
  Mix_FreeChunk(WavChunk[2]); //free the chunks
  Mix_CloseAudio();           //close sdl_mixer
  //fprintf(stdout,"\nprogramm terminated properly!\n"); 	//normal termination
  exit(1);
  //*********************************
  return(0);
}

// ###########################
// ###########################
// ###########################

void loadGameConfiguration()
{
  // ATTENTION! DUE TO SOME COMPILER WARNINGS I CHANGED ALL
  // ScaleValue = atoi(iniValue);
  // TO
  // ScaleValue = atoi(const_cast<char*>(iniValue));

  strcpy(Path_to_ini, "config.ini");
  #ifdef LINUX
    // Linux users have their ini-File in the home directory
	// Also, Dreamcast users enters here (just get filename).
    #ifdef WIZ
      strcpy(Path_to_home, getenv("PWD"));
    #else
      strcpy(Path_to_home, getenv("HOME"));
    #endif
    strcpy(Path_to_ini,Path_to_home);
    strcat(Path_to_ini,"/.OpenGGS/");
    strcat(Path_to_ini, "config.ini");
  #endif
#ifdef LINUX
    
#endif


  FILE *FileExistenceCheck = fopen(Path_to_ini,"r");

  // *** CHECKING THE VERSION OF THE INI FILE *** //
  bool CreateNewini = true;
  if(FileExistenceCheck)
  {
    iniValue = readFromINI(Path_to_ini, "General", "Version");
    if(atoi(const_cast<char*>(iniValue)) == 3){CreateNewini=false;}
    free(iniValue);
  }

  // *** CREATE A NEW INI FILE *** //
  // *** IF IT DOESN'T EXIST OR *** //
  // *** IF IT IS THE WRONG VERSION *** //
  if(!FileExistenceCheck || CreateNewini)
  {
    // ini file doesnt exist, so we create it.
    #ifdef LINUX
      // under Linux, we create a directory inside the $HOME directory
      char cfg_path[300];
      sprintf(cfg_path, "%s/.OpenGGS/", Path_to_home);
      mkdir(cfg_path, 0755);
    #endif
    FILE *newinifile = fopen(Path_to_ini,"w");

    #ifdef LINUX
    fprintf(newinifile,"; 1 = yes, 0 = no\r\n");
    fprintf(newinifile,"\r\n");
    fprintf(newinifile,"[General]\r\n");
    fprintf(newinifile,"Version = 2\r\n");
    fprintf(newinifile,"Start_Stage = 1\r\n");
    fprintf(newinifile,"Bonus = 0\r\n");
    fprintf(newinifile,"Time = 99\r\n");
    fprintf(newinifile,"Fullscreen = 0\r\n");
    fprintf(newinifile,"Show_Intro = 1\r\n");
    fprintf(newinifile,"Play_Music = 1\r\n");
  #ifdef WIZ
    fprintf(newinifile,"Scale = 1\r\n");
  #else
    fprintf(newinifile,"Scale = 2\r\n");
  #endif
    fprintf(newinifile,"; Scale = 1 -> 320x240 (standard resolution)\r\n");
    fprintf(newinifile,"; Scale = 2 -> 640x480 (loads higher-rez graphic-file)\r\n");
    fprintf(newinifile,"; Scale = 3 -> 960x720\r\n");
    fprintf(newinifile,"; Scale = 4 -> 1280x960 (maximum resolution)\r\n");
    fprintf(newinifile,"\r\n");
    fprintf(newinifile,"[Systems]\r\n");
    fprintf(newinifile,"DifferentSystems = 1\r\n");
    fprintf(newinifile,"C64_enabled = 1\r\n");
    fprintf(newinifile,"\r\n");
    fprintf(newinifile,"[Extensions]\r\n");
    fprintf(newinifile,"ExtensionsInClassicMode = 0\r\n");
    fprintf(newinifile,"Snow = 0\r\n");
    fprintf(newinifile,"Rain = 0\r\n");
    fprintf(newinifile,"Walljumps = 1\r\n");
    fprintf(newinifile,"Stompattack = 1\r\n");
    fprintf(newinifile,"Running = 1\r\n");
    fprintf(newinifile,"\r\n");
    fprintf(newinifile,"[Joystick]\r\n");
    #ifdef WIZ
      fprintf(newinifile,"Joystick_Number = 0\n");
      fprintf(newinifile,"Button_Jump = 14\n");
      fprintf(newinifile,"Button_Run = 12\n");
      fprintf(newinifile,"Button_Shoot = 13\n");
      fprintf(newinifile,"Button_Enter = 11\n");
      fprintf(newinifile,"Button_Escape = 10\n");
      fprintf(newinifile,"Button_Tab = 8\n");
      fprintf(newinifile,"Button_VolumeUp = 16\n");
      fprintf(newinifile,"Button_VolumeDown = 17\n");
    #else
      fprintf(newinifile,"Joystick_Number = 4\n");
      fprintf(newinifile,"Button_Jump = 3\n");
      fprintf(newinifile,"Button_Run = 5\n");
      fprintf(newinifile,"Button_Shoot = 1\n");
      fprintf(newinifile,"Button_Enter = 3\n");
      fprintf(newinifile,"Button_Escape = 6\n");
      fprintf(newinifile,"Button_Tab = 4\n");
    #endif
    fprintf(newinifile,"\r\n");
    fprintf(newinifile,"; 0 = jump with button\r\n");
    fprintf(newinifile,"; 1 = jump with d-pad up\r\n");
    fprintf(newinifile,"Use_Up_For_Jump = 0\r\n");
    fprintf(newinifile,"\r\n");
    fprintf(newinifile,"; in case you use buttons instead of a d-pad\r\n");
    #ifdef WIZ
      fprintf(newinifile,"Button_Left = 2\r\n");
      fprintf(newinifile,"Button_Right = 6\r\n");
      fprintf(newinifile,"Button_Up = 0\r\n");
      fprintf(newinifile,"Button_Down = 4\r\n");
    #else
      fprintf(newinifile,"Button_Left = 100\r\n");
      fprintf(newinifile,"Button_Right = 101\r\n");
      fprintf(newinifile,"Button_Up = 102\r\n");
      fprintf(newinifile,"Button_Down = 103\r\n");
    #endif
    fprintf(newinifile,"\r\n");
    fclose(newinifile);
    #else
    fprintf(newinifile,"; 1 = yes, 0 = no\r\n");
    fprintf(newinifile,"\r\n");
    fprintf(newinifile,"[General]\n");
    fprintf(newinifile,"Version = 2\n");
    fprintf(newinifile,"Start_Stage = 1\n");
    fprintf(newinifile,"Bonus = 0\n");
    fprintf(newinifile,"Time = 99\n");
    fprintf(newinifile,"Fullscreen = 0\n");
    fprintf(newinifile,"Show_Intro = 1\n");
    fprintf(newinifile,"Play_Music = 1\n");
    fprintf(newinifile,"Scale = 2\n");
    fprintf(newinifile,"; Scale = 1 -> 320x240 (standard resolution)\n");
    fprintf(newinifile,"; Scale = 2 -> 640x480 (loads higher-rez graphic-file)\n");
    fprintf(newinifile,"; Scale = 3 -> 960x720\n");
    fprintf(newinifile,"; Scale = 4 -> 1280x960 (maximum resolution)\n");
    fprintf(newinifile,"\n");
    fprintf(newinifile,"[Systems]\n");
    fprintf(newinifile,"DifferentSystems = 1\n");
    fprintf(newinifile,"C64_enabled = 1\n");
    fprintf(newinifile,"\n");
    fprintf(newinifile,"[Extensions]\n");
    fprintf(newinifile,"ExtensionsInClassicMode = 0\n");
    fprintf(newinifile,"Snow = 0\n");
    fprintf(newinifile,"Rain = 0\n");
    fprintf(newinifile,"Walljumps = 1\n");
    fprintf(newinifile,"Stompattack = 1\n");
    fprintf(newinifile,"Running = 1\n");
    fprintf(newinifile,"\n");
    fprintf(newinifile,"[Joystick]\n");
    #if defined wiz || defined gp2x
      fprintf(newinifile,"Joystick_Number = 0\n");
      fprintf(newinifile,"Button_Jump = 14\n");
      fprintf(newinifile,"Button_Run = 12\n");
      fprintf(newinifile,"Button_Shoot = 13\n");
      fprintf(newinifile,"Button_Enter = 11\n");
      fprintf(newinifile,"Button_Escape = 10\n");
      fprintf(newinifile,"Button_Tab = 8\n");
    #else
      fprintf(newinifile,"Joystick_Number = 0\n");
      fprintf(newinifile,"Button_Jump = 3\n");
      fprintf(newinifile,"Button_Run = 5\n");
      fprintf(newinifile,"Button_Shoot = 1\n");
      fprintf(newinifile,"Button_Enter = 3\n");
      fprintf(newinifile,"Button_Escape = 6\n");
      fprintf(newinifile,"Button_Tab = 4\n");
    #endif
    fprintf(newinifile,"\n");
    fprintf(newinifile,"; 0 = jump with button\n");
    fprintf(newinifile,"; 1 = jump with d-pad up\n");
    fprintf(newinifile,"Use_Up_For_Jump = 0\n");
    fprintf(newinifile,"\n");
    fprintf(newinifile,"; in case you use buttons instead of a d-pad\n");
	#ifndef DREAMCAST
    fprintf(newinifile,"Button_Left = 100\n");
    fprintf(newinifile,"Button_Right = 101\n");
    fprintf(newinifile,"Button_Up = 102\n");
    fprintf(newinifile,"Button_Down = 103\n");
	#endif
    fprintf(newinifile,"\n");
    fclose(newinifile);
    #endif
  }

intStartLives = 9;
LevelSet = 0;

  ScaleValue = 1;
  iniValue = readFromINI(Path_to_ini, "General", "Scale");
  ScaleValue = atoi(const_cast<char*>(iniValue));
  // ScaleValue = atoi(iniValue);
  free(iniValue);
  if(ScaleValue>4){ScaleValue=4;}
  if(ScaleValue<1){ScaleValue=1;}

  iniValue = readFromINI(Path_to_ini, "General", "Fullscreen");
  FullscreenMode=true;
  if(atoi(const_cast<char*>(iniValue)) == 1){FullscreenMode=false;}
  free(iniValue);
  ToggleFullscreen();

  StartStage = 1; // default value...
  iniValue = readFromINI(Path_to_ini, "General", "Start_Stage");
  StartStage = atoi(const_cast<char*>(iniValue));
  free(iniValue);
    
  StartBonus = 0; // default value
  iniValue = readFromINI(Path_to_ini, "General", "Bonus");
  StartBonus = atoi(const_cast<char*>(iniValue));
  free(iniValue);
    
  StartTime = 99; // default value
  iniValue = readFromINI(Path_to_ini, "General", "Time");
  StartTime = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  ShowIntro = true; // default value
  iniValue = readFromINI(Path_to_ini, "General", "Show_Intro");
  ShowIntro = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  PlayMusic = true; // default value
  iniValue = readFromINI(Path_to_ini, "General", "Play_Music");
  PlayMusic = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  DifferentSystems = true; // default value
  iniValue = readFromINI(Path_to_ini, "Systems", "DifferentSystems");
  DifferentSystems = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  ExtensionsInClassicMode_enabled = false; // default value
  iniValue = readFromINI(Path_to_ini, "Extensions", "ExtensionsInClassicMode");
  ExtensionsInClassicMode_enabled = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  Walljumps_enabled = false; // default value
  iniValue = readFromINI(Path_to_ini, "Extensions", "Walljumps");
  Walljumps_enabled = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  Snow_enabled = false; // default value
  iniValue = readFromINI(Path_to_ini, "Extensions", "Snow");
  Snow_enabled = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  Rain_enabled = false; // default value
  iniValue = readFromINI(Path_to_ini, "Extensions", "Rain");
  Rain_enabled = atoi(const_cast<char*>(iniValue));
  free(iniValue);
  Rain_PositionCounter=0;
  if(Snow_enabled && Rain_enabled){Rain_enabled = false;}

  Stompattack_enabled = false; // default value
  iniValue = readFromINI(Path_to_ini, "Extensions", "Stompattack");
  Stompattack_enabled = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  Running_enabled = false; // default value
  iniValue = readFromINI(Path_to_ini, "Extensions", "Running");
  Running_enabled = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Joystick_Number");
  Joy_Number = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Use_Up_For_Jump");
  Use_Up_For_Jump = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Button_Left");
  Joy_Left = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Button_Right");
  Joy_Right = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Button_Up");
  Joy_Up = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Button_Down");
  Joy_Down = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Button_Jump");
  Joy_Jump = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Button_Shoot");
  Joy_Shoot = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Button_Run");
  Joy_Run = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Button_Enter");
  Joy_Enter = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Button_Escape");
  Joy_Escape = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  iniValue = readFromINI(Path_to_ini, "Joystick", "Button_Tab");
  Joy_Tab = atoi(const_cast<char*>(iniValue));
  free(iniValue);

  #if defined WIZ || defined LINUX
    iniValue = readFromINI(Path_to_ini, "Joystick", "Button_VolumeUp");
    if (iniValue!=NULL)
    {	
      Joy_VolumeUp = atoi(const_cast<char*>(iniValue));
      free(iniValue);
    } 
    iniValue = readFromINI(Path_to_ini, "Joystick", "Button_VolumeDown");
    if (iniValue!=NULL) 
    {	
      Joy_VolumeDown = atoi(const_cast<char*>(iniValue));
      free(iniValue);
    }
  #endif
  
}

