#include "_variables.h"

int TileArray[STAGEWIDTH][STAGEHEIGHT];
int STAGE_NUMBER = 1;
int STAGE_XPos = 0;
int STAGE_YPos = 0;
int TopLeft_Tile_X = 0;
int TopRight_Tile_X = 0;
int StartTime;
int ReStartPosition = 0;
int PortalExitPositionX = 0;
int PortalExitPositionY = 0;
int BigEnemyLiveCounter;
bool BigEnemyExists;
int CloudPosX[10];
int CloudPosY[10];
int OnOffTilesColour = 0;

Level_Struct Level;

void loadStage()
{
  int x, y, i;
  //fprintf(stdout, "\nattempting to load stage %i...\n", STAGE_NUMBER);

  BonusX = -100;            // MOVE BONUS OUT OF VISIBLE AREA
  BonusY = -100;            // MOVE BONUS OUT OF VISIBLE AREA
  intTime = StartTime;      // RESET THE TIMER
  defineCoin();             // RESETS ALL COINS
  Player.direction = 1;     // DEFAULT VALUE
  Player.jumpcounter = 0;   // DEFAULT VALUE
  Player.accelleration = 0; // DEFAULT VALUE
  Player.x = 25;            // DEFAULT VALUE
  Player.y = 190;           // DEFAULT VALUE
  resetEnemies();
  Player.CoinsThisStage = 0;
  PortalExitPositionX = 0;
  PortalExitPositionY = 0;
  BigEnemyLiveCounter = 5;
  OnOffTilesColour = 0;

  Platform[0].inUse = false;
  playerOnPlatform = false;

  // and now we load what's in the binary file...
  FILE *Level_File;
  if(LevelSet==1){Level_File = fopen ("new.lvl", "rb");}
  else {Level_File = fopen ("classic.lvl", "rb");}

  if (Level_File != NULL)
  {
    // move to data set in question...
    fseek(Level_File, STAGE_NUMBER * sizeof (Level_Struct), SEEK_SET);
    fread (&Level, sizeof (Level_Struct), 1, Level_File); // read data

    // load enemies positions
    BigEnemyExists = false;
    for(x=0; x<ENEMIESPERSTAGE;x++)
    {
      Enemy[x].inUse = Level.Enemy_InUse[x+1];
      Enemy[x].x = Level.Enemy_PosX[x+1];
      Enemy[x].y = Level.Enemy_PosY[x+1];
      Enemy[x].type = Level.Enemy_Type[x+1];
      if(Enemy[x].type == 12 || Enemy[x].type == 13){BigEnemyExists=true;}
      Enemy[x].direction = Level.Enemy_Direction[x+1];
    }
    // load enemies positions
    
    // load start positions
    for(x=0; x<4;x++)
    {
      StageStartPositionX[STAGE_NUMBER][x] = Level.StartPositionX[x];
      StageStartPositionY[STAGE_NUMBER][x] = Level.StartPositionY[x];
    }
    // load start positions

    // load tile array and count max coins
    StageInfo[STAGE_NUMBER].totalCoins = 0;
    for(y = 0; y < STAGEHEIGHT; y++)
    {
      for (x = 0; x < STAGEWIDTH; x++)
      {
        TileArray[x][y] = Level.Array[x][y];
        if(Level.Array[x][y] == 3){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 680){StageInfo[STAGE_NUMBER].totalCoins += 5;}
        if(Level.Array[x][y] == 686){StageInfo[STAGE_NUMBER].totalCoins += 4;}
        if(Level.Array[x][y] == 692){StageInfo[STAGE_NUMBER].totalCoins += 3;}
        if(Level.Array[x][y] == 698){StageInfo[STAGE_NUMBER].totalCoins += 2;}
        if(Level.Array[x][y] == 704){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 520){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 523){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 526){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 529){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 532){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 535){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 600){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 603){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 606){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 609){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 612){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 615){StageInfo[STAGE_NUMBER].totalCoins++;}
        if(Level.Array[x][y] == 156){PortalExitPositionX = x*8; PortalExitPositionY = y*8;}
      }
	}
    // load tile array and count coins

    StageBackgroundColour =  Level.BackgroundColour;
    defineTiles(Level.TileType);
    WarpToLevel = Level.WarpToLevel;

    Platform[0].x = Level.PlatformX;
    Platform[0].y = Level.PlatformY;
    Platform[0].type = Level.PlatformType;
    Platform[0].direction = Level.PlatformDirection;
    Platform[0].pathlength = Level.PlatformPathLength;
    Platform[0].movepos = Level.PlatformMovePos;
    Platform[0].inUse = Level.PlatformInUse;
    PlatformSrcRect[0].x = PlatformType[Platform[0].type].x;
    PlatformSrcRect[0].y = PlatformType[Platform[0].type].y;
    PlatformSrcRect[0].w = PlatformType[Platform[0].type].w;
    PlatformSrcRect[0].h = PlatformType[Platform[0].type].h;


    fclose (Level_File);
   }
  Player.x = StageStartPositionX[STAGE_NUMBER][ReStartPosition];
  Player.y = StageStartPositionY[STAGE_NUMBER][ReStartPosition];

  if(STAGE_NUMBER != 0)
  {
    missionScreen();
    if(StageBackgroundColour==0)
    {
      if(SystemNumber == 0){iniValue = readFromINI("base/default/audio.ini", "Music", "Outdoors");}
      if(SystemNumber == 1){iniValue = readFromINI("base/amiga/audio.ini", "Music", "Outdoors");}
      if(SystemNumber == 2){iniValue = readFromINI("base/c64/audio.ini", "Music", "Outdoors");}
      if(SystemNumber == 3){iniValue = readFromINI("base/atari/audio.ini", "Music", "Outdoors");}
      if(SystemNumber == 4){iniValue = readFromINI("base/amstradcpc/audio.ini", "Music", "Outdoors");}
	  BackgroundMusic=Mix_LoadMUS(iniValue); //load in the music
      free(iniValue);
    }
    if(StageBackgroundColour==1)
    {
      if(SystemNumber == 0){iniValue = readFromINI("base/default/audio.ini", "Music", "Indoors");}
      if(SystemNumber == 1){iniValue = readFromINI("base/amiga/audio.ini", "Music", "Indoors");}
      if(SystemNumber == 2){iniValue = readFromINI("base/c64/audio.ini", "Music", "Indoors");}
      if(SystemNumber == 3){iniValue = readFromINI("base/atari/audio.ini", "Music", "Indoors");}
      if(SystemNumber == 4){iniValue = readFromINI("base/amstradcpc/audio.ini", "Music", "Indoors");}
      BackgroundMusic=Mix_LoadMUS(iniValue); //load in the music
      free(iniValue);    
    }
  }


  if(STAGE_NUMBER == 0)
  {

  if(SystemNumber == 0){iniValue = readFromINI("base/default/audio.ini", "Music", "Title");}
  if(SystemNumber == 1){iniValue = readFromINI("base/amiga/audio.ini", "Music", "Title");}
  if(SystemNumber == 2){iniValue = readFromINI("base/c64/audio.ini", "Music", "Title");}
  if(SystemNumber == 3){iniValue = readFromINI("base/atari/audio.ini", "Music", "Title");}
  if(SystemNumber == 4){iniValue = readFromINI("base/amstradcpc/audio.ini", "Music", "Title");}
  BackgroundMusic=Mix_LoadMUS(iniValue); //load in the music
  free(iniValue);

    // if it's between 20-6 o'clock, background of Intro is black
    struct tm *Sys_T = NULL;
    time_t Tval = 0;
    Tval = time(NULL);
    Sys_T = localtime(&Tval);
    // int Day=Sys_T->tm_mday;
    // int Month=Sys_T->tm_mon+1;
    // int Year=1900 + Sys_T->tm_year;
    int Hour=Sys_T->tm_hour;
    StageBackgroundColour =  0;
    if(Hour>19 || (Hour>0&&Hour<6)){StageBackgroundColour =  1;}
    //  int Minute=Sys_T->tm_min;
    //  int Seconde=Sys_T->tm_sec;
    //  Print(16,169,0,"Time:");
    //  PrintInt(68,169,0, Hour);
    //  Print(84,169,0,":");
    //  PrintInt(92,169,0, Minute);
    //  Print(108,169,0,":");
    //  PrintInt(116,169,0, Seconde);
  }
  if(PlayMusic){Mix_PlayMusic(BackgroundMusic,-1);} //play the music

  // randomize cloudpositions...
  for(i=0; i<10; i++)
  {
    CloudPosX[i] = rand() % 2040;
    CloudPosY[i] = rand() % 60 + 20;
  }
  ToggleOnOffTiles(false);
}
