#include "_variables.h"

void drawSnow();
void addOverlay(int Overlaytype);
bool RandomizeSnow;

int SnowFlakes = 75;
int SnowPositionX[75];
int SnowPositionY[75];
SDL_Rect SnowTempRect[75];
int LeftRight;
Uint32 OverlayTimer;

void drawSnow()
{
  int x, y;
  if(!RandomizeSnow)
  {
    for(x=0; x<SnowFlakes;x++)
    {
        SnowPositionX[x] = rand()%320*ScaleValue;
        SnowPositionY[x] = rand()%240*ScaleValue;
        RandomizeSnow=true;
    }
  }

  if(SDL_GetTicks() - OverlayTimer > 25)
  {
    OverlayTimer = SDL_GetTicks(); 	// reset counter
    for(x=0; x<SnowFlakes;x++)
    {
      if(SnowPositionY[x] > 240*ScaleValue){SnowPositionY[x] = 0;}
      LeftRight = rand()%2;
      for(y=-1;y<ScaleValue;y++)
      {
        SnowPositionY[x]++;
        if(x>25){SnowPositionY[x]++;}
        if(LeftRight == 0){SnowPositionX[x]--;}
        if(LeftRight == 1){SnowPositionX[x]++;}
      }
      if(SnowPositionX[x]<-14*ScaleValue)
      {
        SnowPositionX[x] = rand()%320*ScaleValue;
        SnowPositionY[x] = 0;
      }
      if(SnowPositionX[x]>334*ScaleValue)
      {
        SnowPositionX[x] = rand()%320*ScaleValue;
        SnowPositionY[x] = 0;
      }
    }
  }
  for(x=0; x<SnowFlakes;x++)
  {
    SnowTempRect[x].x = SnowPositionX[x];
    SnowTempRect[x].y = SnowPositionY[x]; 
    SnowTempRect[x].w = 8;
    SnowTempRect[x].h = 8;
    //SDL_SetAlpha(TilesSurface, SDL_SRCALPHA , 180);
    SDL_BlitSurface(TilesSurface,&TileSrcRect[2],DisplaySurface,&SnowTempRect[x]);
    //SDL_SetAlpha(TilesSurface, SDL_SRCALPHA , 255);
  }

}


void drawRain()
{
  int TileCols = 8;
  int TileRows = 8;
  int RainTilesX[TileCols][TileRows];
  int RainTilesY[TileCols][TileRows];
  int x, y;


  if(SDL_GetTicks() - OverlayTimer > 25)
  {
    OverlayTimer = SDL_GetTicks(); 	// reset counter
    Rain_PositionCounter--;
    if(Rain_PositionCounter<-24){Rain_PositionCounter=0;}
    if(Rain_PositionCounter>0){Rain_PositionCounter=0;}
  }

  SDL_Rect OverlaySRCRect;
  SDL_Rect OverlayDSTRect;
  OverlaySRCRect.x = 0*ScaleValue;
  OverlaySRCRect.y = 8*ScaleValue; 
  OverlaySRCRect.w = 48*ScaleValue;
  OverlaySRCRect.h = 48*ScaleValue;
  OverlayDSTRect.w = OverlaySRCRect.w;
  OverlayDSTRect.h = OverlaySRCRect.h;
  //SDL_SetAlpha(OverlaySurface, SDL_SRCALPHA , 100);
  for(x=0; x<TileCols;x++)
  {
    for(y=0; y<TileRows;y++)
    {
      OverlayDSTRect.x = (x - 0) * OverlaySRCRect.w +(2*Rain_PositionCounter*ScaleValue);
      OverlayDSTRect.y = (y - 2) * OverlaySRCRect.h -(2*Rain_PositionCounter*ScaleValue);
      SDL_BlitSurface(OverlaySurface,&OverlaySRCRect,DisplaySurface,&OverlayDSTRect);

    }
  }  
  //SDL_SetAlpha(OverlaySurface, SDL_SRCALPHA , 255);

}


void addOverlay(int Overlaytype)
{
  SDL_Rect OverlaySRCRect;
  SDL_Rect OverlayDSTRect;

  if(Overlaytype == 1)
  {
  // Snowflake
  OverlaySRCRect.x = 0*ScaleValue;
  OverlaySRCRect.y = 0*ScaleValue; 
  OverlaySRCRect.w = 8*ScaleValue;
  OverlaySRCRect.h = 8*ScaleValue;
  OverlayDSTRect.x = 16*ScaleValue;
  OverlayDSTRect.y = 0*ScaleValue; 
  OverlayDSTRect.w = OverlaySRCRect.w;
  OverlayDSTRect.h = OverlaySRCRect.h;
  SDL_BlitSurface(OverlaySurface,&OverlaySRCRect,TilesSurface,&OverlayDSTRect);

  // snow on the ground
  OverlaySRCRect.x = 8*ScaleValue;
  OverlaySRCRect.y = 0*ScaleValue; 
  OverlaySRCRect.w = 200*ScaleValue;
  OverlaySRCRect.h = 8*ScaleValue;
  OverlayDSTRect.x = 0*ScaleValue;
  OverlayDSTRect.y = 296*ScaleValue; 
  OverlayDSTRect.w = OverlaySRCRect.w;
  OverlayDSTRect.h = OverlaySRCRect.h;
  SDL_SetAlpha(OverlaySurface, SDL_SRCALPHA , 180);
  SDL_BlitSurface(OverlaySurface,&OverlaySRCRect,TilesSurface,&OverlayDSTRect);
  SDL_SetAlpha(OverlaySurface, SDL_SRCALPHA , 255);
  }

}
