#include "_variables.h"

SDL_Rect BulletRect;
SDL_Rect BulletExplosionRect;
bool BulletActive = false;
int BulletExplosionCounter;
int EnemyInRadar = -1; // the number of the enemy that the bullet is following

void drawBullet()
{
  BulletRect.x = (STAGE_XPos + BulletPosX-4)*ScaleValue;
  BulletRect.y = (BulletPosY-4)*ScaleValue;
  BulletRect.w = 8;
  BulletRect.h = 8;
  if(BulletRect.x > (SCREENWIDTH + 8)*ScaleValue || BulletRect.x < -8*ScaleValue || BulletRect.y > (SCREENHEIGHT + 8)*ScaleValue || BulletRect.y < -8*ScaleValue )
  {
    BulletActive = false; BulletPosX = -8; BulletPosY = -8;
  }
  if(BulletActive == true)
  {
    SDL_BlitSurface(TilesSurface,&BulletSrcRect[BulletAnimationNumber],DisplaySurface,&BulletRect);
  }
}



void startBullet()
{
  int i;
  BulletActive = true;
  BulletDirH = Player.direction;
  if(PlayerIsPlane){BulletDirH=1;}
  if(EnemyInRadar == -1 && Player.Bonus > 3 && !PlayerIsPlane)
  {//find next enemy...
    for(i = 0; i < ENEMIESPERSTAGE; i++)
    {
      if(Enemy[i].alive == true && Enemy[i].inUse == true && EnemyInRadar == -1)
      {
      if(Player.direction == 1 && Enemy[i].x <= Player.x + 160 && Enemy[i].x > Player.x){EnemyInRadar = i;}
      if(Player.direction == 0 && Enemy[i].x >= Player.x - 160 && Enemy[i].x < Player.x){EnemyInRadar = i;}
      }
    }
  }
  if(BulletDirH == 1){BulletPosX = Player.x+20;}
  if(BulletDirH == 0){BulletPosX = Player.x-1;}
  BulletPosY = Player.y;
  if(PlayerIsPlane){BulletPosX = Player.x+25; BulletPosY = Player.y+10;}
  BulletDirV = 1;
}






void moveBullet()
{
  int BulletTileX;
  int BulletTileY;

  // if bullet hit's Player, the bullet is inactivated
  if(BulletPosX > Player.x && 
     BulletPosX < Player.x + 19 && 
     BulletPosY > Player.y && 
     BulletPosY < Player.y + 21 && 
     EnemyInRadar == -1)
  {
    BulletPosX = -80;
    BulletPosY = -80;
    BulletActive = false;
  }

  if(Player.Bonus < 4 || EnemyInRadar == -1) // bullet has no auto aim below Bonus 4
  {
    // move bullet up/down
    // if bullet hit's a solid tile it is reflected (up and down)
    if(BulletDirV == 1 && !PlayerIsPlane){BulletPosY +=1;}
    if(BulletDirV == 0 && !PlayerIsPlane){BulletPosY -=1;}
    BulletTileX = ((BulletPosX + 4) / 8);
    BulletTileY = ((BulletPosY + 4) / 8);
    if(TileTypes[TileArray[BulletTileX][BulletTileY]].solid)
    {
      if(BulletDirV == 1){BulletDirV = 0;BulletPosY -=1;}
      else if(BulletDirV == 0){BulletDirV = 1;BulletPosY +=1;}
    }

    // move bullet left/right
    if(BulletDirH == 1){BulletPosX +=3;}
    if(BulletDirH == 0){BulletPosX -=3;}
    BulletTileX = ((BulletPosX + 4) / 8);
    BulletTileY = ((BulletPosY + 4) / 8);

    if(TileTypes[TileArray[BulletTileX][BulletTileY]].solid==true && Player.Bonus > 2)
    {
      if(BulletDirH == 1){BulletDirH = 0; BulletPosX -=3;}
      else if(BulletDirH == 0){BulletDirH = 1; BulletPosX +=3;}
    }
    if(TileTypes[TileArray[BulletTileX][BulletTileY]].solid==true && Player.Bonus < 3){bulletExplosionStart();}
  } // end of Bonus < 4

  if(Player.Bonus > 3 && EnemyInRadar != -1 && BulletActive) // bullet has auto aim
  {
    if(BulletPosX < Enemy[EnemyInRadar].x+8){BulletPosX +=3;}
    if(BulletPosX > Enemy[EnemyInRadar].x+8){BulletPosX -=3;}
    if(BulletPosY < Enemy[EnemyInRadar].y+8){BulletPosY +=3;}
    if(BulletPosY > Enemy[EnemyInRadar].y+8){BulletPosY -=3;}
  }

  if(BulletPosX < 0) {BulletActive = false;}   //kill the bullet on stage start
  if(BulletPosX > 2048) {BulletActive = false;}//kill the bullet on stage end
  if(BulletPosY < 0) {BulletActive = false;;}  //kill bullet on top of the screen
  if(BulletPosY > 240) {BulletActive = false;}//kill the bullet on the bottom of the screen
}






void bulletExplosionStart()
{
  // bullet has hit something and exploded
  BulletActive = false;
  BulletExplosionRect.x = (STAGE_XPos + BulletPosX-4)*ScaleValue;
  BulletExplosionRect.y = (BulletPosY-4)*ScaleValue;
  BulletExplosionRect.w = 16*ScaleValue;
  BulletExplosionRect.h = 16*ScaleValue;
  BulletExplosionCounter = 15;
}






void explodeBullet()
{
  BulletExplosionCounter--;
  // updating the x-position in case the STAGE_XPos changed
  BulletExplosionRect.x = (STAGE_XPos + BulletPosX-4)*ScaleValue;
  // updating the x-position in case the STAGE_XPos changed
  if(BulletExplosionCounter > 8)
  {
    SDL_BlitSurface(TilesSurface,&BulletExplosionSrcRect[0],DisplaySurface,&BulletExplosionRect);
  }
  if(BulletExplosionCounter > 0 && BulletExplosionCounter < 9)
  {
    SDL_BlitSurface(TilesSurface,&BulletExplosionSrcRect[1],DisplaySurface,&BulletExplosionRect);
  }

  // just to make sure that the bullet isn't lingering around once it's exploded
  if(BulletExplosionCounter == 0)
  {
    BulletPosX = -8*ScaleValue;
    BulletPosY = -8*ScaleValue;
    BulletActive = false;
  }
}
