#include "_variables.h"

TileTypesDefinition TileTypes[2000];
SDL_Rect TileSrcRect[20000];
AnimationDefinition TileAnimation[2000];
SDL_Rect MouseCursorRect;

void defineTiles(int TileSetColour)
{
	// fprintf(stdout,"\nattempting to define the mouse cursor...\n");
    MouseCursorRect.x=256*ScaleValue;
    MouseCursorRect.y=288*ScaleValue;
    MouseCursorRect.h=11*ScaleValue;
    MouseCursorRect.w=11*ScaleValue;

	// fprintf(stdout,"\nattempting to define tiles...\n");
	int j, i, k, l;

	for(j=0;j<TILESHEETHEIGHT/TILESIZE;j++)
	{
		for(i=0;i<TILESHEETWIDTH/TILESIZE;i++)
		{
		k=i+j*TILESHEETWIDTH/TILESIZE;
		if(k < 440){TileTypes[k].solid = 0;}
		if(k > 439){TileTypes[k].solid = 1;}
		TileTypes[472].solid = 0;
		TileTypes[473].solid = 0;
		TileTypes[474].solid = 0;
		if(k == 273 | k == 274 | k == 275 | k == 276 | k == 277 | k == 278 | k == 279){TileTypes[k].solid = 1;}
		if(k == 315 | k == 316 | k == 317 | k == 318 | k == 319){TileTypes[k].solid = 1;}
		if(k == 355 | k == 356 | k == 357 | k == 358 | k == 359){TileTypes[k].solid = 1;}
		if(k == 395 | k == 396 | k == 397 | k == 398 | k == 399){TileTypes[k].solid = 1;}
		if(k == 435 | k == 436 | k == 437 | k == 438 | k == 439){TileTypes[k].solid = 1;}
		if(k == 475 | k == 476 | k == 477 | k == 478 | k == 479){TileTypes[k].solid = 1;}
		TileSrcRect[k].x = i*TILESIZE*ScaleValue;
		TileSrcRect[k].y = j*TILESIZE*ScaleValue;
		TileSrcRect[k].w = TILESIZE*ScaleValue;
		TileSrcRect[k].h = TILESIZE*ScaleValue;
		TileAnimation[k].animated = 0;
		TileAnimation[k].nexttile = 0;
		TileTypes[k].isexit = 0;
		TileTypes[k].lethal = 0;
		}
	}
	
  // Level destroying fire
	for(l=1686;l<1692;l++){TileAnimation[l].animated = 1;}
  TileAnimation[1686].nexttile = 1687;
  TileAnimation[1687].nexttile = 1688;
  TileAnimation[1688].nexttile = 1689;
  TileAnimation[1689].nexttile = 1690;
  TileAnimation[1690].nexttile = 1691;
  TileAnimation[1691].nexttile = 58;
  TileTypes[1686].lethal = 1;
  TileTypes[1687].lethal = 1;
  TileTypes[1688].lethal = 1;
  TileTypes[1689].lethal = 1;
  TileTypes[1690].lethal = 1;
  TileTypes[1691].lethal = 1;
  TileTypes[1686].solid = 0;
  TileTypes[1687].solid = 0;
  TileTypes[1688].solid = 0;
  TileTypes[1689].solid = 0;
  TileTypes[1690].solid = 0;
  TileTypes[1691].solid = 0;

  // TileAnimation[1690].nexttile = 1691;
  // TileAnimation[1691].nexttile = 1692;
  // TileAnimation[1692].nexttile = 1693;
  // TileAnimation[1693].nexttile = 58; // <- destroyed, killer tile
  // Level destroying fire


	// BEGIN ANIMATED STAR-TILE
    // special star-tile
	for(l=480;l<498;l++){TileAnimation[l].animated = 1;}
	for(l=520;l<538;l++){TileAnimation[l].animated = 1;}
	TileAnimation[480].nexttile = 483;
	TileAnimation[481].nexttile = 484;
	TileAnimation[482].nexttile = 485;
	TileAnimation[483].nexttile = 486;
	TileAnimation[484].nexttile = 487;
	TileAnimation[485].nexttile = 488;
	TileAnimation[486].nexttile = 489;
	TileAnimation[487].nexttile = 490;
	TileAnimation[488].nexttile = 491;
	TileAnimation[489].nexttile = 492;
	TileAnimation[490].nexttile = 493;
	TileAnimation[491].nexttile = 494;
	TileAnimation[492].nexttile = 495;
	TileAnimation[493].nexttile = 496;
	TileAnimation[494].nexttile = 497;
	TileAnimation[495].nexttile = 480;
	TileAnimation[496].nexttile = 481;
	TileAnimation[497].nexttile = 482;

	TileAnimation[520].nexttile = 523;
	TileAnimation[521].nexttile = 524;
	TileAnimation[522].nexttile = 525;
	TileAnimation[523].nexttile = 526;
	TileAnimation[524].nexttile = 527;
	TileAnimation[525].nexttile = 528;
	TileAnimation[526].nexttile = 529;
	TileAnimation[527].nexttile = 530;
	TileAnimation[528].nexttile = 531;
	TileAnimation[529].nexttile = 532;
	TileAnimation[530].nexttile = 533;
	TileAnimation[531].nexttile = 534;
	TileAnimation[532].nexttile = 535;
	TileAnimation[533].nexttile = 536;
	TileAnimation[534].nexttile = 537;
	TileAnimation[535].nexttile = 520;
	TileAnimation[536].nexttile = 521;
	TileAnimation[537].nexttile = 522;
    // special star-tile
    
    // standard star-tile
	for(l=560;l<578;l++){TileAnimation[l].animated = 1;}
	for(l=600;l<618;l++){TileAnimation[l].animated = 1;}
	TileAnimation[560].nexttile = 563;
	TileAnimation[561].nexttile = 564;
	TileAnimation[562].nexttile = 565;
	TileAnimation[563].nexttile = 566;
	TileAnimation[564].nexttile = 567;
	TileAnimation[565].nexttile = 568;
	TileAnimation[566].nexttile = 569;
	TileAnimation[567].nexttile = 570;
	TileAnimation[568].nexttile = 571;
	TileAnimation[569].nexttile = 572;
	TileAnimation[570].nexttile = 573;
	TileAnimation[571].nexttile = 574;
	TileAnimation[572].nexttile = 575;
	TileAnimation[573].nexttile = 576;
	TileAnimation[574].nexttile = 577;
	TileAnimation[575].nexttile = 560;
	TileAnimation[576].nexttile = 561;
	TileAnimation[577].nexttile = 562;

	TileAnimation[600].nexttile = 603;
	TileAnimation[601].nexttile = 604;
	TileAnimation[602].nexttile = 605;
	TileAnimation[603].nexttile = 606;
	TileAnimation[604].nexttile = 607;
	TileAnimation[605].nexttile = 608;
	TileAnimation[606].nexttile = 609;
	TileAnimation[607].nexttile = 610;
	TileAnimation[608].nexttile = 611;
	TileAnimation[609].nexttile = 612;
	TileAnimation[610].nexttile = 613;
	TileAnimation[611].nexttile = 614;
	TileAnimation[612].nexttile = 615;
	TileAnimation[613].nexttile = 616;
	TileAnimation[614].nexttile = 617;
	TileAnimation[615].nexttile = 600;
	TileAnimation[616].nexttile = 601;
	TileAnimation[617].nexttile = 602;
    // standard star-tile
	// END ANIMATED STAR-TILE

    // BEGIN QUICK BLINKING BLOCK
	for(l=578;l<581;l++){TileAnimation[l].animated = 1;}
	for(l=618;l<621;l++){TileAnimation[l].animated = 1;}
	TileAnimation[578].nexttile = 587;
	TileAnimation[579].nexttile = 588;
	TileAnimation[580].nexttile = 589;
	TileAnimation[618].nexttile = 627;
	TileAnimation[619].nexttile = 628;
	TileAnimation[620].nexttile = 629;
    // BEGIN QUICK BLINKING BLOCK			


	// BEGIN FIRE
	for(l=6;l<18;l++){TileAnimation[l].animated = 1;}
	for(l=46;l<58;l++){TileAnimation[l].animated = 1;}
	TileAnimation[6].nexttile = 10;	TileAnimation[7].nexttile = 11;	TileAnimation[8].nexttile = 12;	TileAnimation[9].nexttile = 13;
	TileAnimation[10].nexttile = 14;TileAnimation[11].nexttile = 15;TileAnimation[12].nexttile = 16;TileAnimation[13].nexttile = 17;
	TileAnimation[14].nexttile = 6;	TileAnimation[15].nexttile = 7;	TileAnimation[16].nexttile = 8;	TileAnimation[17].nexttile = 9;
	TileAnimation[46].nexttile = 50;TileAnimation[47].nexttile = 51;TileAnimation[48].nexttile = 52;TileAnimation[49].nexttile = 53;
	TileAnimation[50].nexttile = 54;TileAnimation[51].nexttile = 55;TileAnimation[52].nexttile = 56;TileAnimation[53].nexttile = 57;
	TileAnimation[54].nexttile = 46;TileAnimation[55].nexttile = 47;TileAnimation[56].nexttile = 48;TileAnimation[57].nexttile = 49;
	// END FIRE

	// BEGIN SPIKES
	for(l=92;l<100;l++){TileAnimation[l].animated = 1;}
	for(l=132;l<140;l++){TileAnimation[l].animated = 1;}
	TileAnimation[92].nexttile = 96;
	TileAnimation[93].nexttile = 97;
	TileAnimation[94].nexttile = 98;
	TileAnimation[95].nexttile = 99;
	TileAnimation[96].nexttile = 132;
	TileAnimation[97].nexttile = 133;
	TileAnimation[98].nexttile = 134;
	TileAnimation[99].nexttile = 135;
	TileAnimation[132].nexttile = 136;
	TileAnimation[133].nexttile = 137;
	TileAnimation[134].nexttile = 138;
	TileAnimation[135].nexttile = 139;
	TileAnimation[136].nexttile = 92;
	TileAnimation[137].nexttile = 93;
	TileAnimation[138].nexttile = 94;
	TileAnimation[139].nexttile = 95;
	// END SPIKES

	// BEGIN CRUMBLING GROUND
	for(l=442;l<448;l++){TileAnimation[l].animated = 1;}
	TileAnimation[442].nexttile = 444;
	TileAnimation[443].nexttile = 445;
	TileAnimation[444].nexttile = 446;
	TileAnimation[445].nexttile = 447;
	TileAnimation[446].nexttile = 0;
	TileAnimation[447].nexttile = 0;
	// END CRUMBLING GROUND


	// BEGIN EXIT-TILE
	TileTypes[354].isexit = 1;
	TileTypes[394].isexit = 1;
	TileTypes[434].isexit = 1;
	TileTypes[474].isexit = 1;
	TileTypes[293].isexit = 1;
	TileTypes[333].isexit = 1;
	TileTypes[373].isexit = 1;
	TileTypes[413].isexit = 1;
	
	TileTypes[305].isexit = 1;
	TileTypes[306].isexit = 1;
	TileTypes[307].isexit = 1;
	TileTypes[345].isexit = 1;
	TileTypes[346].isexit = 1;
	TileTypes[347].isexit = 1;
	TileTypes[385].isexit = 1;
	TileTypes[386].isexit = 1;
	TileTypes[387].isexit = 1;
	TileTypes[425].isexit = 1;
	TileTypes[426].isexit = 1;
	TileTypes[427].isexit = 1;

	TileTypes[349].isexit = 1;
	TileTypes[350].isexit = 1;
	// END EXIT-TILE



	// BEGIN LETHAL TILES
    for(l=6;l<19;l++){TileTypes[l].lethal = 1;}
	for(l=46;l<59;l++){TileTypes[l].lethal = 1;}
	for(l=92;l<100;l++){TileTypes[l].lethal = 1;}
	for(l=132;l<140;l++){TileTypes[l].lethal = 1;}
	for(l=112;l<115;l++){TileTypes[l].lethal = 1;}
	TileTypes[33].lethal = 1;
	TileTypes[73].lethal = 1;
	TileTypes[256].lethal = 1;
	TileTypes[6].lethal = 0; // make some fire tiles non-lethal...
	TileTypes[9].lethal = 0; // make some fire tiles non-lethal...
	TileTypes[10].lethal = 0; // make some fire tiles non-lethal...
	TileTypes[13].lethal = 0; // make some fire tiles non-lethal...
	TileTypes[14].lethal = 0; // make some fire tiles non-lethal...
	TileTypes[17].lethal = 0; // make some fire tiles non-lethal...
	// END LETHAL TILES


	// BEGIN BREAKABLE TILES
    for(l=504;l<510;l++){TileAnimation[l].animated = 1;}
    for(l=544;l<550;l++){TileAnimation[l].animated = 1;}
	TileAnimation[504].nexttile = 507;
    TileAnimation[505].nexttile = 508;
    TileAnimation[506].nexttile = 509;
	TileAnimation[507].nexttile = 0;
    TileAnimation[508].nexttile = 0;
    TileAnimation[509].nexttile = 0;
	TileAnimation[544].nexttile = 547;
    TileAnimation[545].nexttile = 548;
    TileAnimation[546].nexttile = 549;
	TileAnimation[547].nexttile = 0;
    TileAnimation[548].nexttile = 0;
    TileAnimation[549].nexttile = 0;

	// BEGIN 5-DIAMOND TILES
    for(l=643;l<646;l++){TileAnimation[l].animated = 1;}
    for(l=683;l<686;l++){TileAnimation[l].animated = 1;}
	TileAnimation[643].nexttile = 646;
    TileAnimation[644].nexttile = 647;
    TileAnimation[645].nexttile = 648;
	TileAnimation[683].nexttile = 686;
    TileAnimation[684].nexttile = 687;
    TileAnimation[685].nexttile = 688;
    for(l=649;l<652;l++){TileAnimation[l].animated = 1;}
    for(l=689;l<692;l++){TileAnimation[l].animated = 1;}
	TileAnimation[649].nexttile = 652;
    TileAnimation[650].nexttile = 653;
    TileAnimation[651].nexttile = 654;
	TileAnimation[689].nexttile = 692;
    TileAnimation[690].nexttile = 693;
    TileAnimation[691].nexttile = 694;
    for(l=655;l<658;l++){TileAnimation[l].animated = 1;}
    for(l=695;l<698;l++){TileAnimation[l].animated = 1;}
	TileAnimation[655].nexttile = 658;
    TileAnimation[656].nexttile = 659;
    TileAnimation[657].nexttile = 660;
	TileAnimation[695].nexttile = 698;
    TileAnimation[696].nexttile = 699;
    TileAnimation[697].nexttile = 700;
    for(l=661;l<664;l++){TileAnimation[l].animated = 1;}
    for(l=701;l<704;l++){TileAnimation[l].animated = 1;}
	TileAnimation[661].nexttile = 664;
    TileAnimation[662].nexttile = 665;
    TileAnimation[663].nexttile = 666;
	TileAnimation[701].nexttile = 704;
    TileAnimation[702].nexttile = 705;
    TileAnimation[703].nexttile = 706;
    for(l=667;l<670;l++){TileAnimation[l].animated = 1;}
    for(l=707;l<710;l++){TileAnimation[l].animated = 1;}
	TileAnimation[667].nexttile = 587;
    TileAnimation[668].nexttile = 588;
    TileAnimation[669].nexttile = 589;
	TileAnimation[707].nexttile = 627;
    TileAnimation[708].nexttile = 628;
    TileAnimation[709].nexttile = 629;

// fprintf(stdout,"succesfully defined tiles...\n");


if(TileSetColour==1)
{ // Tileset -> Red...
  for(j=0;j<TILESHEETHEIGHT/TILESIZE;j++)
  {
    for(i=0;i<TILESHEETWIDTH/TILESIZE;i++)
    {
      k=i+j*TILESHEETWIDTH/TILESIZE;
	  if(k > 439 && k < 448)
      {
        TileSrcRect[k].x = (i*TILESIZE + 64)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE)*ScaleValue;
      }
	  if(k > 479 && k < 720)
      {
        TileSrcRect[k].x = (i*TILESIZE)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE + 48)*ScaleValue;
      }
      if(k > 279 && k < 286)
      {
        TileSrcRect[k].x = (i*TILESIZE + 72)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE)*ScaleValue;
      }
      if(k > 319 && k < 326)
      {
        TileSrcRect[k].x = (i*TILESIZE + 72)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE)*ScaleValue;
      }
      if(k > 359 && k < 366)
      {
        TileSrcRect[k].x = (i*TILESIZE + 72)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE)*ScaleValue;
      }
      if(k > 399 && k < 406)
      {
        TileSrcRect[k].x = (i*TILESIZE + 72)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE)*ScaleValue;
      }
    }
  }
}

if(TileSetColour==2)
{ // Tileset -> Lilac Greyish...
  for(j=0;j<TILESHEETHEIGHT/TILESIZE;j++)
  {
    for(i=0;i<TILESHEETWIDTH/TILESIZE;i++)
    {
      k=i+j*TILESHEETWIDTH/TILESIZE;
	  if(k > 439 && k < 448)
      {
        TileSrcRect[k].x = (i*TILESIZE + 128)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE)*ScaleValue;
      }
	  if(k > 479 && k < 720)
      {
        TileSrcRect[k].x = (i*TILESIZE)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE + 96)*ScaleValue;
      }
    }
  }
}

if(TileSetColour==3)
{ // Tileset -> Violet...
  for(j=0;j<TILESHEETHEIGHT/TILESIZE;j++)
  {
    for(i=0;i<TILESHEETWIDTH/TILESIZE;i++)
    {
      k=i+j*TILESHEETWIDTH/TILESIZE;
	  if(k > 439 && k < 448)
      {
        TileSrcRect[k].x = (i*TILESIZE + 192)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE)*ScaleValue;
      }
	  if(k > 479 && k < 720)
      {
        TileSrcRect[k].x = (i*TILESIZE)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE + 144)*ScaleValue;
      }
      if(k > 279 && k < 286)
      {
        TileSrcRect[k].x = (i*TILESIZE + 152)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE)*ScaleValue;
      }
      if(k > 319 && k < 326)
      {
        TileSrcRect[k].x = (i*TILESIZE + 152)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE)*ScaleValue;
      }
      if(k > 359 && k < 366)
      {
        TileSrcRect[k].x = (i*TILESIZE + 152)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE)*ScaleValue;
      }
      if(k > 399 && k < 406)
      {
        TileSrcRect[k].x = (i*TILESIZE + 152)*ScaleValue;
        TileSrcRect[k].y = (j*TILESIZE)*ScaleValue;
      }
    }
  }
}

  // CLOUDS
  TileTypes[1612].solid = 0;
  TileTypes[1613].solid = 0;
  TileTypes[1614].solid = 0;
  TileTypes[1615].solid = 0;
  TileTypes[1616].solid = 0;
  // CLOUDS

  // Disappearing Tiles
  TileTypes[1619].solid = 0;
  TileTypes[1620].solid = 0;
  TileTypes[1659].solid = 0;
  TileTypes[1660].solid = 0;
  // Disappearing Tiles

  // on/off-switchable tiles
  TileTypes[1629].solid = 0;
  TileTypes[1630].solid = 0;
  TileTypes[1669].solid = 0;
  TileTypes[1670].solid = 0;
  TileTypes[1633].solid = 0;
  TileTypes[1634].solid = 0;
  TileTypes[1673].solid = 0;
  TileTypes[1674].solid = 0;

  TileTypes[1709].solid = 0;
  TileTypes[1710].solid = 0;
  TileTypes[1711].solid = 0;
  TileTypes[1712].solid = 0;
  TileTypes[1713].solid = 0;
  TileTypes[1714].solid = 0;
  TileTypes[1715].solid = 0;
  TileTypes[1716].solid = 0;

  TileTypes[1749].solid = 0;
  TileTypes[1750].solid = 0;
  TileTypes[1751].solid = 0;
  TileTypes[1752].solid = 0;
  TileTypes[1753].solid = 0;
  TileTypes[1754].solid = 0;
  TileTypes[1755].solid = 0;
  TileTypes[1756].solid = 0;
  // on/off-switchable tiles
}
