#include "_variables.h"

SDL_Rect EnemySrcRightRect[ENEMYTYPES][6];	//[EnemyType][AnimationFrame]
SDL_Rect EnemySrcLeftRect[ENEMYTYPES][6];	//[EnemyType][AnimationFrame]
Uint16 EnemyPath[ENEMYTYPES];				// normal enemies don't have paths. Exception = Ball
Uint16 EnemyFlying[ENEMYTYPES];				// bees etc.

// 1 = Owl            -> does NOT stop at edges
// 2 = Eye            -> does NOT stop at edges
// 3 = Jelly creature -> stops at edges
// 4 = Crab           -> stops at edges
// 5 = Bee            -> flies
// 6 = Bug
// 7 = Ball
// 8 = Hook 1
// 9 = Hook 2
// 10 = Hook 3
// 11 = Robin Hood Like Thing
// 12 = Dragon
// 13 = Spider
// 14 = Piranha
// 15 = Pipe-Thing...

// Worm
// Jumping Hook

EnemyDefinition Enemy[ENEMIESPERSTAGE];

void defineEnemies()
{
    int i, j; 
	EnemyPath[1] = 1; // enemy which falls down
	EnemyPath[2] = 1; // enemy which falls down 
	EnemyPath[3] = 0; // enemy which stops at edges
	EnemyPath[4] = 1; // enemy which falls down 
	EnemyPath[5] = 0; // enemy which flies...
	EnemyPath[6] = 0; // enemy which stops at edges
	EnemyPath[7] = 2; // ball which moves up and down...
	EnemyPath[8] = 1; // enemy which falls down
	EnemyPath[9] = 0; // enemy which stops at edges [?????]
	EnemyPath[10] = 0; // enemy which stops at edges [?????]
	EnemyPath[11] = 0; // enemy which stops at edges [?????]
	EnemyPath[12] = 3; // dragon
	EnemyPath[13] = 4; // spider
	EnemyPath[14] = 5; // Piranha
	EnemyPath[15] = 1; // enemy which falls down
	EnemyPath[16] = 6; // circle of flames
    EnemyFlying[16] = 0; // circle of flames
		
	for(i = 1; i < 6;i++)
	{
		EnemySrcRightRect[1][i].w = 24*ScaleValue;
		EnemySrcRightRect[1][i].h = 17*ScaleValue;
		EnemySrcRightRect[1][i].y = 7*ScaleValue;
		EnemySrcLeftRect[1][i].w = 24*ScaleValue;
		EnemySrcLeftRect[1][i].h = 17*ScaleValue;
		EnemySrcLeftRect[1][i].y = 7*ScaleValue;
	}
		EnemySrcRightRect[1][1].x = 0*ScaleValue;
		EnemySrcRightRect[1][2].x = 24*ScaleValue;
		EnemySrcRightRect[1][3].x = 48*ScaleValue;
		EnemySrcRightRect[1][4].x = 72*ScaleValue;
		EnemySrcRightRect[1][5].x = 96*ScaleValue;
		EnemySrcLeftRect[1][1].x = 120*ScaleValue;
		EnemySrcLeftRect[1][2].x = 144*ScaleValue;
		EnemySrcLeftRect[1][3].x = 168*ScaleValue;
		EnemySrcLeftRect[1][4].x = 192*ScaleValue;
		EnemySrcLeftRect[1][5].x = 216*ScaleValue;
		EnemyFlying[1] = 0;

	for(i = 1; i < 6;i++)
	{
		EnemySrcRightRect[2][i].w = 24*ScaleValue;
		EnemySrcRightRect[2][i].h = 18*ScaleValue;
		EnemySrcRightRect[2][i].y = 30*ScaleValue;
		EnemySrcLeftRect[2][i].w = 24*ScaleValue;
		EnemySrcLeftRect[2][i].h = 18*ScaleValue;
		EnemySrcLeftRect[2][i].y = 30*ScaleValue;
	}
		EnemySrcRightRect[2][1].x = 0*ScaleValue;
		EnemySrcRightRect[2][2].x = 24*ScaleValue;
		EnemySrcRightRect[2][3].x = 48*ScaleValue;
		EnemySrcRightRect[2][4].x = 72*ScaleValue;
		EnemySrcRightRect[2][5].x = 96*ScaleValue;
		EnemySrcLeftRect[2][1].x = 120*ScaleValue;
		EnemySrcLeftRect[2][2].x = 144*ScaleValue;
		EnemySrcLeftRect[2][3].x = 168*ScaleValue;
		EnemySrcLeftRect[2][4].x = 192*ScaleValue;
		EnemySrcLeftRect[2][5].x = 216*ScaleValue;
		EnemyFlying[2] = 0;

	for(i = 1; i < 6;i++)
	{
		EnemySrcRightRect[3][i].w = 24*ScaleValue;
		EnemySrcRightRect[3][i].h = 13*ScaleValue;
		EnemySrcRightRect[3][i].y = 51*ScaleValue;
		EnemySrcLeftRect[3][i].w = 24*ScaleValue;
		EnemySrcLeftRect[3][i].h = 13*ScaleValue;
		EnemySrcLeftRect[3][i].y = 51*ScaleValue;
	}
		EnemySrcRightRect[3][1].x = 0*ScaleValue;
		EnemySrcRightRect[3][2].x = 24*ScaleValue;
		EnemySrcRightRect[3][3].x = 48*ScaleValue;
		EnemySrcRightRect[3][4].x = 72*ScaleValue;
		EnemySrcRightRect[3][5].x = 96*ScaleValue;
		EnemySrcLeftRect[3][1].x = 120*ScaleValue;
		EnemySrcLeftRect[3][2].x = 144*ScaleValue;
		EnemySrcLeftRect[3][3].x = 168*ScaleValue;
		EnemySrcLeftRect[3][4].x = 192*ScaleValue;
		EnemySrcLeftRect[3][5].x = 216*ScaleValue;
		EnemyFlying[3] = 0;

	for(i = 1; i < 6;i++)
	{
		EnemySrcRightRect[4][i].w = 24*ScaleValue;
		EnemySrcRightRect[4][i].h = 16*ScaleValue;
		EnemySrcRightRect[4][i].y = 64*ScaleValue;
		EnemySrcLeftRect[4][i].w = 24*ScaleValue;
		EnemySrcLeftRect[4][i].h = 16*ScaleValue;
		EnemySrcLeftRect[4][i].y = 64*ScaleValue;
	}
		EnemySrcRightRect[4][1].x = 0*ScaleValue;
		EnemySrcRightRect[4][2].x = 24*ScaleValue;
		EnemySrcRightRect[4][3].x = 48*ScaleValue;
		EnemySrcRightRect[4][4].x = 72*ScaleValue;
		EnemySrcRightRect[4][5].x = 96*ScaleValue;
		EnemySrcLeftRect[4][1].x = 120*ScaleValue;
		EnemySrcLeftRect[4][2].x = 144*ScaleValue;
		EnemySrcLeftRect[4][3].x = 168*ScaleValue;
		EnemySrcLeftRect[4][4].x = 192*ScaleValue;
		EnemySrcLeftRect[4][5].x = 216*ScaleValue;
		EnemyFlying[4] = 0;

    // BEE
	for(i = 1; i < 6;i++)
	{
		EnemySrcRightRect[5][i].w = 24*ScaleValue;
		EnemySrcRightRect[5][i].h = 18*ScaleValue;
		EnemySrcRightRect[5][i].y = 86*ScaleValue;
        if(SystemNumber==2){EnemySrcRightRect[5][i].y = 83*ScaleValue;}
		EnemySrcLeftRect[5][i].w = 24*ScaleValue;
		EnemySrcLeftRect[5][i].h = 18*ScaleValue;
        if(SystemNumber==2){EnemySrcLeftRect[5][i].h = 20*ScaleValue;}
		EnemySrcLeftRect[5][i].y = 86*ScaleValue;
	}
		EnemySrcRightRect[5][1].x = 0*ScaleValue;
		EnemySrcRightRect[5][2].x = 24*ScaleValue;
		EnemySrcRightRect[5][3].x = 48*ScaleValue;
		EnemySrcRightRect[5][4].x = 72*ScaleValue;
		EnemySrcRightRect[5][5].x = 96*ScaleValue;
		EnemySrcLeftRect[5][1].x = 120*ScaleValue;
		EnemySrcLeftRect[5][2].x = 144*ScaleValue;
		EnemySrcLeftRect[5][3].x = 168*ScaleValue;
		EnemySrcLeftRect[5][4].x = 192*ScaleValue;
		EnemySrcLeftRect[5][5].x = 216*ScaleValue;
		EnemyFlying[5] = 1;

    // BUG
	for(i = 1; i < 6;i++)
	{
		EnemySrcRightRect[6][i].w = 24*ScaleValue;
		EnemySrcRightRect[6][i].h = 10*ScaleValue;
		EnemySrcRightRect[6][i].y = 109*ScaleValue;
		EnemySrcLeftRect[6][i].w = 24*ScaleValue;
		EnemySrcLeftRect[6][i].h = 10*ScaleValue;
		EnemySrcLeftRect[6][i].y = 109*ScaleValue;
	}
		EnemySrcRightRect[6][1].x = 0*ScaleValue;
		EnemySrcRightRect[6][2].x = 24*ScaleValue;
		EnemySrcRightRect[6][3].x = 48*ScaleValue;
		EnemySrcRightRect[6][4].x = 72*ScaleValue;
		EnemySrcRightRect[6][5].x = 96*ScaleValue;
		EnemySrcLeftRect[6][1].x = 120*ScaleValue;
		EnemySrcLeftRect[6][2].x = 144*ScaleValue;
		EnemySrcLeftRect[6][3].x = 168*ScaleValue;
		EnemySrcLeftRect[6][4].x = 192*ScaleValue;
		EnemySrcLeftRect[6][5].x = 216*ScaleValue;
		EnemyFlying[6] = 0;
		
    // BALL
	for(i = 1; i < 6;i++)
	{
		EnemySrcRightRect[7][i].w = 24*ScaleValue;
		EnemySrcRightRect[7][i].h = 17*ScaleValue;
		EnemySrcRightRect[7][i].y = 127*ScaleValue;
		EnemySrcLeftRect[7][i].w = 24*ScaleValue;
		EnemySrcLeftRect[7][i].h = 17*ScaleValue;
		EnemySrcLeftRect[7][i].y = 127*ScaleValue;
	}
		EnemySrcRightRect[7][1].x = 0*ScaleValue;
		EnemySrcRightRect[7][2].x = 24*ScaleValue;
		EnemySrcRightRect[7][3].x = 48*ScaleValue;
		EnemySrcRightRect[7][4].x = 72*ScaleValue;
		EnemySrcRightRect[7][5].x = 96*ScaleValue;
		EnemySrcLeftRect[7][1].x = 120*ScaleValue;
		EnemySrcLeftRect[7][2].x = 144*ScaleValue;
		EnemySrcLeftRect[7][3].x = 168*ScaleValue;
		EnemySrcLeftRect[7][4].x = 192*ScaleValue;
		EnemySrcLeftRect[7][5].x = 216*ScaleValue;
		EnemyFlying[7] = 0;

	for(i = 1; i < 6;i++) // HOOK 1
	{
		EnemySrcRightRect[8][i].w = 24*ScaleValue;
		EnemySrcRightRect[8][i].h = 22*ScaleValue;
		EnemySrcRightRect[8][i].y = 146*ScaleValue;
		EnemySrcLeftRect[8][i].w = 24*ScaleValue;
		EnemySrcLeftRect[8][i].h = 22*ScaleValue;
		EnemySrcLeftRect[8][i].y = 146*ScaleValue;
	}
		EnemySrcRightRect[8][1].x = 0*ScaleValue;
		EnemySrcRightRect[8][2].x = 24*ScaleValue;
		EnemySrcRightRect[8][3].x = 48*ScaleValue;
		EnemySrcRightRect[8][4].x = 72*ScaleValue;
		EnemySrcRightRect[8][5].x = 96*ScaleValue;
		EnemySrcLeftRect[8][1].x = 120*ScaleValue;
		EnemySrcLeftRect[8][2].x = 144*ScaleValue;
		EnemySrcLeftRect[8][3].x = 168*ScaleValue;
		EnemySrcLeftRect[8][4].x = 192*ScaleValue;
		EnemySrcLeftRect[8][5].x = 216*ScaleValue;
		EnemyFlying[8] = 0;

	for(i = 1; i < 6;i++) // HOOK 2
	{
		EnemySrcRightRect[9][i].w = 24*ScaleValue;
		EnemySrcRightRect[9][i].h = 22*ScaleValue;
		EnemySrcRightRect[9][i].y = 170*ScaleValue;
		EnemySrcLeftRect[9][i].w = 24*ScaleValue;
		EnemySrcLeftRect[9][i].h = 22*ScaleValue;
		EnemySrcLeftRect[9][i].y = 170*ScaleValue;
	}
		EnemySrcRightRect[9][1].x = 0*ScaleValue;
		EnemySrcRightRect[9][2].x = 24*ScaleValue;
		EnemySrcRightRect[9][3].x = 48*ScaleValue;
		EnemySrcRightRect[9][4].x = 72*ScaleValue;
		EnemySrcRightRect[9][5].x = 96*ScaleValue;
		EnemySrcLeftRect[9][1].x = 120*ScaleValue;
		EnemySrcLeftRect[9][2].x = 144*ScaleValue;
		EnemySrcLeftRect[9][3].x = 168*ScaleValue;
		EnemySrcLeftRect[9][4].x = 192*ScaleValue;
		EnemySrcLeftRect[9][5].x = 216*ScaleValue;
		EnemyFlying[9] = 0;

	for(i = 1; i < 6;i++) // HOOK 3
	{
		EnemySrcRightRect[10][i].w = 24*ScaleValue;
		EnemySrcRightRect[10][i].h = 22*ScaleValue;
		EnemySrcRightRect[10][i].y = 194*ScaleValue;
		EnemySrcLeftRect[10][i].w = 24*ScaleValue;
		EnemySrcLeftRect[10][i].h = 22*ScaleValue;
		EnemySrcLeftRect[10][i].y = 194*ScaleValue;
	}
		EnemySrcRightRect[10][1].x = 0*ScaleValue;
		EnemySrcRightRect[10][2].x = 24*ScaleValue;
		EnemySrcRightRect[10][3].x = 48*ScaleValue;
		EnemySrcRightRect[10][4].x = 72*ScaleValue;
		EnemySrcRightRect[10][5].x = 96*ScaleValue;
		EnemySrcLeftRect[10][1].x = 120*ScaleValue;
		EnemySrcLeftRect[10][2].x = 144*ScaleValue;
		EnemySrcLeftRect[10][3].x = 168*ScaleValue;
		EnemySrcLeftRect[10][4].x = 192*ScaleValue;
		EnemySrcLeftRect[10][5].x = 216*ScaleValue;
		EnemyFlying[10] = 0;

    // Bug with spike
	for(i = 1; i < 6;i++)
	{
		EnemySrcRightRect[11][i].w = 24*ScaleValue;
		EnemySrcRightRect[11][i].h = 14*ScaleValue;
        if(SystemNumber==2){EnemySrcRightRect[11][i].h = 17*ScaleValue;}
		EnemySrcRightRect[11][i].y = 226*ScaleValue;
        if(SystemNumber==2){EnemySrcRightRect[11][i].y = 223*ScaleValue;}
		EnemySrcLeftRect[11][i].w = 24*ScaleValue;
		EnemySrcLeftRect[11][i].h = 14*ScaleValue;
        if(SystemNumber==2){EnemySrcLeftRect[11][i].h = 17*ScaleValue;}
		EnemySrcLeftRect[11][i].y = 226*ScaleValue;
        if(SystemNumber==2){EnemySrcLeftRect[11][i].y = 223*ScaleValue;}
	}
		EnemySrcRightRect[11][1].x = 0*ScaleValue;
		EnemySrcRightRect[11][2].x = 24*ScaleValue;
		EnemySrcRightRect[11][3].x = 48*ScaleValue;
		EnemySrcRightRect[11][4].x = 72*ScaleValue;
		EnemySrcRightRect[11][5].x = 96*ScaleValue;
		EnemySrcLeftRect[11][1].x = 120*ScaleValue;
		EnemySrcLeftRect[11][2].x = 144*ScaleValue;
		EnemySrcLeftRect[11][3].x = 168*ScaleValue;
		EnemySrcLeftRect[11][4].x = 192*ScaleValue;
		EnemySrcLeftRect[11][5].x = 216*ScaleValue;
		EnemyFlying[11] = 0;

    // DRAGON
	for(i = 1; i < 6;i++)
	{
		EnemySrcRightRect[12][i].w = 83*ScaleValue;
		EnemySrcRightRect[12][i].h = 23*ScaleValue;
		EnemySrcRightRect[12][i].y = 296*ScaleValue;
		EnemySrcLeftRect[12][i].w = 83*ScaleValue;
		EnemySrcLeftRect[12][i].h = 23*ScaleValue;
		EnemySrcLeftRect[12][i].y = 296*ScaleValue;
        if(SystemNumber==2)
        {
		  EnemySrcRightRect[12][i].w = 72*ScaleValue;
		  EnemySrcRightRect[12][i].h = 21*ScaleValue;
		  EnemySrcLeftRect[12][i].w = 72*ScaleValue;
		  EnemySrcLeftRect[12][i].h = 21*ScaleValue;
        }
	}

		EnemySrcRightRect[12][1].x = 0*ScaleValue;
		EnemySrcRightRect[12][2].x = 85*ScaleValue;
		EnemySrcRightRect[12][3].x = 0*ScaleValue;
		EnemySrcRightRect[12][4].x = 85*ScaleValue;
		EnemySrcRightRect[12][5].x = 0*ScaleValue;
		EnemySrcLeftRect[12][1].x = 0*ScaleValue;
		EnemySrcLeftRect[12][2].x = 85*ScaleValue;
		EnemySrcLeftRect[12][3].x = 0*ScaleValue;
		EnemySrcLeftRect[12][4].x = 85*ScaleValue;
		EnemySrcLeftRect[12][5].x = 0*ScaleValue;
        if(SystemNumber==2)
        {
		  EnemySrcRightRect[12][2].x = 80*ScaleValue;
		  EnemySrcRightRect[12][4].x = 80*ScaleValue;
		  EnemySrcLeftRect[12][2].x = 80*ScaleValue;
		  EnemySrcLeftRect[12][4].x = 80*ScaleValue;
        }
		EnemyFlying[12] = 0;



    // SPIDER
	for(i = 1; i < 6;i++)
	{
		EnemySrcRightRect[13][i].w = 45*ScaleValue;
        if(SystemNumber==2){EnemySrcRightRect[13][i].w = 44*ScaleValue;}
		EnemySrcRightRect[13][i].h = 21*ScaleValue;
		EnemySrcRightRect[13][i].y = 296*ScaleValue;
		EnemySrcLeftRect[13][i].w = 45*ScaleValue;
        if(SystemNumber==2){EnemySrcLeftRect[13][i].w = 44*ScaleValue;}
		EnemySrcLeftRect[13][i].h = 21*ScaleValue;
		EnemySrcLeftRect[13][i].y = 296*ScaleValue;
	}
		EnemySrcRightRect[13][1].x = 168*ScaleValue;
		EnemySrcRightRect[13][2].x = 216*ScaleValue;
		EnemySrcRightRect[13][3].x = 168*ScaleValue;
		EnemySrcRightRect[13][4].x = 216*ScaleValue;
		EnemySrcRightRect[13][5].x = 168*ScaleValue;
		EnemySrcLeftRect[13][1].x = 168*ScaleValue;
		EnemySrcLeftRect[13][2].x = 216*ScaleValue;
		EnemySrcLeftRect[13][3].x = 168*ScaleValue;
		EnemySrcLeftRect[13][4].x = 216*ScaleValue;
		EnemySrcLeftRect[13][5].x = 168*ScaleValue;
		EnemyFlying[13] = 0;

    // PIRANHA
	for(i = 1; i < 6;i++)
	{
		EnemySrcRightRect[14][i].w = 20*ScaleValue;
		EnemySrcRightRect[14][i].h = 20*ScaleValue;
		EnemySrcRightRect[14][i].y = 124*ScaleValue;
		EnemySrcLeftRect[14][i].w = 20*ScaleValue;
		EnemySrcLeftRect[14][i].h = 20*ScaleValue;
		EnemySrcLeftRect[14][i].y = 124*ScaleValue;
	}
		EnemySrcRightRect[14][1].x = 218*ScaleValue;
		EnemySrcRightRect[14][2].x = 242*ScaleValue;
		EnemySrcRightRect[14][3].x = 218*ScaleValue;
		EnemySrcRightRect[14][4].x = 242*ScaleValue;
		EnemySrcRightRect[14][5].x = 218*ScaleValue;
		EnemySrcLeftRect[14][1].x = 218*ScaleValue;
		EnemySrcLeftRect[14][2].x = 242*ScaleValue;
		EnemySrcLeftRect[14][3].x = 218*ScaleValue;
		EnemySrcLeftRect[14][4].x = 242*ScaleValue;
		EnemySrcLeftRect[14][5].x = 218*ScaleValue;
		EnemyFlying[14] = 0;


    // PIPE-THING
	for(i = 1; i < 6;i++)
	{

		EnemySrcRightRect[15][5].y = 262*ScaleValue;
		EnemySrcRightRect[15][5].x = 4*ScaleValue;
		EnemySrcRightRect[15][5].w = 24*ScaleValue;
		EnemySrcRightRect[15][5].h = 26*ScaleValue;

		EnemySrcRightRect[15][4].y = 262*ScaleValue;
		EnemySrcRightRect[15][4].x = 61*ScaleValue;
		EnemySrcRightRect[15][4].w = 31*ScaleValue;
		EnemySrcRightRect[15][4].h = 26*ScaleValue;

		EnemySrcRightRect[15][3].y = 262*ScaleValue;
		EnemySrcRightRect[15][3].x = 95*ScaleValue;
		EnemySrcRightRect[15][3].w = 25*ScaleValue;
		EnemySrcRightRect[15][3].h = 26*ScaleValue;

		EnemySrcRightRect[15][2].y = 262*ScaleValue;
		EnemySrcRightRect[15][2].x = 164*ScaleValue;
		EnemySrcRightRect[15][2].w = 31*ScaleValue;
		EnemySrcRightRect[15][2].h = 26*ScaleValue;

		EnemySrcRightRect[15][1].y = 262*ScaleValue;
		EnemySrcRightRect[15][1].x = 196*ScaleValue;
		EnemySrcRightRect[15][1].w = 24*ScaleValue;
		EnemySrcRightRect[15][1].h = 26*ScaleValue;


		EnemySrcLeftRect[15][1].y = 262*ScaleValue;
		EnemySrcLeftRect[15][1].x = 4*ScaleValue;
		EnemySrcLeftRect[15][1].w = 24*ScaleValue;
		EnemySrcLeftRect[15][1].h = 26*ScaleValue;

		EnemySrcLeftRect[15][2].y = 262*ScaleValue;
		EnemySrcLeftRect[15][2].x = 61*ScaleValue;
		EnemySrcLeftRect[15][2].w = 31*ScaleValue;
		EnemySrcLeftRect[15][2].h = 26*ScaleValue;

		EnemySrcLeftRect[15][3].y = 262*ScaleValue;
		EnemySrcLeftRect[15][3].x = 95*ScaleValue;
		EnemySrcLeftRect[15][3].w = 25*ScaleValue;
		EnemySrcLeftRect[15][3].h = 26*ScaleValue;

		EnemySrcLeftRect[15][4].y = 262*ScaleValue;
		EnemySrcLeftRect[15][4].x = 164*ScaleValue;
		EnemySrcLeftRect[15][4].w = 31*ScaleValue;
		EnemySrcLeftRect[15][4].h = 26*ScaleValue;

		EnemySrcLeftRect[15][5].y = 262*ScaleValue;
		EnemySrcLeftRect[15][5].x = 196*ScaleValue;
		EnemySrcLeftRect[15][5].w = 24*ScaleValue;
		EnemySrcLeftRect[15][5].h = 26*ScaleValue;

		EnemyFlying[15] = 0;
    }
}

void resetEnemies()
{
	for(int j = 0; j < ENEMIESPERSTAGE; j++)
	{
		Enemy[j].inUse = 0;
		Enemy[j].direction = 0;
		Enemy[j].alive = 1;
        Enemy[j].movementFrame = 0;
	}
}
