#include "_variables.h"

int WarpToLevel;

void warp()
{
  Mix_FreeMusic(BackgroundMusic); //free the music
  // make sure the jump is stopped
  Player.jumpcounter = 0;
  StageMission = 0;
  playSound(2);

  // draw everything for a "freeze frame"
  drawBackground(StageBackgroundColour, 0, 0);
  drawTiles();
  drawCoin();
  drawPlayer();
  drawEnemy();
  drawBonus();
  drawStats(0,0);
  drawBullet();
  SDL_UpdateRect(DisplaySurface,0,0,0,0);
  timecounter = SDL_GetTicks();	// reset counter
  while(SDL_GetTicks() - timecounter < 500)
  {
  }

  // some cleaning up
  timecounter = SDL_GetTicks();	// reset counter
  exitReached = 0; 
  ReStartPosition = 0; // Player is to start at the beginning of the next stage...

  // the stage is considered "solved", since the player
  // has found a "legal exit"
  updateRecords();

  // get the stage to warp to
  STAGE_NUMBER = WarpToLevel;

  // show some warp-screen
  timecounter = SDL_GetTicks(); 	// reset counter
  while(SDL_GetTicks() - timecounter < 2000)
  {
    drawBackground(1,0,0);
    Print (104,80,0,  "WARP TO LEVEL");
    PrintInt (152,96,0, STAGE_NUMBER);
    SDL_UpdateRect(DisplaySurface,0,0,0,0);
  }

  // and the story continues
  loadStage();
  getInput();
}
