#include "_variables.h"

SDL_Surface* DisplaySurface = NULL;			//display surface
SDL_Surface* TilesSurface = NULL;			//tiles surface
SDL_Surface* PlayerSpritesSurface = NULL;	//Player's sprites surface
SDL_Surface* EnemySpritesSurface = NULL;	//enemy-sprites surface
SDL_Surface* FontSurface = NULL;			//the font surface
SDL_Surface* BonusSurface = NULL;			//the Bonus surface
SDL_Surface* IntroSurface = NULL;			//the intro surface
SDL_Surface* OverlaySurface = NULL;			//the overlay surface


void DrawPixel(SDL_Surface* Target, Sint16 X, Sint16 Y, Uint16 Color);
Uint32 ReadPixel(SDL_Surface* Source, Sint16 X, Sint16 Y);
SDL_Surface *ScaleSurface(SDL_Surface *Surface, Uint16 Width, Uint16 Height);

// char fileAdress[50] = "base/";
// char modDirectory[50];

void setSurfaces()
{
  SDL_Surface* TempSurface;
  // needed for scaling
  SDL_Rect TempRect;
  TempRect.x=0;
  TempRect.y=0;
  // needed for scaling

 // strcpy(modDirectory, fileAdress);
    
  //*********************************
  // set window caption
  SDL_WM_SetCaption("OpenGGS", "OpenGGS");
  //*********************************

  //*********************************
  // set colourcode for transparent colour
  Uint32 CKColor = SDL_MapRGB(DisplaySurface->format,255,0,255);
  //*********************************


  //*********************************
  // generate font surfaces
  TempSurface = IMG_Load("base/font.png");
  FontSurface = SDL_DisplayFormat(TempSurface);
  SDL_FreeSurface(TempSurface);

  TempRect.h=FontSurface->h*ScaleValue;
  TempRect.w=FontSurface->w*ScaleValue;
  FontSurface = ScaleSurface(FontSurface, FontSurface->w*ScaleValue, FontSurface->h*ScaleValue);
  SDL_SetColorKey(FontSurface, SDL_SRCCOLORKEY, CKColor);
  //*********************************

  //*********************************
  // generate tiles surfaces
  TempSurface = IMG_Load("base/default/tiles.png");
  TilesSurface = SDL_DisplayFormat(TempSurface);
  SDL_FreeSurface(TempSurface);

  TempRect.h=TilesSurface->h*ScaleValue;
  TempRect.w=TilesSurface->w*ScaleValue;
  TilesSurface = ScaleSurface(TilesSurface, TilesSurface->w*ScaleValue, TilesSurface->h*ScaleValue);
  SDL_SetColorKey(TilesSurface, SDL_SRCCOLORKEY, CKColor);
  //*********************************

  //*********************************
  // generate Player sprites surfaces
  TempSurface = IMG_Load("base/default/player.png");
  PlayerSpritesSurface = SDL_DisplayFormat(TempSurface);
  SDL_FreeSurface(TempSurface);

  TempRect.h=PlayerSpritesSurface->h*ScaleValue;
  TempRect.w=PlayerSpritesSurface->w*ScaleValue;
  PlayerSpritesSurface = ScaleSurface(PlayerSpritesSurface, PlayerSpritesSurface->w*ScaleValue, PlayerSpritesSurface->h*ScaleValue);
  SDL_SetColorKey(PlayerSpritesSurface, SDL_SRCCOLORKEY, CKColor);
  //*********************************

  //*********************************
  // generate enemy sprites surfaces
  TempSurface = IMG_Load("base/default/enemies.png");
  EnemySpritesSurface = SDL_DisplayFormat(TempSurface);
  SDL_FreeSurface(TempSurface);

  TempRect.h=EnemySpritesSurface->h*ScaleValue;
  TempRect.w=EnemySpritesSurface->w*ScaleValue;
  EnemySpritesSurface = ScaleSurface(EnemySpritesSurface, EnemySpritesSurface->w*ScaleValue, EnemySpritesSurface->h*ScaleValue);
  SDL_SetColorKey(EnemySpritesSurface, SDL_SRCCOLORKEY, CKColor);
  //*********************************

  //*********************************
  // generate bonus sprites surfaces
  TempSurface = IMG_Load("base/default/bonus.png");
  BonusSurface = SDL_DisplayFormat(TempSurface);
  SDL_FreeSurface(TempSurface);

  TempRect.h=BonusSurface->h*ScaleValue;
  TempRect.w=BonusSurface->w*ScaleValue;
  BonusSurface = ScaleSurface(BonusSurface, BonusSurface->w*ScaleValue, BonusSurface->h*ScaleValue);
  SDL_SetColorKey(BonusSurface, SDL_SRCCOLORKEY, CKColor);
  //*********************************

  //*********************************
  // generate intro image surfaces
  TempSurface = IMG_Load("base/pick_system.png");
  IntroSurface = SDL_DisplayFormat(TempSurface);
  SDL_FreeSurface(TempSurface);
 
  TempRect.h=IntroSurface->h*ScaleValue;
  TempRect.w=IntroSurface->w*ScaleValue;
  IntroSurface = ScaleSurface(IntroSurface, IntroSurface->w*ScaleValue, IntroSurface->h*ScaleValue);
  SDL_SetColorKey(IntroSurface, SDL_SRCCOLORKEY, CKColor);
  //*********************************

  //*********************************
  TempSurface = IMG_Load("base/overlays/tiles.png");
  OverlaySurface = SDL_DisplayFormat(TempSurface);
  SDL_FreeSurface(TempSurface);
 
  TempRect.h=OverlaySurface->h*ScaleValue;
  TempRect.w=OverlaySurface->w*ScaleValue;
  OverlaySurface = ScaleSurface(OverlaySurface, OverlaySurface->w*ScaleValue, OverlaySurface->h*ScaleValue);
  SDL_SetColorKey(OverlaySurface, SDL_SRCCOLORKEY, CKColor);
  //*********************************
}



SDL_Surface *ScaleSurface(SDL_Surface *Surface, Uint16 Width, Uint16 Height)
{
  // this function is based on information found here:
  // http://www.sdltutorials.com/sdl-scale-surface/
  // thanks!
  if(!Surface || !Width || !Height){return 0;}

  SDL_Surface *_ret = SDL_CreateRGBSurface(Surface->flags, Width, Height, Surface->format->BitsPerPixel,
    Surface->format->Rmask, Surface->format->Gmask, Surface->format->Bmask, Surface->format->Amask);
  double  _stretch_factor_x = (static_cast<double>(Width)  / static_cast<double>(Surface->w)),
    _stretch_factor_y = (static_cast<double>(Height) / static_cast<double>(Surface->h));

  for(Sint32 y = 0; y < Surface->h; y++)
  {
    for(Sint32 x = 0; x < Surface->w; x++)
    {
      for(Sint32 o_y = 0; o_y < _stretch_factor_y; ++o_y)
      {
        for(Sint32 o_x = 0; o_x < _stretch_factor_x; ++o_x)
        {
          DrawPixel(_ret, static_cast<Sint32>(_stretch_factor_x * x) + o_x,
            static_cast<Sint32>(_stretch_factor_y * y) + o_y, ReadPixel(Surface, x, y));
        }
      }
    }
  }
  return _ret;
}


void DrawPixelSimpel(SDL_Surface* Target, Sint16 x, Sint16 y, Uint16 r, Uint16 g, Uint16 b)
{
Uint32 Farbe = SDL_MapRGB(Target->format,r,g,b);
char* pData;
pData=(char*)Target->pixels;
pData+=(y*Target->pitch);
pData+=(x*Target->format->BytesPerPixel);
memcpy(pData,&Farbe,Target->format->BytesPerPixel);
}


void DrawPixel(SDL_Surface* Target, Sint16 X, Sint16 Y, Uint16 Color)
{
  // this function is based on information found here:
  // http://www.libsdl.org/cgi/docwiki.cgi/Pixel_Access
  // thanks!

  int bpp = Target->format->BytesPerPixel;
  /* Here p is the address to the pixel we want to set */
  Uint8 *p = (Uint8 *)Target->pixels + Y * Target->pitch + X * bpp;
  switch(bpp)
  {
    case 1:
      *p = Color;
      break;
    case 2:
      *(Uint16 *)p = Color;
      break;
    case 3:
      if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
      {
        p[0] = (Color >> 16) & 0xff;
        p[1] = (Color >> 8) & 0xff;
        p[2] = Color & 0xff;
      }
      else
      {
        p[0] = Color & 0xff;
        p[1] = (Color >> 8) & 0xff;
        p[2] = (Color >> 16) & 0xff;
      }
      break;
    case 4:
      *(Uint32 *)p = Color;
    break;
  }
}



Uint32 ReadPixel(SDL_Surface* Source, Sint16 X, Sint16 Y)
{
  // this function is based on information found here:
  // http://www.libsdl.org/cgi/docwiki.cgi/Pixel_Access
  // thanks!

  int bpp = Source->format->BytesPerPixel;
  /* Here p is the address to the pixel we want to retrieve */
  Uint8 *p = (Uint8 *)Source->pixels + Y * Source->pitch + X * bpp;
  switch(bpp)
  {
    case 1:
      return *p;
    case 2:
      return *(Uint16 *)p;
    case 3:
      if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
      {
        return p[0] << 16 | p[1] << 8 | p[2];
      }
      else
      {
        return p[0] | p[1] << 8 | p[2] << 16;
      }
    case 4:
      return *(Uint32 *)p;
    default:
      return 0;
  }
}

void ToggleFullscreen()
{
  getInput();
  FullscreenMode=!FullscreenMode;
  if(FullscreenMode){DisplaySurface = SDL_SetVideoMode(SCREENWIDTH*ScaleValue, SCREENHEIGHT*ScaleValue, 16, SDL_SWSURFACE|SDL_FULLSCREEN);}
  if(!FullscreenMode){DisplaySurface = SDL_SetVideoMode(SCREENWIDTH*ScaleValue, SCREENHEIGHT*ScaleValue, 16, SDL_SWSURFACE);}
}

