#include "_variables.h"

#ifdef WIZ
#include "WIZ_VolumeControl.h"
#endif

int JoyButtonIndex;
Uint8 *keys;

bool Key_UP;        int Key_UP_pressed_value;        bool Key_UP_pressed;
bool Key_RIGHT;     int Key_RIGHT_pressed_value;     bool Key_RIGHT_pressed;
bool Key_DOWN;      int Key_DOWN_pressed_value;      bool Key_DOWN_pressed;
bool Key_LEFT;      int Key_LEFT_pressed_value;      bool Key_LEFT_pressed;
bool Key_ESCAPE;    int Key_ESCAPE_pressed_value;    bool Key_ESCAPE_pressed;
bool Key_ENTER;     int Key_ENTER_pressed_value;     bool Key_ENTER_pressed;

bool Key_1;         int Key_1_pressed_value;         bool Key_1_pressed;
bool Key_2;         int Key_2_pressed_value;         bool Key_2_pressed;
bool Key_3;         int Key_3_pressed_value;         bool Key_3_pressed;
bool Key_4;         int Key_4_pressed_value;         bool Key_4_pressed;
bool Key_5;         int Key_5_pressed_value;         bool Key_5_pressed;
bool Key_6;         int Key_6_pressed_value;         bool Key_6_pressed;
bool Key_7;         int Key_7_pressed_value;         bool Key_7_pressed;
bool Key_8;         int Key_8_pressed_value;         bool Key_8_pressed;
bool Key_9;         int Key_9_pressed_value;         bool Key_9_pressed;
bool Key_0;         int Key_0_pressed_value;         bool Key_0_pressed;
bool Button_0;      int Button_0_pressed_value;      bool Button_0_pressed;
bool Button_1;      int Button_1_pressed_value;      bool Button_1_pressed;
bool Button_2;      int Button_2_pressed_value;      bool Button_2_pressed;
bool Button_3;      int Button_3_pressed_value;      bool Button_3_pressed;
bool Button_4;      int Button_4_pressed_value;      bool Button_4_pressed;
bool Key_F11;       int Key_F11_pressed_value;       bool Key_F11_pressed;
bool Key_F12;       int Key_F12_pressed_value;       bool Key_F12_pressed;

//bool JumpKey;
int JumpKey; int RELEASED_JumpKey;

bool MOUSE_LEFT;   int MOUSE_LEFT_pressed_value;   bool MOUSE_LEFT_pressed;
bool MOUSE_CENTER; int MOUSE_CENTER_pressed_value; bool MOUSE_CENTER_pressed;
bool MOUSE_RIGHT;  int MOUSE_RIGHT_pressed_value;  bool MOUSE_RIGHT_pressed;
int MouseX, MouseY;

void getInput()
{
	JumpKey = 0;
	//Instead of mixing events and keystrokes, only use events!
	//This fixes and improves options menu controls in Dreamcast! :D
	while (SDL_PollEvent(&sdlEvent))
	{
	  //Keyboard
	  if (sdlEvent.type == SDL_KEYDOWN)
	  {
		switch(sdlEvent.key.keysym.sym){
		  case SDLK_ESCAPE:
			Key_ESCAPE = true;
			break;
		  case SDLK_RETURN:
			Key_ENTER = true;
			break;
		  case SDLK_LEFT:
			Key_LEFT = true;
			break;
		  case SDLK_RIGHT:
			Key_RIGHT = true;
			break;
		  case SDLK_UP:
			Key_UP = true;
			break;
		  case SDLK_DOWN:
			Key_DOWN = true;
			Key_2 = true;
			break;
		  case SDLK_RSHIFT:
			Button_1 = true;
			break;
		  case SDLK_RCTRL:
			Button_2 = true;
			break;
		  case SDLK_TAB:
			Key_1 = true;
			break;
		  case SDLK_F11:
			Key_F11 = true;
			break;
		  case SDLK_F12:
			Key_F12 = true;
			break;			
		  default:
			break;
		}
	  }
	  if (sdlEvent.type == SDL_KEYUP)
	  {
		switch(sdlEvent.key.keysym.sym){
		  case SDLK_ESCAPE:
			Key_ESCAPE = false;
			break;
		  case SDLK_RETURN:
			Key_ENTER = false;
			break;
		  case SDLK_LEFT:
			Key_LEFT = false;
			break;
		  case SDLK_RIGHT:
			Key_RIGHT = false;
			break;
		  case SDLK_UP:
			Key_UP = false;
			break;
		  case SDLK_DOWN:
			Key_DOWN = false;
			Key_2 = false;
			break;
		  case SDLK_RSHIFT:
			Button_1 = false;
			break;
		  case SDLK_RCTRL:
			Button_2 = false;
			break;
		  case SDLK_TAB:
			Key_1 = false;
			break;
		  case SDLK_F11:
			Key_F11 = false;
			break;
		  case SDLK_F12:
			Key_F12 = false;
			break;
		  default:
			break;
		}
	  }
	  //Mouse events
	  if (sdlEvent.type == SDL_MOUSEBUTTONDOWN)
	  {
		switch(sdlEvent.button.button){
		  case SDL_BUTTON_LEFT:
			MOUSE_LEFT = false;
			break;
		  case SDL_BUTTON_MIDDLE:
			MOUSE_CENTER = false;
			break;
		  case SDL_BUTTON_RIGHT:
			MOUSE_RIGHT = false;
			break;
		  default:
			break;
		}
	  }
	}

//Check Joystick Inputs
#ifndef DREAMCAST
	if(Use_Up_For_Jump || MenuControls || PlayerIsPlane)
    {
      if(SDL_JoystickGetAxis(SDL_JoystickOpen(Joy_Number),1) < -100) {Key_UP = 1;}
    }
	if(SDL_JoystickGetAxis(SDL_JoystickOpen(Joy_Number),0) < -100) {Key_LEFT = 1;}
	if(SDL_JoystickGetAxis(SDL_JoystickOpen(Joy_Number),0) > 100)  {Key_RIGHT = 1;}
	if(SDL_JoystickGetAxis(SDL_JoystickOpen(Joy_Number),1) > 100)  {Key_DOWN = 1; Key_2 = true;}
	if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_Left)) {Key_LEFT = 1;}
    if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_Right)) {Key_RIGHT = 1;}
    if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_Up)) {Key_UP = 1;}
	if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_Down)) {Key_DOWN = 1; Key_2 = true;}
	if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_Shoot)) {Button_2 = 1;}	// shoot

    if(!MenuControls)
    {
      if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_Jump)) {Key_UP = 1;} // jump
    }
    if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_Run)) {Button_1 = 1;} // 
	if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_Enter)) {Key_ENTER = 1;}	// BUTTON 2 IS PRESSED
	if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_Escape)) {Key_ESCAPE = 1;}	// BUTTON 3 IS PRESSED
	if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_Tab)) {Key_1 = 1;}	// BUTTON 3 IS PRESSED

    #ifdef WIZ
    volume_direction = VOLUME_NOCHG;
    if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_VolumeUp)) {volume_direction=VOLUME_UP;}
    if(SDL_JoystickGetButton(SDL_JoystickOpen(Joy_Number),Joy_VolumeDown)) {volume_direction=VOLUME_DOWN;}
    #endif
#endif

//Determine keys status
    if (Key_ENTER == false)	{Key_ENTER_pressed_value =	0; Key_ENTER_pressed = false;} else
                            {if (Key_ENTER_pressed_value == 2){Key_ENTER_pressed_value = 1; Key_ENTER_pressed = false;}
                             if (Key_ENTER_pressed_value == 0){Key_ENTER_pressed_value = 2; Key_ENTER_pressed = true;}}                             
    if (Key_ESCAPE == false){Key_ESCAPE_pressed_value =	0; Key_ESCAPE_pressed = false;} else
                            {if (Key_ESCAPE_pressed_value == 2){Key_ESCAPE_pressed_value = 1; Key_ESCAPE_pressed = false;}
                             if (Key_ESCAPE_pressed_value == 0){Key_ESCAPE_pressed_value = 2; Key_ESCAPE_pressed = true;}}
    if (Key_UP == false)	{Key_UP_pressed_value =	0; Key_UP_pressed = false;} else
                    {if (Key_UP_pressed_value == 2){Key_UP_pressed_value = 1; Key_UP_pressed = false;}
                     if (Key_UP_pressed_value == 0){Key_UP_pressed_value = 2; Key_UP_pressed = true;}}
    if (Key_LEFT == false)	{Key_LEFT_pressed_value =	0; Key_LEFT_pressed = false;} else
                    {if (Key_LEFT_pressed_value == 2){Key_LEFT_pressed_value = 1; Key_LEFT_pressed = false;}
                     if (Key_LEFT_pressed_value == 0){Key_LEFT_pressed_value = 2; Key_LEFT_pressed = true;}}
    if (Key_DOWN == false)	{Key_DOWN_pressed_value =	0; Key_DOWN_pressed = false;} else
                    {if (Key_DOWN_pressed_value == 2){Key_DOWN_pressed_value = 1; Key_DOWN_pressed = false;}
                     if (Key_DOWN_pressed_value == 0){Key_DOWN_pressed_value = 2; Key_DOWN_pressed = true;}}
    if (Key_RIGHT == false)	{Key_RIGHT_pressed_value =	0; Key_RIGHT_pressed = false;} else
                    {if (Key_RIGHT_pressed_value == 2){Key_RIGHT_pressed_value = 1; Key_RIGHT_pressed = false;}
                     if (Key_RIGHT_pressed_value == 0){Key_RIGHT_pressed_value = 2; Key_RIGHT_pressed = true;}}
                             
    if (Key_1 == false)	{Key_1_pressed_value =	0; Key_1_pressed = false;} else
                    {if (Key_1_pressed_value == 2){Key_1_pressed_value = 1; Key_1_pressed = false;}
                     if (Key_1_pressed_value == 0){Key_1_pressed_value = 2; Key_1_pressed = true;}}
    if (Key_2 == false)	{Key_2_pressed_value =	0; Key_2_pressed = false;} else
                    {if (Key_2_pressed_value == 2){Key_2_pressed_value = 1; Key_2_pressed = false;}
                     if (Key_2_pressed_value == 0){Key_2_pressed_value = 2; Key_2_pressed = true;}}
    if (Key_3 == false)	{Key_3_pressed_value =	0; Key_3_pressed = false;} else
                    {if (Key_3_pressed_value == 2){Key_3_pressed_value = 1; Key_3_pressed = false;}
                     if (Key_3_pressed_value == 0){Key_3_pressed_value = 2; Key_3_pressed = true;}}
    if (Key_4 == false)	{Key_4_pressed_value =	0; Key_4_pressed = false;} else
                    {if (Key_4_pressed_value == 2){Key_4_pressed_value = 1; Key_4_pressed = false;}
                     if (Key_4_pressed_value == 0){Key_4_pressed_value = 2; Key_4_pressed = true;}}
    if (Key_5 == false)	{Key_5_pressed_value =	0; Key_5_pressed = false;} else
                    {if (Key_5_pressed_value == 2){Key_5_pressed_value = 1; Key_5_pressed = false;}
                     if (Key_5_pressed_value == 0){Key_5_pressed_value = 2; Key_5_pressed = true;}}
    if (Key_6 == false)	{Key_6_pressed_value =	0; Key_6_pressed = false;} else
                    {if (Key_6_pressed_value == 2){Key_6_pressed_value = 1; Key_6_pressed = false;}
                     if (Key_6_pressed_value == 0){Key_6_pressed_value = 2; Key_6_pressed = true;}}
    if (Key_7 == false)	{Key_7_pressed_value =	0; Key_7_pressed = false;} else
                    {if (Key_7_pressed_value == 2){Key_7_pressed_value = 1; Key_7_pressed = false;}
                     if (Key_7_pressed_value == 0){Key_7_pressed_value = 2; Key_7_pressed = true;}}
    if (Key_8 == false)	{Key_8_pressed_value =	0; Key_8_pressed = false;} else
                    {if (Key_8_pressed_value == 2){Key_8_pressed_value = 1; Key_8_pressed = false;}
                     if (Key_8_pressed_value == 0){Key_8_pressed_value = 2; Key_8_pressed = true;}}
    if (Key_9 == false)	{Key_9_pressed_value =	0; Key_9_pressed = false;} else
                    {if (Key_9_pressed_value == 2){Key_9_pressed_value = 1; Key_9_pressed = false;}
                     if (Key_9_pressed_value == 0){Key_9_pressed_value = 2; Key_9_pressed = true;}}
    if (Key_0 == false)	{Key_0_pressed_value =	0; Key_0_pressed = false;} else
                    {if (Key_0_pressed_value == 2){Key_0_pressed_value = 1; Key_0_pressed = false;}
                     if (Key_0_pressed_value == 0){Key_0_pressed_value = 2; Key_0_pressed = true;}}
    if (Key_F11 == false)	{Key_F11_pressed_value =	0; Key_F11_pressed = false;} else
                    {if (Key_F11_pressed_value == 2){Key_F11_pressed_value = 1; Key_F11_pressed = false;}
                     if (Key_F11_pressed_value == 0){Key_F11_pressed_value = 2; Key_F11_pressed = true;}}
    if (Key_F12 == false)	{Key_F12_pressed_value =	0; Key_F12_pressed = false;} else
                    {if (Key_F12_pressed_value == 2){Key_F12_pressed_value = 1; Key_F12_pressed = false;}
                     if (Key_F12_pressed_value == 0){Key_F12_pressed_value = 2; Key_F12_pressed = true;}}
    if (Button_2 == false)	{Button_2_pressed_value =	0; Button_2_pressed = false;} else
                    {if (Button_2_pressed_value == 2){Button_2_pressed_value = 1; Button_2_pressed = false;}
                     if (Button_2_pressed_value == 0){Button_2_pressed_value = 2; Button_2_pressed = true;}}
	if (!MOUSE_LEFT) {MOUSE_LEFT_pressed_value =	0; MOUSE_LEFT_pressed = false;} else
                  {if (MOUSE_LEFT_pressed_value == 2){MOUSE_LEFT_pressed_value = 1; MOUSE_LEFT_pressed = false;}
                   if (MOUSE_LEFT_pressed_value == 0){MOUSE_LEFT_pressed_value = 2; MOUSE_LEFT_pressed = true;}}
	if (!MOUSE_CENTER) {MOUSE_CENTER_pressed_value =	0; MOUSE_CENTER_pressed = false;} else
                  {if (MOUSE_CENTER_pressed_value == 2){MOUSE_CENTER_pressed_value = 1; MOUSE_CENTER_pressed = false;}
                   if (MOUSE_CENTER_pressed_value == 0){MOUSE_CENTER_pressed_value = 2; MOUSE_CENTER_pressed = true;}}
	if (!MOUSE_RIGHT) {MOUSE_RIGHT_pressed_value =	0; MOUSE_RIGHT_pressed = false;} else
                  {if (MOUSE_RIGHT_pressed_value == 2){MOUSE_RIGHT_pressed_value = 1; MOUSE_RIGHT_pressed = false;}
                   if (MOUSE_RIGHT_pressed_value == 0){MOUSE_RIGHT_pressed_value = 2; MOUSE_RIGHT_pressed = true;}}

//Finally, look at jump action.
	if (Key_UP == true && RELEASED_JumpKey == 0)  {JumpKey = 1;}
	if (Key_UP == false){RELEASED_JumpKey = 0;}
	if (Key_UP == true) {if(Player.jumpcounter > 0){JumpKey = 1;}}
	if (Key_UP == true)
	{
		if(Player.jumpcounter == 0 && Player.onground == 0 && RELEASED_JumpKey == 0)	
		{RELEASED_JumpKey = 0;}
		else {RELEASED_JumpKey = 1;}
	}
//Mouse jump button
    SDL_GetMouseState(&MouseX, &MouseY);
#ifndef DREAMCAST
	if (SDL_JoystickGetButton(SDL_JoystickOpen(0),0) && Player.jumpcounter == 0)		{RELEASED_JumpKey = 1;}
#endif

#ifdef WIZ
  WIZ_AdjustVolume(volume_direction);
#endif

}
