#include "_variables.h"

SDL_Event sdlEvent;				//event structure
SDL_Rect SrcRect,DstRect;		//source and destination rectangles


SDL_Joystick* pStick;	// define the Joystick
int nStickButtons;
int StickAxis[2];

#ifdef DREAMCAST
#include <kos.h>
#include <SDL/SDL_dreamcast.h>
#endif

void initSDL()
{
  //*********************************
  // initialize SDL
  if (SDL_Init(SDL_INIT_VIDEO)==-1)
  {
    fprintf(stderr,"SDL fucked up!\n");
    exit(1);
  }
  else
  {
    // fprintf(stdout,"SDL initialized properly!\n");
    atexit(SDL_Quit);
  }
  //*********************************

	
    //*********************************
	// initialize joystick
	SDL_Init(SDL_INIT_JOYSTICK);
	
	#ifdef DREAMCAST
		SDL_DC_MapKey(0,SDL_DC_START,SDLK_RETURN);
		SDL_DC_MapKey(0,SDL_DC_UP,SDLK_UP);
		SDL_DC_MapKey(0,SDL_DC_DOWN,SDLK_DOWN);
		SDL_DC_MapKey(0,SDL_DC_LEFT,SDLK_LEFT); 
		SDL_DC_MapKey(0,SDL_DC_RIGHT,SDLK_RIGHT);
		SDL_DC_MapKey(0,SDL_DC_A,SDLK_UP); //jump
		SDL_DC_MapKey(0,SDL_DC_B,SDLK_RCTRL); //fire ball
		SDL_DC_MapKey(0,SDL_DC_Y,SDLK_RSHIFT); //x button, run
		SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //L button, exits
		SDL_DC_MapKey(0,SDL_DC_L,SDLK_TAB); //R button, info
	#endif
	
    pStick = SDL_JoystickOpen(0);
    nStickButtons = SDL_JoystickNumButtons(pStick);
    SDL_JoystickEventState(SDL_ENABLE);
	
	//Dreamcast: disable mouse controls and set keyboard controls
	#ifdef DREAMCAST
		SDL_DC_EmulateMouse(SDL_bool (false));
		//Dreamcast delay...
		SDL_Event event;
		SDL_PollEvent(&event);
	#endif
  //*********************************
}

