#include "_variables.h"

int InfoScreenPage;

int OptionNumber;
bool SnowChanged;
int SongNumber;
bool LevelsetChanged;

// ******************************************
// ******************************************
// ******************************************

void gotoscreen(int ScreenType)
{
  MenuControls = true;
  int x_pos = 0;
  int y_pos = -235;
  timecounter = SDL_GetTicks();	// reset counter
  OptionNumber = 19;

  while(!Key_ESCAPE_pressed && y_pos < 0)
  {
    getInput();
    if(ScreenType==1){draw_optionsscreen(x_pos,y_pos);}
    if(ScreenType==2){draw_creditsscreen(x_pos,y_pos);}
    if(ScreenType==3){draw_infoscreen(x_pos,y_pos);}
    if(SDL_GetTicks() - timecounter > 20)
    {
      timecounter = SDL_GetTicks(); 	// reset counter
      y_pos +=10;
    }
  }
  y_pos = 0;
  if(ScreenType==1){optionsscreen(x_pos,y_pos);}
  if(ScreenType==2){creditsscreen(x_pos,y_pos);}
  if(ScreenType==3){infoscreen(x_pos,y_pos);}
}

// ******************************************
// ******************************************
// ******************************************

void leavescreen(int ScreenType)
{
  MenuControls=false;
  int x_pos = 0;
  int y_pos = 0;
  timecounter = SDL_GetTicks();	// reset counter

  while(!Key_ESCAPE_pressed && y_pos > -240)
  {
    getInput();
    if(ScreenType==1){draw_optionsscreen(x_pos,y_pos);}
    if(ScreenType==2){draw_creditsscreen(x_pos,y_pos);}
    if(ScreenType==3){draw_infoscreen(x_pos,y_pos);}
    if(SDL_GetTicks() - timecounter > 20)
    {
      timecounter = SDL_GetTicks(); 	// reset counter
      y_pos -=10;
    }
  }
}

// ******************************************
// ******************************************
// ******************************************

void infoscreen(int x_off, int y_off)
{
  getInput();
  InfoScreenPage=0;
  if(STAGE_NUMBER<21){InfoScreenPage=0;}
  if(STAGE_NUMBER>20){InfoScreenPage=1;}
  draw_infoscreen(x_off, y_off);
  while(!Key_1_pressed && !Key_ESCAPE_pressed && !Button_2_pressed)
  {
    getInput();
    if(Key_RIGHT_pressed){InfoScreenPage++;}
    if(Key_LEFT_pressed){InfoScreenPage--;}
    if(Key_F12_pressed) {ToggleFullscreen();}
    if(InfoScreenPage<0){InfoScreenPage=0;}
    if(InfoScreenPage>1){InfoScreenPage=1;}
    draw_infoscreen(x_off, y_off);
  }
  getInput();
  leavescreen(3);
}


// ******************************************
// ******************************************
// ******************************************


void draw_infoscreen(int x_off, int y_off)
{
// draw what's behind the info screen
    drawBackground(StageBackgroundColour, 0, 0);
    drawTiles();
    drawPlatforms();
    drawCoin();
    //drawPlayer();
    drawEnemy();
    drawBonus();
    if(Snow_enabled){drawSnow();}
    if(Rain_enabled){drawRain();}
    //drawStats(0,0);
// draw what's behind the info screen

  drawBackground(2, x_off, y_off);

  int i;
  Print (16+x_off,16+y_off,0, "STAGE");
  Print (112+x_off,8+y_off,0, "MAX");
  Print (96+x_off,16+y_off,0, "COINS");

  // draw a little coin next to the number
  SDL_Rect TempCoinRect;
  TempCoinRect.x = (96+x_off)*ScaleValue;
  TempCoinRect.y = (8+y_off)*ScaleValue;
  TempCoinRect.w = (8)*ScaleValue;
  TempCoinRect.h = (8)*ScaleValue;
  SDL_BlitSurface(TilesSurface,&TileSrcRect[45],DisplaySurface,&TempCoinRect);


  // Print (176,8,0, "BEST");
  // Print (176,16,0, "TIME");

  if(InfoScreenPage==0)
  {
    Print (40+x_off,32+y_off,0, "01");
    Print (40+x_off,41+y_off,0, "02");
    Print (40+x_off,50+y_off,0, "03");
    Print (40+x_off,59+y_off,0, "04");
    Print (40+x_off,68+y_off,0, "05");
    Print (40+x_off,77+y_off,0, "06");
    Print (40+x_off,86+y_off,0, "07");
    Print (40+x_off,95+y_off,0, "08");
    Print (40+x_off,104+y_off,0, "09");
    Print (40+x_off,113+y_off,0, "10");
    Print (40+x_off,122+y_off,0, "11");
    Print (40+x_off,131+y_off,0, "12");
    Print (40+x_off,140+y_off,0, "13");
    Print (40+x_off,149+y_off,0, "14");
    Print (40+x_off,158+y_off,0, "15");
    Print (40+x_off,167+y_off,0, "16");
    Print (40+x_off,176+y_off,0, "17");
    Print (40+x_off,185+y_off,0, "18");
    Print (40+x_off,194+y_off,0, "19");
    Print (40+x_off,203+y_off,0, "20");

    for(i=0; i<20; i++)
    {
      if(!StageInfo[i+1].solved)
      {
        Print (64+x_off,32+(i*9)+y_off,1, "stage not completed yet...");
      }
      if(StageInfo[i+1].solved)
      {
        if(StageInfo[i+1].maxCoins < 1000 && StageInfo[i+1].maxCoins >= 100) {PrintInt (88+x_off,32+(i*9)+y_off,0, StageInfo[i+1].maxCoins);}
        if(StageInfo[i+1].maxCoins < 100 && StageInfo[i+1].maxCoins >= 10) {PrintInt (96+x_off,32+(i*9)+y_off,0, StageInfo[i+1].maxCoins);}
        if(StageInfo[i+1].maxCoins < 10) {PrintInt (104+x_off,32+(i*9)+y_off,0, StageInfo[i+1].maxCoins);}
        Print (112+x_off,32+(i*9)+y_off,0, ";");
        PrintInt (120+x_off,32+(i*9)+y_off,0, StageInfo[i+1].totalCoins);
        if(StageInfo[i+1].maxCoins == StageInfo[i+1].totalCoins){Print (160+x_off,32+(i*9)+y_off,2, "Perfect!");}
        if(StageInfo[i+1].maxCoins < StageInfo[i+1].totalCoins){Print (160+x_off,32+(i*9)+y_off,1, "find all coins");}
      }
    }
    Print (184+x_off,224+y_off,0, "Stages 21-32 >>>");
  }

  if(InfoScreenPage==1)
  {
    Print (40+x_off,32+y_off,0, "21");
    Print (40+x_off,41+y_off,0, "22");
    Print (40+x_off,50+y_off,0, "23");
    Print (40+x_off,59+y_off,0, "24");
    Print (40+x_off,68+y_off,0, "25");
    Print (40+x_off,77+y_off,0, "26");
    Print (40+x_off,86+y_off,0, "27");
    Print (40+x_off,95+y_off,0, "28");
    Print (40+x_off,104+y_off,0, "29");
    Print (40+x_off,113+y_off,0, "30");
    Print (40+x_off,122+y_off,0, "31");
    Print (40+x_off,131+y_off,0, "32");

    for(i=20; i<32; i++)
    {
      if(!StageInfo[i+1].solved)
      {
        Print (64+x_off,32+((i-20)*9)+y_off,1, "stage not completed yet...");
      }
      if(StageInfo[i+1].solved)
      {
        if(StageInfo[i+1].maxCoins < 1000 && StageInfo[i+1].maxCoins >= 100) {PrintInt (88+x_off,32+((i-20)*9)+y_off,0, StageInfo[i+1].maxCoins);}
        if(StageInfo[i+1].maxCoins < 100 && StageInfo[i+1].maxCoins >= 10) {PrintInt (96+x_off,32+((i-20)*9)+y_off,0, StageInfo[i+1].maxCoins);}
        if(StageInfo[i+1].maxCoins < 10) {PrintInt (104+x_off,32+((i-20)*9)+y_off,0, StageInfo[i+1].maxCoins);}
        Print (112+x_off,32+((i-20)*9)+y_off,0, ";");
        PrintInt (120+x_off,32+((i-20)*9)+y_off,0, StageInfo[i+1].totalCoins);
        if(StageInfo[i+1].maxCoins == StageInfo[i+1].totalCoins){Print (160+x_off,32+((i-20)*9)+y_off,2, "Perfect!");}
        if(StageInfo[i+1].maxCoins < StageInfo[i+1].totalCoins){Print (160+x_off,32+((i-20)*9)+y_off,1, "find all coins");}
      }
    }
    Print (16+x_off,224+y_off,0, "<<< Stages 1-20");
  }

/*
  // FPS
  Uint32 FPS_Counter;
  int TempFPS = (int) (SDL_GetTicks()-FPS_Counter);
  if(TempFPS < 1){TempFPS = 1;}
  Print(4+x_off,SCREENHEIGHT-20+y_off,0, "FPS:");
  PrintInt(60+x_off,SCREENHEIGHT-20+y_off,0, (int) (1000/TempFPS));
  FPS_Counter = SDL_GetTicks();
  // FPS
*/
  SDL_UpdateRect(DisplaySurface,0,0,0,0);
}


// ******************************************
// ******************************************
// ******************************************

void optionsscreen(int x_off, int y_off)
{
  getInput();
  OptionNumber = 19;
  SongNumber = 1;
  bool ExitOptions = false;
  SnowChanged = false;
  LevelsetChanged = false;
  draw_optionsscreen(x_off, y_off);

  while(!Key_1_pressed && !Key_ESCAPE_pressed && !ExitOptions)
  {
    getInput();
    if(Key_F12_pressed)  {ToggleFullscreen();}
    if(Key_RIGHT_pressed || Key_LEFT_pressed || Button_2_pressed  || Key_ENTER_pressed)
    {
      playSound(3);
      if(OptionNumber==0){Walljumps_enabled=!Walljumps_enabled;}
      if(OptionNumber==1){Stompattack_enabled=!Stompattack_enabled;}
      if(OptionNumber==2){Running_enabled=!Running_enabled;}

      if(OptionNumber==3)
      {
        if(Key_RIGHT_pressed)
        {
          if(Snow_enabled){Snow_enabled = false; Rain_enabled=true; SnowChanged = true;}
          else if(Rain_enabled){Snow_enabled = false; Rain_enabled=false; SnowChanged = true;}
          else if(!Rain_enabled && !Snow_enabled){Snow_enabled = true; Rain_enabled=false; SnowChanged = true;}
        }
        if(Key_LEFT_pressed)
        {
          if(Snow_enabled){Snow_enabled = false; Rain_enabled=false; SnowChanged = true;}
          else if(Rain_enabled){Snow_enabled = true; Rain_enabled=false; SnowChanged = true;}
          else if(!Rain_enabled && !Snow_enabled){Snow_enabled = false; Rain_enabled=true; SnowChanged = true;}
        }
      }

      if(OptionNumber==5)
      {
        if((Key_RIGHT_pressed || Button_2_pressed) && intStartLives <99){intStartLives++;}
        if(Key_LEFT_pressed && intStartLives>1){intStartLives--;}
      }
      if(OptionNumber==6)
      {
        if((Key_RIGHT_pressed || Button_2_pressed) && StartBonus <7){StartBonus++;}
        if(Key_LEFT_pressed && StartBonus>0){StartBonus--;}
      }
      if(OptionNumber==7)
      {
        if(Key_LEFT_pressed) {StartStage--;if(StartStage<0){StartStage=LASTSTAGE;}}
        if(Key_RIGHT_pressed || Button_2_pressed){StartStage++;if(StartStage>LASTSTAGE){StartStage=0;}}
      }
      if(OptionNumber==9)
      {
        if(Key_LEFT_pressed) {Mix_VolumeMusic(Mix_VolumeMusic(-1)-5); if(Mix_VolumeMusic(-1)<5){Mix_VolumeMusic(0);}}
        if(Key_RIGHT_pressed || Button_2_pressed){Mix_VolumeMusic(Mix_VolumeMusic(-1)+5);}
      }
      if(OptionNumber==10){PlayMusic=!PlayMusic;}

      if(OptionNumber==12)
      {
        if(Key_LEFT_pressed) {SongNumber--;if(SongNumber<1){SongNumber=6;}}
        if(Key_RIGHT_pressed || Button_2_pressed){SongNumber++;if(SongNumber>6){SongNumber=1;}}
      }
      if(OptionNumber==13)
      {
        Mix_FreeMusic(BackgroundMusic);  //free the music
        if(SystemNumber == 0)
        {
          if(SongNumber==1){iniValue = readFromINI("base/default/audio.ini", "Music", "Title");}
          if(SongNumber==2){iniValue = readFromINI("base/default/audio.ini", "Music", "Intro");}
          if(SongNumber==3){iniValue = readFromINI("base/default/audio.ini", "Music", "Ready");}
          if(SongNumber==4){iniValue = readFromINI("base/default/audio.ini", "Music", "Outdoors");}
          if(SongNumber==5){iniValue = readFromINI("base/default/audio.ini", "Music", "Indoors");}
          if(SongNumber==6){iniValue = readFromINI("base/default/audio.ini", "Music", "Highscore");}
        }
        if(SystemNumber == 1)
        {
          if(SongNumber==1){iniValue = readFromINI("base/c64/audio.ini", "Music", "Title");}
          if(SongNumber==2){iniValue = readFromINI("base/c64/audio.ini", "Music", "Intro");}
          if(SongNumber==3){iniValue = readFromINI("base/c64/audio.ini", "Music", "Ready");}
          if(SongNumber==4){iniValue = readFromINI("base/c64/audio.ini", "Music", "Outdoors");}
          if(SongNumber==5){iniValue = readFromINI("base/c64/audio.ini", "Music", "Indoors");}
          if(SongNumber==6){iniValue = readFromINI("base/c64/audio.ini", "Music", "Highscore");}
        }
        BackgroundMusic=Mix_LoadMUS(iniValue); //load in the music
        free(iniValue);
        if(PlayMusic){Mix_PlayMusic(BackgroundMusic,-1);} //play the music
      }
      if(OptionNumber==15)
      {
        if(Key_LEFT_pressed) {LevelSet--;  LevelsetChanged=true;if(LevelSet<0){LevelSet=1;}}
        if(Key_RIGHT_pressed || Button_2_pressed){LevelSet++; LevelsetChanged=true;if(LevelSet>1){LevelSet=0;}}
      }
      if(OptionNumber==17)
      {
        ToggleFullscreen();
      }
      if(OptionNumber==19)
      {
        ExitOptions=true;
      }
    }


    if(Key_DOWN_pressed){playSound(3);OptionNumber++; if(OptionNumber == 18 || OptionNumber == 16 || OptionNumber ==  14 || OptionNumber ==  11 || OptionNumber ==  8 || OptionNumber ==  4){OptionNumber++;}}
    if(Key_UP_pressed){playSound(3);OptionNumber--; if(OptionNumber == 18 || OptionNumber == 16 || OptionNumber ==  14 || OptionNumber ==  11 || OptionNumber ==  8 || OptionNumber ==  4){OptionNumber--;}}
    if(OptionNumber > 19){OptionNumber = 0;}
    if(OptionNumber < 0){OptionNumber = 19;}

    draw_optionsscreen(x_off, y_off);
  }
  getInput();
  if(!PlayMusic){Mix_HaltMusic();}

  if(LevelsetChanged)
  {
   // STAGE_NUMBER = 0;
   // TitleScreenMenuSelection = 0;
    loadStage();
  }

  if(SnowChanged && Snow_enabled){addOverlay(1);}
  if(SnowChanged && !Snow_enabled)
  {
    SDL_Surface* TempSurface;
    SDL_Rect TempRect;
    TempRect.x=0;
    TempRect.y=0;
    Uint32 CKColor = SDL_MapRGB(DisplaySurface->format,255,0,255);
    if(ScaleValue!=2 && SystemNumber==0)
    {
      TempSurface = IMG_Load("base/default/tiles.png");
      TilesSurface = SDL_DisplayFormat(TempSurface);
      SDL_FreeSurface(TempSurface);
      TempRect.h=TilesSurface->h*ScaleValue;
      TempRect.w=TilesSurface->w*ScaleValue;
      TilesSurface = ScaleSurface(TilesSurface, TilesSurface->w*ScaleValue, TilesSurface->h*ScaleValue);
      SDL_SetColorKey(TilesSurface, SDL_SRCCOLORKEY, CKColor);
    }
    if(ScaleValue==2 && SystemNumber==0)
    {
      TempSurface = IMG_Load("base/default/tiles_hr.png");
      TilesSurface = SDL_DisplayFormat(TempSurface);
      SDL_FreeSurface(TempSurface);
      SDL_SetColorKey(TilesSurface, SDL_SRCCOLORKEY, CKColor);
    }
    if(SystemNumber!=0)
    {
      TempSurface = IMG_Load("base/c64/tiles.png");
      TilesSurface = SDL_DisplayFormat(TempSurface);
      SDL_FreeSurface(TempSurface);
      TempRect.h=TilesSurface->h*ScaleValue;
      TempRect.w=TilesSurface->w*ScaleValue;
      TilesSurface = ScaleSurface(TilesSurface, TilesSurface->w*ScaleValue, TilesSurface->h*ScaleValue);
      SDL_SetColorKey(TilesSurface, SDL_SRCCOLORKEY, CKColor);
    }
  }
  leavescreen(1);
}

// ******************************************
// ******************************************
// ******************************************

void draw_optionsscreen(int x_off, int y_off)
{
// draw what's behind the info screen
    drawBackground(StageBackgroundColour, 0, 0);
    drawTiles();
    drawPlatforms();
    drawCoin();
    //drawPlayer();
    drawEnemy();
    drawBonus();
    if(Snow_enabled){drawSnow();}
    if(Rain_enabled){drawRain();}
    //drawStats(0,0);
// draw what's behind the info screen

  drawBackground(2, x_off, y_off);

  int i;
  Print (16+x_off,8+y_off,1, "options...");

  if(Walljumps_enabled) {Print (40+x_off,32+y_off,0, "   Walljumps");}
  if(!Walljumps_enabled){Print (40+x_off,32+y_off,0, "#   Walljumps");}

  if(Stompattack_enabled) {Print (40+x_off,41+y_off,0, "   stomp attack");}
  if(!Stompattack_enabled){Print (40+x_off,41+y_off,0, "#   stomp attack");}

  if(Running_enabled) {Print (40+x_off,50+y_off,0, "   running");}
  if(!Running_enabled){Print (40+x_off,50+y_off,0, "#   running");}

  Print (40+x_off,59+y_off,0, "< > Weather:");
  if(Snow_enabled) {Print (48+x_off,59+y_off,1, "1           SNOW");}
  if(Rain_enabled) {Print (48+x_off,59+y_off,1, "2           RAIN");}
  if(!Rain_enabled && !Snow_enabled) {Print (48+x_off,59+y_off,1, "0           none (sunny)");}


  Print (40+x_off,68+y_off,2, "=============================");

  PrintInt (40+x_off,77+y_off,1, intStartLives);
  if(intStartLives==1){Print (40+x_off,77+y_off,0, "    start live");}
  if(intStartLives>1){Print (40+x_off,77+y_off,0, "    start lives");}

  PrintInt (40+x_off,86+y_off,1, StartBonus);
  if(StartBonus==0){Print (40+x_off,86+y_off,0, "    Start bonus (none)");}
  if(StartBonus==1){Print (40+x_off,86+y_off,0, "    Start bonus (punked)");}
  if(StartBonus==2){Print (40+x_off,86+y_off,0, "    Start bonus (fire 1)");}
  if(StartBonus==3){Print (40+x_off,86+y_off,0, "    Start bonus (fire 2)");}
  if(StartBonus==4){Print (40+x_off,86+y_off,0, "    Start bonus (fire auto aim)");}
  if(StartBonus==5){Print (40+x_off,86+y_off,0, "    Start bonus (not implemented)");}
  if(StartBonus==6){Print (40+x_off,86+y_off,0, "    Start bonus (not implemented)");}
  if(StartBonus==7){Print (40+x_off,86+y_off,0, "    Start bonus (flame resistance)");}

  PrintInt (40+x_off,95+y_off,1, StartStage);
  Print (40+x_off,95+y_off,0, "    Start stage");

  Print (40+x_off,104+y_off,2, "=============================");

  PrintInt (40+x_off,113+y_off,1, Mix_VolumeMusic(-1));
  Print (40+x_off,113+y_off,0, "    music volume (0-128)");

  if(PlayMusic) {Print (40+x_off,122+y_off,0, "   play music");}
  if(!PlayMusic){Print (40+x_off,122+y_off,0, "#   play music");}

  Print (40+x_off,131+y_off,2, "=============================");

  PrintInt (48+x_off,140+y_off,1, SongNumber);
  Print (40+x_off,140+y_off,0, "< > Songtitle:");
  if(SongNumber==1){Print (40+x_off,140+y_off,1, "               Title");}
  if(SongNumber==2){Print (40+x_off,140+y_off,1, "               Intro");}
  if(SongNumber==3){Print (40+x_off,140+y_off,1, "               Ready");}
  if(SongNumber==4){Print (40+x_off,140+y_off,1, "               Outdoors");}
  if(SongNumber==5){Print (40+x_off,140+y_off,1, "               Indoors");}
  if(SongNumber==6){Print (40+x_off,140+y_off,1, "               Highscore");}
  Print (40+x_off,149+y_off,0, "==> load and play this song");
  Print (40+x_off,158+y_off,2, "=============================");
  Print (40+x_off,167+y_off,0, "    Levelset:");
  if(LevelSet==0){Print (40+x_off,167+y_off,1, "              Classic");}
  if(LevelSet==1){Print (40+x_off,167+y_off,1, "              New");}
  Print (40+x_off,176+y_off,2, "=============================");
  if(FullscreenMode){Print (40+x_off,185+y_off,0, "   fullscreen");}
  if(!FullscreenMode){Print (40+x_off,185+y_off,0, "#   fullscreen");}
  Print (40+x_off,194+y_off,2, "=============================");
  Print (40+x_off,203+y_off,0, "             OK");

  if(OptionNumber<19) {Print(8+x_off,32+y_off+OptionNumber*9,1,">>>");}
  if(OptionNumber==19){Print(8+x_off,32+y_off+OptionNumber*9,1,"              >>>  <<<");}

  SDL_UpdateRect(DisplaySurface,0,0,0,0);
}


// ******************************************
// ******************************************
// ******************************************

void creditsscreen(int x_off, int y_off)
{
  getInput();
  draw_creditsscreen(x_off, y_off);
  while(!Key_1_pressed && !Key_ESCAPE_pressed && !Button_2_pressed  && !Key_ENTER_pressed)
  {
    Animation();
    getInput();
    draw_creditsscreen(x_off, y_off);
  }
  getInput();
  leavescreen(2);
}

// ******************************************
// ******************************************
// ******************************************

void draw_creditsscreen(int x_off, int y_off)
{
// draw what's behind the info screen
    drawBackground(StageBackgroundColour, 0, 0);
    drawTiles();
    drawPlatforms();
    drawCoin();
    //drawPlayer();
    drawEnemy();
    drawBonus();
    if(Snow_enabled){drawSnow();}
    if(Rain_enabled){drawRain();}
    //drawStats(0,0);
// draw what's behind the info screen

  drawBackground(2, x_off, y_off);

  int i;
  Print(16+x_off,8+y_off,1,"CREDITS");
  Print(16+x_off,26+y_off,1,"The Great Giana Sisters (C64)");
  Print(16+x_off,36+y_off,0,"Written by: Armin Gessert");
  Print(16+x_off,46+y_off,0,"Artwork by: Manfred Trenz");
  Print(16+x_off,56+y_off,0,"Music by:   Chris Huelsbeck");
  Print(16+x_off,66+y_off,0,"1987 Softgold/Rainbow Arts");

  Print(16+x_off,96+y_off,1,"OpenGGS");
  Print(16+x_off,106+y_off,0,"Written by:      RomanH");
  Print(16+x_off,116+y_off,0,"Artwork by:      RomanH (default)");
  Print(16+x_off,126+y_off,0,"                 ...... (high res)");
  Print(16+x_off,136+y_off,0,"Soundeffects by: RomanH");
  Print(16+x_off,146+y_off,0,"Music by:        Alejandro Altimari");
  Print(16+x_off,156+y_off,0,"                 (puch666)");
  Print(16+x_off,186+y_off,0,"Thanks to everybody involved in");
  Print(16+x_off,196+y_off,0,"porting the game to different");
  Print(16+x_off,206+y_off,0,"plattforms!!!");

  SDL_UpdateRect(DisplaySurface,0,0,0,0);
}

// ******************************************
// ******************************************
// ******************************************

