#include "_variables.h"

int EnemyTopLeft;
int EnemyTopRight;
int EnemyBottomLeft;
int EnemyBottomRight;

int TileEnemyTopLeftX;
int TileEnemyTopRightX;
int TileEnemyBottomLeftX;
int TileEnemyBottomRightX;
int TileEnemyTopLeftY;
int TileEnemyTopRightY;
int TileEnemyBottomLeftY;
int TileEnemyBottomRightY;

int TileEnemyGroundLeftX;
int TileEnemyGroundRightX;
int TileEnemyGroundLeftY;
int TileEnemyGroundRightY;

int EnemyKilled;

void moveEnemies()
{
  EnemyKilled = 0; //check whether an enemy was killed in this cicle
  for(int i = 0;i<ENEMIESPERSTAGE+1;i++)
  {
    // moving walking enemies that stop at edges
    if(EnemyFlying[Enemy[i].type] == 0 && Enemy[i].inUse == 1 && Enemy[i].alive == 1 && EnemyPath[Enemy[i].type] == 0 && Enemy[i].x + STAGE_XPos < 400)
    {
      EnemyPosition(i);
      if(TileTypes[TileArray[TileEnemyGroundLeftX][TileEnemyGroundLeftY]].solid == 0 
      && TileTypes[TileArray[TileEnemyGroundRightX][TileEnemyGroundRightY]].solid == 0)
      {
        for(int Repeater = 0; Repeater < MovementSpeed; Repeater++)
        {
          EnemyPosition(i);
          if(TileTypes[TileArray[TileEnemyGroundLeftX][TileEnemyGroundLeftY]].solid == 0 
          && TileTypes[TileArray[TileEnemyGroundRightX][TileEnemyGroundRightY]].solid == 0)
          {
            Enemy[i].y = Enemy[i].y + 1; // drops enemy because there is no ground...
          }
        }
      }
	  else
      {
        // turn at left stage end
        if(Enemy[i].x < 0){Enemy[i].direction = 1;}
        // turn at right stage end
        if(Enemy[i].x > (256*8)-Enemy[i].w/ScaleValue){Enemy[i].direction = 0;}
        // turn when hitting a block on the left or reaching the edge
        if(TileTypes[TileArray[TileEnemyTopLeftX][TileEnemyTopLeftY]].solid == 1){Enemy[i].direction = 1;}
        if(TileTypes[TileArray[TileEnemyBottomLeftX][TileEnemyBottomLeftY]].solid == 1){Enemy[i].direction = 1;}
		if(TileTypes[TileArray[TileEnemyGroundLeftX][TileEnemyGroundLeftY]].solid == 0){Enemy[i].direction = 1;}
        // turn when hitting a block on the right or reaching the edge
        if(TileTypes[TileArray[TileEnemyTopRightX][TileEnemyTopRightY]].solid == 1){Enemy[i].direction = 0;}
        if(TileTypes[TileArray[TileEnemyBottomRightX][TileEnemyBottomRightY]].solid == 1){Enemy[i].direction = 0;}
		if(TileTypes[TileArray[TileEnemyGroundRightX][TileEnemyGroundRightY]].solid == 0){Enemy[i].direction = 0;}

		if(Enemy[i].direction == 0){Enemy[i].x = Enemy[i].x - MovementSpeed;}
		if(Enemy[i].direction == 1){Enemy[i].x = Enemy[i].x + MovementSpeed;}
      }
	}

    // moving walking enemies that DON'T stop at edges
	if(EnemyFlying[Enemy[i].type] == 0 && Enemy[i].inUse == 1 && Enemy[i].alive == 1 && EnemyPath[Enemy[i].type] == 1 && Enemy[i].x + STAGE_XPos < 400)
	{
      EnemyPosition(i);
      if(TileTypes[TileArray[TileEnemyGroundLeftX][TileEnemyGroundLeftY]].solid == 0 
      && TileTypes[TileArray[TileEnemyGroundRightX][TileEnemyGroundRightY]].solid == 0)
      {
        for(int Repeater = 0; Repeater < MovementSpeed; Repeater++)
		{
          EnemyPosition(i);
          if(TileTypes[TileArray[TileEnemyGroundLeftX][TileEnemyGroundLeftY]].solid == 0 
          && TileTypes[TileArray[TileEnemyGroundRightX][TileEnemyGroundRightY]].solid == 0)
          {
            Enemy[i].y = Enemy[i].y + 1; // drops enemy because there is no ground...
          }
		}
      }
	  else
      {
        // turn at left stage end
        if(Enemy[i].x < 0){Enemy[i].direction = 1;}
        // turn at right stage end
        if(Enemy[i].x > (256*8)-Enemy[i].w){Enemy[i].direction = 0;}
        // turn when hitting a block on the left or reaching the edge
        if(TileTypes[TileArray[TileEnemyTopLeftX][TileEnemyTopLeftY]].solid == 1){Enemy[i].direction = 1;}
        if(TileTypes[TileArray[TileEnemyBottomLeftX][TileEnemyBottomLeftY]].solid == 1){Enemy[i].direction = 1;}
        // turn when hitting a block on the right or reaching the edge
        if(TileTypes[TileArray[TileEnemyTopRightX][TileEnemyTopRightY]].solid == 1){Enemy[i].direction = 0;}
        if(TileTypes[TileArray[TileEnemyBottomRightX][TileEnemyBottomRightY]].solid == 1){Enemy[i].direction = 0;}

		if(Enemy[i].direction == 0){Enemy[i].x = Enemy[i].x - MovementSpeed;}
		if(Enemy[i].direction == 1){Enemy[i].x = Enemy[i].x + MovementSpeed;}
      }
	}

    // moving flying enemies...
	if(EnemyFlying[Enemy[i].type] == 1 && Enemy[i].inUse == 1 && Enemy[i].alive == 1 && EnemyPath[Enemy[i].type] == 0 && Enemy[i].x + STAGE_XPos < 400)
	{
		EnemyPosition(i);
		if(Enemy[i].x < 0){Enemy[i].direction = 1;}
		if(Enemy[i].x > (256*8)-Enemy[i].w){Enemy[i].direction = 0;}

		if(TileTypes[TileArray[TileEnemyTopLeftX][TileEnemyTopLeftY]].solid == 1){Enemy[i].direction = 1;}
		if(TileTypes[TileArray[TileEnemyTopRightX][TileEnemyTopRightY]].solid == 1){Enemy[i].direction = 0;}

		if(TileTypes[TileArray[TileEnemyBottomLeftX] [TileEnemyBottomLeftY]].solid == 1){Enemy[i].direction = 1;}
		if(TileTypes[TileArray[TileEnemyBottomRightX][TileEnemyBottomRightY]].solid == 1){Enemy[i].direction = 0;}

		if(Enemy[i].x < 1){Enemy[i].direction = 1;}

		if(Enemy[i].direction == 0){Enemy[i].x = Enemy[i].x - MovementSpeed;}
		if(Enemy[i].direction == 1){Enemy[i].x = Enemy[i].x + MovementSpeed;}
	}


    // movement of ball
    if(EnemyFlying[Enemy[i].type] == 0 && 
       Enemy[i].inUse == 1 && 
       Enemy[i].alive == 1 && 
       EnemyPath[Enemy[i].type] == 2)
    {
      EnemyPosition(i);
      Enemy[i].movementFrame++;
      if(Enemy[i].movementFrame > 31){Enemy[i].movementFrame=0;}
      if(Enemy[i].movementFrame < 16){Enemy[i].y--;Enemy[i].y--;}
      if(Enemy[i].movementFrame > 15){Enemy[i].y++;Enemy[i].y++;}
    }


    // movement of dragon
    if(EnemyFlying[Enemy[i].type] == 0 && 
       Enemy[i].inUse == 1 && 
       Enemy[i].alive == 1 && 
       EnemyPath[Enemy[i].type] == 3)
    {
      EnemyPosition(i);
      Enemy[i].movementFrame++;
      if(Enemy[i].movementFrame > 101){Enemy[i].movementFrame=0;}
      if(Enemy[i].movementFrame < 26){Enemy[i].y--;}
      if(Enemy[i].movementFrame > 25 && Enemy[i].movementFrame < 51){Enemy[i].x--;Enemy[i].x--;}
      if(Enemy[i].movementFrame > 50 && Enemy[i].movementFrame < 76){Enemy[i].x++;Enemy[i].x++;}
      if(Enemy[i].movementFrame > 75){Enemy[i].y++;}
    }

    // movement of spider
    if(EnemyFlying[Enemy[i].type] == 0 && 
       Enemy[i].inUse == 1 && 
       Enemy[i].alive == 1 && 
       EnemyPath[Enemy[i].type] == 4  && 
       Enemy[i].x + STAGE_XPos < 325)
    {
      EnemyPosition(i);
      Enemy[i].movementFrame++;
      if(Enemy[i].movementFrame > 65){Enemy[i].movementFrame=0;}
      if(Enemy[i].movementFrame < 41){Enemy[i].x--;Enemy[i].x--;}
      if(Enemy[i].movementFrame > 40){Enemy[i].x++;}
    }

    // movement of fish
    if(EnemyFlying[Enemy[i].type] == 0 && 
       Enemy[i].inUse == 1 && 
       Enemy[i].alive == 1 && 
       EnemyPath[Enemy[i].type] == 5  && 
       Enemy[i].x + STAGE_XPos < 325)
    {
      EnemyPosition(i);
      Enemy[i].movementFrame++;
      if(Enemy[i].movementFrame > 130){Enemy[i].movementFrame=0;}
      if(Enemy[i].movementFrame < 60){Enemy[i].y++;Enemy[i].y++;}
      if(Enemy[i].movementFrame > 70){Enemy[i].y--;Enemy[i].y--;}
    }


    // making sure dead enemies drop if they have no ground beneath them
    if(Enemy[i].inUse == 1 && Enemy[i].alive == 0 && Enemy[i].x + STAGE_XPos < 400 && (Enemy[i].type != 12 || Enemy[i].type != 13 || Enemy[i].type != 16))
    {
      EnemyPosition(i);
      if(TileTypes[TileArray[TileEnemyGroundLeftX][TileEnemyGroundLeftY]].solid == 0 
      && TileTypes[TileArray[TileEnemyGroundRightX][TileEnemyGroundRightY]].solid == 0)
      {
        for(int Repeater = 0; Repeater < MovementSpeed; Repeater++)
		{
          EnemyPosition(i);
          if(TileTypes[TileArray[TileEnemyGroundLeftX][TileEnemyGroundLeftY]].solid == 0 
          && TileTypes[TileArray[TileEnemyGroundRightX][TileEnemyGroundRightY]].solid == 0)
          {
            Enemy[i].y = Enemy[i].y + 1; // drops enemy because there is no ground...
          }
		}
      }
    }

    // drop dragons and spiders through the ground...
    if(Enemy[i].inUse == 1 && Enemy[i].alive == 0 && Enemy[i].x + STAGE_XPos < 400 && (Enemy[i].type == 12 || Enemy[i].type == 13))
    {
       if(Enemy[i].y < 240){Enemy[i].y = Enemy[i].y + 1;} // drops enemy because there is no ground...
    }

  }
  if(EnemyKilled == 1){Player.jumpcounter = 78;}
}





void EnemyPosition(int EnemyNumber)
{
  Enemy[EnemyNumber].w = EnemySrcRightRect[Enemy[EnemyNumber].type][1].w/ScaleValue;
  Enemy[EnemyNumber].h = EnemySrcRightRect[Enemy[EnemyNumber].type][1].h/ScaleValue;

  TileEnemyTopLeftX = ((Enemy[EnemyNumber].x) / 8);
  TileEnemyTopLeftY = ((Enemy[EnemyNumber].y) / 8);
  TileEnemyTopRightX = ((Enemy[EnemyNumber].x + (Enemy[EnemyNumber].w)) / 8);
  TileEnemyTopRightY = ((Enemy[EnemyNumber].y) / 8);

  TileEnemyBottomLeftX = ((Enemy[EnemyNumber].x) / 8);
  TileEnemyBottomLeftY = ((Enemy[EnemyNumber].y + (Enemy[EnemyNumber].h/ScaleValue)-1) / 8);
  TileEnemyBottomRightX = ((Enemy[EnemyNumber].x + (Enemy[EnemyNumber].w)) / 8);
  TileEnemyBottomRightY = ((Enemy[EnemyNumber].y + (Enemy[EnemyNumber].h/ScaleValue)-1) / 8);

  TileEnemyGroundLeftX = ((Enemy[EnemyNumber].x) / 8);
  TileEnemyGroundLeftY = ((Enemy[EnemyNumber].y + EnemySrcRightRect[Enemy[EnemyNumber].type][1].h/ScaleValue) / 8);
  TileEnemyGroundRightX = ((Enemy[EnemyNumber].x + EnemySrcRightRect[Enemy[EnemyNumber].type][1].w/ScaleValue) / 8);
  TileEnemyGroundRightY = ((Enemy[EnemyNumber].y + EnemySrcRightRect[Enemy[EnemyNumber].type][1].h/ScaleValue) / 8);


  //if(Enemy[EnemyNumber].type==8)
  {
  TileEnemyGroundLeftX = ((Enemy[EnemyNumber].x+5) / 8);
  TileEnemyGroundRightX = ((Enemy[EnemyNumber].x + (EnemySrcRightRect[Enemy[EnemyNumber].type][1].w-5)/ScaleValue) / 8);
  }


  if(Enemy[EnemyNumber].type != 7 && Enemy[EnemyNumber].type != 12 && Enemy[EnemyNumber].type != 13 && Enemy[EnemyNumber].type != 14 && Enemy[EnemyNumber].type != 15 && Enemy[EnemyNumber].alive == true && Player.x > Enemy[EnemyNumber].x && Player.x < Enemy[EnemyNumber].x + Enemy[EnemyNumber].w)
  {
    if(Player.y > Enemy[EnemyNumber].y && Player.y < Enemy[EnemyNumber].y + Enemy[EnemyNumber].h)
    {
      if(Player.onground){PlayerDied = true;}
      if(!Player.onground && !StompAttack){Enemy[EnemyNumber].alive = false; Player.jumpcounter = 78; intPoints += POINTSPERENEMY;}
      if(!Player.onground && StompAttack){Enemy[EnemyNumber].alive = false; Player.jumpcounter = 78; intPoints += POINTSPERENEMY; stompeffect();}
      if(Player.y > Enemy[EnemyNumber].y){PlayerDied = true;}
    }
    if(Player.y + Player.h/ScaleValue - 3 > Enemy[EnemyNumber].y && Player.y + Player.h/ScaleValue - 3 < Enemy[EnemyNumber].y + Enemy[EnemyNumber].h)
    {
      if(Player.onground){PlayerDied = true;}
      if(!Player.onground && !StompAttack){Enemy[EnemyNumber].alive = false; Player.jumpcounter = 78; intPoints += POINTSPERENEMY;}
      if(!Player.onground && StompAttack){Enemy[EnemyNumber].alive = false; Player.jumpcounter = 78; intPoints += POINTSPERENEMY; stompeffect();}
      if(Player.y > Enemy[EnemyNumber].y){PlayerDied = true;}
    }
  }

  if(Enemy[EnemyNumber].type != 7 && Enemy[EnemyNumber].type != 12 && Enemy[EnemyNumber].type != 13 && Enemy[EnemyNumber].type != 14 && Enemy[EnemyNumber].type != 15 && Enemy[EnemyNumber].alive == true && Player.x + Player.w/ScaleValue > Enemy[EnemyNumber].x && Player.x + Player.w/ScaleValue < Enemy[EnemyNumber].x + Enemy[EnemyNumber].w)
  {
    if(Player.y > Enemy[EnemyNumber].y && Player.y < Enemy[EnemyNumber].y + Enemy[EnemyNumber].h)
    {
      if(Player.onground || Player.jumpcounter > 0){PlayerDied = true;}
      if(!Player.onground && !StompAttack){Enemy[EnemyNumber].alive = false; EnemyKilled = true; intPoints += POINTSPERENEMY;}
      if(!Player.onground && StompAttack){Enemy[EnemyNumber].alive = false; EnemyKilled = true; intPoints += POINTSPERENEMY; stompeffect();}
      if(Player.y > Enemy[EnemyNumber].y){PlayerDied = true;}
    }
    if(Player.y + Player.h/ScaleValue - 3 > Enemy[EnemyNumber].y && Player.y + Player.h/ScaleValue - 3 < Enemy[EnemyNumber].y + Enemy[EnemyNumber].h)
    {
      if(Player.onground || Player.jumpcounter > 0){PlayerDied = true;}
      if(!Player.onground && !StompAttack){Enemy[EnemyNumber].alive = false; EnemyKilled = true; intPoints += POINTSPERENEMY;}
      if(!Player.onground && StompAttack){Enemy[EnemyNumber].alive = false; EnemyKilled = true; intPoints += POINTSPERENEMY; stompeffect();}
      if(Player.y > Enemy[EnemyNumber].y){PlayerDied = true;}
    }
  }

  // SHOOTING ENEMIES
  if(Enemy[EnemyNumber].alive == true && BulletPosX > Enemy[EnemyNumber].x && BulletPosX < Enemy[EnemyNumber].x + Enemy[EnemyNumber].w)
  {
    if(BulletPosY > Enemy[EnemyNumber].y && BulletPosY < Enemy[EnemyNumber].y + Enemy[EnemyNumber].h)
    {
      BulletPosX = -8*ScaleValue;
      BulletPosY = -8*ScaleValue;
      BulletActive = false;
      if(Enemy[EnemyNumber].type != 7  && Enemy[EnemyNumber].type != 12 && Enemy[EnemyNumber].type != 13 && Enemy[EnemyNumber].type != 14 && Enemy[EnemyNumber].type != 15) // can't kill a ball, piranha, pipe...
      {
        // bulletExplosionStart();
        Enemy[EnemyNumber].alive = false;
        intPoints += POINTSPERENEMY;
      }
      if(Enemy[EnemyNumber].type == 12 || Enemy[EnemyNumber].type == 13) // shooting dragons and spiders
      {
        BigEnemyLiveCounter--;
        if(BigEnemyLiveCounter<1)
        {
          Enemy[EnemyNumber].alive = false;
          intPoints += POINTSPERENEMY;
        }
      }
    }
  }
  // SHOOTING ENEMIES

  if(Enemy[EnemyNumber].type == 7 || Enemy[EnemyNumber].type == 12 || Enemy[EnemyNumber].type == 13 || Enemy[EnemyNumber].type == 14 || Enemy[EnemyNumber].type == 15)
  {
    if(Player.x + Player.w/ScaleValue > Enemy[EnemyNumber].x &&
       Player.x < Enemy[EnemyNumber].x + Enemy[EnemyNumber].w)
    {
      if(Player.y + (Player.h/2)/ScaleValue > Enemy[EnemyNumber].y && 
         Player.y < Enemy[EnemyNumber].y + Enemy[EnemyNumber].h)
      {
        PlayerDied =1;
      }
    }
  }
  if(Enemy[EnemyInRadar].alive == 0){EnemyInRadar = -1;}
  if(portalReached){PlayerDied = false;}
}


void FireCircle(int CenterX, int CenterY)
{
  int radius; //= multiplicated by 10!
  int x;
  // int Positions[6];

  if(CenterX-Player.x<380 && CenterX - Player.x > -380)
  {
  SDL_Rect BulletRect;
  BulletRect.w = 8;
  BulletRect.h = 8;
  // change here to create patterns...
  // Positions[0] = RotationCounter_32-0;if(Positions[4]<0){Positions[4]+=32;}
  // Positions[1] = RotationCounter_32-0;if(Positions[1]<0){Positions[1]+=32;}
  // Positions[2] = RotationCounter_32-0;if(Positions[2]<0){Positions[2]+=32;}
  // Positions[3] = RotationCounter_32-0;if(Positions[3]<0){Positions[3]+=32;}
  // Positions[4] = RotationCounter_32-0;if(Positions[4]<0){Positions[4]+=32;}
  // Positions[5] = RotationCounter_32-0;if(Positions[5]<0){Positions[5]+=32;}
  // change here to create patterns...

  for(x=0;x<6;x++)
  {
    radius = x;
    BulletRect.x = (int(CirclePosX[RotationCounter_32]*radius+CenterX));
    BulletRect.y = int(CirclePosY[RotationCounter_32]*radius+CenterY);

    // change here to create patterns...
    // BulletRect.x = (int(CirclePosX[Positions[x]]*radius+CenterX));
    // BulletRect.y = int(CirclePosY[Positions[x]]*radius+CenterY);
    // change here to create patterns...

    if(
     Player.y+2*ScaleValue > BulletRect.y &&
     Player.y+2*ScaleValue < BulletRect.y + BulletRect.h &&
     Player.x+2*ScaleValue > BulletRect.x &&
     Player.x+2*ScaleValue < BulletRect.x + BulletRect.w)
    {PlayerDied = true;}

    if(
     Player.y-2*ScaleValue + (Player.h/ScaleValue) > BulletRect.y &&
     Player.y-2*ScaleValue + (Player.h/ScaleValue) < BulletRect.y + BulletRect.h &&
     Player.x-2*ScaleValue + (Player.w/ScaleValue) > BulletRect.x &&
     Player.x-2*ScaleValue + (Player.w/ScaleValue) < BulletRect.x + BulletRect.w)
    {PlayerDied = true;}

    if(
     Player.y+2*ScaleValue > BulletRect.y &&
     Player.y+2*ScaleValue < BulletRect.y + BulletRect.h &&
     Player.x-2*ScaleValue + (Player.w/ScaleValue) > BulletRect.x &&
     Player.x-2*ScaleValue + (Player.w/ScaleValue) < BulletRect.x + BulletRect.w)
    {PlayerDied = true;}

    if(
     Player.y-2*ScaleValue + (Player.h/ScaleValue) > BulletRect.y &&
     Player.y-2*ScaleValue + (Player.h/ScaleValue) < BulletRect.y + BulletRect.h &&
     Player.x+2*ScaleValue > BulletRect.x &&
     Player.x+2*ScaleValue < BulletRect.x + BulletRect.w)
    {PlayerDied = true;}

//     Print(Player.x+STAGE_XPos, Player.y,1,"x");
//     Print(Player.x + (Player.w/ScaleValue) +STAGE_XPos, Player.y + (Player.h/ScaleValue),1,"x");
/*
    PrintInt (0,56, 0, Player.x);
    PrintInt (0,64+x*8, 0, BulletRect.x - STAGE_XPos);
    PrintInt (40,56, 0, Player.y);
    PrintInt (40,64+x*8, 0, BulletRect.y);
*/
    BulletRect.x = (BulletRect.x+STAGE_XPos)*ScaleValue; //(STAGE_XPos + BulletPosX-4)*ScaleValue;
    BulletRect.y = BulletRect.y*ScaleValue; //(BulletPosY-4)*ScaleValue;
    SDL_BlitSurface(TilesSurface,&BulletSrcRect[BulletAnimationNumber],DisplaySurface,&BulletRect);

  }
  }
}
