#include "_variables.h"

PlayableCharacter Player;

SDL_Rect BulletSrcRect[4];
SDL_Rect BulletExplosionSrcRect[2];
int BulletPosX, BulletPosY;
bool BulletDirH = 1;
bool BulletDirV = 1;

SDL_Rect PlayerRightSrcRect[4];
SDL_Rect PlayerLeftSrcRect[4];
SDL_Rect PlayerJumpRightSrcRect;
SDL_Rect PlayerJumpLeftSrcRect;
SDL_Rect PlayerTurnRightSrcRect;
SDL_Rect PlayerTurnLeftSrcRect;
SDL_Rect PlayerDeadSrcRect;

SDL_Rect PlayerPunkRightSrcRect[4];
SDL_Rect PlayerPunkLeftSrcRect[4];
SDL_Rect PlayerPunkJumpRightSrcRect;
SDL_Rect PlayerPunkJumpLeftSrcRect;
SDL_Rect PlayerPunkTurnRightSrcRect;
SDL_Rect PlayerPunkTurnLeftSrcRect;

SDL_Rect PlayerPlaneSrcRect;

SDL_Rect PlayerMorphSrcRect[2];

int WalkAnimationCounter = 0;
int WalkAnimationNumber = 0;
bool PlayerDied = false;


void definePlayer()
{
  // fprintf(stdout,"\nattempting to define Player...\n");
  int i;
  for(i=0;i<3;i++)
  {
    /*Player standing/walking to the right */
    PlayerRightSrcRect[i].x = i*24*ScaleValue;
    PlayerRightSrcRect[i].y = 0*ScaleValue;
    PlayerRightSrcRect[i].w = 15*ScaleValue;
    PlayerRightSrcRect[i].h = 21*ScaleValue;

    /*Player standing/walking to the left */
    PlayerLeftSrcRect[i].x = i*24*ScaleValue;
    PlayerLeftSrcRect[i].y = 24*ScaleValue;
    PlayerLeftSrcRect[i].w = 15*ScaleValue;
    PlayerLeftSrcRect[i].h = 21*ScaleValue;
    // C64 player dimensions
    if(SystemNumber==2){PlayerRightSrcRect[i].w = 16*ScaleValue;}
    if(SystemNumber==2){PlayerLeftSrcRect[i].w = 16*ScaleValue;}
    // C64 player dimensions
  }

  // C64 player dimensions
  if(SystemNumber==2){PlayerRightSrcRect[0].h = 22*ScaleValue;}
  if(SystemNumber==2){PlayerRightSrcRect[1].h = 23*ScaleValue;}
  if(SystemNumber==2){PlayerRightSrcRect[2].h = 23*ScaleValue;}
  if(SystemNumber==2){PlayerLeftSrcRect[0].h = 22*ScaleValue;}
  if(SystemNumber==2){PlayerLeftSrcRect[1].h = 23*ScaleValue;}
  if(SystemNumber==2){PlayerLeftSrcRect[2].h = 23*ScaleValue;}
  // C64 player dimensions
		
  /*Player jumping to the right */
  PlayerJumpRightSrcRect.x = 72*ScaleValue;
  PlayerJumpRightSrcRect.y = 0*ScaleValue;
  PlayerJumpRightSrcRect.w = 21*ScaleValue;
  PlayerJumpRightSrcRect.h = 21*ScaleValue;
  // C64 player dimensions
  if(SystemNumber==2){PlayerJumpRightSrcRect.w = 20*ScaleValue;}
  if(SystemNumber==2){PlayerJumpRightSrcRect.h = 22*ScaleValue;}
  // C64 player dimensions

  /*Player jumping to the left */
  PlayerJumpLeftSrcRect.x = 72*ScaleValue;
  PlayerJumpLeftSrcRect.y = 24*ScaleValue;
  PlayerJumpLeftSrcRect.w = 21*ScaleValue;
  PlayerJumpLeftSrcRect.h = 21*ScaleValue;
  // C64 player dimensions
  if(SystemNumber==2){PlayerJumpLeftSrcRect.w = 20*ScaleValue;}
  if(SystemNumber==2){PlayerJumpLeftSrcRect.h = 22*ScaleValue;}
  // C64 player dimensions

  /*Player turning to the right */
  PlayerTurnRightSrcRect.x = 96*ScaleValue;
  PlayerTurnRightSrcRect.y = 0*ScaleValue;
  PlayerTurnRightSrcRect.w = 16*ScaleValue;
  PlayerTurnRightSrcRect.h = 21*ScaleValue;
  // C64 player dimensions
  if(SystemNumber==2){PlayerTurnRightSrcRect.w = 16*ScaleValue;}
  if(SystemNumber==2){PlayerTurnRightSrcRect.h = 22*ScaleValue;}
  // C64 player dimensions

  /*Player turning to the left */
  PlayerTurnLeftSrcRect.x = 96*ScaleValue;
  PlayerTurnLeftSrcRect.y = 24*ScaleValue;
  PlayerTurnLeftSrcRect.w = 16*ScaleValue;
  PlayerTurnLeftSrcRect.h = 21*ScaleValue;
  // C64 player dimensions
  if(SystemNumber==2){PlayerTurnLeftSrcRect.w = 16*ScaleValue;}
  if(SystemNumber==2){PlayerTurnLeftSrcRect.h = 22*ScaleValue;}
  // C64 player dimensions

  for(i=0;i<3;i++)
  {
    /*PunkPlayer standing/walking to the right */
    PlayerPunkRightSrcRect[i].x = i*24*ScaleValue;
    PlayerPunkRightSrcRect[i].y = 48*ScaleValue;
    PlayerPunkRightSrcRect[i].w = 19*ScaleValue;
    PlayerPunkRightSrcRect[i].h = 21*ScaleValue;
    // C64 player dimensions
    if(SystemNumber==2){PlayerPunkRightSrcRect[i].w = 22*ScaleValue;}
    if(SystemNumber==2){PlayerPunkRightSrcRect[i].h = 23*ScaleValue;}
    // C64 player dimensions

    /*PunkPlayer standing/walking to the left */
    PlayerPunkLeftSrcRect[i].x = i*24*ScaleValue;
    PlayerPunkLeftSrcRect[i].y = 72*ScaleValue;
    PlayerPunkLeftSrcRect[i].w = 19*ScaleValue;
    PlayerPunkLeftSrcRect[i].h = 21*ScaleValue;
    // C64 player dimensions
    if(SystemNumber==2){PlayerPunkLeftSrcRect[i].w = 22*ScaleValue;}
    if(SystemNumber==2){PlayerPunkLeftSrcRect[i].h = 23*ScaleValue;}
    // C64 player dimensions
  }
		
  /*PunkPlayer jumping to the right */
  PlayerPunkJumpRightSrcRect.x = 72*ScaleValue;
  PlayerPunkJumpRightSrcRect.y = 48*ScaleValue;
  PlayerPunkJumpRightSrcRect.w = 21*ScaleValue;
  PlayerPunkJumpRightSrcRect.h = 21*ScaleValue;
  // C64 player dimensions
  if(SystemNumber==2){PlayerPunkJumpRightSrcRect.w = 22*ScaleValue;}
  if(SystemNumber==2){PlayerPunkJumpRightSrcRect.h = 22*ScaleValue;}
  // C64 player dimensions

  /*PunkPlayer jumping to the left */
  PlayerPunkJumpLeftSrcRect.x = 72*ScaleValue;
  PlayerPunkJumpLeftSrcRect.y = 72*ScaleValue;
  PlayerPunkJumpLeftSrcRect.w = 21*ScaleValue;
  PlayerPunkJumpLeftSrcRect.h = 21*ScaleValue;
  // C64 player dimensions
  if(SystemNumber==2){PlayerPunkJumpLeftSrcRect.w = 22*ScaleValue;}
  if(SystemNumber==2){PlayerPunkJumpLeftSrcRect.h = 22*ScaleValue;}
  // C64 player dimensions

  /*PunkPlayer turning to the right */
  PlayerPunkTurnRightSrcRect.x = 96*ScaleValue;
  PlayerPunkTurnRightSrcRect.y = 48*ScaleValue;
  PlayerPunkTurnRightSrcRect.w = 19*ScaleValue;
  PlayerPunkTurnRightSrcRect.h = 21*ScaleValue;
  // C64 player dimensions
  if(SystemNumber==2){PlayerPunkTurnRightSrcRect.w = 22*ScaleValue;}
  if(SystemNumber==2){PlayerPunkTurnRightSrcRect.h = 23*ScaleValue;}
  // C64 player dimensions

  /*PunkPlayer turning to the left */
  PlayerPunkTurnLeftSrcRect.x = 96*ScaleValue;
  PlayerPunkTurnLeftSrcRect.y = 72*ScaleValue;
  PlayerPunkTurnLeftSrcRect.w = 19*ScaleValue;
  PlayerPunkTurnLeftSrcRect.h = 21*ScaleValue;
  // C64 player dimensions
  if(SystemNumber==2){PlayerPunkTurnLeftSrcRect.w = 22*ScaleValue;}
  if(SystemNumber==2){PlayerPunkTurnLeftSrcRect.h = 23*ScaleValue;}
  // C64 player dimensions

  /*Player dead */
  PlayerDeadSrcRect.x = 48*ScaleValue;
  PlayerDeadSrcRect.y = 96*ScaleValue;
  PlayerDeadSrcRect.w = 18*ScaleValue;
  PlayerDeadSrcRect.h = 19*ScaleValue;
  // C64 player dimensions
  if(SystemNumber==2){PlayerDeadSrcRect.w = 22*ScaleValue;}
  if(SystemNumber==2){PlayerDeadSrcRect.h = 22*ScaleValue;}
  // C64 player dimensions

  /*Player turn punk */
  PlayerMorphSrcRect[0].x=0*ScaleValue;
  PlayerMorphSrcRect[0].y=96*ScaleValue;
  PlayerMorphSrcRect[0].w=24*ScaleValue;
  PlayerMorphSrcRect[0].h=24*ScaleValue;

  PlayerMorphSrcRect[1].x=24*ScaleValue;
  PlayerMorphSrcRect[1].y=96*ScaleValue;
  PlayerMorphSrcRect[1].w=24*ScaleValue;
  PlayerMorphSrcRect[1].h=24*ScaleValue;

  Player.w = PlayerRightSrcRect[0].w;
  Player.h = PlayerRightSrcRect[0].h;
  //  fprintf(stdout,"Succesfully defined Player...\n");
  // fprintf(stdout,"\nattempting to define shooting sprite...\n");

  PlayerPlaneSrcRect.x=72*ScaleValue;
  PlayerPlaneSrcRect.y=96*ScaleValue;
  PlayerPlaneSrcRect.w=24*ScaleValue;
  PlayerPlaneSrcRect.h=24*ScaleValue;



  BulletSrcRect[0].x = 152*ScaleValue;
  BulletSrcRect[0].y = 0*ScaleValue; 
  BulletSrcRect[0].w = 8*ScaleValue;
  BulletSrcRect[0].h = 8*ScaleValue;
  BulletSrcRect[1].x = 160*ScaleValue;
  BulletSrcRect[1].y = 0*ScaleValue; 
  BulletSrcRect[1].w = 8*ScaleValue;
  BulletSrcRect[1].h = 8*ScaleValue;
  BulletSrcRect[2].x = 168*ScaleValue;
  BulletSrcRect[2].y = 0*ScaleValue;
  BulletSrcRect[2].w = 8*ScaleValue;
  BulletSrcRect[2].h = 8*ScaleValue;
  BulletSrcRect[3].x = 176*ScaleValue;
  BulletSrcRect[3].y = 0*ScaleValue;
  BulletSrcRect[3].w = 8*ScaleValue;
  BulletSrcRect[3].h = 8*ScaleValue;
  BulletExplosionSrcRect[0].x = 192*ScaleValue;
  BulletExplosionSrcRect[0].y = 0*ScaleValue;
  BulletExplosionSrcRect[0].w = 16*ScaleValue;
  BulletExplosionSrcRect[0].h = 16*ScaleValue;
  BulletExplosionSrcRect[1].x = 208*ScaleValue;
  BulletExplosionSrcRect[1].y = 0*ScaleValue;
  BulletExplosionSrcRect[1].w = 16*ScaleValue;
  BulletExplosionSrcRect[1].h = 16*ScaleValue;
  // fprintf(stdout,"Succesfully defined shooting sprite...\n");
}
