#include "SDL/SDL.h"	// include SDL stuff
#include "SDL/SDL_mixer.h"
#include "SDL/SDL_image.h"

#include <stdlib.h>			// include ability to exit program
#include <stdio.h>			// include ability to read/write files
#include <string.h>
#include <time.h>

// when compiling, please pick you target platform :-)
// #define WINDOWS
// #define LINUX
// #define WIZ
// #define DREAMCAST


#define FULLSCREEN 1	    // 0 = windowed, 1 = fullscreen
#define SCREENWIDTH 320     // screen dimensions (pixel)
#define SCREENHEIGHT 240    // screen dimensions (pixel)
#define STAGEWIDTH 256      // width of tilesheet
#define STAGEHEIGHT 30      // height of tilesheet
#define TOTALTILES 7680     // number of tiles in a stage
#define LASTSTAGE 33         // number of stages...
#define POINTSPERCOIN 25   // number of points per coin...
#define POINTSPERENEMY 50   // number of points per enemy...
#define TILESHEETWIDTH 320  // width of tilesheet
#define TILESHEETHEIGHT 400 // height of tilesheet
#define TILESIZE 8          // size of tile (they are square 8x8 pixels)
#define ENEMYTYPES 20       // number of different types of enemies
#define ENEMIESPERSTAGE 15  // maximum number of enemies per stage

#define MAX_LENGTH_OF_LINE 128  // maximum length of a line in the ini file

#include "check_collision_bonus.h"
#include "getCurrentTile.h"
#include "check_collision_tiles_special.h"

#include "define_enemies.h"
#include "define_player.h"
#include "define_stages.h"
#include "define_sound.h"
#include "define_bonus.h"
#include "define_tiles.h"
#include "define_platforms.h"

#include "draw_background.h"
#include "draw_bullet.h"
#include "draw_enemies.h"
#include "draw_player.h"
#include "draw_bonus.h"
#include "draw_stats.h"
#include "draw_text.h"
#include "draw_tiles.h"
#include "draw_platforms.h"
#include "sub_screens.h"

#include "animations.h"
#include "gameloops.h"
#include "ini_handling.h"
#include "intro.h"
#include "load_stage.h"
#include "main.h"
#include "mission.h"
#include "move_enemies.h"
#include "move_platforms.h"
#include "move_player.h"
#include "move_player_jump.h"
#include "playSound.h"
#include "records.h"
#include "SDL_initialize.h"
#include "SDL_input.h"
#include "SDL_surfaces.h"
#include "titlescreen.h"
#include "warp.h"
#include "stompeffect.h"
#include "pick_system.h"
#include "draw_overlay.h"



