#include "init.h"
#include "time.h"

DATAFILE *mondata; /* poiteur vers mon datafile */
BITMAP *buffer;
unsigned int argent=5000;
unsigned int jouermenu=1;
unsigned int jouerlejeu=0;
volatile int counter;
void game_timer(); /* pour le bon fonctionnement du install_int_ex mieux vaut mettre cette fonction en globale !*/

extern uint8 romdisk[];
KOS_INIT_FLAGS(INIT_DEFAULT);
KOS_INIT_ROMDISK(romdisk);


void jeudecartes::initall()
{
	allegro_init();
	install_keyboard();
	install_timer();
	install_mouse();
	install_joystick(JOY_TYPE_AUTODETECT); //To detect keyboard
	install_sound(MIDI_AUTODETECT,DIGI_AUTODETECT,NULL);
	set_color_depth(16);
	set_gfx_mode(GFX_AUTODETECT,640,480,0,0);

	srand(time (NULL));	
	
}

void game_timer()
{
	counter++;
}
END_OF_FUNCTION(game_timer);

void jeudecartes::loadall()
{
	buffer=create_bitmap(SCREEN_W,SCREEN_H);
	if((mondata=load_datafile("/rd/cartes.dat"))==NULL)
		allegro_message("Can not load datafile !"); /* on ne sait jamais ! */
}

void jeudecartes::initvariables()
{
	brassageok=1;
	for(int x=0;x<52;x++)
		jeucartes[ x ]=0; /* mettre toutes les valeurs  0 */
	for(int xx=0;xx<5;xx++)
		tableau[ xx ]=52; /* le 52 ?? ben oui regardez le bmp 52 dans le datafile  */
	for(int xxx=2;xxx<5;xxx++)
		tableaupc[ xxx ]=52;
 	staynumber=2; /* va initialiser les 2 premieres cartes du joueur ! */
	mise=100;      /* la mise */
	nbpoints=0;
	nbpointspc=0;
	compterok=1;
	jeudupc=0;
	nbpioche=4;
	numero=1;
	indicepc=2;
	determinergagnant=0;
	quiagagne=0; /* 1 pour joueur , 2 pour le pc */
	peutjouer=1;
	cartecache=1;
	peutbrasser=1;
	compteur=0;
	/* pour tout ce qui va suivre : 
	   0 : pour trefle 
	   1 : pour coeur
	   2 : pour pique
	   3 : pour carreau */

	as[ 0 ]=0; /* as de trefle numero 0 dans le datafile ! */
	as[ 1 ]=13; /* as de coeur numero 13 dans le datafile ! */
	as[ 2 ]=26; /* as de pique : 26 */
	as[ 3 ]=39; /* as de carreau : 39 */
	deux[ 0 ]=3; /* deux de trefle : 3 */
	deux[ 1 ]=16;   /* deux de coeur  :   */
	deux[ 2 ]=29; /* deux de pique */
	deux[ 3 ]=42; /* deux de carreau */
	trois[ 0 ]=11; /* trois de trefle */
	trois[ 1 ]=24; /* trois de coeur */
	trois[ 2 ]=37; /* trois de pique */
	trois[ 3 ]=50; /* trois de carreau */
	quatre[ 0 ]=7; /* quatre de trefle */
	quatre[ 1 ]=20; /* quatre de coeur */
	quatre[ 2 ]=33; /* quatre de pique */
	quatre[ 3 ]=46; /* quatre de carreau */
	cinq[ 0 ]=1; /* cinq de trefle */
	cinq[ 1 ]=14; /* cinq de coeur */
	cinq[ 2 ]=27; /* cinq de pique */
	cinq[ 3 ]=40; /* cinq de carreau */
	six[ 0 ]=10; /* six de trefle */
	six[ 1 ]=23; /* six de coeur */
	six[ 2 ]=36; /* six de pique */
	six[ 3 ]=49; /* six de carreau */
	sept[ 0 ]=9; /* sept de trefle */
	sept[ 1 ]=22; /* sept de coeur */
	sept[ 2 ]=35; /* sept de pique */
	sept[ 3 ]=48; /* sept de carreau */
	huit[ 0 ]=5; /* huit de trefle */
	huit[ 1 ]=18; /* huit de coeur */
	huit[ 2 ]=31; /* huit de pique */
	huit[ 3 ]=44; /* huit de carreau */
	neuf[ 0 ]=6; /* neuf de trefle */
	neuf[ 1 ]=19; /* neuf de coeur */
	neuf[ 2 ]=32; /* neuf de pique */
	neuf[ 3 ]=45; /* neuf de carreau */
	dix[ 0 ]=4; /* dix de trefle */
	dix[ 1 ]=17; /* dix de coeur */
 	dix[ 2 ]=30; /* dix de pique */
	dix[ 3 ]=43; /* dix de carreau */
	valet[ 0 ]=12; /* valet de trefle */
	valet[ 1 ]=25; /* valet de coeur */
	valet[ 2 ]=38; /* valet de pique */
	valet[ 3 ]=51; /* valet de carreau */
	dame[ 0 ]=2; /* dame de trefle */
	dame[ 1 ]=15; /* dame de coeur */
	dame[ 2 ]=28; /* dame de pique */
	dame[ 3 ]=41; /* dame de carreau */
	roi[ 0 ]=8; /* roi de trefle */
	roi[ 1 ]=21; /* roi de coeur */
	roi[ 2 ]=34; /* roi de pique */
	roi[ 3 ]=47; /* roi de carreau */

}

void jeudecartes::menu()
{
	clear_bitmap(buffer);
	floodfill(buffer,100,100,makecol16(0,100,0));
	draw_sprite(buffer,(BITMAP*)mondata[ 58 ].dat,0,0); /* Le beau logo du jeu */
	draw_sprite(buffer,(BITMAP*)mondata[ 56 ].dat,200,130);/* Le bouton jouer */
	draw_sprite(buffer,(BITMAP*)mondata[ 55 ].dat,200,250); /* Le bouton credits */
	draw_sprite(buffer,(BITMAP*)mondata[ 57 ].dat,200,370); /* Le bouton quitter */
	rect(buffer,192,141,450,225,makecol16(0,0,255)); /* les carrs qui vont avec ! */
	rect(buffer,192,257,450,341,makecol16(0,0,255));
	rect(buffer,192,380,450,464,makecol16(0,0,255));
	
	if( (mouse_x>=192 && mouse_x<=450) && (mouse_y>=141 && mouse_y<=225) )
	{
		rect(buffer,192,141,450,225,makecol16(255,0,0));
		if(mouse_b & 1)
		{
			jouerlejeu=1;
			jouermenu=0;
		}
	}

	if( (mouse_x>=192 && mouse_x<=450) && (mouse_y>=257 && mouse_y<=341) )
	{
		rect(buffer,192,257,450,341,makecol16(255,0,0));
		if(mouse_b & 1)
		{
			unsigned int fin=480;
			jouermenu=0;
			jouerlejeu=0;
			clear_bitmap(buffer);
			floodfill(buffer,100,100,makecol(128,128,128));
			text_mode(-1); /* pour la transparence */
			for(unsigned int x=0;x<820;x++)
			{
				clear_bitmap(buffer);
				floodfill(buffer,100,100,makecol16(0,100,0));
                                /* blalbla et mes potes :) */
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin-x,makecol16(255,0,0),"Programmeur : ");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin+25-x,makecol16(0,0,255),"Amokrane Chentir ( AmK ) ");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin+50-x,makecol16(255,0,0),"Graphismes : ");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin+75-x,makecol16(0,0,255),"http://www.gametutorials.com");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin+100-x,makecol16(255,0,0),"Special GreetZ to :");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin+125-x,makecol16(0,0,255),"Herve.P ( Goldeneye) ");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin+150-x,makecol16(0,0,255),"Lionel.F (Funto) ");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin+175-x,makecol16(0,0,255),"Nicolas.B (Kirua) ");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin+200-x,makecol16(0,0,255),"Fabien.M (startjeux) ");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin+225-x,makecol16(0,0,255),"Mehdi.T ( Xarier) ");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,215,fin+250-x,makecol16(0,0,255),"Farid.A ( Linkin Park) ");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,215,fin+275-x,makecol16(0,0,255),"Ali (Osm3k) ");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin+300-x,makecol16(255,0,0),"Site Web ");
				textprintf(buffer,(FONT*)mondata[ 53 ].dat,210,fin+325-x,makecol16(0,0,255),"http://www.amk-project.fr.st");
				acquire_screen();
				blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
				release_screen();
				rest(20);
				
			}
			jouermenu=1;
		
			    
		}
	}

	if( (mouse_x>=192 && mouse_x<=450) && (mouse_y>=380 && mouse_y<=464) )
	{
		rect(buffer,192,380,450,464,makecol16(255,0,0));
		if(mouse_b & 1)
			exit(0);
	}
	show_mouse(buffer); /* Attention ! l'ordre dans lequel vous mettez show_mouse est important !*/
	acquire_screen();
	blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
	release_screen();
}

void jeudecartes::brassage()
{
	unsigned int aleatoire;
		for(int x=0;x<52;x++)
		{
			do
			{
				aleatoire=rand()%52; 
			}while(jeucartes[ aleatoire ]!=0);

			jeucartes[ aleatoire ]=x;
		}
}

void jeudecartes::logique()
{
	unsigned int pccounter=0;

	if(peutbrasser==1) /* pour brasser juste quand on le veut ! */
	{
		brassage();
		peutbrasser=0;
	}
	for(unsigned int x=0;x<staynumber;x++)
	{
		tableau[ x ]=jeucartes[ x ];
	}
	tableaupc[ 0 ]=jeucartes[ 2 ];
	tableaupc[ 1 ]=jeucartes[ 3 ];
	if(compterok==1)
	{
		compterp(tableau,&nbpoints);
		compterok=0;
	}

	if(jeudupc==1)
		pcia();
	if(argent<=0)
	{
		jouermenu=1;
		jouerlejeu=0;
	}
			
}

void jeudecartes::compterp(unsigned int wtableau[ 5 ],unsigned int *wnbp)
{
	*wnbp=0;
	unsigned int verify=0;
	do
	{
		for(unsigned int verifx=0;verifx<4;verifx++)  /* tout ce qui va suivre va calculer le nb de pts */
		{
			if(wtableau[ verify ]==roi[ verifx ] ||
			   wtableau[ verify ]==dame[ verifx ]||
			   wtableau[ verify ]==valet[ verifx ])
				*wnbp+=10;
			if(wtableau[ verify ]==deux[ verifx ])
				*wnbp+=2;
			if(wtableau[ verify ]==trois[ verifx ])
				*wnbp+=3;
			if(wtableau[ verify ]==quatre[ verifx ])
				*wnbp+=4;
			if(wtableau[ verify ]==cinq[ verifx ])
				*wnbp+=5;
			if(wtableau[ verify ]==six[ verifx ])
				*wnbp+=6;
			if(wtableau[ verify ]==sept[ verifx ])
				*wnbp+=7;
			if(wtableau[ verify ]==huit[ verifx ])
				*wnbp+=8;
			if(wtableau[ verify ]==neuf[ verifx ])
				*wnbp+=9;
			if(wtableau[ verify ]==dix[ verifx ])
				*wnbp+=10;

			if(wtableau[ verify ]==as[ verifx ])
			{
				unsigned int unouonze=1+rand()%2; /* regardez les regles du jeu */
				if(unouonze==1)
					*wnbp+=1;
				if(unouonze==2)
					*wnbp+=11;
			}

		}
		verify++;
	}
	while(verify<5);

}

void jeudecartes::pcia()
{
	compterp(tableaupc,&nbpointspc);
	if(nbpointspc<=nbpoints && nbpointspc<21 && nbpoints<=21)
	{
		tableaupc[ indicepc ]=jeucartes[ nbpioche ];
		indicepc++;
		nbpioche++;
	}
	
	else
	{
		jeudupc=0; /* desactive l'ia */
		determinergagnant=1;
	}

}

void jeudecartes::resultat()
{
	if( ( nbpoints>nbpointspc && nbpoints<=21 ) || (nbpointspc>=21 && nbpoints<=21) )
	{
		if(peutjouer==1)
		{
			argent+=mise;
			peutjouer=0; /* pour empecher que le montant du fric s'increment tjrs */
		}
		quiagagne=1;
	}
	else if( ( nbpoints<nbpointspc && nbpointspc<=21) || ( nbpoints>=21 && nbpointspc<=21) )
	{
		if(peutjouer==1)
		{
			argent-=mise;
			peutjouer=0;
		}
		quiagagne=2;
	}
}

void jeudecartes::graphique()
{
	rest(80);
	clear_bitmap(buffer);
	unsigned int distance=0,distancepc=0;
	unsigned int distanceb=7,distancebb=85,distancebis=7,distancebbis=87;
	// Debut du dessin du menu banque !
	rect(buffer,540,20,618,75,makecol16(0,0,255));
	rect(buffer,570,180,600,210,makecol16(255,0,255));
	rect(buffer,570,280,600,310,makecol16(255,0,255));
	rect(buffer,550,230,630,260,makecol16(255,255,0));
	textprintf(buffer,(FONT*)mondata[ 53 ].dat,542,21,makecol16(0,255,0),"BANQUE");
	textprintf(buffer,(FONT*)mondata[ 53 ].dat,542,50,makecol16(255,255,255),"%d",argent);
	textprintf(buffer,(FONT*)mondata[ 53 ].dat,587,50,makecol16(255,255,255),"$");
	textprintf(buffer,(FONT*)mondata[ 53 ].dat,570,235,makecol16(255,0,0),"%d",mise);
	textprintf(buffer,(FONT*)mondata[ 53 ].dat,610,237,makecol16(255,213,12),"$");
	textprintf(buffer,(FONT*)mondata[ 53 ].dat,580,185,makecol16(0,0,255),"+");
	textprintf(buffer,(FONT*)mondata[ 53 ].dat,580,287,makecol16(0,0,255),"-");
	// Fin du dessin
	//debut du dessin du menu stay-change
	rect(buffer,127,401,240,431,makecol16(0,0,255));
	rect(buffer,312,401,425,431,makecol16(0,0,255));
	textprintf(buffer,(FONT*)mondata[ 53 ].dat,130,408,makecol16(255,255,0),"CHANGE !!!");
	textprintf(buffer,(FONT*)mondata[ 53 ].dat,315,408,makecol16(255,255,0),"ABATTRE !!!");
    for(int x=0;x<5;x++) /* dessins des petits carrs verts qui rendent le jeu beau */
	{
		rectfill(buffer,distanceb,247,distancebb,353,makecol16(0,255,0));
		distanceb+=110;
		distancebb+=110;
	}
    
	for(int i=0;i<5;i++) /* affichage de la main du joueur */
	{
		draw_sprite(buffer,(BITMAP *)mondata[ tableau[ i ] ].dat,10+distance,250);
		distance+=110;
	}
		
	for(int xx=0;xx<5;xx++)
	{
		rectfill(buffer,distancebis,97,distancebbis,203,makecol16(255,0,0));
		distancebis+=110;
		distancebbis+=110;
	}

	for(int ii=0;ii<5;ii++)/* affichage de la main du pc */
	{
		if(ii==1 && cartecache==1)
			draw_sprite(buffer,(BITMAP*)mondata[ 54 ].dat,10+distancepc,100);
		else
			draw_sprite(buffer,(BITMAP *)mondata[ tableaupc[ ii ] ].dat,10+distancepc,100);
		distancepc+=110;
	}

	
	if( (mouse_x>=572 && mouse_x<=600) && (mouse_y>=182 && mouse_y<=210)) /* Le bouton + */
		if(mouse_b & 1)
		{
			if(mise<argent && peutjouer==1)
				mise+=100;
		}
	
	if( (mouse_x>=572 && mouse_x<=600) && (mouse_y>=283 && mouse_y<=310) ) /* Le bouton - */
		if(mouse_b & 1)
		{
			if(mise>=200 && peutjouer==1)
				mise-=100;
		}
	
	if( (mouse_x>=129 && mouse_x<=242) && (mouse_y>=403 && mouse_y<=431) ) /* Le bouton change */
		if(mouse_b & 1 && peutjouer==1 && compteur<=3)
		{
			compteur++;
			nbpioche++;
			numero++;
			tableau[ numero ]=jeucartes[ nbpioche ];
			compterok=1; /* nouveau nombre de points = recompter ! */
		}
	
	if( (mouse_x>=313 && mouse_x<=425) && (mouse_y>=403 && mouse_y<=431) ) /* Le bouton stay */
		if(mouse_b & 1 && peutjouer==1)
		{
			cartecache=0;
			jeudupc=1; /* va permettre au pc de jouer  son tour ! */
		}
    if(determinergagnant==1)
	{
		resultat();
		rectfill(buffer,227,0,420,86,makecol16(0,100,0));
		rect(buffer,252,50,313,77,makecol16(255,0,0));
		rect(buffer,348,50,409,77,makecol16(255,0,0));
		if(quiagagne==2) textprintf(buffer,(FONT*)mondata[ 53 ].dat,105,0,makecol16(255,255,0),"Vous avez perdu !!!");
		if(quiagagne==1) textprintf(buffer,(FONT*)mondata[ 53 ].dat,105,0,makecol16(255,255,0),"Vous avez gagne !!!");
		if(nbpointspc==nbpoints) textprintf(buffer,(FONT*)mondata[ 53 ].dat,105,0,makecol16(255,255,0),"Vous avez egalite !");
		textprintf(buffer,(FONT*)mondata[ 53 ].dat,295,0,makecol16(255,0,255),"Voulez vous rejouer ?");
		textprintf(buffer,(FONT*)mondata[ 53 ].dat,264,55,makecol16(255,255,0),"OUI !");
		textprintf(buffer,(FONT*)mondata[ 53 ].dat,354,55,makecol16(255,255,0),"NON !");

		if( (mouse_x>=348 && mouse_x<=409) && (mouse_y>=50 && mouse_y<=77) )
			if(mouse_b & 1)
			{
				initvariables();
				jouermenu=1;
				jouerlejeu=0;
			}
		if( (mouse_x>=252 && mouse_x<=313) && (mouse_y>=50 && mouse_y<=77) )
			if(mouse_b & 1)
				initvariables();
	}
	
	show_mouse(buffer);
	floodfill(buffer,100,100,makecol16(0,100,0));
	acquire_screen();
	blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
	release_screen();
}


void jeudecartes::destroyall()
{
	unload_datafile(mondata);
}

int main()
{
	printf("Starting...\n");
	int draw=0;

	jeudecartes Jeu;

	Jeu.initall();
	LOCK_VARIABLE(counter);
	LOCK_FUNCTION(game_timer);
	Jeu.loadall();
	Jeu.initvariables();

	install_int_ex(game_timer,BPS_TO_TIMER(60));

	while(1)
	{
		while(counter>0 && jouermenu==0 && jouerlejeu==1)
		{
			Jeu.logique();
			counter--;
			draw=1;
		}

		while(counter>0 && jouermenu==1 && jouerlejeu==0)
		{
			counter--;
			Jeu.menu();
		}

		if(draw && jouermenu==0 && jouerlejeu==1)
		{
			Jeu.graphique();
			draw=0;
		}

		while(counter<0){
		}
		
	}

	Jeu.destroyall();
	return 0;
}
END_OF_MAIN();
