#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_mixer.h>
#include <SDL/SDL_ttf.h>

#include "iniparser/iniparser.h"
#include "constantes.h"
#include "jeu.h"
#include "logique.h"
#include "GUI.h"

#ifdef DREAMCAST
#include <kos.h>
#include <SDL/SDL_dreamcast.h>
extern uint8 romdisk[];
KOS_INIT_FLAGS(INIT_DEFAULT);
KOS_INIT_ROMDISK(romdisk);
#endif

/* Mix_Music actually holds the music information.  */
Mix_Music *music = NULL;

void quit(char texte[]);

int main (int argc, char* argv[])
{
    printf("Starting...\n");
    // initialize SDL video
    if ( SDL_Init( SDL_INIT_VIDEO | SDL_INIT_JOYSTICK | SDL_INIT_AUDIO) < 0 )
    {
        fprintf(stderr, "Unable to init SDL: %s\n", SDL_GetError() );
        return 1;
    }

    // Init SDL_image
    if (TTF_Init() == -1)
    {
        fprintf(stderr,"SDL_ttf Error : %s\n",TTF_GetError());
        exit(EXIT_FAILURE);
    }

    // create a new window
    //SDL_WM_SetIcon(IMG_Load("icone.png"),NULL);
	//Changing HW and DOUBLEBUF to SW -> to show cursor!
    SDL_Surface* ecran = SDL_SetVideoMode(LARGEUR_FENETRE, HAUTEUR_FENETRE, 16,SDL_SWSURFACE);
    if ( !ecran )
    {
        fprintf(stderr, "Unable to set video: %s\n", SDL_GetError());
        return 1;
    }

    #ifdef DREAMCAST
    SDL_DC_MapKey(0,SDL_DC_UP,SDLK_UP); 
    SDL_DC_MapKey(0,SDL_DC_DOWN,SDLK_DOWN); 
    SDL_DC_MapKey(0,SDL_DC_LEFT,SDLK_LEFT); 
    SDL_DC_MapKey(0,SDL_DC_RIGHT,SDLK_RIGHT);
    SDL_DC_MapKey(0,SDL_DC_R,SDLK_ESCAPE); //left button on the controller
	
    SDL_JoystickEventState(SDL_ENABLE);
    SDL_JoystickOpen(0);
    SDL_DC_EmulateMouse(1);
    SDL_ShowCursor(1);

    //Dreamcast delay...
    SDL_Delay(50);
    SDL_Event event;
    while(SDL_PollEvent(&event))
	SDL_Delay(20);
    #endif

	if(Mix_OpenAudio(22050, AUDIO_S16, 2, 512)) {
		printf("Unable to open audio!\n");
		exit(1);
	}
	
	music = Mix_LoadMUS("/rd/casino.s3m");
	Mix_PlayMusic(music, -1);
	
    SDL_FillRect(ecran,NULL,SDL_MapRGB(ecran->format,BG_COLOR())); // Colorie l'cran
    //SDL_WM_SetCaption("VideoPoker",NULL);
    SDL_Flip(ecran);

    SDL_EnableKeyRepeat(300, 50); // Activaition des appuis rptes
    srand(time(NULL)); // Init du random

    jeu(ecran); // Droulement du jeu

    TTF_Quit();
    SDL_Quit();
    return EXIT_SUCCESS;
}

void quit(char texte[])
{
    fprintf(stderr, "Erreur : %s",texte);
    TTF_Quit();
	Mix_CloseAudio();
    SDL_Quit();
    exit(-1);
}
