#ifndef JEU_H_INCLUDED
#define JEU_H_INCLUDED

#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>

#include "iniparser/iniparser.h"
#include "constantes.h"
#include "logique.h"
#include "GUI.h"

// Structure qui contient des donnes sur les cartes tires
typedef struct CardData CardData;
struct CardData
{
    int ID;             // Identifiant unique de la carte (1-52)
    int numero;         // Numro de la carte (2-14)
    int couleur;        // Couleur de la carte (TREFLE,PIQUE,CARREAU,COEUR)
    int statut;         // Statut de la carte (NORMAL,SURVOLE,CLIQUE)
    char chemin[100];   // Chemin du fichier de la carte
};

// Structure qui peur contenir des coordones
typedef struct Coordonnees Coordonnees;
struct Coordonnees
{
    int xd;  //Position en abscisse au dbut
    int yd;  //Position en ordonne au dbut
    int xf;  //Position en abscisse  la fin
    int yf;  //Position en ordonne  la fin
};

// Boucle principale du jeu
int jeu(SDL_Surface *ecran);

// Boucle evenementielle initiale
int eventInitial(int *cash, int *pari, Coordonnees *positionBouton, CardData cartesJoueur[], SDL_Surface *ecran);

// Boucle evenementielle de la phase d'limination
int eventElimination(int cash, int pari, Coordonnees *positionBouton, CardData cartesJoueur[], SDL_Surface *ecran);

// Boucle evenementielle de la phase finale
int eventFinal(int cash, int pari, Coordonnees *positionBouton, CardData cartesJoueur[], SDL_Surface *ecran, char stringGain[], char stringBouton[]);

// Rcupre le CashInitial dans le ficier ini
int optionParser();

// Fonctions qui incrmentent ou dcrmentent le paris
void pariPlus(int *cash, int *pari);
void pariMoins(int *cash, int *pari);

// Fonctions qui determine si des lments sont survols
int carteSurvol(int x, int y, int i);
int boutonSurvol(Coordonnees *positionBouton, int x, int y);

#endif // JEU_H_INCLUDED
