#include "jeu.h"

int jeu(SDL_Surface *ecran)
{
    int cash = 0, cashInitial, pari = 0, coeffGain = 0, statut = RIEN, i;
    cashInitial = optionParser();
    if (cashInitial <= 0) // On vrifie que le cash est bien rentr
        quit("Cash initial ngatif ou nul. Vrifier ou restaurer le fichier options.ini");
    cash = cashInitial;
    Coordonnees positionBouton = {0,0,0,0};
    CardData cartesJoueur[NOMBRE_CARTES] = {0,0,0,0,""};
    int cartesJetees[NOMBRE_ID] = {0}; // Ce tableau mmorisera les IDs des cartes jetes
    char stringGain[100] = "", stringBouton[20] = "";

    do
    {
        // Restauration du pari prcdent
        if (pari <= cash)
            cash -= pari ;
        else
        {
            pari = cash;
            cash = 0;
        }
        // Phase initiale
        blit(ecran, cash, pari, "Placez un pari", "MISER", &positionBouton, cartesJoueur, BACKS);
        statut = eventInitial(&cash, &pari, &positionBouton, cartesJoueur, ecran);
        // Phase d'limination
        if (statut != QUITTER)
        {
            tirageInitial(cartesJoueur); // Tirage des cartes
            blit(ecran, cash, pari, "Slectionnez les cartes  garder", "DONNER", &positionBouton, cartesJoueur, NO_FLAG);
            statut = eventElimination(cash, pari, &positionBouton, cartesJoueur, ecran);
        }

        // Phase finale
        if (statut != QUITTER)
        {
            tirageFinal(cartesJoueur, cartesJetees);    // Tirage des cartes jetes
            coeffGain = gain(cartesJoueur);             // Dtermination du coeff de gain
            infoGain(pari, coeffGain, stringGain);      // Dtermination du string de la barre d'info
            cash += pari*coeffGain;                     // Ajout des gains au cash
            if (cash > 0)
            {
				printf("Start to draw result...\n");
                blit(ecran, cash, pari, stringGain, "REJOUER", &positionBouton, cartesJoueur, CACHER_PARI);
				printf("Results...\n");
                statut = eventFinal(cash, pari, &positionBouton, cartesJoueur, ecran, stringGain, "REJOUER");
            }
            else
            {
                sprintf(stringGain,"Vous tes ruin !");
                blit(ecran, cash, pari, stringGain, "RECOMMENCER", &positionBouton, cartesJoueur, CACHER_PARI);
                statut = eventFinal(cash, pari, &positionBouton, cartesJoueur, ecran, stringGain, "RECOMMENCER");
                cash = cashInitial;
                pari = 0;
            }
        }
    } while (statut != QUITTER);
    return 0;
}

int eventInitial(int *cash, int *pari, Coordonnees *positionBouton, CardData cartesJoueur[], SDL_Surface *ecran)
{
    int statut=RIEN, importantEvent=0, survol=NORMAL;
    SDL_Event event;

    while (statut == RIEN)
    {
        importantEvent = 0;
        SDL_WaitEvent(&event);
        switch(event.type)
        {
            case SDL_QUIT:
                statut = QUITTER;
                break;
            case SDL_KEYDOWN:
                switch (event.key.keysym.sym)
                {
                    case SDLK_ESCAPE:
                        statut = QUITTER;
                        break;
                    case SDLK_UP:
                        pariPlus(cash, pari);
                        importantEvent = 1;
                        break;
                    case SDLK_DOWN:
                        pariMoins(cash, pari);
                        importantEvent = 1;
                        break;
                    case SDLK_SPACE:
                        statut = CONTINUER;
                        break;
                    case SDLK_F5:
                        importantEvent = 1;
                        break;
                }
                break;
            case SDL_MOUSEBUTTONUP:
                switch (event.button.button)
                {
                    case SDL_BUTTON_WHEELUP:
                        pariPlus(cash, pari);
                        importantEvent = 1;
                        break;
                    case SDL_BUTTON_WHEELDOWN:
                        pariMoins(cash, pari);
                        importantEvent = 1;
                        break;
                    case SDL_BUTTON_LEFT:
                        // Si le bouton est survol et si on a pari quelque chose
                        if (boutonSurvol(positionBouton, event.button.x, event.button.y) && *pari > 0)
                            statut = CONTINUER;             // on continue
                        break;
                }
                break;
            case SDL_MOUSEMOTION:
                // Si la souris est dans la zone du bouton...
                if (boutonSurvol(positionBouton, event.motion.x, event.motion.y) && !survol)
                {
                    survol = BOUTON_SURVOLE;
                    importantEvent = 1;
                }
                else if (boutonSurvol(positionBouton, event.motion.x, event.motion.y) && survol)
                    importantEvent = 0;
                else if (!boutonSurvol(positionBouton, event.motion.x, event.motion.y) && survol)
                {
                    survol = NO_FLAG;
                    importantEvent = 1;
                }
                else
                    importantEvent = 0;
                break;
        }
        if (importantEvent) // S'il s'est produit un evenement 'important', or recalcule la fentre
            blit(ecran, *cash, *pari, "Placez un pari", "MISER", positionBouton, cartesJoueur, BACKS|survol);
    }
    return statut;
}

int eventElimination(int cash, int pari, Coordonnees *positionBouton, CardData cartesJoueur[], SDL_Surface *ecran)
{
    int statut=RIEN, importantEvent=0, survol=NORMAL, i;
    SDL_Event event;

    while (statut == RIEN)
    {
        importantEvent = 0;
        SDL_WaitEvent(&event);
        switch(event.type)
        {
            case SDL_QUIT:
                statut = QUITTER;
                break;
            case SDL_KEYDOWN:
                switch (event.key.keysym.sym)
                {
                    case SDLK_ESCAPE:
                        statut = QUITTER;
                        break;
                    case SDLK_SPACE:
                        statut = CONTINUER;
                        break;
                }
                break;
            case SDL_MOUSEBUTTONUP:
                for(i=0 ; i<NOMBRE_CARTES ; i++)
                {
                    if (event.button.button == SDL_BUTTON_LEFT && carteSurvol(event.button.x, event.button.y, i))
                    {
                        if (cartesJoueur[i].statut == CLIQUE)
                            cartesJoueur[i].statut = NORMAL;
                        else
                            cartesJoueur[i].statut = CLIQUE;
                        importantEvent = 0;
                    }
                    else if (event.button.button == SDL_BUTTON_LEFT && boutonSurvol(positionBouton, event.button.x, event.button.y))
                        statut = CONTINUER;
                }
            case SDL_MOUSEMOTION:
                // Vrifie si une des cartes est survole
                for(i=0 ; i<NOMBRE_CARTES ; i++)
                {
                    if(boutonSurvol(positionBouton, event.motion.x, event.motion.y) && !survol) // Si le bouton est survol
                    {
                        survol = BOUTON_SURVOLE;
                        importantEvent = 1;
                        if (cartesJoueur[i].statut != CLIQUE)
                            cartesJoueur[i].statut = NORMAL;
                    }
                    else if (carteSurvol(event.motion.x, event.motion.y, i) && cartesJoueur[i].statut == NORMAL) // Si une carte est survole
                    {
                        cartesJoueur[i].statut = SURVOLE;
                        importantEvent = 1;
                    }
                    else if (!carteSurvol(event.motion.x, event.motion.y, i) &&
                             !boutonSurvol(positionBouton, event.motion.x, event.motion.y))
                    {
                        if (survol) // Si le bouton n'est plus survole
                        {
                            survol = NO_FLAG;
                            importantEvent = 1;
                        }
                        else if (cartesJoueur[i].statut == SURVOLE)
                        {
                            cartesJoueur[i].statut = NORMAL;
                            importantEvent = 1;
                        }
                    }
                }
                break;
        }

        if (importantEvent) // S'il s'est produit un evenement 'important', or recalcule la fentre
            blit(ecran, cash, pari, "Slectionnez les cartes  garder", "DONNER", positionBouton, cartesJoueur, survol);
    }
    return statut;
}

int eventFinal(int cash, int pari, Coordonnees *positionBouton, CardData cartesJoueur[], SDL_Surface *ecran, char stringGain[], char stringBouton[])
{
    int statut=RIEN, importantEvent=0, survol=NORMAL, flagRuine = 0;
    SDL_Event event;

    while (statut == RIEN)
    {
        importantEvent = 0;
        SDL_WaitEvent(&event);
        switch(event.type)
        {
            case SDL_QUIT:
                statut = QUITTER;
                break;
            case SDL_KEYDOWN:
                switch (event.key.keysym.sym)
                {
                    case SDLK_ESCAPE:
                        statut = QUITTER;
                        break;
                    case SDLK_SPACE:
                        statut = CONTINUER;
                        break;
                }
                break;
            case SDL_MOUSEBUTTONUP:
                if (event.button.button == SDL_BUTTON_LEFT &&
                    boutonSurvol(positionBouton, event.button.x, event.button.y))
                    statut = CONTINUER;
                break;
            case SDL_MOUSEMOTION:
                // Si la souris est dans la zone du bouton...
                if (boutonSurvol(positionBouton, event.motion.x, event.motion.y) && !survol)
                {
                    survol = BOUTON_SURVOLE;
                    importantEvent = 1;
                }
                else if (boutonSurvol(positionBouton, event.motion.x, event.motion.y) && survol)
                    importantEvent = 0;
                else if (!boutonSurvol(positionBouton, event.motion.x, event.motion.y) && survol)
                {
                    survol = NO_FLAG;
                    importantEvent = 1;
                }
                else
                    importantEvent = 0;
                break;
        }
    }
    return statut;
}

int optionParser()
{
    int retour=0;
    dictionary *dict;
	dict = iniparser_load("/rd/options.ini");
	retour = iniparser_getint(dict,"jeu:cashinitial",-1);
	iniparser_freedict(dict);
	return retour;
}

void pariPlus(int *cash, int *pari)
{
    if (*cash > 0)
    {
        *pari += 1;
        *cash -= 1;
    }
}

void pariMoins(int *cash, int *pari)
{
    if (*pari > 0)
    {
        *pari -= 1;
        *cash += 1;
    }
}

//Changed to adapt 640x480
int carteSurvol(int x, int y, int i)
{
    int retour = NORMAL;
    if (x >= (50 + 115*i) &&
        x <= (50 + 115*i + 105) &&
        y >= 80 &&
        y <= (80 + 150 + 60))
            retour = SURVOLE;
    return retour;
}

int boutonSurvol(Coordonnees *positionBouton, int x, int y)
{
    int retour = 0;
    if (x >= positionBouton->xd &&
        x <= positionBouton->xf &&
        y >= positionBouton->yd &&
        y <= positionBouton->yf)
        retour = 1;
    return retour;
}
