#include "GUI.h"

void blit(SDL_Surface *ecran,
          int cash,
          int pari,
          char info[],
          char bouton[],
          Coordonnees *positionBouton,
          CardData *cartesJoueur,
          unsigned int flags)
{
    // Initialisations
    SDL_Rect position;
    TTF_Font *police = NULL ;
    SDL_Surface *texteCash, *textePari, *texteInfo, *texteBouton, *surfaceCarte[NOMBRE_CARTES], *carteBack;
    SDL_Color bg_color = {BG_COLOR()}, noir = {0,0,0}, blanc = {255,255,255}, couleurBouton = {0,0,0};
    char stringCash[50] = "", stringPari[50] = "", skin[50]="", stringSkin[50];
    int i; // Variable pour les boucles
    dictionary *dict; //structure du dictionnaire pour le parseur ini

    SDL_FillRect(ecran,NULL,SDL_MapRGB(ecran->format,BG_COLOR())); // Colorie l'cran

    // Ecriture des stings
    sprintf(stringCash,"Cash : %ld",cash);
    sprintf(stringPari,"Pari : %ld",pari);

    // Dessin de texteCash
    police = TTF_OpenFont(POLICE(),TAILLE_CASH);
    texteCash = TTF_RenderText_Shaded(police,stringCash,noir,bg_color);
    TTF_CloseFont(police);
    position.x = (ecran->w / 2) - (texteCash->w / 2);
    position.y = MARGE_CASH_Y;
    SDL_BlitSurface(texteCash, NULL, ecran, &position);

    // Dessin de textePari
    if ((flags & CACHER_PARI) == 0) // Test du flag CACHER_PARI
    {
        police = TTF_OpenFont(POLICE(),TAILLE_PARI);
        textePari = TTF_RenderText_Shaded(police,stringPari,noir,bg_color);
        TTF_CloseFont(police);
        position.x = MARGE_PARI_X;
        position.y = ecran->h - (MARGE_PARI_Y + textePari->h);
        SDL_BlitSurface(textePari, NULL, ecran, &position);
    }

    // Dessin de texteInfo
    police = TTF_OpenFont(POLICE(),TAILLE_INFO);
    texteInfo = TTF_RenderText_Shaded(police,info,blanc,bg_color);
    TTF_CloseFont(police);
    if ((flags & CACHER_PARI) == 0)     // Test du flag CACHER_PARI
        position.x = (((ecran->w - LARGEUR_INFO)/2)+LARGEUR_INFO) - (texteInfo->w / 2);
    else                                // Sinon le texte est centr
        position.x = (ecran->w / 2) - (texteInfo->w / 2);
    position.y = ecran->h - (MARGE_INFO_X + texteInfo->h);
    SDL_BlitSurface(texteInfo, NULL, ecran, &position);

    // Dessin du bouton
    if ((flags & BOUTON_SURVOLE) != 0)  // Test du flag de survol : si le bouton est survol
        couleurBouton.r=100;
    police = TTF_OpenFont(POLICE(),TAILLE_BOUTON);
    TTF_SetFontStyle(police, TTF_STYLE_BOLD);
    texteBouton = TTF_RenderText_Shaded(police,bouton,couleurBouton,bg_color);
    TTF_CloseFont(police);
    position.x = (ecran->w / 2) - (texteBouton->w / 2);
    position.y = ecran->h - (MARGE_BOUTON_Y + texteBouton->h);
    // enregistre les coordones du bouton
    positionBouton->xd = position.x;
    positionBouton->yd = position.y;
    positionBouton->xf = position.x + texteBouton->w;
    positionBouton->yf = position.y + texteBouton->h;
    SDL_BlitSurface(texteBouton, NULL, ecran, &position);

    // Dessin des cartes
    if ((flags & BACKS) != 0) // Si les cartes sont des backs (phase initiale)
    {
        dict = iniparser_load("/rd/options.ini"); //ouverture du fichier ini
        if (dict != 0) // Si le dictionnaire est ouvert
        {
            sprintf(skin, "/rd/img/back/%s.png", iniparser_getstr(dict,"skin:back"));
            iniparser_freedict(dict);
            carteBack = IMG_Load(skin);
        }
        else // Si le dictionnaire ne s'ouvre pas
            quit("Ouverture du fichier ini impossible");

        for (i=0 ; i<NOMBRE_CARTES ; i++) // On blitte cette surface 5 fois
        {
            position.x = MARGE_CARTES_X + (MARGE_INTERCARTE * i);
            position.y = MARGE_CARTES_Y;
            SDL_BlitSurface(carteBack, NULL, ecran, &position);
        }
    }
    else // sinon on dessine les cartes une par une
    {
        for(i=0 ; i<NOMBRE_CARTES ; i++)
        {
            surfaceCarte[i] = IMG_Load(cartesJoueur[i].chemin);
            position.x = MARGE_CARTES_X + (MARGE_INTERCARTE * i);
            position.y = MARGE_CARTES_Y;
            if (cartesJoueur[i].statut != NORMAL) // Si la carte est survole ou clique
                position.y += DECALAGE_SURVOL;
            SDL_BlitSurface(surfaceCarte[i], NULL, ecran, &position);
        }
    }

    SDL_Flip(ecran);

    // Nettoyage des surfaces
    SDL_FreeSurface(texteCash);
    SDL_FreeSurface(textePari);
    SDL_FreeSurface(texteInfo);
    SDL_FreeSurface(texteBouton);
    if ((flags & BACKS) != 0)
        SDL_FreeSurface(carteBack);
    else
        for(i=0 ; i<NOMBRE_CARTES ; i++)
            SDL_FreeSurface(surfaceCarte[i]);
}

void skinParser(char argument[], char string[])
{
    dictionary *dict;
	dict = iniparser_load("/rd/options.ini");
	if (dict != 0)
	{
        string = iniparser_getstr(dict,argument);
        iniparser_freedict(dict);
        if (string == NULL)
            quit("Erreur de lecture du fichier INI");
	}
	else
        quit("Ouverture du fichier ini impossible");
}

void infoGain(long pari, long gain, char string[])
{
    switch (gain)
    {
        case PERDU:
            sprintf(string,"Vous avez perdu");
            break;
        case PAIRE_TETES:
            sprintf(string,"Paire de ttes : +%ld",(pari*gain));
            break;
        case DEUX_PAIRES:
            sprintf(string,"Double paire : +%ld",(pari*gain));
            break;
        case BRELAN:
            sprintf(string,"Brelan : +%ld",(pari*gain));
            break;
        case COULEUR:
            sprintf(string,"Couleur : +%ld",(pari*gain));
            break;
        case SUITE:
            sprintf(string,"Suite : +%ld",(pari*gain));
            break;
        case FULL:
            sprintf(string,"Full : +%ld",(pari*gain));
            break;
        case CARRE:
            sprintf(string,"Carr : +%ld",(pari*gain));
            break;
        case SUITE_COULEUR:
            sprintf(string,"Suite de couleur : +%ld",(pari*gain));
            break;
        case SUITE_ROYALE:
            sprintf(string,"!SUITE ROYALE! : +%ld",(pari*gain));
            break;
        default:
            sprintf(string,"Wow ! Y'a un problme l");
            break;
    }
}
