/***************************************************************************
    Copyright            : (C) 2006 by Tony R. Freeman
    Email                : tony@tonyfreeman.us
    Web                  : http://www.tonyfreeman.us/
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

void hideBeans ()
{
	int i = 0;
	int item = 0;
	for (i=0; i<BEAN_COUNT; i++) {
		item = list[i];
		src.x = theBeans[item][1] - beans[i][theBeans[item][0]]->w / 2;
		src.y = theBeans[item][2] - beans[i][theBeans[item][0]]->h / 2;
		src.w = beans[i][theBeans[item][0]]->w;
		src.h = beans[i][theBeans[item][0]]->h;
		dest = src;
		SDL_BlitSurface(background, &src, screen, &dest);
	}
	SDL_UpdateRect(screen, 0, 0, 0, 0);	
}


void showBeans ()
{
	int i = 0;
	int r = 0;
	int item = 0;
	int temp = 0;
	
	srand(time(NULL));
	
	// LIST IS USED TO SHUFFLE THE X,Y COORDINATES OF EACH BEAN'S LANDING
	// POSITION ON THE BOARD.
	for (i=0; i<BEAN_COUNT; i++) {
		r = rand() % BEAN_COUNT;
		temp = list[i];
		list[i] = list[r];
		list[r] = temp;
	}
	
	for (i=0; i < BEAN_COUNT; i++) {
		item = list[i];
		dest.x = theBeans[item][1] - beans[i][theBeans[i][0]]->w / 2;
		dest.y = theBeans[item][2] - beans[i][theBeans[i][0]]->h / 2;
		dest.w = beans[i][theBeans[item][0]]->w;
		dest.h = beans[i][theBeans[item][0]]->h;
		SDL_BlitSurface(beans[i][theBeans[i][0]], NULL, screen, &dest);
	}

	SDL_UpdateRect(screen, 0, 0, 0, 0);
}


void handle_roll_the_beans()
{
	//printf("handle_roll_the_beans\n");
	int i = 0;
	int j = 0;
	bool test = false;
	bean_count = 0;
	srand((unsigned)time(NULL));
	// SHAKING THE BEANS SOUND
	hideBeans();
	Mix_PlayChannel(-1, shake_beans, 0);
	SDL_Delay(800);
	// FIGURE THE BEANS ARRAY
	for (i=0; i<BEAN_COUNT; i++) {
		j = rand() % 2;
		theBeans[i][0] = j;
		bean_count += j;
	}
	// SHOW THE BEANS ON THE BOARD
	showBeans();
	// BEANS HITTING THE BOARD SOUND
	Mix_PlayChannel(-1, scatter_beans, 0);
	// HANDLE THE 5 OR 0 BEAN COUNT
	test = is_player_on_board();
	if (test && (bean_count == BEAN_COUNT)) {
		bean_count = 10;
		Mix_PlayChannel(-1, big_chear, 0);
	//} else if (test && (bean_count == 0)) {
	} else if (bean_count == 0) {
		Mix_PlayChannel(-1, god_chuckle, 0);
		pay_the_kitty();
	}
}


bool roll_the_beans ()
{
	SDL_Event event;
	SDL_EventFilter filter;
	bool done = false;
	
	switch (player) {
		
		case RED:
			SDL_Delay(400);
			handle_roll_the_beans();
			break;
			
		case BLUE:
			filter = SDL_GetEventFilter();
			SDL_SetEventFilter(all_filter);
			while (SDL_PollEvent(&event));
			SDL_SetEventFilter(filter);
			while (!done) {
					SDL_WaitEvent(&event);
					switch (event.type) {
						case SDL_QUIT:
							state = STATE_MENU;
							break;
						case SDL_VIDEOEXPOSE:
							// NEED A REDRAW
							SDL_UpdateRect(screen, 0, 0, 0, 0);
							break;
						case SDL_MOUSEBUTTONDOWN:
							handle_roll_the_beans();
							done = true;
							break;
						default:
							// CLOSE THE GAME IF USER PRESSES ESCAPE OR THE q KEY
							if (event.key.keysym.sym == SDLK_ESCAPE || event.key.keysym.sym == SDLK_q) { 
								state = STATE_MENU; 
								done = true; 
							}
							break;
					}
			}
			break;
			
		default:
			// CLOSE THE GAME IF USER PRESSES ESCAPE OR THE q KEY
			if (event.key.keysym.sym == SDLK_ESCAPE || event.key.keysym.sym == SDLK_q) { 
				state = STATE_MENU; 
			}
			break;
			
	}
	return true;
}
