/***************************************************************************
    Copyright            : (C) 2006 by Tony R. Freeman
    Email                : tony@tonyfreeman.us
    Web                  : http://www.tonyfreeman.us/
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

void menu_init (Menu *menu, int y, int y_offset)
{
	memset(menu, 0, sizeof(Menu));
	menu->y = y;
	menu->y_offset = y_offset;
	menu->cur_entry_id = -1;
}


void menu_add_entry (Menu *menu, char *name, int id)
{
	MenuEntry *entry;
	if (menu->entry_count <= MAX_MENU_ENTRIES) {
		entry = &menu->entries[menu->entry_count++];
		snprintf(entry->name, 24, "%s", name); 
		entry->name[23] = '\0';
		entry->w = SFont_TextWidth(ft_menu, entry->name);
		entry->h = SFont_TextHeight(ft_menu);
		entry->x = (screen->w - entry->w) / 2;
		entry->id = id;
	}
}


void menu_draw (Menu *menu, SDL_Surface *dest)
{
	int	i, y;
	SFont_Font *temp_font;
	for ( i = 0, y = menu->y; i < menu->entry_count; i++, y += menu->y_offset ) {
		temp_font = (i == menu->cur_entry_id) ? ft_menu_highlight : ft_menu;
		SFont_Write(dest, temp_font, menu->entries[i].x, y, menu->entries[i].name);
	}
}


void menu_handle_motion (Menu *menu, int mx, int my)
{
	MenuEntry *entry;
	SDL_Event event;
	int	  i = 0;
	int   y = 0;
	SDL_WaitEvent(&event);
	SDL_PumpEvents();
	menu->cur_entry_id = -1;
	for ( i = 0, y = menu->y; i < menu->entry_count; i++, y += menu->y_offset ) {
		entry = &menu->entries[i];
		if ( mx >= entry->x && mx < entry->x + entry->w )
		if ( my >= y && my < y + entry->h ) {
			menu->cur_entry_id = i;
			break;
		}
	}
}


int menu_handle_click (Menu *menu, int x, int y)
{
	menu_handle_motion(menu, x, y);
	if ( menu->cur_entry_id == -1 ) {
		return 0;
	} else {
		return menu->entries[menu->cur_entry_id].id;
	}
}


void setupMenus ()
{
	menu_init( &main_menu, 230, 40 );
	menu_add_entry( &main_menu, "Play Patolli", ID_GAME );
	menu_add_entry( &main_menu, "Help Menu",    ID_HELP );
	menu_add_entry( &main_menu, "Quit",         ID_QUIT );
	
	menu_init( &help_menu_one, 406, 30 );
	menu_add_entry( &help_menu_one, "Main Menu", ID_MENU );
	menu_add_entry( &help_menu_one, "Next",      ID_NEXT );
	
	menu_init( &help_menu_two, 406, 30 );
	menu_add_entry( &help_menu_two, "Main Menu", ID_MENU );
	menu_add_entry( &help_menu_two, "Back",      ID_BACK );
	
	menu_init( &yesno_menu, 300, 35 );
	menu_add_entry( &yesno_menu, "Yes", ID_GAME);
	menu_add_entry( &yesno_menu, "No",  ID_QUIT);
}


static int all_filter (const SDL_Event *event) { return 0; }

static void draw_help ()
{
	int x = 160;
	LINE(50,"Patolli is an ancient Mayan board game that ");
	LINE(70,"takes its name from the Mayan/Aztec word ");
	LINE(90,"for beans. The game is played on a Parcheesi ");
	LINE(110,"like game board with red and blue jade markers ");
	LINE(130,"and 5 kidney beans. ");
	LINE(170,"It was played all over MesoAmerica: the ");
	LINE(190,"Teotihuacanos (the builders of Teotihuacan, ");
	LINE(210," 200 B.C. - 650 A.D.) played it as well as the ");
	LINE(230," Toltecs (750 - 1000 A.D.), the inhabitants of ");
	LINE(250," Chizen Itza (founded by refugee Toltec nobles, ");
	LINE(270,"   1100 - 1300 A.D. ), the Aztecs (1168 - 1521 A.D.).");
	LINE(310,"      Patolli was a game that commoners and ");
	LINE(330,"       nobles alike enjoyed.  It was reported by the ");
	LINE(350,"        conquistadors that Montezuma enjoyed ");
	LINE(370,"          watching people play the game in the ");
	LINE(390,"            courtyard.");
}



static void draw_help_two ()
{
	int x = 140;
	LINE(50,"The Red player always goes first. One must ");
	LINE(70,"first toss the beans on the board and get a total ");
	LINE(90,"count of 1 in order to place a jade marker on ");
	LINE(110,"the game board.  If at any time you should roll ");
	LINE(130,"the beans and get a total count of zero, then you ");
	LINE(150,"must pay a penalty dollar.  This money will go ");
	LINE(170,"to the winner of the round.  After you get on the ");
	LINE(190,"board, you then travel your jade marker clockwise ");
	LINE(210,"by the same amount as your bean count.  If you ");
	LINE(230," should get a count of 5, then you must move a ");
	LINE(250," marker 10 spaces.  If you land on one of the ");
	LINE(270,"  black triangular areas, you loose money.  But if ");
	LINE(290,"    you land on one of the spaces at the end of a ");
	LINE(310,"     wing you get another turn!  You can send your ");
	LINE(330,"        opponent back to the start by landing on ");
	LINE(350,"      special squares: all the squares in the middle ");
	LINE(370,"and the square across from the start square. The ");
	LINE(390,"winner of the round is the first to travel all his ");
	LINE(410,"jade markers arround the board. The winner of the ");
	LINE(430,"GAME is the person who has all the money.");
}


static void draw_new_round_comment ()
{
	int x = 160;
	LINE(130,"         Another Round To Be Played ");
	LINE(150,"        Until Someone Is Out Of Money ");
	LINE(190,"       Waiting for new round to begin ...");
}
