/***************************************************************************
    Copyright            : (C) 2006 by Tony R. Freeman
    Email                : tony@tonyfreeman.us
    Web                  : http://www.tonyfreeman.us/
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

int setupVideo()
{
	SDL_Surface *temp = NULL;
	
	// THE (ORIGINAL) BACKGROUND IMAGE WILL BE 800x600 32bits SO SET SCREEN TO THIS
	//Changed to 640x480 for the DREAMCAST!!!

	screen = SDL_SetVideoMode(640, 480, 32, SDL_ANYFORMAT);
	if (screen == NULL) {
		fprintf(stderr, "Error: unable to set video mode: %s\n", SDL_GetError());
		return EXIT_FAILURE;
	}
	
	// LOAD IN THE GAME BACKGROUND
	temp = IMG_Load("/rd/images/background.png");
	background = SDL_DisplayFormat(temp);
	SDL_FreeSurface(temp);
	
	// LOAD IN THE MENU BACKGROUND
	temp = IMG_Load("/rd/images/welcome.png");
	menu_background = SDL_DisplayFormat(temp);
	SDL_FreeSurface(temp);
	
	// DISPLAY THE MENU BACKGROUND
	SDL_BlitSurface(menu_background, 0, screen, 0);
	SDL_Flip(screen);
	
	SDL_WM_SetCaption("Patolli", "Patolli");
	
	printf("Patolli by Tony Freeman <tony@tonyfreeman.us>\n\n");
	
	return EXIT_SUCCESS;
}


static void fade_screen( int type, int time )
{
	SDL_Surface *buffer = 0;
	float alpha;
	float alpha_change;
	int leave = 0;
	int ms;
	int cur_ticks, prev_ticks;
	buffer = SDL_CreateRGBSurface( 
			 SDL_SWSURFACE, screen->w, screen->h, 
			 screen->format->BitsPerPixel,
			 screen->format->Rmask, screen->format->Bmask,
			 screen->format->Gmask, screen->format->Amask 
	);
	if ( buffer == 0 ) { return; }
	SDL_BlitSurface( screen, 0, buffer, 0 );
	if ( type == FADE_OUT ) {
		alpha = 255;
		alpha_change = -255.0 / time;
	} else {
		alpha = 0;
		alpha_change = 255.0 / time;
	}
	cur_ticks = prev_ticks = SDL_GetTicks();
	while ( !leave ) {
		prev_ticks = cur_ticks;
		cur_ticks = SDL_GetTicks();
		ms = cur_ticks - prev_ticks;
		alpha += alpha_change * ms;
		if ( type == FADE_IN && alpha >= 255 ) { break; }
		if ( type == FADE_OUT && alpha <= 0 ) { break; }
		SDL_FillRect( screen, 0, 0x0 );
		SDL_SetAlpha( buffer, SDL_SRCALPHA | SDL_RLEACCEL, (int)alpha );
		SDL_BlitSurface( buffer, 0, screen, 0 );
		SDL_Flip(screen);
	}
	SDL_SetAlpha( buffer, 0, 0 );
	if ( type == FADE_IN ) {
		SDL_BlitSurface( buffer, 0, screen, 0 );
	} else {
		SDL_FillRect( screen, 0, 0x0 );
	}
	SDL_Flip(screen);
	SDL_FreeSurface( buffer );
}


void refresh_screen ()
{
	fade_screen( FADE_OUT, 500 );
	SDL_BlitSurface( background, 0, screen, 0 );
	fade_screen( FADE_IN, 500 );
}
