/***************************************************************************
    Copyright            : (C) 2006 by Tony R. Freeman
    Email                : tony@tonyfreeman.us
    Web                  : http://www.tonyfreeman.us/
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

void check_opponent_kick()
{
	// DID THE OPPONENT JUST GET KICKED FROM A SPECIAL SQUARE?
	int i = 0;
	int j = 0;
	if (player == RED) { // RED PLAYER ACTIONS
		for (i=0; i<JADE_COUNT; i++) {
			for (j=0; j<JADE_COUNT; j++) {
				if (JadePositions[j][BLUE] >= 0) {
					if (JadePositions[i][RED] == JadePositions[j][BLUE]) {
						// RED PLAYER KICKED A BLUE PLAYER
						// MAKE A SOUND
						Mix_PlayChannel(-1, boom, 0);
						// MOVE THE BLUE PLAYER BACK TO A FREE START POSITION
						// ... ACTUALLY BECAUSE THE PLAYER IS 'HIDDING' THE OPPONENT
						// WE CAN JUST UPDATE THE OPPONENT POSITION IN THE ARRAY AND
						// JUST BLIT THE OPPONENT JADE BACK ON THE START BOARD
						JadePositions[j][BLUE] = -1;
						show_blue_home_jades(BlueHomePositions[j][0], BlueHomePositions[j][1]);
						// BLUE OPPONENT PAYS THE FINE
						get_credit_from_opponent();
					}
				}
			}
		}
	} else {  // BLUE PLAYER ACTIONS
		for (i=0; i<JADE_COUNT; i++) {
			for (j=0; j<JADE_COUNT; j++) {
				if (JadePositions[j][RED] >= 0) {
					if (JadePositions[i][BLUE] == JadePositions[j][RED]) {
						// BLUE PLAYER KICKED A RED PLAYER
						// MAKE A SOUND
						Mix_PlayChannel(-1, boom, 0);
						// MOVE THE BLUE PLAYER BACK TO A FREE START POSITION
						// ... ACTUALLY BECAUSE THE PLAYER IS 'HIDDING' THE OPPONENT
						// WE CAN JUST UPDATE THE OPPONENT POSITION IN THE ARRAY AND
						// JUST BLIT THE OPPONENT JADE BACK ON THE START BOARD
						JadePositions[j][RED] = -1;
						show_red_home_jades(RedHomePositions[j][0], RedHomePositions[j][1]);
						// RED OPPONENT PAYS THE FINE
						get_credit_from_opponent();
					}
				}
			}
		}
	}
}




void move_jade (int current_square, int next_square) 
{
	int i = 0;
	// MOVE JADE ONTO THE GAME BOARD
	if (current_square == -1) {
		for (i=0; i<JADE_COUNT; i++) {
			// TAKE THIS JADE THAT IS WAITING AND MOVE IT ONTO THE GAME BOARD
			if (JadePositions[i][player] == -1) {
				if (player == RED) {
					// GRAB THE FIRST RED JADE AVAILABLE
					src.x = RedHomePositions[i][0] - red_jade_1->w / 2;
					src.y = RedHomePositions[i][1] - red_jade_1->h / 2;
					break;
				} else {
					// GRAB THE USER SELECTED BLUE JADE
					src.x = BlueHomePositions[selected_blue_jade][0] - blue_jade_1->w / 2;
					src.y = BlueHomePositions[selected_blue_jade][1] - blue_jade_1->h / 2;
					break;
				}
			}
		}
	} else {
		// THIS WORKS FOR BOTH RED AND BLUE BECAUSE THE W AND H ARE THE SAME FOR BOTH JADE IMAGES
		src.x = gameBoardArray[current_square][0] - red_jade_1->w / 2;
		src.y = gameBoardArray[current_square][1] - red_jade_1->h / 2;
	}
	// THIS WORKS FOR BOTH RED AND BLUE BECAUSE THE W AND H ARE THE SAME FOR BOTH JADE IMAGES
	src.w = red_jade_1->w;
	src.h = red_jade_1->h;	
	dest = src;
	SDL_BlitSurface(background, &src, screen, &dest);
	
	// MOVE JADE OFF THE GAME BOARD
	if (next_square == -2) {
		for (i=0; i<JADE_COUNT; i++) {
			// GRAB THE JADE THAT'S SITTING ON THE END POSITION
			if (JadePositions[i][player] == playerStart[player][1]) {
				if (player == RED) {
					dest.x = RedEndPositions[i][0] - red_jade_1->w / 2;
					dest.y = RedEndPositions[i][1] - red_jade_1->w / 2;
					break;
				} else {
					dest.x = BlueEndPositions[i][0] - blue_jade_1->w / 2;
					dest.y = BlueEndPositions[i][1] - blue_jade_1->w / 2;
					break;
				}
			}
		}
	} else {
		// THIS WORKS FOR BOTH RED AND BLUE BECAUSE THE W AND H ARE THE SAME
		dest.x = gameBoardArray[next_square][0] - red_jade_1->w / 2;
		dest.y = gameBoardArray[next_square][1] - red_jade_1->h / 2;
	}
	// THIS WORKS FOR BOTH RED AND BLUE BECAUSE THE W AND H ARE THE SAME
	dest.w = red_jade_1->w;
	dest.h = red_jade_1->h;
	
	if (player == RED) {
		SDL_BlitSurface(red_jade_1, NULL, screen, &dest);
	} else {
		SDL_BlitSurface(blue_jade_1, NULL, screen, &dest);
	}
	SDL_UpdateRect(screen, 0, 0, 0, 0);
}




bool is_start_position_empty()
{
	// RUN THROUGH THE ARRAY TO SEE IF ONE OF THE CURRENT PLAYER PIECES 
	// IS ON THE START POSITIONS
	int i = 0;
	if (player == RED) {
		for (i=0; i<JADE_COUNT; i++) {
			if (JadePositions[i][RED] == 0) {
				return false;
			}
		}
	} else {
		for (i=0; i<JADE_COUNT; i++) {
			if (JadePositions[i][BLUE] == 34) {
				return false;
			}
		}
	}
	return true;
}



bool is_opponent_on_start_position()
{
	int i = 0;
	if (player == RED) {
		// RED CHECKS FOR BLUE OPPONENT
		for (i=0; i<JADE_COUNT; i++) {
			if (JadePositions[i][BLUE] == 0) {
				return true;
			}
		}
	} else {
		// BLUE CHECKS FOR RED OPPONENT
		for (i=0; i<JADE_COUNT; i++) {
			if (JadePositions[i][RED] == 34) {
				return true;
			}
		}
	}
	return false;
}



bool is_opponent_on_end_position()
{
	// CHECK IF THERE IS AN OPPONENT HOGGING THE END POSITIONS
	int i = 0;
	if (player == RED) {
		for (i=0; i<JADE_COUNT; i++) {
			if (JadePositions[i][BLUE] == 67) {
				return true;
			}
		}
	} else {
		for (i=0; i<JADE_COUNT; i++) {
			if (JadePositions[i][RED] == 33) {
				return true;
			}
		}
	}
	return false;
}


// THIS CALCULATES THE MOVE FOR RED
// RETURNS A POSITIVE NUMBER THAT REPRESENTS THE RED JADE TO MOVE
// RETURNS -2 ON SOME SORT OF ERROR THAT NEEDS TO BE LOOKED AT
// RETURNS -1 IF THERE ARE NO RED JADES ON BOARD TO MOVE OR THERE ARE NO 
// LEGAL MOVES TO MAKE
int returnJadeToMove()
{
	//printf("returnJadeToMove\n");
	int i = 0;
	int j = 0;
	int k = 0;
	int l = 0;
	int test  = 0;
	int test1 = 0;
	int test2 = 0;
	int next_square 	= -1;
	// THESE ARRAYS WILL KEEP TRACK OF THE DIFFERENT *TYPES* OF MOVES AVAILABLE
	int goodMoves[6] 	= {-1,-1,-1,-1,-1,-1};
	int badMoves[6] 	= {-1,-1,-1,-1,-1,-1};
	int betterMoves[6] 	= {-1,-1,-1,-1,-1,-1};
	bool jadetest 		= false;
	bool legal_move 	= true;
	bool opponent_test	= true;
	// IS THERE A JADE ON BOARD FOR THE PLAYER TO MOVE ...
	jadetest = is_player_on_board();
	if (jadetest) {
		// IF THERE IS A JADE HOGGING THE FIRST SPACE, MOVE IT FIRST THING IF POSSIBLE
		for (i=0; i<JADE_COUNT; i++) {
			if (JadePositions[i][RED] == 0) {
				// THIS ONE IS HOGGING THE SPOT
				// CHECK TO SEE IF IT CAN BE MOVED TO THE bean_count POSITION
				for (j=0; j<JADE_COUNT; j++) {
					if (JadePositions[j][RED] == bean_count) {
						legal_move = false;
					}
					// IT IS SAFE TO CHECK IF A BLUE IS IN THE WAY BECAUSE THERE ARE NO SPECIAL SPACES
					// THAT COULD BE MOVED TO FROM THE FIRST POSITION
					if (JadePositions[j][BLUE] == bean_count) {
						legal_move = false;
					}
				}
				if (legal_move == true) {
					return i;
				}
				// IF WE MADE IT THIS FAR, THEN WE FOUND ONE OF OUR RED JADES HOGGING THE START POSITION
				// BUT THERE IS NO LEGAL MOVE FOR IT TO MAKE ... SO WE'LL BREAK OUT OF THIS LOOP
				// AND CONTINUE EVALUATING OUR OTHER MOVE OPTIONS
				break;
			}
		}
		// IF THERE IS A JADE THAT CAN FINISH THE GAME, THEN RETURN THAT ONE
		opponent_test = is_opponent_on_end_position();
		if (opponent_test == false) {
			for (i=0; i<JADE_COUNT; i++) {
				if ((JadePositions[i][RED] + bean_count) == 67) {
						return i;
				}
			}
		}
		// RETURN THE FIRST "GOOD" LEGAL MOVE
		// NOTE:  legal_move SHOULD BE "FALSE" AT THIS POINT SO RESET IT TO TRUE
		legal_move = true;
		for (i=0; i<JADE_COUNT; i++) {
			// GET A RED JADE THAT IS NOT ON THE FIRST SQUARE OF THE GAME BOARD
			if (JadePositions[i][RED] >= 0) {
				// THIS IS THE SPACE ON THE GAME BOARD THAT THE JADE WOULD LAND 
				// IF WE COULD MOVE IT FROM IT'S CURRENT POSITION
				test = JadePositions[i][RED] + bean_count;
				if (test < 68) {
					// THE JADE CAN ACTUALLY LAND SOMEWHERE ON THE BOARD (AND 
					// NOT OUT ON THE STREET)
					for (j=0; j<JADE_COUNT; j++) {
						// HOWEVER ONE OF THE RED JADES IS ALREADY ON THAT 
						// LANDING POSITION
						if (JadePositions[j][RED] == test) {
							legal_move = false;
						}
					}
					// OK ... NONE OF MY OWN RED JADES ARE BLOCKING ME FROM 
					// MOVING LET'S CHECK TO SEE IF BLUE IS BLOCKING ME
					if (legal_move) {
						for (j=0; j<JADE_COUNT; j++) {
							if (JadePositions[j][BLUE] == test) {
								legal_move = false;
								// IT DOESN'T MATTER IF THE BLUE OPPONENT IS ON THE
								// FOLLOWING SQUARES.  WE ACTUALLY HOPE BLUE *IS* ON 
								// THE SQUARE SO THAT WE CAN BUMP IT BACK
								// TO THE STARTING POSITION.
								if (test == 0  || test == 16 || test == 17 || 
									test == 34 || test == 50 || test == 51) {
									legal_move = true;
								}
							}
						}
					}
					if (legal_move == true) {
						// THIS IS A STILL A GOOD MOVE ... ADD IT TO AN ARRAY OF GOOD MOVES
						goodMoves[k] = i;
						k++;
					}
					// RESET THE legal_move TEST VALUE SO THAT I CAN CHECK THE REST OF THE
					// RED PLAYERS ON THE BOARD FOR LEGAL MOVES THEY CAN MAKE
					legal_move = true;
				}
			}
		}
		// EXAMIN THE goodMoves	ARRAY FOR THE BEST MOVE ... IF THERE ISN'T REALLY A
		// BEST MOVE, THEN JUST SHOOT OUT A RANDOM ONE FROM THE goodMoves ARRAY
		k = 0;
		for (i=0; i<JADE_COUNT; i++) {
			if (goodMoves[i] >= 0) {
				next_square = JadePositions[goodMoves[i]][RED] + bean_count;
				// CHECK IF THIS RED JADE WILL LAND ON ONE OF THE BLACK TRIANGLES
				if (next_square == 5  || next_square == 12 || 
					next_square == 23 || next_square == 28 || 
					next_square == 39 || next_square == 46 || 
					next_square == 57 || next_square == 62) {
						badMoves[k] = goodMoves[i];
						k++;
				} else {
					betterMoves[l] = goodMoves[i];
					l++;
				}
			}
		}
		// HOW MANY ELEMENTS DO WE HAVE IN THE betterMoves and badMoves ARRAYS?
		test1 = count(betterMoves);
		test2 = count(badMoves);
		if (test1 > 0) {
			// RETURN A RANDOM ITEM FROM THE betterMoves ARRAY IF THERE IS MORE THAN ONE ELEMENT
			return (test1 == 1) ? betterMoves[0] : betterMoves[rand() % test1];
		} else if (test2 > 0) {
			// I CANNOT MAKE A GOOD MOVE ... SO I'LL MAKE A BAD ONE
			// RETURN A RANDOM ITEM FROM THE badMoves ARRAY
			return (test2 == 1) ? badMoves[0] : badMoves[rand() % test2];
		} else {
			return -2;
		}
	}
	// IF WE MAKE IT THIS FAR THEN THERE IS NOBODY ON BOARD TO MOVE
	return -1;
}



// THIS ONLY WORKS FOR RED
void moveJadeOnBoard() 
{
	int thisJade = -10;
	int next_square = 0;
	// IS THERE A JADE ON THE GAME BOARD TO MOVE? 
	thisJade = returnJadeToMove();
	if (thisJade == -10) { 
		printf("SOMETHING WRONG: I didn't get anything from the returnJadeToMove function\n"); 
		SDL_Quit(); 
	} else if (thisJade == -2) {
		printf("SOMETHING WRONG: I got a -2 from the returnJadeToMove function");
		printf("I should have gotten a positive value or -1\n");
		SDL_Quit();
	} else if (thisJade >= 0 ) {
		next_square = JadePositions[thisJade][RED] + bean_count;
		if (next_square >= 0 && next_square <= 67) {
			move_jade(JadePositions[thisJade][RED], next_square);
			JadePositions[thisJade][RED] = next_square;
			if (bean_count == 0) {
				printf("Oops ... paying the kitty.\n");
			} else if (next_square == 67) {
				// RED JADE PIECE FINISHED THE BOARD
				Mix_PlayChannel(-1, big_chear, 0);
				move_jade(JadePositions[thisJade][RED], -2);
				JadePositions[thisJade][RED] = -2;
				get_credit_from_opponent();
			} else if (next_square == 5  || next_square == 12 || 
				next_square == 23 || next_square == 28 || 
				next_square == 39 || next_square == 46 || 
				next_square == 57 || next_square == 62) {
				  Mix_PlayChannel(-1, gasp, 0);
				  SDL_Delay(800);
				  pay_the_opponent();
			} else if (next_square == 8  || next_square == 9  || 
				next_square == 25 || next_square == 26 || 
				next_square == 42 || next_square == 43 || 
				next_square == 59 || next_square == 60) {
				  Mix_PlayChannel(-1, yahoo_red, 0);
				  player = (player == RED) ? BLUE : RED;
			}
		} else {
			printf("next_square is illegal: %i\n", next_square);
		}
	} else {
		printf("No legal move available on the board.\n");
	}
}


// THIS ONLY WORKS FOR RED
bool moveJadeFromBar ()
{
	int i = 0;
	// MOVE A JADE FROM THE BAR IF POSSIBLE
	if (is_start_position_empty()) {
		printf("start position is empty ... moving jade onto board\n");
		// CHECK TO SEE IF THERE IS A JADE READY TO JUMP ONTO THE BOARD
		for (i=0; i<JADE_COUNT; i++) {
			if (JadePositions[i][RED] == -1) {
				Mix_PlayChannel(-1, yahoo_red, 0);
				move_jade(JadePositions[i][RED], 0);
				JadePositions[i][RED] = 0;
				return true;
			}
		}
	}
	return false;
}


// THIS ONLY WORKS FOR RED
void handle_make_move()
{
	bool test = false;
	if (bean_count == 1) {
		test = moveJadeFromBar();
		if (!test) {
			// START POSITION IS BEING HOGGED
			// NEED TO MOVE A JADE ALREADY ON THE BOARD
			moveJadeOnBoard();
		}
	} else {
		moveJadeOnBoard();
	}
}


// CHECKS MOUSE CLICK ... DID USER CLICK ON A JADE ON THE GAME BOARD
int check_blue_jade_on_board (int x, int y)
{
	int i = 0;
	// CYCLE THROUGH BLUE JADE LOCATIONS TO FIGURE OUT IF THE PLAYER CLICKED ON A BLUE JADE
	// LOCATED ON THE GAME BOARD
	for (i=0; i<JADE_COUNT; i++) {
		//printf("GAMEBOARD TESTING:\n");
		//printf("event.button.x >= (gameBoardArray[JadePositions[i][BLUE]][0] - blue_jade_1->w / 2): x = %i\n", gameBoardArray[JadePositions[i][BLUE]][0]);
		//printf("event.button.y >= (gameBoardArray[JadePositions[i][BLUE]][1] - blue_jade_1->h / 2): y = %i\n", gameBoardArray[JadePositions[i][BLUE]][1]);
		if(x >= (gameBoardArray[JadePositions[i][BLUE]][0] - blue_jade_1->w / 2) && 
		   y >= (gameBoardArray[JadePositions[i][BLUE]][1] - blue_jade_1->h / 2) && 
		   x  < (gameBoardArray[JadePositions[i][BLUE]][0] + blue_jade_1->w / 2) && 
		   y  < (gameBoardArray[JadePositions[i][BLUE]][1] + blue_jade_1->h / 2))
		{
			// FOUND THE JADE THE USER CLICKED ON
			return i;
		}
	}
	// DID NOT FIND A JADE
	return -1;
}


// CHECKS MOUSE CLICK ... DID USER CLICK ON JADE IN START AREA
int check_blue_jade_on_start(int x, int y)
{
	int i = 0;
	for (i=0; i<JADE_COUNT; i++) {
		//printf("START BOARD TESTING:\n");
		//printf("START: event.button.x >= (BlueHomePositions[i][0] - blue_jade_1->w / 2): x = %i\n", BlueHomePositions[i][0]);
		//printf("START: event.button.y >= (BlueHomePositions[i][1] - blue_jade_1->h / 2): y = %i\n", BlueHomePositions[i][1]);
		if(x >= (BlueHomePositions[i][0] - blue_jade_1->w / 2) && 
		   y >= (BlueHomePositions[i][1] - blue_jade_1->h / 2) && 
		   x  < (BlueHomePositions[i][0] + blue_jade_1->w / 2) && 
		   y  < (BlueHomePositions[i][1] + blue_jade_1->h / 2))
		{
			// FOUND THE JADE THE USER CLICKED ON
			return i;
		}
	}
	return -1;
}



bool is_valid_move (int start_position, int end_position)
{
	int i = 0;
	if (start_position < 34 && end_position >= 34) {
		// NOT A VALID MOVE AS IT GOES PAST THE EXIT POINT FOR BLUE
		return false;
	} else {
		// IF THERE ARE ANY BLUE JADES IN THE WAY THEN IT IS NOT A VALID MOVE
		for (i=0; i<JADE_COUNT; i++) {
			if (JadePositions[i][BLUE] == end_position) {
				return false;
			}
		}
		// OK ... BLUE JADES ARE NOT IN MY WAY!  THEREFORE I DON'T CARE IF
		// RED IS ON THE FOLLOWING SQUARES ... AS A MATTER OF FACT I HOPE THEY
		// ARE SO THAT I CAN KNOCK THEM BACK TO THE STARTING POSITION
		if (end_position ==  0 || end_position == 16 || end_position == 17 || 
			end_position == 34 || end_position == 50 || end_position == 51) {
				return true;
		}
		// RED IS NOT ON A SPECIAL SQUARE AND BLUE IS NOT IN THE WAY
		// SO ... CHECK IF THERE ARE ANY RED JADES IN THE WAY FOR THE OTHER POSITIONS
		for (i=0; i<JADE_COUNT; i++) {
			if (JadePositions[i][RED] == end_position) {
				return false;
			}
		}
	}
	// THE WAY IS CLEAR
	return true;
}



void report_invalid_board_move (int clicked_jade)
{
	// USER CLICKED ON A JADE THAT IS ON THE GAME BOARD AND IS NOT A VALID MOVE
	// SO I'LL FLASH THE JADE 3 TIMES AND PLAY A SOUND
	int i = 0;
	// PLAY SOUND
	Mix_PlayChannel(-1, illegal_move, 0);
	for (i=0; i<3; i++) {
		// HIDE THE JADE
		src.x = gameBoardArray[JadePositions[clicked_jade][BLUE]][0] - blue_jade_1->w / 2;
		src.y = gameBoardArray[JadePositions[clicked_jade][BLUE]][1] - blue_jade_1->h / 2;
		src.w = blue_jade_1->w;
		src.h = blue_jade_1->h;
		dest = src;
		SDL_BlitSurface(background, &src, screen, &dest);
		SDL_UpdateRect(screen, 0, 0, 0, 0);
		// PAUSE
		SDL_Delay(200);
		// SHOW THE JADE
		dest.x = gameBoardArray[JadePositions[clicked_jade][BLUE]][0] - blue_jade_1->w / 2;
		dest.y = gameBoardArray[JadePositions[clicked_jade][BLUE]][1] - blue_jade_1->h / 2;
		dest.w = blue_jade_1->w;
		dest.h = blue_jade_1->h;
		SDL_BlitSurface(blue_jade_1, NULL, screen, &dest);
		SDL_UpdateRect(screen, 0, 0, 0, 0);
		SDL_Delay(200);
	}
}




void report_invalid_start_move(int clicked_jade)
{
	// USER CLICKED ON A JADE THAT IS ON THE START POSITION BUT IS NOT A VALID MOVE
	// SO I'LL FLASH THE JADE 3 TIMES AND PLAY A SOUND
	int i = 0;
	// PLAY SOUND
	Mix_PlayChannel(-1, illegal_move, 0);
	for (i=0; i<3; i++) {
		// HIDE THE JADE
		src.x = BlueHomePositions[clicked_jade][0] - blue_jade_1->w / 2;
		src.y = BlueHomePositions[clicked_jade][1] - blue_jade_1->h / 2;
		src.w = blue_jade_1->w;
		src.h = blue_jade_1->h;
		dest = src;
		SDL_BlitSurface(background, &src, screen, &dest);
		SDL_UpdateRect(screen, 0, 0, 0, 0);
		// PAUSE
		SDL_Delay(200);
		// SHOW THE JADE
		dest.x = BlueHomePositions[clicked_jade][0] - blue_jade_1->w / 2;
		dest.y = BlueHomePositions[clicked_jade][1] - blue_jade_1->h / 2;
		dest.w = blue_jade_1->w;
		dest.h = blue_jade_1->h;
		SDL_BlitSurface(blue_jade_1, NULL, screen, &dest);
		SDL_UpdateRect(screen, 0, 0, 0, 0);
		SDL_Delay(200);
	}
}	



void check_landing (int thisJade, int next_square)
{
	// HANDLE VARIOUS LANDING POSITIONS FOR THE BLUE JADE
	if (next_square == 33) {
		// BLUE CROSSED FINISH LINE
		Mix_PlayChannel(-1, big_chear, 0);
		move_jade(JadePositions[thisJade][BLUE], -2);
		JadePositions[thisJade][BLUE] = -2;
		get_credit_from_opponent();
		//is_game_finished();
	} else if (next_square == 5  || next_square == 12 || 
		// BLUE LANDED ON A BLACK TRIANGLE
		next_square == 23 || next_square == 28 || 
		next_square == 39 || next_square == 46 || 
		next_square == 57 || next_square == 62) {
		  Mix_PlayChannel(-1, gasp, 0);
		  SDL_Delay(800);
		  pay_the_opponent();
		  //is_game_finished();
	} else if (next_square == 8  || next_square == 9  || 
		next_square == 25 || next_square == 26 || 
		next_square == 42 || next_square == 43 || 
		next_square == 59 || next_square == 60) {
		  // BLUE LANDED ON FREE TURN SPACE
		  Mix_PlayChannel(-1, yahoo_blue, 0);
		  player = (player == RED) ? BLUE : RED;
	}
}



bool are_there_any_valid_moves()
{
	int i = 0;
	int j = 0;
	int test = -10;
	bool blocked = false;
	bool red_blocked = false;
	
	// IF THE BEAN COUNT IS 1 THEN CHECK TO SEE IF THE
	// START POSITION IS EMPTY OF BLUE
	if (bean_count == 1 && is_start_position_empty()) {
		// START IS EMPTY ... DO WE HAVE A JADE THAT CAN MOVE FROM THE BAR ONTO IT?
		for (i=0; i<JADE_COUNT; i++) {
			if (JadePositions[i][BLUE] == -1) {
				// ... FOUND ONE SO THERE IS A VALID MOVE
				return true;
			}
		}
	}
	
	// IF WE GET THIS FAR - THEN THERE IS NOT A JADE ON THE START POSITION TO 
	// MOVE ONTO THE GAME BOARD .... SO .....
	// RUN THROUGH EACH OF THE BLUE JADES ON THE BOARD AND
	// CHECK IF IT IS BEING BLOCKED BY ANOTHER BLUE JADE
	for (i=0; i<JADE_COUNT; i++) {
		blocked = false;
		if (JadePositions[i][BLUE] > -1) {
			test = JadePositions[i][BLUE] + bean_count;
			if (JadePositions[i][BLUE] < 34 && test >= 34) {
				continue;
			} else if (test >= 68) {
				test -= 68;
			}
			for (j=0; j<JADE_COUNT; j++) {
				if (JadePositions[j][BLUE] > -1 && JadePositions[j][BLUE] == test) {
					blocked = true;
				}
			}
			if (blocked == false) {
				// A BLUE JADE IS NOT BLOCKING THIS ONE ... SO THERE MAY BE A VALID MOVE
				// LET'S CHECK TO SEE IF IT FALLS ON A SPECIAL SQUARE
				if (test ==  0 || test == 16 || test == 17 || 
					test == 34 || test == 50 || test == 51) {
					// THIS IS A VALID MOVE ... 
					return true;
				}
				// NOT LANDING ON A SPECIAL SQUARE ... SO LET'S CHECK TO SEE IF 
				// IT'S BEING BLOCKED BY A RED JADE
				red_blocked = false;
				for (j=0; j<JADE_COUNT; j++) {
					if (JadePositions[j][RED] == test) {
						red_blocked = true;
					}
				}
				if (red_blocked == false) {
					// NON OF THE REDS ARE BLOCKING THIS ONE, SO IT'S A VALID MOVE
					return true;
				}
			}
		}
	}
	// IF WE GET THIS FAR THEN ALL BLUE JADES ON THE BOARD ARE BEING BLOCKED 
	return false;
}


					
bool make_move()
{
	SDL_Event       event;
	SDL_EventFilter filter;
	
	 int jadetest        = -1;
	 int next_square     = -1;
	bool done            = false;
	bool valid_move_test = false;
	
	if (bean_count == 0) { return true; }
	
	if ( !is_player_on_board() && bean_count >  1) { return true; }
	
	if (  is_player_on_board() || bean_count == 1) {
		
		switch (player) {
			
			case RED:
				handle_make_move();
				break;
				
			case BLUE:
				filter = SDL_GetEventFilter();
				SDL_SetEventFilter(all_filter);
				while (SDL_PollEvent(&event));
				SDL_SetEventFilter(filter);
				while (!done) {
					SDL_WaitEvent(&event);
					switch (event.type) {
						
						case SDL_QUIT:
							state = STATE_MENU;
							break;
						
						case SDL_VIDEOEXPOSE:
							// NEED A REDRAW
							SDL_UpdateRect(screen, 0, 0, 0, 0);
							break;
						
						case SDL_MOUSEBUTTONDOWN:
							if (event.button.button == SDL_BUTTON_LEFT) {
									//printf("%i,%i\n", event.button.x, event.button.y);
									// TEST TO SEE IF THE JADE CLICKED ON WAS ON THE GAMEBOARD
									jadetest = check_blue_jade_on_board(event.button.x, event.button.y);
									if (jadetest > -1) {
										// UPDATE GLOBAL BLUE JADE TRACKING VARIABLE
										selected_blue_jade = jadetest;
										//printf("GAMEBOARD: You clicked on %i jade located at: (%i, %i)\n", jadetest, gameBoardArray[JadePositions[jadetest][BLUE]][0], gameBoardArray[JadePositions[jadetest][BLUE]][1]);
										// TEST TO SEE IF THIS JADE CAN MAKE A VALID MOVE ...
										next_square = JadePositions[jadetest][BLUE] + bean_count;
										if (next_square >= 68) { next_square -= 68; } 
										if (is_valid_move(JadePositions[jadetest][BLUE], next_square)) {
											// ... IT CAN SO MOVE IT
											move_jade(JadePositions[jadetest][BLUE], next_square);
											JadePositions[jadetest][BLUE] = next_square;
											// DID JADE LAND ON A BLACK SQUARE OR EXTRA-TURN SQUARE
											check_landing(jadetest, next_square);
											// RESET GLOBAL BLUE JADE TRACKER
											selected_blue_jade = JADE_COUNT + 1;
											done = true;
										} else {
											// ... IT CANNOT MAKE A VALID MOVE SO REPORT IT
											report_invalid_board_move(jadetest);
											// CHECK TO SEE IF THERE ARE ANY VALID MOVES AND IF SO, THEN
											// ALLOW THE USER TO TRY TO FIGURE OUT WHICH ONE ... IF NOT THEN
											// DO NOTHING AND LET THE RED PLAYER HAVE A GO.
											valid_move_test = are_there_any_valid_moves();
											if (valid_move_test == true) {
												printf("There are valid moves ... find one.\n");
											} else {
												done = true;
											}
										}
									} else {
										// IF BEAN COUNT IS 1, THEN YOU CAN MOVE A JADE FROM THE START POSITION
										if (bean_count == 1 ) {
											// TEST TO SEE IF THE JADE CLICKED ON WAS ON THE STARTING AREA
											jadetest = check_blue_jade_on_start(event.button.x, event.button.y);
											if (jadetest > -1) {
												// UPDATE GLOBAL BLUE JADE TRACKING VARIABLE
												selected_blue_jade = jadetest;
												// CHECK TO SEE IF IT CAN BE MOVED ON TO THE GAME BOARD
												if (is_start_position_empty()) {
													// FINISHED MAKING A PROPER MOVE ONTO GAME BOARD
													Mix_PlayChannel(-1, yahoo_blue, 0);
													move_jade(JadePositions[jadetest][BLUE], 34);
													JadePositions[jadetest][BLUE] = 34;
													// RESET GLOBAL BLUE JADE TRACKER
													selected_blue_jade = JADE_COUNT + 1;
													done = true;
												} else {
													// PLAYER CANNOT MAKE THIS MOVE BECAUSE A FELLOW JADE IS HOGGING THE
													// START POSITION.
													printf("Sorry ... not a legal move.\n");
													report_invalid_start_move(jadetest);
												}
											} else {
												// NOT A PROPER SELECTION
												printf("You clicked somewhere on the board ... but not on a jade.\n");
												Mix_PlayChannel(-1, illegal_move, 0);
											}
										}
									}
							}
							break;
						default:
							//if (gameOver) {
							//	is_game_finished();
							//}
							// CLOSE THE GAME IF USER PRESSES ESCAPE OR THE q KEY
							if (event.key.keysym.sym == SDLK_ESCAPE || event.key.keysym.sym == SDLK_q) { state = STATE_MENU; done = true; }
							break;
					}
				}
				break;
		}
		//if (gameOver == true) {
		//	is_game_finished();
		//}
		// CLOSE THE GAME IF USER PRESSES ESCAPE OR THE q KEY
		if (event.key.keysym.sym == SDLK_ESCAPE || event.key.keysym.sym == SDLK_q) { state = STATE_MENU; }
	}

	check_opponent_kick();
	
	return is_game_finished();
}
