/***************************************************************************
    Copyright            : (C) 2006 by Tony R. Freeman
    Email                : tony@tonyfreeman.us
    Web                  : http://www.tonyfreeman.us/
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// ------------------------------------------------
// GLOBAL DEFINITIONS
// ------------------------------------------------

#define JADE_COUNT 6
#define BEAN_COUNT 5
#define FADE_IN 0
#define FADE_OUT 1
#define MAX_MENU_ENTRIES 5

#define SDL_WriteText( font, surface, posx, posy, text ) SFont_Write(surface,font,posx,posy,text )
#define SDL_WriteTextCenter( font, surface, posx, posy, text ) SDL_WriteText(surface,font,(TextWidth(font,text)),posy,text)
#define SDL_WriteTextRight( font, surface, posx, posy, text ) SFont_Write(surface,font,posx-TextWidth(font,text),posy,text)
#define SDL_EnterTextCenter( font, surface, posx, posy, len, buf ) SFont_WriteCenter(surface,font,posx,posy,len,buf)
#define SDL_TextWidth(font,text) SFont_TextWidth(font,text)
#define SDL_FontHeight(font) (font->Surface->h)
#define SET_ALPHA( surf, alpha ) SDL_SetAlpha( surf, SDL_SRCALPHA | SDL_RLEACCEL, alpha )
#define SET_CKEY( surf, ckey ) SDL_SetColorKey( surf, SDL_SRCCOLORKEY, ckey )
#define LINE(y,text) SDL_WriteText(ft_help,screen,x,y,text)


// ------------------------------------------------
// MENU ITEMS
// ------------------------------------------------

typedef struct {
	char 	name[20];
	int  	x, w, h;
	int	    id;
} MenuEntry;

typedef struct {
	MenuEntry 	entries[MAX_MENU_ENTRIES];
	int		entry_count;
	int		y;
	int		y_offset;
	int		cur_entry_id;
} Menu;

Menu main_menu;
Menu help_menu_one;
Menu help_menu_two;
Menu yesno_menu;


// ------------------------------------------------
// GAME STATE 
// ------------------------------------------------

enum {STATE_MENU, STATE_HELP, STATE_GAME, STATE_QUIT, NEW_ROUND, GAME_OVER};
enum {ID_GAME = 101, ID_HELP, ID_QUIT, ID_NEXT, ID_BACK, ID_MENU};

enum players {RED, BLUE};
enum players player;

int state = STATE_MENU; // INITIAL STATE OF THE GAME.
bool playing = false; 	// IS THE GAME IN PROGRESS OR NOT
int page = 1;   	    // THE GLOBAL HELP PAGE REFERENCE

char * winningPlayer = "Nobody";

bool gameOver       = false;
bool gameReallyOver = false;

int selected_blue_jade = JADE_COUNT + 1;
int bean_count = 0;
int winner = -1;
int speed = 6; // THE NUMBER OF PIXELS FOR THE DOLLAR SIGN TO JUMP


// ------------------------------------------------
// GAME BOARD ARRAYS 
// ------------------------------------------------

char *beanFilenames[] = {
	"/rd/images/bean_0_0.png",
	"/rd/images/bean_0_1.png",
	"/rd/images/bean_1_0.png",
	"/rd/images/bean_1_1.png",
	"/rd/images/bean_2_0.png",
	"/rd/images/bean_2_1.png",
	"/rd/images/bean_3_0.png",
	"/rd/images/bean_3_1.png",
	"/rd/images/bean_4_0.png",
	"/rd/images/bean_4_1.png"
};

char *numbersFilenames[] = {
	"/rd/images/0.png",
	"/rd/images/1.png",
	"/rd/images/2.png",
	"/rd/images/3.png",
	"/rd/images/4.png",
	"/rd/images/5.png",
	"/rd/images/6.png",
	"/rd/images/7.png",
	"/rd/images/8.png",
	"/rd/images/9.png",
	"/rd/images/10.png",
	"/rd/images/11.png",
	"/rd/images/12.png",
	"/rd/images/13.png",
	"/rd/images/14.png",
	"/rd/images/15.png",
	"/rd/images/16.png",
	"/rd/images/17.png",
	"/rd/images/18.png",
	"/rd/images/19.png",
	"/rd/images/20.png"
};

//WARING: ALL COORDINATES CHANGED TO 640x480 FOR DREAMCAST!!!! -> * by 0.8

// x AND y COORDINATES FOR THE CENTER OF THE COUNTERS FOR RED, BLUE AND
// KITTY MARKERS
int numbersCoordinates[3][2] = {
	{433,216},
	{208,216},
	{318,150}
};


// x AND y COORDINATES OF THE RED, BLUE AND KITTY POSITIONS
int dollarCoordinates[3][2] = {
	{400,216},
	{240,216},
	{318,182}
};


// RED'S X,Y COORDINATES FOR EACH LANDING POSITION ON THE GAME BOARD
int gameBoardArray[68][2] = {
	{356,214},
	{384,233},
	{414,254},
	{446,275},
	{483,296},
	{515,313},
	{539,334},
	{574,355},
	{603,377},
	{576,395},
	{544,377},
	{507,355},
	{478,340},
	{452,316},
	{416,294},
	{384,275},
	{350,252},
	{320,233},
	{288,254},
	{254,275},
	{224,294},
	{192,315},
	{153,336},
	{128,358},
	{97,374},
	{64,393},
	{36,374},
	{65,353},
	{94,334},
	{123,316},
	{160,294},
	{190,275},
	{224,252},
	{254,233},
	{289,214},
	{256,192},
	{224,172},
	{192,153},
	{158,131},
	{126,113},
	{99,91},
	{64,68},
	{36,48},
	{62,30},
	{92,48},
	{128,70},
	{163,88},
	{188,107},
	{220,129},
	{254,150},
	{288,172},
	{318,190},
	{350,171},
	{382,150},
	{414,129},
	{446,108},
	{481,89},
	{507,67},
	{539,49},
	{577,30},
	{603,49},
	{572,70},
	{545,92},
	{513,107},
	{481,129},
	{448,150},
	{416,171},
	{384,192}
};


// THESE SPACES ON THE GAME BOARD ALLOW PLAYER TO SEND THE OPPONENT 
// BACK TO START POSITION
int specialSpaces[6] = {0,16,17,34,50,51};


// -1 MEANS THE JADE IS WAITING TO BE PLACED ON THE GAME GRID
// NON NEGATIVE MEANS THE JADE IS ON THAT SPACE OF THE GAME BOARD
// -2 MEANS THE JADE HAS FINISHED IT'S CIRCUT AROUND THE BOARD
// THE FIRST COLUMN IS red AND THE SECOND COLUMN IS blue
int JadePositions[JADE_COUNT][2] = {
	{-1,-1},
	{-1,-1},
	{-1,-1},
	{-1,-1},
	{-1,-1},
	{-1,-1}
};


// THE x AND y COORDINATES OF WHERE EACH RED JADE IS LOCATED AT THE START POSITION
int RedHomePositions[JADE_COUNT][2] = {
	{570,145},
	{554,171},
	{597,162},
	{613,193},
	{584,206},
	{579,179}
};

// THE x AND y COORDINATES OF WHERE EACH RED JADE SITS AFTER IT FINISHES THE GAME
int RedEndPositions[JADE_COUNT][2] = {
	{528,440},
	{560,448},
	{600,456},
	{580,437},
	{540,460},
	{548,432}
};

// THE x AND y COORDINATES OF WHERE EACH BLUE JADE IS LOCATED AT THE START POSITION
int BlueHomePositions[JADE_COUNT][2] = {
	{10,145},
	{18,171},
	{37,162},
	{45,193},
	{60,170},
	{16,195}
};

// THE x AND y COORDINATES OF WHERE EACH BLUE JADE SITS AFTER IT FINISHES THE GAME
int BlueEndPositions[JADE_COUNT][2] = {
	{10,438},
	{18,464},
	{37,460},
	{45,433},
	{60,446},
	{16,435}
};

// THE FIRST COLUMN IN THE ARRAY IS THE VALUE OF THE BEAN (WHICH CAN BE 0 OR 1)
// THE SECOND AND THIRD COLUMNS ARE THE x AND y COORDINATES WHERE EACH OF THE 
// BEANS LAND ON THE BOARD
int theBeans[5][3] = {
	{0,266,344},
	{0,296,304},
	{0,336,312},
	{0,364,344},
	{0,320,352}
};

// AMOUNT OF MONEY EACH PLAYER STARTS OUT WITH
// RED, BLUE, KITTY
int theMoney[3] = {10,10,0};

// USED TO RANDOMIZE THE COORDINATES OF theBeans
int list[BEAN_COUNT] = {0,1,2,3,4};

// START AND END POSITIONS ON THE GAME BOARD FOR EACH PLAYER
// POSITION 0 IS THE FIRST LANDING POSITION FOR RED
int playerStart[2][2] = {
	{0,67},  // RED
	{34,33}  // BLUE
};
