/***************************************************************************
    Copyright            : (C) 2006 by Tony R. Freeman
    Email                : tony@tonyfreeman.us
    Web                  : http://www.tonyfreeman.us/
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

int setupAudio()
{
	if (Mix_OpenAudio(44100, AUDIO_S16, 2, 1024) < 0) {
		fprintf(stderr, "Warning: Audio could not be setup for 44100 Hz 16-bit stereo.\nReason: %s\n", SDL_GetError());
	}
	
	// SET THE MUSIC VOLUME
	Mix_VolumeMusic(MIX_MAX_VOLUME);
	
	// LOAD BACKGROUND MUSIC INTO MEMORY
	music = Mix_LoadMUS("/rd/music/children.xm");
	if (!music) { printf("Unable to load music file as background music: %s\n", Mix_GetError()); }
	
	// START PLAYING THE BACKGROUND MUSIC
	if (Mix_PlayMusic(music, -1) == -1) {
		fprintf(stderr, "Warning: Cannot play background music. %s\n", Mix_GetError());
	}
	
	// 4 SOUND EFFECTS CAN PLAY AT ONCE
	Mix_AllocateChannels(4);
	
	// LOAD IN ALL THE SOUND EFFECTS
	click_on_ball 	= Mix_LoadWAV("/rd/sounds/click_on_ball.wav");
	if (!click_on_ball) { fprintf(stderr, "Unable to load 'click_on_ball' sample: %s\n", Mix_GetError()); }
	illegal_move 	= Mix_LoadWAV("/rd/sounds/illegal_move.wav");
	shake_beans	    = Mix_LoadWAV("/rd/sounds/shake_beans.wav");
	scatter_beans	= Mix_LoadWAV("/rd/sounds/scatter_beans.wav");
	yahoo_red		= Mix_LoadWAV("/rd/sounds/yahoo_red.wav");
	yahoo_blue	    = Mix_LoadWAV("/rd/sounds/yahoo_blue.wav");
	big_chear		= Mix_LoadWAV("/rd/sounds/big_chear.wav");
	gasp            = Mix_LoadWAV("/rd/sounds/gasp.wav");
	god_chuckle	    = Mix_LoadWAV("/rd/sounds/god_chuckle.wav");
	pay_opponent    = Mix_LoadWAV("/rd/sounds/pay_opponent.wav");
	pay_kitty		= Mix_LoadWAV("/rd/sounds/pay_kitty.wav");
	boom            = Mix_LoadWAV("/rd/sounds/boom.wav");
	wav_click		= Mix_LoadWAV("/rd/sounds/wav_click.wav");
	wav_highlight	= Mix_LoadWAV("/rd/sounds/wav_highlight.wav");
	
	return EXIT_SUCCESS;
}


int shutdownAudio()
{
	Mix_HaltMusic();
	Mix_FreeChunk(click_on_ball);
	Mix_FreeChunk(illegal_move);
	Mix_FreeChunk(shake_beans);
	Mix_FreeChunk(scatter_beans);
	Mix_FreeChunk(yahoo_red);
	Mix_FreeChunk(yahoo_blue);
	Mix_FreeChunk(big_chear);
	Mix_FreeChunk(gasp);
	Mix_FreeChunk(god_chuckle);
	Mix_FreeChunk(pay_opponent);
	Mix_FreeChunk(pay_kitty);
	Mix_FreeChunk(boom);
	Mix_FreeChunk(wav_click);
	Mix_FreeChunk(wav_highlight);
	Mix_FreeMusic(music);
	Mix_CloseAudio();
	
	return EXIT_SUCCESS;
}
