/***************************************************************************
    Copyright            : (C) 2006 by Tony R. Freeman
    Email                : tony@tonyfreeman.us
    Web                  : http://www.tonyfreeman.us/
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

void refreshJadesOnBoard ()
{
	// BECAUSE THE DOLLAR SIGN MOVES ACROSS THE GAME BOARD
	// I NEED TO REFRESH THE DISPLAY OF THE JADES ON THE GAME BOARD
	int i = 0;
	int this_square = 0;
	for (i=0; i<JADE_COUNT; i++) {
		this_square = JadePositions[i][RED];
		if (this_square ==  0 || this_square == 1  || this_square == 17 || 
			this_square == 33 || this_square == 34 || this_square == 35 || 
			this_square == 36 || this_square == 49 || this_square == 50 || 
			this_square == 51 || this_square == 52 || this_square == 53 || 
			this_square == 67 || this_square == 1) {
			// RE-SHOW THIS JADE ON THE GAME BOARD
			dest.x = gameBoardArray[this_square][0] - red_jade_1->w / 2;
			dest.y = gameBoardArray[this_square][1] - red_jade_1->h / 2;
			dest.w = red_jade_1->w;
			dest.h = red_jade_1->h;	
			SDL_BlitSurface(red_jade_1, NULL, screen, &dest);
		}
	}
	for (i=0; i<JADE_COUNT; i++) {
		this_square = JadePositions[i][BLUE];
		if (this_square ==  0 || this_square == 1  || this_square == 17 || 
			this_square == 33 || this_square == 34 || this_square == 35 || 
			this_square == 36 || this_square == 49 || this_square == 50 || 
			this_square == 51 || this_square == 52 || this_square == 53 || 
			this_square == 67 || this_square == 1) {
			// RE-SHOW THIS JADE ON THE GAME BOARD
			dest.x = gameBoardArray[this_square][0] - blue_jade_1->w / 2;
			dest.y = gameBoardArray[this_square][1] - blue_jade_1->h / 2;
			dest.w = blue_jade_1->w;
			dest.h = blue_jade_1->h;	
			SDL_BlitSurface(blue_jade_1, NULL, screen, &dest);
		}
	}
}


// THIS IS WHERE THE DOLLAR SIGN SCROLLS ACROSS THE GAME BOARD
void show_payment (int start, int end)
{
	// THE X AND Y COORDINATES OF THE STARTING POSITION
	int start_x = dollarCoordinates[start][0];
	int start_y = dollarCoordinates[start][1];
	// THE X AND Y COORDINATES OF THE ENDING POSITION
	// WHICH WILL BE SOMEWHERE NEAR THE TOP CENTER OF THE SCREEN
	int end_x = dollarCoordinates[end][0];
	int end_y = dollarCoordinates[end][1];
	// TESTING VARIABLES
	bool x_done = false;
	bool y_done = false;
	bool done = false;
	// money IS THE SDL_Surface IMAGE OF A DOLLAR SIGN
	// I'M ADDING THE VALUE OF SPEED TO THE WIDTH AND HEIGHT
	// SO THAT I CAN GRAB SOME EXTRA BACKGROUND SPACE
	// WHICH WILL ERASE ANY TRAILS CAUSED BY 
	// THE MOVEMENT OF THE IMAGE ACROSS THE SCREEN
	src.w = money->w + speed;
	src.h = money->h + speed;
	// ADJUSTING THE VALUE OF X AND Y SO THAT THE CENTER
	// OF THE IMAGE IS PLACED OVER THE X,Y COORDINATES
	src.x = start_x - (src.w / 2);
	src.y = start_y - (src.h / 2);
	dest = src;
	do {
		// SHOW THE DOLLAR SIGN
		SDL_BlitSurface(money, NULL, screen, &dest);
		SDL_Flip(screen);
		// ERASE THE DOLLAR SIGN BY SHOWING THE BACKGROUND
		SDL_BlitSurface(background, &src, screen, &dest);
		refreshJadesOnBoard();
		// FIGURE THE NEXT VALUE OF start_x
		// THE START OF MOVEMENT COULD BE ON THE LEFT OF THE SCREEN
		// OR ON THE RIGHT ... SO I HAVE TO FIGURE THE PROPER MATH IN
		// ORDER TO GET THE MOVEMENT GOING TOWARD THE TOP-CENTER.
		// SO ... IF THE START IS ON THE LEFT I NEED TO ADD
		// AND IF THE START IS ON THE RIGHT I NEED TO SUBTRACT
		if (start_x < end_x) {
			if (start_x + speed >= end_x) {
				start_x = end_x;
				x_done = true;
			} else {
				start_x += speed;
			}
		} else if (start_x > end_x) {
			if (start_x - speed <= end_x) {
				start_x = end_x;
				x_done = true;
			} else {
				start_x -= speed;
			}
		} else {
			x_done = true;
		}
		// FIGURE THE VALUE OF start_y
		if (start_y < end_y) {
			if (start_y + speed >= end_y) {
				start_y = end_y;
				y_done = true;
			} else {
				start_y += speed;
			}
		} else if (start_y > end_y) {
			if (start_y - speed <= end_y) {
				start_y = end_y;
				y_done = true;
			} else {
				start_y -= speed;
			}
		} else {
			y_done = true;
		}
		src.w  = money->w + speed;
		src.h  = money->h + speed;
		dest.w = src.w;
		dest.h = src.h;
		src.x  = start_x - (src.w / 2);
		src.y  = start_y - (src.h / 2);
		dest.x = start_x - (dest.w / 2);
		dest.y = start_y - (dest.h / 2);
		done = (x_done == true && y_done == true) ? true : false;
	} while (done == false);
}




void give_kitty_to_winner()
{
	winner = (theMoney[RED] <= 0) ? BLUE : RED;
	theMoney[winner] += theMoney[2];
	theMoney[2] = 0;
	update_totals();
}



bool is_player_completely_done ()
{
	// ARE ALL THE PLAYER'S JADES OFF OF THE GAME BOARD?
	int i=0;
	for (i=0; i<JADE_COUNT; i++) {
		if (JadePositions[i][player] > -2) {
			return false;
		}
	}
	return true;
}


bool is_player_out_of_money ()
{
	if ( (theMoney[RED] <= 0) || (theMoney[BLUE] <= 0) ) {
		return true;
	}
	return false;
}



bool is_game_finished()
{
	gameOver = false;
	gameReallyOver = false;
	
	if (is_player_completely_done()) {
		gameOver = true;
	}
	
	if (is_player_out_of_money()) {
		gameOver = true;
		gameReallyOver = true;
	}
	
	if (gameOver && gameReallyOver) {
		printf("GAME IS OVER!\n");
		// FADE THE SCREEN OUT AND IN
		fade_screen( FADE_OUT, 500 );
		SDL_BlitSurface( menu_background, 0, screen, 0 );
		fade_screen( FADE_IN, 500 );
		// TELL EVERYONE WHO WON THE GAME
		if (theMoney[RED] > 0) { 
			winningPlayer = "RED";
		} else { 
			winningPlayer = "BLUE";
		}
		state = GAME_OVER;
	} else if (gameOver  && !gameReallyOver) {
		printf("Game is not over yet ... another round starting ...\n");
		// THE GAME IS NOT OVER UNTIL SOMEONE IS OUT OF MONEY
		gameReallyOver = false;
		gameOver = false;
		give_kitty_to_winner();
		// SHOW A STATUS COMMENT FOR A FEW SECONDS AND THEN START THE NEW ROUND
		state = NEW_ROUND;
		playing = false;
	}
	return gameReallyOver;
}



void adjust_totals ()
{
	if (theMoney[RED]  >= 20) { theMoney[RED]  = 20; gameOver = true;   }
	if (theMoney[RED]  <= 0 ) { gameOver = true; gameReallyOver = true; }
	if (theMoney[BLUE] <= 0 ) { gameOver = true; gameReallyOver = true; }
	if (theMoney[BLUE] >= 20) { theMoney[BLUE] = 20; gameOver = true;   }
}



void pay_the_kitty()
{
	theMoney[player] -= 2;
	theMoney[2] += 2;
	adjust_totals();
	show_payment(player, 2);
	update_totals();
}



void pay_the_opponent()
{
	int opponent;
	opponent = (player == RED) ? BLUE : RED;
	theMoney[player] -= 2;
	theMoney[opponent] += 2;
	adjust_totals();
	show_payment(player, opponent);
	update_totals();
}




void get_credit_from_opponent()
{
	int opponent = (player == RED) ? BLUE : RED;
	theMoney[opponent] -= 2;
	theMoney[player] += 2;
	adjust_totals();
	show_payment(opponent, player);
	update_totals();
}
